/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.type.Type;
import com.caucho.java.JavaWriter;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ClobType
extends Type {
    private static final L10N L = new L10N(ClobType._resin_compat_class_0());
    private static final ClobType BLOB_TYPE = new ClobType();
    private static Class _resin_compat_class_0;

    private ClobType() {
    }

    public static ClobType create() {
        return BLOB_TYPE;
    }

    public String getName() {
        return "java.sql.Clob";
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print(new CharBuffer().append("").append(rs).append(".getClob(").append(indexVar).append(" + ").append(index).append(")").toString());
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println(new CharBuffer().append(pstmt).append(".setClob(").append(index).append("++, ").append(value).append(");").toString());
    }

    public Object getObject(ResultSet rs, int index) throws SQLException {
        return rs.getClob(index);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.amber.type.ClobType");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

