/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.AmberException;
import com.caucho.amber.type.Type;
import com.caucho.java.JavaWriter;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ClassType
extends Type {
    private static final L10N L = new L10N(ClassType._resin_compat_class_0());
    private static final ClassType CLASS_TYPE = new ClassType();
    private static Class _resin_compat_class_0;

    private ClassType() {
    }

    public static ClassType create() {
        return CLASS_TYPE;
    }

    public String getName() {
        return "java.lang.Class";
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print(new CharBuffer().append("com.caucho.amber.type.ClassType.toClass(").append(rs).append(".getString(").append(indexVar).append(" + ").append(index).append("))").toString());
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println(new CharBuffer().append("if (").append(value).append(" == null)").toString());
        out.println(new CharBuffer().append("  ").append(pstmt).append(".setNull(").append(index).append("++, java.sql.Types.VARCHAR);").toString());
        out.println("else");
        out.println(new CharBuffer().append("  ").append(pstmt).append(".setString(").append(index).append("++, ").append(value).append(".getName());").toString());
    }

    public void generateSetNull(JavaWriter out, String pstmt, String index) throws IOException {
        out.println(new CharBuffer().append(pstmt).append(".setNull(").append(index).append("++, java.sql.Types.VARCHAR);").toString());
    }

    public static Class toClass(String name) throws SQLException {
        if (name == null) {
            return null;
        }
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            return Class.forName(name, false, loader);
        }
        catch (ClassNotFoundException e) {
            throw new AmberException(e);
        }
    }

    public Object getObject(ResultSet rs, int index) throws SQLException {
        return ClassType.toClass(rs.getString(index));
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.amber.type.ClassType");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

