/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.AmberManager;
import com.caucho.amber.type.Type;
import com.caucho.java.JavaWriter;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public class CharacterType
extends Type {
    private static final L10N L = new L10N(CharacterType._resin_compat_class_0());
    private static final CharacterType CHAR_TYPE = new CharacterType();
    private static Class _resin_compat_class_0;

    private CharacterType() {
    }

    public static CharacterType create() {
        return CHAR_TYPE;
    }

    public String getName() {
        return "java.lang.Character";
    }

    public String generateCreateColumnSQL(AmberManager manager, int length, int precision, int scale) {
        return manager.getCreateColumnSQL(1, 0, precision, scale);
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print(new CharBuffer().append("com.caucho.amber.type.CharacterType.toChar(").append(rs).append(".getString(").append(indexVar).append(" + ").append(index).append("))").toString());
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println(new CharBuffer().append("if (").append(value).append(" == null)").toString());
        out.println(new CharBuffer().append("  ").append(pstmt).append(".setNull(").append(index).append("++, java.sql.Types.CHAR);").toString());
        out.println("else");
        out.println(new CharBuffer().append("  ").append(pstmt).append(".setString(").append(index).append("++, String.valueOf(").append(value).append("));").toString());
    }

    public void generateSetNull(JavaWriter out, String pstmt, String index) throws IOException {
        out.println(new CharBuffer().append(pstmt).append(".setNull(").append(index).append("++, java.sql.Types.CHAR);").toString());
    }

    public static Character toChar(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        return new Character(value.charAt(0));
    }

    public Object getObject(ResultSet rs, int index) throws SQLException {
        String value = rs.getString(index);
        return value == null || value.length() == 0 ? null : new Character(value.charAt(0));
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.amber.type.CharacterType");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

