/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.type.Type;
import com.caucho.java.JavaWriter;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

public class CalendarType
extends Type {
    private static final L10N L = new L10N(CalendarType._resin_compat_class_0());
    private static final CalendarType CALENDAR_TYPE = new CalendarType();
    private static Class _resin_compat_class_0;

    private CalendarType() {
    }

    public static CalendarType create() {
        return CALENDAR_TYPE;
    }

    public String getName() {
        return "java.util.Calendar";
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print(new CharBuffer().append("com.caucho.amber.type.CalendarType.toCalendar(").append(rs).append(".getTimestamp(").append(indexVar).append(" + ").append(index).append("))").toString());
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println(new CharBuffer().append("if (").append(value).append(" == null)").toString());
        out.println(new CharBuffer().append("  ").append(pstmt).append(".setNull(").append(index).append("++, java.sql.Types.TIMESTAMP);").toString());
        out.println("else");
        out.println(new CharBuffer().append("  ").append(pstmt).append(".setTimestamp(").append(index).append("++, new java.sql.Timestamp(").append(value).append(".getTimeInMillis()));").toString());
    }

    public static Calendar toCalendar(Date time) throws SQLException {
        if (time == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        return cal;
    }

    public Object getObject(ResultSet rs, int index) throws SQLException {
        Timestamp time = rs.getTimestamp(index);
        if (time == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        return cal;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.amber.type.CalendarType");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

