/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.AmberManager;
import com.caucho.amber.type.Type;
import com.caucho.java.JavaWriter;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public class BooleanType
extends Type {
    private static final L10N L = new L10N(BooleanType._resin_compat_class_0());
    private static final BooleanType BOOLEAN_TYPE = new BooleanType();
    private static Class _resin_compat_class_0;

    private BooleanType() {
    }

    public static BooleanType create() {
        return BOOLEAN_TYPE;
    }

    public String getName() {
        return "java.lang.Boolean";
    }

    public boolean isBoolean() {
        return true;
    }

    public String generateCreateColumnSQL(AmberManager manager, int length, int precision, int scale) {
        return manager.getCreateColumnSQL(16, length, precision, scale);
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print(new CharBuffer().append("com.caucho.amber.type.BooleanType.toBoolean(").append(rs).append(".getBoolean(").append(indexVar).append(" + ").append(index).append("), ").append(rs).append(".wasNull())").toString());
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println(new CharBuffer().append("if (").append(value).append(" == null)").toString());
        out.println(new CharBuffer().append("  ").append(pstmt).append(".setNull(").append(index).append("++, java.sql.Types.BIT);").toString());
        out.println("else");
        out.println(new CharBuffer().append("  ").append(pstmt).append(".setBoolean(").append(index).append("++, ").append(value).append(".booleanValue());").toString());
    }

    public void generateSetNull(JavaWriter out, String pstmt, String index) throws IOException {
        out.println(new CharBuffer().append(pstmt).append(".setNull(").append(index).append("++, java.sql.Types.BIT);").toString());
    }

    public static Boolean toBoolean(boolean value, boolean wasNull) {
        if (wasNull) {
            return null;
        }
        return new Boolean(value);
    }

    public Object getObject(ResultSet rs, int index) throws SQLException {
        boolean value = rs.getBoolean(index);
        return rs.wasNull() ? null : (value ? Boolean.TRUE : Boolean.FALSE);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.amber.type.BooleanType");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

