/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.query;

import com.caucho.amber.type.ByteType;
import com.caucho.amber.type.DoubleType;
import com.caucho.amber.type.IntegerType;
import com.caucho.amber.type.LongType;
import com.caucho.amber.type.ShortType;
import com.caucho.amber.type.SqlDateType;
import com.caucho.amber.type.SqlTimestampType;
import com.caucho.amber.type.StringType;
import com.caucho.amber.type.Type;
import java.sql.Date;
import java.sql.Timestamp;

public class QueryArgs {
    private Type[] _argTypes;
    private Object[] _argValues;

    public QueryArgs(int length) {
        this._argTypes = new Type[length];
        this._argValues = new Object[length];
    }

    Type[] getArgTypes() {
        return this._argTypes;
    }

    Object[] getArgValues() {
        return this._argValues;
    }

    public void setString(int index, String v) {
        this._argTypes[index - 1] = StringType.create();
        this._argValues[index - 1] = v;
    }

    public void setByte(int index, byte v) {
        this._argTypes[index - 1] = ByteType.create();
        this._argValues[index - 1] = new Integer(v);
    }

    public void setShort(int index, short v) {
        this._argTypes[index - 1] = ShortType.create();
        this._argValues[index - 1] = new Integer(v);
    }

    public void setInt(int index, int v) {
        this._argTypes[index - 1] = IntegerType.create();
        this._argValues[index - 1] = new Integer(v);
    }

    public void setLong(int index, long v) {
        this._argTypes[index - 1] = LongType.create();
        this._argValues[index - 1] = new Long(v);
    }

    public void setDouble(int index, double v) {
        this._argTypes[index - 1] = DoubleType.create();
        this._argValues[index - 1] = new Double(v);
    }

    public void setTimestamp(int index, Timestamp v) {
        this._argTypes[index - 1] = SqlTimestampType.create();
        this._argValues[index - 1] = v;
    }

    public void setDate(int index, Date v) {
        this._argTypes[index - 1] = SqlDateType.create();
        this._argValues[index - 1] = v;
    }

    public void setNull(int index, int v) {
        this._argTypes[index - 1] = StringType.create();
        this._argValues[index - 1] = null;
    }

    public int hashCode() {
        int hash = 37;
        for (int i = this._argValues.length - 1; i >= 0; --i) {
            Object v = this._argValues[i];
            hash = v != null ? 31 * hash + v.hashCode() : 31 * hash + 17;
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (!(o instanceof QueryArgs)) {
            return false;
        }
        QueryArgs args = (QueryArgs)o;
        if (this._argValues.length != args._argValues.length) {
            return false;
        }
        for (int i = this._argValues.length - 1; i >= 0; --i) {
            Object a = args._argValues[i];
            Object b = this._argValues[i];
            if (a == b || a != null && a.equals(b)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "QueryArgs[]";
    }
}

