/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.query;

import com.caucho.amber.query.AbstractAmberExpr;
import com.caucho.amber.query.AmberExpr;
import com.caucho.amber.query.CollectionIdExpr;
import com.caucho.amber.query.FromItem;
import com.caucho.amber.query.IdExpr;
import com.caucho.amber.query.JoinExpr;
import com.caucho.amber.query.ManyToOneJoinExpr;
import com.caucho.amber.query.OneToManyExpr;
import com.caucho.amber.query.PathExpr;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.query.UnaryExpr;
import com.caucho.amber.table.LinkColumns;
import com.caucho.amber.table.Table;
import com.caucho.util.CharBuffer;

public class MemberExpr
extends AbstractAmberExpr {
    private boolean _isNot;
    private PathExpr _itemExpr;
    private AmberExpr _collectionExpr;

    private MemberExpr(PathExpr itemExpr, AmberExpr collectionExpr, boolean isNot) {
        this._itemExpr = itemExpr;
        this._collectionExpr = collectionExpr;
    }

    static AmberExpr create(QueryParser parser, PathExpr itemExpr, AmberExpr collectionExpr, boolean isNot) {
        if (collectionExpr instanceof IdExpr) {
            collectionExpr = ((CollectionIdExpr)collectionExpr).getPath();
        }
        if (collectionExpr instanceof OneToManyExpr) {
            OneToManyExpr oneToMany = (OneToManyExpr)collectionExpr;
            PathExpr parent = oneToMany.getParent();
            ManyToOneJoinExpr expr = new ManyToOneJoinExpr(oneToMany.getLinkColumns(), itemExpr.getChildFromItem(), parent.getChildFromItem());
            if (isNot) {
                return new UnaryExpr(169, expr);
            }
            return expr;
        }
        return new MemberExpr(itemExpr, collectionExpr, isNot);
    }

    public AmberExpr bindSelect(QueryParser parser) {
        return this;
    }

    public boolean usesFrom(FromItem from, int type, boolean isNot) {
        return this._collectionExpr.usesFrom(from, type) || this._itemExpr.usesFrom(from, type);
    }

    public AmberExpr replaceJoin(JoinExpr join) {
        this._collectionExpr = this._collectionExpr.replaceJoin(join);
        this._itemExpr = (PathExpr)this._itemExpr.replaceJoin(join);
        return this;
    }

    public void generateWhere(CharBuffer cb) {
        if (!(this._collectionExpr instanceof OneToManyExpr)) {
            throw new UnsupportedOperationException();
        }
        OneToManyExpr oneToMany = (OneToManyExpr)this._collectionExpr;
        LinkColumns join = oneToMany.getLinkColumns();
        cb.append("EXISTS(SELECT *");
        Table table = join.getSourceTable();
        cb.append(new CharBuffer().append(" FROM ").append(table.getName()).append(" caucho").toString());
        cb.append(')');
    }
}

