/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.query;

import com.caucho.amber.field.AmberField;
import com.caucho.amber.query.AmberExpr;
import com.caucho.amber.query.FromItem;
import com.caucho.amber.query.ManyToOneExpr;
import com.caucho.amber.query.OneToManyExpr;
import com.caucho.amber.query.OneToManySchemaExpr;
import com.caucho.amber.query.QueryParseException;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.query.SchemaExpr;
import com.caucho.amber.type.EntityType;
import com.caucho.util.L10N;

public class ManyToOneSchemaExpr
extends SchemaExpr {
    private static final L10N L = new L10N(ManyToOneSchemaExpr._resin_compat_class_0());
    private ManyToOneExpr _expr;
    private String _name;
    private static Class _resin_compat_class_0;

    public ManyToOneSchemaExpr(ManyToOneExpr expr, String name) {
        this._expr = expr;
        this._name = name;
    }

    public String getTailName() {
        return this._name;
    }

    public SchemaExpr createField(QueryParser parser, String name) throws QueryParseException {
        EntityType type = this._expr.getTargetType();
        AmberField field = type.getField(name);
        if (field == null) {
            throw parser.error(L.l("{0}: '{1}' is an unknown field.", (Object)type.getBeanClass().getName(), name));
        }
        AmberExpr fieldExpr = this._expr.createField(parser, name);
        if (fieldExpr instanceof ManyToOneExpr) {
            return new ManyToOneSchemaExpr((ManyToOneExpr)fieldExpr, name);
        }
        if (fieldExpr instanceof OneToManyExpr) {
            return new OneToManySchemaExpr((OneToManyExpr)fieldExpr);
        }
        throw parser.error(L.l("{0}: '{1}' must be a collection.", (Object)type.getBeanClass().getName(), name));
    }

    public FromItem addFromItem(QueryParser parser, String id) throws QueryParseException {
        this._expr = (ManyToOneExpr)this._expr.bindSelect(parser, id);
        FromItem fromItem = this._expr.bindSubPath(parser);
        return fromItem;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.amber.query.CollectionSchemaExpr");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

