/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.query;

import com.caucho.amber.query.AbstractPathExpr;
import com.caucho.amber.query.AmberExpr;
import com.caucho.amber.query.FromItem;
import com.caucho.amber.query.ManyToOneJoinExpr;
import com.caucho.amber.query.PathExpr;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.table.LinkColumns;
import com.caucho.amber.table.Table;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.Type;
import com.caucho.util.CharBuffer;

public class ManyToOneExpr
extends AbstractPathExpr {
    private PathExpr _parent;
    private LinkColumns _linkColumns;
    private FromItem _fromItem;
    private FromItem _childFromItem;

    public ManyToOneExpr(PathExpr parent, LinkColumns linkColumns) {
        this._parent = parent;
        this._linkColumns = linkColumns;
    }

    public EntityType getTargetType() {
        return this._linkColumns.getTargetTable().getType();
    }

    public Type getType() {
        return this.getTargetType();
    }

    public AmberExpr bindSelect(QueryParser parser) {
        this._fromItem = this._parent.bindSubPath(parser);
        return this;
    }

    public FromItem getFromItem() {
        return this._fromItem;
    }

    public LinkColumns getLinkColumns() {
        return this._linkColumns;
    }

    public FromItem getChildFromItem() {
        return this._childFromItem;
    }

    public FromItem bindSubPath(QueryParser parser) {
        if (this._childFromItem != null) {
            return this._childFromItem;
        }
        ManyToOneExpr pathExpr = (ManyToOneExpr)parser.addPath(this);
        if (pathExpr != this) {
            this._fromItem = pathExpr._fromItem;
            this._childFromItem = pathExpr._childFromItem;
            return this._childFromItem;
        }
        this._parent = this._parent.bindSelect(parser, null);
        this.bindSelect(parser, parser.createTableName());
        return this._childFromItem;
    }

    public PathExpr bindSelect(QueryParser parser, String id) {
        if (this._childFromItem != null) {
            return this;
        }
        if (this._fromItem == null) {
            this._fromItem = this._parent.bindSubPath(parser);
        }
        Table targetTable = this._linkColumns.getTargetTable();
        this._childFromItem = parser.addFromItem(targetTable, id);
        ManyToOneJoinExpr joinExpr = new ManyToOneJoinExpr(this._linkColumns, this._fromItem, this._childFromItem);
        this._childFromItem.setJoinExpr(joinExpr);
        return this;
    }

    public boolean usesFrom(FromItem from, int type, boolean isNot) {
        return this._childFromItem == from && type == 1 || this._fromItem == from || this._parent.usesFrom(from, type);
    }

    public void generateMatchArgWhere(CharBuffer cb) {
        if (this._fromItem != null) {
            cb.append(this._linkColumns.generateMatchArgSQL(this._fromItem.getName()));
        } else {
            cb.append(this._linkColumns.generateMatchArgSQL(this._parent.getChildFromItem().getName()));
        }
    }

    public void generateSelect(CharBuffer cb) {
        String tableName = this._fromItem != null ? this._fromItem.getName() : this._parent.getChildFromItem().getName();
        cb.append(this._linkColumns.generateSelectSQL(tableName));
    }

    public int hashCode() {
        return 65521 * this._parent.hashCode() + this._linkColumns.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        ManyToOneExpr manyToOne = (ManyToOneExpr)o;
        return this._parent.equals(manyToOne._parent) && this._linkColumns.equals(manyToOne._linkColumns);
    }

    public String toString() {
        return new CharBuffer().append("ManyToOneExpr[").append(this._childFromItem).append(",").append(this._fromItem).append(",").append(this._parent).append("]").toString();
    }
}

