/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.query;

import com.caucho.amber.connection.AmberConnectionImpl;
import com.caucho.amber.entity.EntityItem;
import com.caucho.amber.field.AmberField;
import com.caucho.amber.query.AbstractAmberExpr;
import com.caucho.amber.query.AmberExpr;
import com.caucho.amber.query.FromItem;
import com.caucho.amber.query.PathExpr;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.table.LinkColumns;
import com.caucho.amber.table.Table;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.Type;
import com.caucho.util.CharBuffer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;

public class LoadEntityExpr
extends AbstractAmberExpr {
    private PathExpr _expr;
    private FromItem _fromItem;
    private ArrayList<FromItem> _subItems = new ArrayList();

    LoadEntityExpr(PathExpr expr) {
        this._expr = expr;
    }

    public Type getType() {
        return this.getEntityType();
    }

    public EntityType getEntityType() {
        return this._expr.getTargetType();
    }

    public String getTable() {
        return this._fromItem.getName();
    }

    public AmberExpr bindSelect(QueryParser parser) {
        this._fromItem = this._expr.bindSubPath(parser);
        if (this._fromItem == null) {
            throw new NullPointerException(new CharBuffer().append(this._expr.getClass().getName()).append(" ").append(this._expr).toString());
        }
        EntityType type = this.getEntityType();
        if (type.getSecondaryTables().size() > 0) {
            Iterator<AmberField> i$ = type.getFields().iterator();
            while (i$.hasNext()) {
                AmberField field = i$.next();
                Table subTable = field.getTable();
                if (subTable == null || subTable == type.getTable()) continue;
                LinkColumns link = subTable.getDependentIdLink();
                FromItem item = parser.createDependentFromItem(this._fromItem, link);
                this._subItems.add(item);
            }
        }
        return this;
    }

    public FromItem bindSubPath(QueryParser parser) {
        throw new UnsupportedOperationException();
    }

    public boolean usesFrom(FromItem from, int type, boolean isNot) {
        if (this._fromItem == from) {
            return true;
        }
        for (int i = 0; i < this._subItems.size(); ++i) {
            FromItem subItem = this._subItems.get(i);
            if (from != subItem) continue;
            return true;
        }
        return this._expr.usesFrom(from, type, isNot);
    }

    public FromItem getChildFromItem() {
        return this._expr.getChildFromItem();
    }

    public void generateSelect(CharBuffer cb) {
        cb.append(this.getEntityType().getId().generateSelect(this.getTable()));
        EntityType type = this.getEntityType();
        String valueSelect = type.generateLoadSelect(this._fromItem.getTable(), this._fromItem.getName());
        if (valueSelect != null && !"".equals(valueSelect)) {
            cb.append(", ");
            cb.append(valueSelect);
        }
        for (int i = 0; i < this._subItems.size(); ++i) {
            FromItem item = this._subItems.get(i);
            valueSelect = type.generateLoadSelect(item.getTable(), item.getName());
            if (valueSelect.equals("")) continue;
            cb.append(", ");
            cb.append(valueSelect);
        }
    }

    public void generateWhere(CharBuffer cb, String fieldName) {
        throw new UnsupportedOperationException();
    }

    public Object getObject(AmberConnectionImpl aConn, ResultSet rs, int index) throws SQLException {
        return this.getEntityType().getLoadObject(aConn, rs, index);
    }

    public Object getCacheObject(AmberConnectionImpl aConn, ResultSet rs, int index) throws SQLException {
        return this.findItem(aConn, rs, index);
    }

    public EntityItem findItem(AmberConnectionImpl aConn, ResultSet rs, int index) throws SQLException {
        EntityType entityType = this.getEntityType();
        EntityItem item = entityType.getHome().findItem(aConn, rs, index);
        int keyLength = entityType.getId().getKeyCount();
        item.getEntity().__caucho_load(aConn, rs, index + keyLength);
        return item;
    }
}

