/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.query;

import com.caucho.amber.query.AbstractAmberExpr;
import com.caucho.amber.query.AmberExpr;
import com.caucho.amber.query.FromItem;
import com.caucho.amber.query.JoinExpr;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.type.BooleanType;
import com.caucho.amber.type.Type;
import com.caucho.util.CharBuffer;
import java.util.ArrayList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InExpr
extends AbstractAmberExpr {
    private AmberExpr _expr;
    private ArrayList<AmberExpr> _values;
    private boolean _isNot;

    InExpr(AmberExpr expr, ArrayList<AmberExpr> values, boolean isNot) {
        this._expr = expr;
        this._values = values;
        this._isNot = isNot;
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public Type getType() {
        return BooleanType.create();
    }

    @Override
    public AmberExpr bindSelect(QueryParser parser) {
        this._expr = this._expr.bindSelect(parser);
        for (int i = 0; i < this._values.size(); ++i) {
            this._values.set(i, this._values.get(i).bindSelect(parser));
        }
        return this;
    }

    @Override
    public boolean usesFrom(FromItem from, int type, boolean isNot) {
        if (this._expr.usesFrom(from, type)) {
            return true;
        }
        for (int i = 0; i < this._values.size(); ++i) {
            if (!this._values.get(i).usesFrom(from, type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public AmberExpr replaceJoin(JoinExpr join) {
        this._expr = this._expr.replaceJoin(join);
        for (int i = 0; i < this._values.size(); ++i) {
            this._values.set(i, this._values.get(i).replaceJoin(join));
        }
        return this;
    }

    @Override
    public void generateWhere(CharBuffer cb) {
        cb.append('(');
        this._expr.generateWhere(cb);
        if (this._isNot) {
            cb.append(" NOT");
        }
        cb.append(" IN (");
        for (int i = 0; i < this._values.size(); ++i) {
            if (i != 0) {
                cb.append(',');
            }
            this._values.get(i).generateWhere(cb);
        }
        cb.append("))");
    }

    public String toString() {
        CharBuffer cb = new CharBuffer();
        cb.append('(');
        cb.append(this._expr);
        if (this._isNot) {
            cb.append(" NOT");
        }
        cb.append(" IN (");
        for (int i = 0; i < this._values.size(); ++i) {
            if (i != 0) {
                cb.append(',');
            }
            cb.append(this._values.get(i));
        }
        cb.append("))");
        return cb.toString();
    }
}

