/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.query;

import com.caucho.amber.field.AmberField;
import com.caucho.amber.query.AmberExpr;
import com.caucho.amber.query.FromItem;
import com.caucho.amber.query.IdExpr;
import com.caucho.amber.query.ManyToOneExpr;
import com.caucho.amber.query.ManyToOneSchemaExpr;
import com.caucho.amber.query.OneToManyExpr;
import com.caucho.amber.query.OneToManySchemaExpr;
import com.caucho.amber.query.QueryParseException;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.query.SchemaExpr;
import com.caucho.amber.type.EntityType;
import com.caucho.util.L10N;

public class FromIdSchemaExpr
extends SchemaExpr {
    private static final L10N L = new L10N(FromIdSchemaExpr._resin_compat_class_0());
    private IdExpr _id;
    private static Class _resin_compat_class_0;

    public FromIdSchemaExpr(IdExpr id) {
        this._id = id;
    }

    public String getTailName() {
        return this._id.getId();
    }

    public SchemaExpr createField(QueryParser parser, String name) throws QueryParseException {
        EntityType type = this._id.getTargetType();
        AmberField field = type.getField(name);
        if (field == null) {
            throw parser.error(L.l("{0}: '{1}' is an unknown field.", (Object)type.getBeanClass().getName(), name));
        }
        AmberExpr fieldExpr = this._id.createField(parser, name);
        if (fieldExpr instanceof ManyToOneExpr) {
            return new ManyToOneSchemaExpr((ManyToOneExpr)fieldExpr, name);
        }
        if (fieldExpr instanceof OneToManyExpr) {
            return new OneToManySchemaExpr((OneToManyExpr)fieldExpr);
        }
        throw parser.error(L.l("{0}: '{1}' must be a collection.", (Object)type.getBeanClass().getName(), name));
    }

    public FromItem addFromItem(QueryParser parser, String id) throws QueryParseException {
        return parser.addFromItem(this._id.getTargetType().getTable(), id);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.amber.query.FromIdSchemaExpr");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

