/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.query;

import com.caucho.amber.connection.AmberConnectionImpl;
import com.caucho.amber.entity.AmberEntityHome;
import com.caucho.amber.entity.TableInvalidateCompletion;
import com.caucho.amber.query.AbstractQuery;
import com.caucho.amber.query.AmberExpr;
import com.caucho.amber.query.CachedQuery;
import com.caucho.amber.query.FromItem;
import com.caucho.amber.query.TableCacheUpdate;
import com.caucho.amber.query.UserQuery;
import com.caucho.util.CharBuffer;
import java.sql.SQLException;

public class DeleteQuery
extends AbstractQuery {
    private AmberExpr _where;
    private String _sql;

    DeleteQuery(String query) {
        super(query);
    }

    void setWhere(AmberExpr expr) {
        this._where = expr;
    }

    public String getSQL() {
        return this._sql;
    }

    void init() {
        CharBuffer cb = CharBuffer.allocate();
        cb.append("DELETE FROM ");
        FromItem item = (FromItem)this._fromList.get(0);
        cb.append(item.getTable().getName());
        if (this._where != null) {
            cb.append(" WHERE ");
            this._where.generateWhere(cb);
        }
        this._sql = cb.close();
    }

    void registerUpdates(CachedQuery query) {
        for (int i = 0; i < this._fromList.size(); ++i) {
            FromItem item = (FromItem)this._fromList.get(i);
            AmberEntityHome home = item.getEntityHome();
            TableCacheUpdate update = new TableCacheUpdate(query);
            home.addUpdate(update);
        }
    }

    public void prepare(UserQuery userQuery, AmberConnectionImpl aConn) throws SQLException {
        aConn.flush();
    }

    public void complete(UserQuery userQuery, AmberConnectionImpl aConn) throws SQLException {
        aConn.expire();
        FromItem item = (FromItem)this._fromList.get(0);
        aConn.addCompletion(new TableInvalidateCompletion(item.getEntityType().getTable().getName()));
    }

    public String toString() {
        return new CharBuffer().append("DeleteQuery[").append(this.getQueryString()).append("]").toString();
    }
}

