/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.idgen;

import com.caucho.amber.AmberManager;
import com.caucho.amber.connection.AmberConnectionImpl;
import com.caucho.amber.idgen.IdGenerator;
import com.caucho.config.ConfigException;
import com.caucho.jdbc.JdbcMetaData;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class SequenceIdGenerator
extends IdGenerator {
    private static final L10N L = new L10N(SequenceIdGenerator._resin_compat_class_0());
    private static final Logger log = Log.open(SequenceIdGenerator._resin_compat_class_0());
    private AmberManager _manager;
    private String _name;
    private int _size;
    private String _selectSQL;
    private boolean _isInit;
    private static Class _resin_compat_class_0;

    public SequenceIdGenerator(AmberManager manager, String name, int size) throws ConfigException {
        this._manager = manager;
        this._name = name;
        this._size = size;
    }

    public long allocateGroup(AmberConnectionImpl aConn) throws SQLException {
        Connection conn = aConn.getConnection();
        PreparedStatement selectStmt = conn.prepareStatement(this._selectSQL);
        long value = -1L;
        ResultSet rs = selectStmt.executeQuery();
        if (rs.next()) {
            value = rs.getLong(1);
        }
        rs.close();
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(AmberManager amberManager) throws SQLException {
        if (this._isInit) {
            return;
        }
        this._isInit = true;
        DataSource ds = amberManager.getDataSource();
        Connection conn = ds.getConnection();
        try {
            JdbcMetaData metaData = amberManager.getMetaData();
            this._selectSQL = metaData.selectSequenceSQL(this._name);
            if (amberManager.getCreateDatabaseTables()) {
                String sql = metaData.createSequenceSQL(this._name, this.getGroupSize());
                try {
                    Statement stmt = conn.createStatement();
                    stmt.executeUpdate(sql);
                    stmt.close();
                }
                catch (Exception e) {
                    log.log(Level.FINER, e.toString(), e);
                }
            }
        }
        finally {
            conn.close();
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.amber.idgen.SequenceIdGenerator");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

