/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.hibernate;

import com.caucho.amber.field.AssociationField;
import com.caucho.amber.field.CollectionField;
import com.caucho.amber.field.EntityOneToManyField;
import com.caucho.amber.field.Id;
import com.caucho.amber.field.IdField;
import com.caucho.amber.hibernate.HibernateColumn;
import com.caucho.amber.table.Column;
import com.caucho.amber.table.ForeignColumn;
import com.caucho.amber.table.LinkColumns;
import com.caucho.amber.table.Table;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.Type;
import com.caucho.bytecode.JClass;
import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import java.util.ArrayList;

public class HibernateCollection {
    private static final L10N L = new L10N(HibernateCollection._resin_compat_class_0());
    private String _name;
    private EntityType _type;
    private CollectionField _field;
    private Type _resultType;
    private String _table;
    private LinkColumns _keyColumns;
    private static Class _resin_compat_class_0;

    HibernateCollection(EntityType type) {
        this._type = type;
    }

    public void setField(CollectionField field) {
        this._field = field;
        this.getOwnerType().addField(this._field);
    }

    protected CollectionField getField() {
        return this._field;
    }

    public void setName(String name) throws ConfigException {
        this._name = name;
    }

    String getName() throws ConfigException {
        return this._name;
    }

    void setKeyColumns(LinkColumns columns) throws ConfigException {
        this._keyColumns = columns;
    }

    public void setType(String type) throws ConfigException {
        this._resultType = this._type.getAmberManager().createType(type);
    }

    Type getType() throws ConfigException {
        return this._resultType;
    }

    EntityType getOwnerType() {
        return this._type;
    }

    public void setTable(String table) {
        this._table = table;
    }

    public Key createKey() {
        return new Key();
    }

    public Element createElement() {
        AssociationField field = new AssociationField(this.getOwnerType());
        this.setField(field);
        return new Element(field, this.getOwnerType());
    }

    public OneToMany createOneToMany() {
        this.setField(new EntityOneToManyField(this.getOwnerType()));
        return new OneToMany(this._field, this.getOwnerType());
    }

    public ManyToMany createManyToMany() {
        AssociationField field = new AssociationField(this.getOwnerType());
        this.setField(field);
        return new ManyToMany(field, this.getOwnerType());
    }

    public void init() throws ConfigException {
        if (this._resultType == null) {
            JClass resultClass = this._field.getGetterMethod().getReturnType();
            this._resultType = this._type.getAmberManager().createType(resultClass);
        }
        this._field.setName(this._name);
        this._field.setType(this._resultType);
        if (this._keyColumns != null) {
            this._field.setLinkColumns(this._keyColumns);
        }
        this._field.setTable(this._table);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.amber.hibernate.HibernateCollection");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public class ManyToMany
    extends Association {
        ManyToMany(AssociationField field, EntityType type) {
            super(field, type);
        }

        public void setClass(String type) throws ConfigException {
            HibernateCollection.this.setType(type);
        }
    }

    public class OneToMany
    extends Target {
        OneToMany(CollectionField field, EntityType type) {
            super(field, type);
        }

        public void setClass(String type) throws ConfigException {
            HibernateCollection.this.setType(type);
        }
    }

    public class Element
    extends Association {
        Element(AssociationField field, EntityType type) {
            super(field, type);
        }

        public void setType(String type) throws ConfigException {
            HibernateCollection.this.setType(type);
        }
    }

    public class Association {
        private EntityType _entityType;
        private AssociationField _field;
        private ArrayList<HibernateColumn> _columns = new ArrayList();

        Association(AssociationField field, EntityType type) {
            this._entityType = type;
            this._field = field;
        }

        public void addColumn(HibernateColumn column) {
            this._columns.add(column);
        }

        public void init() throws ConfigException {
            if (this._columns.size() > 0) {
                Id id = this._field.getSourceType().getId();
                ArrayList<IdField> keys = id.getKeys();
                if (keys.size() != this._columns.size()) {
                    throw new ConfigException(L.l("The number of columns must match the number of keys"));
                }
                ArrayList<Column> columns = new ArrayList<Column>();
                for (int i = 0; i < this._columns.size(); ++i) {
                    HibernateColumn hColumn = this._columns.get(i);
                    Column column = HibernateCollection.this.getOwnerType().getTable().createColumn(hColumn.getName(), keys.get(i).getType());
                    columns.add(column);
                }
            }
        }
    }

    public class Target {
        private CollectionField _field;
        private EntityType _entityType;

        Target(CollectionField field, EntityType type) {
            this._entityType = type;
            this._field = field;
        }
    }

    public class Key {
        private ArrayList<HibernateColumn> _columns = new ArrayList();

        public void addColumn(HibernateColumn column) {
            this._columns.add(column);
        }

        public void init() throws ConfigException {
            Id id;
            ArrayList<Column> keys;
            if (this._columns.size() == 0) {
                HibernateColumn column = new HibernateColumn();
                column.setName(HibernateCollection.this.getName());
                this._columns.add(column);
            }
            if ((keys = (id = HibernateCollection.this.getOwnerType().getId()).getColumns()).size() != this._columns.size()) {
                throw new ConfigException(L.l("The number of columns must match the number of keys"));
            }
            Table ownerTable = HibernateCollection.this.getOwnerType().getTable();
            ArrayList<ForeignColumn> columns = new ArrayList<ForeignColumn>();
            for (int i = 0; i < this._columns.size(); ++i) {
                HibernateColumn hColumn = this._columns.get(i);
                ForeignColumn column = ownerTable.createForeignColumn(hColumn.getName(), keys.get(i));
                columns.add(column);
            }
        }
    }
}

