/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.gen;

import com.caucho.amber.table.LinkColumns;
import com.caucho.amber.table.Table;
import com.caucho.amber.type.EntityType;
import com.caucho.java.JavaWriter;
import com.caucho.java.gen.ClassComponent;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.ArrayList;

public class LoadGroupGenerator
extends ClassComponent {
    private static final L10N L = new L10N(LoadGroupGenerator._resin_compat_class_0());
    private String _extClassName;
    private EntityType _entityType;
    private int _index;
    private static Class _resin_compat_class_0;

    public LoadGroupGenerator(String extClassName, EntityType entityType, int index) {
        this._extClassName = extClassName;
        this._entityType = entityType;
        this._index = index;
    }

    public void generate(JavaWriter out) throws IOException {
        out.println();
        out.println(new CharBuffer().append("protected void __caucho_load_").append(this._index).append("(com.caucho.amber.connection.AmberConnectionImpl aConn)").toString());
        out.println("{");
        out.pushDepth();
        int group = this._index / 64;
        long mask = 1L << this._index % 64;
        if (!this._entityType.isReadOnly()) {
            out.println("if (aConn.isInTransaction()) {");
            out.println("  if (com.caucho.amber.entity.Entity.P_DELETING <= __caucho_state) {");
            out.println("    return;");
            out.println("  }");
            out.println("  else if (__caucho_state < com.caucho.amber.entity.Entity.P_TRANSACTIONAL) {");
            out.println("    __caucho_state = com.caucho.amber.entity.Entity.P_TRANSACTIONAL;");
            int loadCount = this._entityType.getLoadGroupIndex();
            for (int i = 0; i <= loadCount / 64; ++i) {
                out.println(new CharBuffer().append("    __caucho_loadMask_").append(i).append(" = 0;").toString());
            }
            int dirtyCount = this._entityType.getDirtyIndex();
            for (int i = 0; i <= dirtyCount / 64; ++i) {
                out.println(new CharBuffer().append("    __caucho_dirtyMask_").append(i).append(" = 0;").toString());
            }
            out.println("    aConn.makeTransactional(this);");
            out.println("  }");
            out.println(new CharBuffer().append("  else if ((__caucho_loadMask_").append(group).append(" & ").append(mask).append("L) != 0)").toString());
            out.println("    return;");
            out.println("}");
            out.print("else ");
        }
        out.println(new CharBuffer().append("if ((__caucho_loadMask_").append(group).append(" & ").append(mask).append("L) != 0)").toString());
        out.println("  return;");
        out.println("else if (__caucho_item != null) {");
        out.pushDepth();
        out.println(new CharBuffer().append(this._extClassName).append(" item = (").append(this._extClassName).append(") __caucho_item.getEntity();").toString());
        out.println(new CharBuffer().append("item.__caucho_load_").append(this._index).append("(aConn);").toString());
        this._entityType.generateCopyLoadObject(out, "super", "item", this._index);
        out.println(new CharBuffer().append("__caucho_loadMask_").append(group).append(" |= ").append(mask).append("L;").toString());
        out.println();
        out.println("return;");
        out.popDepth();
        out.println("}");
        out.println();
        out.println("if (__caucho_log.isLoggable(java.util.logging.Level.FINE))");
        out.println(new CharBuffer().append("  __caucho_log.fine(\"amber load-").append(this._index).append(" \" + this);").toString());
        out.println();
        out.println("try {");
        out.pushDepth();
        Table table = this._entityType.getTable();
        String from = null;
        String select = null;
        String where = null;
        String subSelect = this._entityType.generateLoadSelect(table, "o", this._index);
        Table mainTable = null;
        String tableName = null;
        if (subSelect != null) {
            select = subSelect;
            from = new CharBuffer().append(table.getName()).append(" o").toString();
            where = this._entityType.getId().generateMatchArgWhere("o");
            mainTable = table;
            tableName = "o";
        }
        ArrayList<Table> subTables = this._entityType.getSecondaryTables();
        for (int i = 0; i < subTables.size(); ++i) {
            Table subTable = subTables.get(i);
            subSelect = this._entityType.generateLoadSelect(subTable, new CharBuffer().append("o").append(i).toString(), this._index);
            if (subSelect == null) continue;
            select = select != null ? new CharBuffer().append(select).append(", ").append(subSelect).toString() : subSelect;
            from = from != null ? new CharBuffer().append(from).append(", ").append(subTable.getName()).append(" o").append(i).toString() : new CharBuffer().append(subTable.getName()).append(" o").append(i).toString();
            if (where != null) {
                LinkColumns link = subTable.getDependentIdLink();
                where = new CharBuffer().append(where).append(" AND ").append(link.generateJoin(new CharBuffer().append("o").append(i).toString(), "o")).toString();
                continue;
            }
            throw new IllegalStateException();
        }
        if (select == null) {
            select = "1";
        }
        if (where == null) {
            from = new CharBuffer().append(table.getName()).append(" o").toString();
            where = this._entityType.getId().generateMatchArgWhere("o");
        }
        String sql = new CharBuffer().append("SELECT ").append(select).append(" FROM ").append(from).append(" WHERE ").append(where).toString();
        out.println(new CharBuffer().append("String sql = \"").append(sql).append("\";").toString());
        out.println();
        out.println("java.sql.PreparedStatement pstmt = aConn.prepareStatement(sql);");
        out.println("int index = 1;");
        this._entityType.getId().generateSet(out, "pstmt", "index", "super");
        out.println();
        out.println("java.sql.ResultSet rs = pstmt.executeQuery();");
        out.println("if (rs.next()) {");
        out.pushDepth();
        this._entityType.generateLoad(out, "rs", "", 1, this._index);
        out.println(new CharBuffer().append("__caucho_loadMask_").append(group).append(" |= ").append(mask).append("L;").toString());
        if (this._entityType.getHasLoadCallback()) {
            out.println("__caucho_load_callback();");
        }
        out.popDepth();
        out.println("}");
        out.println("else {");
        out.println("  rs.close();");
        String errorString = new CharBuffer().append("(\"amber load: no matching object ").append(this._entityType.getName()).append("[\" + __caucho_getPrimaryKey() + \"]\")").toString();
        out.println(new CharBuffer().append("  throw new com.caucho.amber.AmberObjectNotFoundException(").append(errorString).append(");").toString());
        out.println("}");
        out.popDepth();
        out.println("} catch (RuntimeException e) {");
        out.println("  throw e;");
        out.println("} catch (Exception e) {");
        out.println("  throw new com.caucho.amber.AmberRuntimeException(e);");
        out.println("}");
        out.popDepth();
        out.println("}");
        if (this._index == 0 && this._entityType.getHasLoadCallback()) {
            out.println();
            out.println("protected void __caucho_load_callback() {}");
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.amber.gen.LoadGroupGenerator");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

