/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.gen;

import com.caucho.Version;
import com.caucho.amber.field.AmberField;
import com.caucho.amber.field.Id;
import com.caucho.amber.field.IdField;
import com.caucho.amber.field.StubMethod;
import com.caucho.amber.gen.LoadGroupGenerator;
import com.caucho.amber.table.Column;
import com.caucho.amber.table.Table;
import com.caucho.amber.type.EntityType;
import com.caucho.bytecode.JMethod;
import com.caucho.java.JavaWriter;
import com.caucho.java.gen.ClassComponent;
import com.caucho.loader.Environment;
import com.caucho.make.PersistentDependency;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityComponent
extends ClassComponent {
    private static final L10N L = new L10N(EntityComponent._resin_compat_class_0());
    private String _baseClassName;
    private String _extClassName;
    private EntityType _entityType;
    private ArrayList<PersistentDependency> _dependencies = new ArrayList();
    private static Class _resin_compat_class_0;

    public void setEntityType(EntityType entityType) {
        this._entityType = entityType;
        this._dependencies.addAll(entityType.getDependencies());
        for (int i = 0; i < this._dependencies.size(); ++i) {
            Environment.addDependency(this._dependencies.get(i));
        }
    }

    public void setBaseClassName(String baseClassName) {
        this._baseClassName = baseClassName;
    }

    public String getBaseClassName() {
        return this._baseClassName;
    }

    public void setExtClassName(String extClassName) {
        this._extClassName = extClassName;
    }

    public String getClassName() {
        return this._extClassName;
    }

    public String getBeanClassName() {
        return this._baseClassName;
    }

    public ArrayList<PersistentDependency> getDependencies() {
        return this._dependencies;
    }

    @Override
    public void generate(JavaWriter out) throws IOException {
        this.generateHeader(out);
        this.generateInit(out);
        HashSet<Object> completedSet = new HashSet<Object>();
        this.generatePrologue(out, completedSet);
        this.generateGetEntityType(out);
        this.generateMatch(out);
        this.generateFields(out);
        this.generateMethods(out);
        this.generateLoad(out);
        int min = 0;
        if (this._entityType.getParentType() != null) {
            min = this._entityType.getParentType().getLoadGroupIndex() + 1;
        }
        int max = this._entityType.getLoadGroupIndex();
        for (int i = min; i <= max; ++i) {
            this.generateLoadGroup(out, i);
        }
        this.generateResultSetLoad(out);
        this.generateSetQuery(out);
        this.generateCopy(out);
        this.generateMakePersistent(out);
        this.generateCreate(out);
        this.generateDelete(out);
        this.generateDeleteForeign(out);
        this.generateFlush(out);
        this.generateAfterCommit(out);
        this.generateAfterRollback(out);
        this.generateHome(out);
    }

    private void generateHeader(JavaWriter out) throws IOException {
        out.println("/*");
        out.println(" * Generated by Resin Amber");
        out.println(new CharBuffer().append(" * ").append(Version.VERSION).toString());
        out.println(" */");
        out.print("private static final java.util.logging.Logger __caucho_log = ");
        out.println(new CharBuffer().append("java.util.logging.Logger.getLogger(\"").append(this.getBeanClassName()).append("\");").toString());
        if (this._entityType.getParentType() == null) {
            out.println();
            out.println("protected transient com.caucho.amber.type.EntityType __caucho_home;");
            out.println("public transient com.caucho.amber.entity.EntityItem __caucho_item;");
            out.println("protected transient com.caucho.amber.connection.AmberConnectionImpl __caucho_session;");
            out.println("protected transient int __caucho_state;");
            int loadCount = this._entityType.getLoadGroupIndex();
            for (int i = 0; i <= loadCount / 64; ++i) {
                out.println(new CharBuffer().append("protected transient long __caucho_loadMask_").append(i).append(";").toString());
            }
            int dirtyCount = this._entityType.getDirtyIndex();
            for (int i = 0; i <= dirtyCount / 64; ++i) {
                out.println(new CharBuffer().append("protected transient long __caucho_dirtyMask_").append(i).append(";").toString());
                out.println(new CharBuffer().append("protected transient long __caucho_updateMask_").append(i).append(";").toString());
            }
        }
    }

    private void generateInit(JavaWriter out) throws IOException {
        if (this._entityType.getParentType() != null) {
            return;
        }
        out.println();
        out.println("public void __caucho_setPrimaryKey(Object key)");
        out.println("{");
        out.pushDepth();
        Id id = this._entityType.getId();
        if (id == null) {
            throw new IllegalStateException(L.l("`{0}' is missing a key.", this._entityType.getName()));
        }
        id.generateSet(out, id.generateCastFromObject("key"));
        out.popDepth();
        out.println("}");
        out.println();
        out.println("public Object __caucho_getPrimaryKey()");
        out.println("{");
        out.pushDepth();
        out.print("return ");
        out.print(id.toObject(id.generateGetProperty("super")));
        out.println(";");
        out.popDepth();
        out.println("}");
        out.println();
        out.println("public void __caucho_setConnection(com.caucho.amber.connection.AmberConnectionImpl aConn)");
        out.println("{");
        out.pushDepth();
        out.println("__caucho_session = aConn;");
        out.popDepth();
        out.println("}");
        this.generateExpire(out);
    }

    private void generateExpire(JavaWriter out) throws IOException {
        out.println();
        out.println("public void __caucho_expire()");
        out.println("{");
        int loadCount = this._entityType.getLoadGroupIndex();
        for (int i = 0; i <= loadCount / 64; ++i) {
            out.println(new CharBuffer().append("  __caucho_loadMask_").append(i).append(" = 0L;").toString());
        }
        this._entityType.generateExpire(out);
        out.println("}");
    }

    private void generateMatch(JavaWriter out) throws IOException {
        if (this._entityType.getParentType() != null) {
            return;
        }
        out.println();
        out.println("public boolean __caucho_match(String className, Object key)");
        out.println("{");
        out.pushDepth();
        out.println(new CharBuffer().append("if (! (\"").append(this.getBeanClassName()).append("\".equals(className)))").toString());
        out.println("  return false;");
        out.println("else {");
        out.pushDepth();
        Id id = this._entityType.getId();
        id.generateMatch(out, id.generateCastFromObject("key"));
        out.popDepth();
        out.println("}");
        out.popDepth();
        out.println("}");
    }

    private void generatePrologue(JavaWriter out, HashSet<Object> completedSet) throws IOException {
        for (Column column : this._entityType.getColumns()) {
            column.generatePrologue(out);
        }
        Id id = this._entityType.getId();
        if (id != null) {
            id.generatePrologue(out, completedSet);
        }
        ArrayList<AmberField> _fields = this._entityType.getFields();
        for (int i = 0; i < _fields.size(); ++i) {
            AmberField prop = _fields.get(i);
            prop.generatePrologue(out, completedSet);
        }
    }

    private void generateGetEntityType(JavaWriter out) throws IOException {
        out.println();
        out.println("public com.caucho.amber.type.EntityType __caucho_getEntityType()");
        out.println("{");
        out.pushDepth();
        out.println("return __caucho_home;");
        out.popDepth();
        out.println("}");
    }

    private void generateFields(JavaWriter out) throws IOException {
        ArrayList<AmberField> _fields = this._entityType.getFields();
        for (int i = 0; i < _fields.size(); ++i) {
            AmberField prop = _fields.get(i);
            prop.generateSuperGetter(out);
            prop.generateGetProperty(out);
            prop.generateSuperSetter(out);
            prop.generateSetProperty(out);
        }
    }

    private void generateMethods(JavaWriter out) throws IOException {
        for (StubMethod method : this._entityType.getMethods()) {
            method.generate(out);
        }
    }

    private void generateLoad(JavaWriter out) throws IOException {
        if (this._entityType.getParentType() != null) {
            return;
        }
        out.println();
        out.println("public boolean __caucho_makePersistent(com.caucho.amber.connection.AmberConnectionImpl aConn, com.caucho.amber.type.EntityType home)");
        out.println("  throws java.sql.SQLException");
        out.println("{");
        out.pushDepth();
        out.println("__caucho_session = aConn;");
        out.println("if (home != null)");
        out.println("  __caucho_home = home;");
        out.println("__caucho_state = com.caucho.amber.entity.Entity.P_NON_TRANSACTIONAL;");
        int loadCount = this._entityType.getLoadGroupIndex();
        for (int i = 0; i <= loadCount / 64; ++i) {
            out.println(new CharBuffer().append("  __caucho_loadMask_").append(i).append(" = 0L;").toString());
        }
        int dirtyCount = this._entityType.getDirtyIndex();
        for (int i = 0; i <= dirtyCount / 64; ++i) {
            out.println(new CharBuffer().append("  __caucho_dirtyMask_").append(i).append(" = 0L;").toString());
            out.println(new CharBuffer().append("  __caucho_updateMask_").append(i).append(" = 0L;").toString());
        }
        out.println();
        out.println("return true;");
        out.popDepth();
        out.println("}");
        out.println();
        out.println("public void __caucho_retrieve(com.caucho.amber.connection.AmberConnectionImpl aConn)");
        out.println("  throws java.sql.SQLException");
        out.println("{");
        out.pushDepth();
        out.println("__caucho_load_0(aConn);");
        out.popDepth();
        out.println("}");
    }

    private void generateLoadGroup(JavaWriter out, int groupIndex) throws IOException {
        if (this._entityType.hasLoadGroup(groupIndex)) {
            new LoadGroupGenerator(this._extClassName, this._entityType, groupIndex).generate(out);
        }
    }

    private void generateResultSetLoad(JavaWriter out) throws IOException {
        if (this._entityType.getParentType() != null) {
            return;
        }
        out.println();
        out.println("public void __caucho_load(com.caucho.amber.connection.AmberConnectionImpl aConn, java.sql.ResultSet rs, int index)");
        out.println("  throws java.sql.SQLException");
        out.println("{");
        out.pushDepth();
        this._entityType.generateLoad(out, "rs", "index", 0, 0);
        out.println("__caucho_loadMask_0 |= 1L;");
        int dirtyCount = this._entityType.getDirtyIndex();
        for (int i = 0; i <= dirtyCount / 64; ++i) {
            out.println(new CharBuffer().append("__caucho_dirtyMask_").append(i).append(" = 0;").toString());
            out.println(new CharBuffer().append("__caucho_updateMask_").append(i).append(" = 0;").toString());
        }
        out.println();
        out.println("if (__caucho_state == com.caucho.amber.entity.Entity.P_TRANSACTIONAL || __caucho_state == com.caucho.amber.entity.Entity.P_NEW) {");
        out.println("}");
        out.println("else if (__caucho_session == null ||");
        out.println("         ! __caucho_session.isInTransaction()) {");
        out.println("  __caucho_state = com.caucho.amber.entity.Entity.P_NON_TRANSACTIONAL;");
        out.println("  if (__caucho_item != null)");
        out.println("    __caucho_item.save(this);");
        out.println("}");
        out.println("else {");
        out.println("  __caucho_state = com.caucho.amber.entity.Entity.P_TRANSACTIONAL;");
        out.println("  aConn.makeTransactional(this);");
        out.println("}");
        if (this._entityType.getHasLoadCallback()) {
            out.println();
            out.println("__caucho_load_callback();");
        }
        out.popDepth();
        out.println("}");
    }

    private void generateSetQuery(JavaWriter out) throws IOException {
        if (this._entityType.getParentType() != null) {
            return;
        }
        out.println();
        out.println("public void __caucho_setKey(java.sql.PreparedStatement pstmt, int index)");
        out.println("  throws java.sql.SQLException");
        out.println("{");
        out.pushDepth();
        this._entityType.generateSet(out, "pstmt", "index", "super");
        out.popDepth();
        out.println("}");
    }

    private void generateFlush(JavaWriter out) throws IOException {
        int i;
        out.println();
        out.println("protected void __caucho_flush_callback()");
        out.println("  throws java.sql.SQLException");
        out.println("{");
        out.println("}");
        out.println();
        out.println("public boolean __caucho_flush()");
        out.println("  throws java.sql.SQLException");
        out.println("{");
        out.pushDepth();
        out.println("if (__caucho_state == com.caucho.amber.entity.Entity.P_DELETED) {");
        out.println("  __caucho_delete_int();");
        out.println("  return true;");
        out.println("}");
        out.println();
        out.println("boolean isDirty = false;");
        int dirtyCount = this._entityType.getDirtyIndex();
        for (i = 0; i <= dirtyCount / 64; ++i) {
            out.println(new CharBuffer().append("long mask_").append(i).append(" = __caucho_dirtyMask_").append(i).append(";").toString());
            out.println(new CharBuffer().append("__caucho_dirtyMask_").append(i).append(" = 0L;").toString());
            out.println(new CharBuffer().append("__caucho_updateMask_").append(i).append(" |= mask_").append(i).append(";").toString());
            out.println();
            out.println(new CharBuffer().append("if (mask_").append(i).append(" != 0L)").toString());
            out.println("  isDirty = true;");
        }
        out.println("if (! isDirty)");
        out.println("  return true;");
        out.println();
        out.println("__caucho_flush_callback();");
        out.println();
        out.println("com.caucho.util.CharBuffer cb = new com.caucho.util.CharBuffer();");
        out.println("__caucho_home.generateUpdateSQLPrefix(cb);");
        out.println("boolean isFirst = true;");
        for (i = 0; i <= dirtyCount / 64; ++i) {
            out.println(new CharBuffer().append("if (mask_").append(i).append(" != 0L)").toString());
            out.println(new CharBuffer().append("  isFirst = __caucho_home.generateUpdateSQLComponent(cb, ").append(i).append(", mask_").append(i).append(", isFirst);").toString());
        }
        out.println("__caucho_home.generateUpdateSQLSuffix(cb);");
        out.println("java.sql.PreparedStatement pstmt = __caucho_session.prepareStatement(cb.toString());");
        out.println("int index = 1;");
        ArrayList<AmberField> fields = this._entityType.getFields();
        for (int i2 = 0; i2 < fields.size(); ++i2) {
            AmberField field = fields.get(i2);
            field.generateUpdate(out, "mask", "pstmt", "index");
        }
        out.println();
        this._entityType.getId().generateSet(out, "pstmt", "index");
        out.println();
        out.println("pstmt.executeUpdate();");
        out.println();
        out.println("if (__caucho_log.isLoggable(java.util.logging.Level.FINE))");
        out.println("  __caucho_log.fine(\"amber update \" + this);");
        out.println();
        out.println("return false;");
        out.popDepth();
        out.println("}");
    }

    private void generateFlushUpdate(JavaWriter out) throws IOException {
        out.println();
        out.println("protected void __caucho_flushUpdate(long mask, com.caucho.amber.type.EntityType home)");
        out.println("  throws java.sql.SQLException");
        out.println("{");
        out.pushDepth();
        if (this._entityType.getParentType() != null) {
            out.println("super.__caucho_flushUpdate(mask, home.getParentType());");
        }
        EntityType type = this._entityType;
        out.println("String sql = home.generateUpdateSQL(mask);");
        out.println("if (sql != null) {");
        out.pushDepth();
        out.println("java.sql.PreparedStatement pstmt = __caucho_session.prepareStatement(sql);");
        out.println("int index = 1;");
        ArrayList<AmberField> fields = this._entityType.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            AmberField field = fields.get(i);
            field.generateUpdate(out, "mask", "pstmt", "index");
        }
        out.println();
        this._entityType.getId().generateSet(out, "pstmt", "index");
        out.println();
        out.println("pstmt.executeUpdate();");
        out.println();
        out.println("if (__caucho_log.isLoggable(java.util.logging.Level.FINE))");
        out.println("  __caucho_log.fine(\"amber update \" + this);");
        out.popDepth();
        out.println("}");
        out.popDepth();
        out.println("}");
    }

    private void generateAfterCommit(JavaWriter out) throws IOException {
        long mask;
        int i;
        out.println();
        out.println("public void __caucho_afterCommit()");
        out.println("{");
        out.pushDepth();
        out.println("int state = __caucho_state;");
        out.println("__caucho_state = com.caucho.amber.entity.Entity.P_NON_TRANSACTIONAL;");
        int dirtyCount = this._entityType.getDirtyIndex();
        for (i = 0; i <= dirtyCount / 64; ++i) {
            out.println(new CharBuffer().append("long updateMask_").append(i).append(" = __caucho_updateMask_").append(i).append(";").toString());
            out.println(new CharBuffer().append("__caucho_updateMask_").append(i).append(" = 0L;").toString());
        }
        out.print("if (updateMask_0 != 0L");
        for (i = 1; i <= dirtyCount / 64; ++i) {
            out.print(new CharBuffer().append(" || updateMask_").append(i).append(" != 0L").toString());
        }
        out.println(")");
        out.println("  __caucho_session.update(this);");
        out.println("if (__caucho_item != null) {");
        out.pushDepth();
        out.println(new CharBuffer().append(this._extClassName).append(" item = (").append(this._extClassName).append(") __caucho_item.getEntity();").toString());
        out.println("if ((__caucho_loadMask_0 & 1L) != 0) {");
        out.pushDepth();
        out.println("item.__caucho_loadMask_0 = 1L;");
        this._entityType.generateCopyLoadObject(out, "item", "super", 0);
        for (i = 1; i < this._entityType.getLoadGroupIndex(); ++i) {
            String loadVar = new CharBuffer().append("__caucho_loadMask_").append(i / 64).toString();
            mask = 1L << i % 64;
            out.println(new CharBuffer().append("if ((").append(loadVar).append(" & ").append(mask).append("L) != 0) {").toString());
            out.pushDepth();
            this._entityType.generateCopyLoadObject(out, "item", "super", i);
            out.println(new CharBuffer().append("item.").append(loadVar).append(" |= ").append(mask).append("L;").toString());
            out.popDepth();
            out.println("}");
        }
        out.popDepth();
        out.println("}");
        for (i = 0; i < this._entityType.getDirtyIndex(); ++i) {
            int group = i / 64;
            mask = 1L << i % 64;
            out.println(new CharBuffer().append("if ((updateMask_").append(group).append(" & ").append(mask).append("L) != 0) {").toString());
            out.pushDepth();
            this._entityType.generateCopyUpdateObject(out, "item", "super", i);
            out.popDepth();
            out.println("}");
        }
        out.popDepth();
        out.println("}");
        out.popDepth();
        out.println("}");
    }

    private void generateAfterRollback(JavaWriter out) throws IOException {
        out.println();
        out.println("public void __caucho_afterRollback()");
        out.println("{");
        out.pushDepth();
        out.println("__caucho_state = com.caucho.amber.entity.Entity.P_NON_TRANSACTIONAL;");
        int loadCount = this._entityType.getLoadGroupIndex();
        for (int i = 0; i <= loadCount / 64; ++i) {
            out.println(new CharBuffer().append("__caucho_loadMask_").append(i).append(" = 0L;").toString());
        }
        int dirtyCount = this._entityType.getDirtyIndex();
        for (int i = 0; i <= dirtyCount / 64; ++i) {
            out.println(new CharBuffer().append("__caucho_dirtyMask_").append(i).append(" = 0L;").toString());
        }
        out.popDepth();
        out.println("}");
    }

    private String getDebug() {
        return "this";
    }

    private void generateCreate(JavaWriter out) throws IOException {
        int i;
        IdField idField;
        ArrayList<IdField> fields = this._entityType.getId().getKeys();
        IdField idField2 = idField = fields.size() > 0 ? fields.get(0) : null;
        if (!this._entityType.getAmberManager().hasReturnGeneratedKeys() && idField != null && idField.getType().isAutoIncrement()) {
            out.println();
            out.println("private static com.caucho.amber.field.Generator __caucho_id_gen;");
            out.println("static {");
            out.pushDepth();
            out.println("com.caucho.amber.field.MaxGenerator gen = new com.caucho.amber.field.MaxGenerator();");
            out.println(new CharBuffer().append("gen.setColumn(\"").append(idField.getColumns().get(0).generateInsertName()).append("\");").toString());
            out.println(new CharBuffer().append("gen.setTable(\"").append(this._entityType.getName()).append("\");").toString());
            out.println("gen.init();");
            out.popDepth();
            out.println("}");
        }
        out.println();
        out.println("public boolean __caucho_create(com.caucho.amber.connection.AmberConnectionImpl aConn, com.caucho.amber.type.EntityType home)");
        out.println("  throws java.sql.SQLException");
        out.println("{");
        out.pushDepth();
        out.println("if (__caucho_session != null)");
        out.println(new CharBuffer().append("  throw new com.caucho.amber.AmberException(\"object \" + ").append(this.getDebug()).append(" + \" is already persistent.\");").toString());
        out.println("__caucho_state = com.caucho.amber.entity.Entity.P_NEW;");
        int loadCount = this._entityType.getLoadGroupIndex();
        for (int i2 = 0; i2 <= loadCount / 64; ++i2) {
            out.println(new CharBuffer().append("__caucho_loadMask_").append(i2).append(" = -1L;").toString());
        }
        int dirtyCount = this._entityType.getDirtyIndex();
        for (int i3 = 0; i3 <= dirtyCount / 64; ++i3) {
            out.println(new CharBuffer().append("__caucho_dirtyMask_").append(i3).append(" = 0L;").toString());
        }
        for (JMethod method : this._entityType.getPrePersistCallbacks()) {
            out.println(new CharBuffer().append(method.getName()).append("();").toString());
        }
        Table table = this._entityType.getTable();
        out.print("String sql = \"");
        out.print(this._entityType.generateCreateSQL(table));
        out.println("\";");
        this._entityType.getId().generateCheckCreateKey(out);
        out.println("java.sql.PreparedStatement pstmt = aConn.prepareInsertStatement(sql);");
        out.println("int index = 1;");
        out.println();
        this._entityType.getId().generateSetInsert(out, "pstmt", "index");
        this._entityType.generateInsertSet(out, table, "pstmt", "index", "super");
        out.println();
        out.println("pstmt.executeUpdate();");
        out.println();
        this._entityType.getId().generateSetGeneratedKeys(out, "pstmt");
        for (Table subTable : this._entityType.getSecondaryTables()) {
            out.println();
            out.print("sql = \"");
            out.print(this._entityType.generateCreateSQL(subTable));
            out.println("\";");
            out.println("pstmt = aConn.prepareStatement(sql);");
            out.println("index = 1;");
            out.println();
            this._entityType.getId().generateSetInsert(out, "pstmt", "index");
            this._entityType.generateInsertSet(out, subTable, "pstmt", "index", "super");
            out.println();
            out.println("pstmt.executeUpdate();");
            out.println();
            this._entityType.getId().generateSetGeneratedKeys(out, "pstmt");
        }
        out.println();
        out.println("__caucho_session = aConn;");
        out.println("__caucho_home = home;");
        out.println(new CharBuffer().append("__caucho_item = new com.caucho.amber.entity.CacheableEntityItem(home.getHome(), new ").append(this.getClassName()).append("());").toString());
        out.println(new CharBuffer().append(this.getClassName()).append(" entity = (").append(this.getClassName()).append(") __caucho_item.getEntity();").toString());
        out.println("entity.__caucho_home = home;");
        ArrayList<IdField> keys = this._entityType.getId().getKeys();
        for (IdField key : keys) {
            String value = key.generateGet("super");
            out.println(new CharBuffer().append(key.generateSet("entity", value)).append(";").toString());
        }
        for (i = 0; i < 1; ++i) {
            this._entityType.generateCopyUpdateObject(out, "entity", "super", i);
        }
        for (i = 0; i <= loadCount / 64; ++i) {
            out.println(new CharBuffer().append("entity.__caucho_loadMask_").append(i).append(" = -1L;").toString());
        }
        out.println();
        out.println("if (__caucho_log.isLoggable(java.util.logging.Level.FINE))");
        out.println("  __caucho_log.fine(\"amber create \" + this);");
        for (JMethod method : this._entityType.getPostPersistCallbacks()) {
            out.println(new CharBuffer().append(method.getName()).append("();").toString());
        }
        out.println();
        out.println("return false;");
        out.popDepth();
        out.println("}");
    }

    private void generateDelete(JavaWriter out) throws IOException {
        out.println();
        out.println("public void __caucho_delete()");
        out.println("{");
        out.pushDepth();
        out.println("if (__caucho_state >= com.caucho.amber.entity.Entity.P_DELETING)");
        out.println("  return;");
        this._entityType.generatePreDelete(out);
        out.println("__caucho_state = com.caucho.amber.entity.Entity.P_DELETING;");
        out.println("if (__caucho_session != null) {");
        out.pushDepth();
        out.println("__caucho_session.update(this);");
        out.println("__caucho_home.getTable().beforeEntityDelete(__caucho_session, this);");
        out.println("__caucho_state = com.caucho.amber.entity.Entity.P_DELETED;");
        this._entityType.generatePostDelete(out);
        out.popDepth();
        out.println("}");
        out.println("else");
        out.println("  __caucho_state = com.caucho.amber.entity.Entity.P_DELETED;");
        out.popDepth();
        out.println("}");
        Id id = this._entityType.getId();
        out.println();
        out.println("private void __caucho_delete_int()");
        out.println("  throws java.sql.SQLException");
        out.println("{");
        out.pushDepth();
        out.print("__caucho_home.delete(__caucho_session, ");
        out.print(id.toObject(id.generateGetProperty("this")));
        out.println(");");
        String table = this._entityType.getTable().getName();
        String where = this._entityType.getId().generateMatchArgWhere(null);
        String sql = new CharBuffer().append("DELETE FROM ").append(table).append(" WHERE ").append(where).toString();
        out.println(new CharBuffer().append("String sql = \"").append(sql).append("\";").toString());
        out.println();
        out.println("java.sql.PreparedStatement pstmt = __caucho_session.prepareStatement(sql);");
        out.println("int index = 1;");
        id.generateSet(out, "pstmt", "index", "this");
        out.println();
        out.println("pstmt.executeUpdate();");
        out.popDepth();
        out.println("}");
    }

    private void generateDeleteForeign(JavaWriter out) throws IOException {
        out.println();
        out.println("public void __caucho_invalidate_foreign(String table, Object key)");
        out.println("{");
        out.pushDepth();
        this._entityType.generateInvalidateForeign(out);
        out.popDepth();
        out.println("}");
    }

    private void generateLoadFromObject(JavaWriter out) throws IOException {
        int i;
        out.println();
        out.println("public void __caucho_loadFromObject(Object src)");
        out.println("{");
        out.pushDepth();
        out.println(new CharBuffer().append(this.getClassName()).append(" o = (").append(this.getClassName()).append(") src;").toString());
        if (this._entityType.getParentType() != null) {
            out.println("super.__caucho_loadFromObject(src);");
        } else {
            int loadCount = this._entityType.getLoadGroupIndex();
            for (i = 0; i <= loadCount / 64; ++i) {
                out.println(new CharBuffer().append("__caucho_loadMask_").append(i).append(" = o.__caucho_loadMask_").append(i).append(";").toString());
            }
        }
        int dirtyCount = this._entityType.getDirtyIndex();
        for (i = 0; i <= dirtyCount / 64; ++i) {
            out.println(new CharBuffer().append("__caucho_dirtyMask_").append(i).append(" = 0;").toString());
        }
        this._entityType.generateLoadFromObject(out, "o");
        out.popDepth();
        out.println("}");
    }

    private void generateCopy(JavaWriter out) throws IOException {
        out.println();
        out.println("public com.caucho.amber.entity.Entity __caucho_copy(com.caucho.amber.connection.AmberConnectionImpl aConn,");
        out.println("                                                    com.caucho.amber.entity.EntityItem item)");
        out.println("{");
        out.pushDepth();
        out.println(new CharBuffer().append(this.getClassName()).append(" o = new ").append(this.getClassName()).append("();").toString());
        out.println("o.__caucho_home = __caucho_home;");
        out.println("o.__caucho_item = item;");
        ArrayList<IdField> keys = this._entityType.getId().getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            IdField key = keys.get(i);
            out.println(new CharBuffer().append(key.generateSet("o", key.generateGet("super"))).append(";").toString());
        }
        this._entityType.generateCopyLoadObject(out, "o", "super", 0);
        out.println("o.__caucho_session = aConn;");
        out.println("o.__caucho_state = com.caucho.amber.entity.Entity.P_NON_TRANSACTIONAL;");
        out.println("o.__caucho_loadMask_0 = __caucho_loadMask_0 & 1L;");
        out.println();
        out.println("return o;");
        out.popDepth();
        out.println("}");
    }

    private void generateMakePersistent(JavaWriter out) throws IOException {
        out.println();
        out.println("public void __caucho_makePersistent(com.caucho.amber.connection.AmberConnectionImpl aConn,");
        out.println("                                    com.caucho.amber.entity.EntityItem item)");
        out.println("{");
        out.pushDepth();
        out.println(new CharBuffer().append(this._extClassName).append(" entity = (").append(this._extClassName).append(") item.getEntity();").toString());
        out.println("__caucho_home = entity.__caucho_home;");
        out.println("if (__caucho_home == null) throw new NullPointerException();");
        out.println("__caucho_item = item;");
        ArrayList<IdField> keys = this._entityType.getId().getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            IdField key = keys.get(i);
            out.println(new CharBuffer().append(key.generateSet("super", key.generateGet("entity"))).append(";").toString());
        }
        out.println("__caucho_session = aConn;");
        out.println("__caucho_state = com.caucho.amber.entity.Entity.P_NON_TRANSACTIONAL;");
        out.popDepth();
        out.println("}");
    }

    private void generateHome(JavaWriter out) throws IOException {
        this.generateHomeFind(out);
        this.generateHomeNew(out);
    }

    private void generateHomeFind(JavaWriter out) throws IOException {
        out.println();
        out.print("public com.caucho.amber.entity.EntityItem __caucho_home_find(");
        out.print("com.caucho.amber.connection.AmberConnectionImpl aConn,");
        out.print("com.caucho.amber.entity.AmberEntityHome home,");
        out.println("java.sql.ResultSet rs, int index)");
        out.println("  throws java.sql.SQLException");
        out.println("{");
        out.pushDepth();
        out.print("Object key = ");
        int index = this._entityType.getId().generateLoadForeign(out, "rs", "index", 0);
        out.println(";");
        if (this._entityType.getDiscriminator() == null) {
            out.println("return home.findEntityItem(aConn, key, false);");
        } else {
            out.println(new CharBuffer().append("String discriminator = rs.getString(index + ").append(index).append(");").toString());
            out.println();
            out.println("return home.findDiscriminatorEntityItem(aConn, key, discriminator);");
        }
        out.popDepth();
        out.println("}");
    }

    private void generateHomeNew(JavaWriter out) throws IOException {
        out.println();
        out.print("public com.caucho.amber.entity.Entity __caucho_home_new(");
        out.print("com.caucho.amber.connection.AmberConnectionImpl aConn,");
        out.print("com.caucho.amber.entity.AmberEntityHome home,");
        out.print("Object key)");
        out.println("  throws java.sql.SQLException");
        out.println("{");
        out.pushDepth();
        Column discriminator = this._entityType.getDiscriminator();
        if (discriminator == null) {
            out.println(new CharBuffer().append(this.getClassName()).append(" entity = new ").append(this.getClassName()).append("();").toString());
            out.println("entity.__caucho_home = home.getEntityType();");
            out.println("entity.__caucho_setPrimaryKey(key);");
            out.println("return entity;");
        } else {
            out.print("String sql = \"SELECT ");
            out.print(this._entityType.generateLoadSelect("o"));
            out.print(new CharBuffer().append(" FROM ").append(this._entityType.getTable().getName()).append(" o WHERE ").toString());
            out.print(this._entityType.getId().generateMatchArgWhere("o"));
            out.println("\";");
            out.println("java.sql.PreparedStatement pstmt = aConn.prepareStatement(sql);");
            String keyType = this._entityType.getId().getForeignTypeName();
            out.println(new CharBuffer().append(keyType).append(" keyValue = (").append(keyType).append(") key;").toString());
            out.println("int index = 1;");
            this._entityType.getId().generateSetKey(out, "pstmt", "index", "keyValue");
            out.println("java.sql.ResultSet rs = pstmt.executeQuery();");
            out.println("if (! rs.next()) {");
            out.println("  rs.close();");
            out.println("  throw new com.caucho.amber.AmberException(key + \" has no matching object\");");
            out.println("}");
            out.println("com.caucho.amber.entity.EntityItem item = home.findDiscriminatorEntityItem(aConn, key, rs.getString(1));");
            out.println("item.getEntity().__caucho_load(aConn, rs, 1);");
            out.println(new CharBuffer().append(this.getClassName()).append(" entity = (").append(this.getClassName()).append(") item.copy(aConn);").toString());
            out.println("rs.close();");
            out.println("return entity;");
        }
        out.popDepth();
        out.println("}");
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.amber.gen.EntityComponent");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

