/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.gen;

import com.caucho.amber.AmberManager;
import com.caucho.amber.AmberRuntimeException;
import com.caucho.amber.field.AmberField;
import com.caucho.amber.field.IdField;
import com.caucho.amber.gen.AmberGenerator;
import com.caucho.amber.gen.EntityComponent;
import com.caucho.amber.gen.EntityGenerator;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.SubEntityType;
import com.caucho.bytecode.Analyzer;
import com.caucho.bytecode.CodeVisitor;
import com.caucho.bytecode.ConstantPool;
import com.caucho.bytecode.FieldRefConstant;
import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JavaClass;
import com.caucho.bytecode.JavaMethod;
import com.caucho.bytecode.MethodRefConstant;
import com.caucho.config.ConfigException;
import com.caucho.java.JavaCompiler;
import com.caucho.java.gen.DependencyComponent;
import com.caucho.java.gen.GenClass;
import com.caucho.java.gen.JavaClassGenerator;
import com.caucho.loader.Environment;
import com.caucho.loader.enhancer.ClassEnhancer;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AmberEnhancer
implements AmberGenerator,
ClassEnhancer {
    private static final L10N L = new L10N(AmberEnhancer._resin_compat_class_1());
    private static final Logger log = Log.open(AmberEnhancer._resin_compat_class_1());
    private Path _configDirectory;
    private boolean _useHibernateFiles;
    private AmberManager _amberManager;
    private ArrayList<String> _pendingClassNames = new ArrayList();
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;

    public AmberEnhancer(AmberManager manager) {
        this._amberManager = manager;
    }

    public void setConfigDirectory(Path dir) {
        this._configDirectory = dir;
    }

    public void setUseHibernateFiles(boolean useHibernateFiles) {
        this._useHibernateFiles = useHibernateFiles;
    }

    public void init() throws Exception {
        if (this._useHibernateFiles && this._configDirectory != null) {
            String[] list = this._configDirectory.list();
            for (int i = 0; i < list.length; ++i) {
                String name = list[i];
                if (!name.endsWith(".hbm.xml")) continue;
                Path path = this._configDirectory.lookup(name);
                this.parseHibernateMapping(path);
            }
            this.compile();
            this._amberManager.initEntityHomes();
        }
    }

    protected boolean isModified(Class preloadedClass) {
        try {
            Method init = preloadedClass.getMethod("_caucho_init", AmberEnhancer._resin_compat_class_0());
            if (this._configDirectory != null) {
                init.invoke(null, this._configDirectory);
            } else {
                init.invoke(null, Vfs.lookup());
            }
            Method isModified = preloadedClass.getMethod("_caucho_is_modified", new Class[0]);
            Object value = isModified.invoke(null, new Object[0]);
            if (Boolean.FALSE.equals(value)) {
                this.loadEntityType(preloadedClass, preloadedClass.getClassLoader());
                return false;
            }
            return true;
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
            return true;
        }
    }

    public boolean shouldEnhance(String className) {
        EntityType type;
        int p = className.lastIndexOf(45);
        if (p > 0) {
            className = className.substring(0, p);
        }
        if ((p = className.lastIndexOf(36)) > 0) {
            className = className.substring(0, p);
        }
        return (type = this._amberManager.getEntity(className)) != null && type.isEnhanced();
    }

    private EntityType loadEntityType(Class cl, ClassLoader loader) {
        EntityType parentType = null;
        while (cl != null) {
            String className = cl.getName();
            EntityType type = this._amberManager.getEntity(className);
            if (parentType == null) {
                parentType = type;
            }
            if (type != null && !type.startConfigure()) {
                return type;
            }
            type = this.loadEntityTypeImpl(cl, loader);
            if (type != null && !type.startConfigure()) {
                return type;
            }
            cl = cl.getSuperclass();
        }
        return parentType;
    }

    protected EntityType loadEntityTypeImpl(Class cl, ClassLoader rawLoader) {
        if (!this._useHibernateFiles) {
            return null;
        }
        String className = cl.getName();
        String xmlName = new CharBuffer().append(className.replace('.', '/')).append(".hbm.xml").toString();
        URL url = rawLoader.getResource(xmlName);
        if (url == null) {
            return null;
        }
        Path path = Vfs.lookup(url.toString());
        try {
            this.parseHibernateMapping(path);
            EntityType type = this._amberManager.getEntity(className);
            type.setInstanceClassName(new CharBuffer().append(className).append("__ResinExt").toString());
            type.setEnhanced(true);
            return type;
        }
        catch (Exception e) {
            throw new AmberRuntimeException(e);
        }
    }

    public void preEnhance(JavaClass baseClass) throws Exception {
        EntityType type = this._amberManager.getEntity(baseClass.getName());
        if (type instanceof SubEntityType) {
            SubEntityType subType = (SubEntityType)type;
            String parentClass = subType.getParentType().getInstanceClassName();
            baseClass.setSuperClass(parentClass.replace('.', '/'));
        }
    }

    public void enhance(GenClass genClass, JClass baseClass, String extClassName) throws Exception {
        String className = baseClass.getName();
        EntityType type = this._amberManager.getEntity(className);
        if (type != null) {
            log.info(new CharBuffer().append("Amber enhancing class ").append(className).toString());
            type.init();
            genClass.addInterfaceName("com.caucho.amber.entity.Entity");
            EntityComponent entity = new EntityComponent();
            entity.setEntityType(type);
            entity.setBaseClassName(baseClass.getName());
            entity.setExtClassName(extClassName);
            genClass.addComponent(entity);
            DependencyComponent dependency = genClass.addDependencyComponent();
            dependency.addDependencyList(type.getDependencies());
        }
    }

    public void generate(EntityType type) throws Exception {
        JavaClassGenerator javaGen = new JavaClassGenerator();
        String extClassName = new CharBuffer().append(type.getBeanClass().getName()).append("__ResinExt").toString();
        type.setInstanceClassName(extClassName);
        type.setEnhanced(true);
        this._pendingClassNames.add(type.getInstanceClassName());
        this.generateJava(javaGen, type);
    }

    public void generateJava(JavaClassGenerator javaGen, EntityType type) throws Exception {
        if (type.isGenerated()) {
            return;
        }
        type.setGenerated(true);
        GenClass javaClass = new GenClass(type.getInstanceClassName());
        javaClass.setSuperClassName(type.getBeanClass().getName());
        javaClass.addInterfaceName("com.caucho.amber.entity.Entity");
        type.setEnhanced(true);
        EntityComponent entity = new EntityComponent();
        entity.setEntityType(type);
        entity.setBaseClassName(type.getBeanClass().getName());
        entity.setExtClassName(type.getInstanceClassName());
        javaClass.addComponent(entity);
        javaGen.generate(javaClass);
    }

    public void compile() throws Exception {
        if (this._pendingClassNames.size() == 0) {
            return;
        }
        ArrayList<String> classNames = new ArrayList<String>(this._pendingClassNames);
        this._pendingClassNames.clear();
        String[] javaFiles = new String[classNames.size()];
        for (int i = 0; i < classNames.size(); ++i) {
            String name = classNames.get(i);
            javaFiles[i] = name = new CharBuffer().append(name.replace('.', '/')).append(".java").toString();
        }
        EntityGenerator gen = new EntityGenerator();
        gen.setSearchPath(this._configDirectory);
        JavaCompiler compiler = gen.getCompiler();
        compiler.compileBatch(javaFiles);
        for (int i = 0; i < classNames.size(); ++i) {
            String extClassName = classNames.get(i);
            int tail = extClassName.length() - "__ResinExt".length();
            String baseClassName = extClassName.substring(0, tail);
        }
    }

    public void postEnhance(JavaClass baseClass) throws Exception {
        Iterator<Object> i$;
        String className = baseClass.getThisClass();
        ArrayList<FieldMap> fieldMaps = new ArrayList<FieldMap>();
        for (JClass thisClass = this._amberManager.getJClassLoader().forName(className.replace('/', '.')); thisClass != null; thisClass = thisClass.getSuperClass()) {
            AmberField field;
            EntityType type = this._amberManager.getEntity(thisClass.getName());
            if (type == null || !type.isFieldAccess()) continue;
            i$ = type.getId().getKeys().iterator();
            while (i$.hasNext()) {
                field = (IdField)i$.next();
                fieldMaps.add(new FieldMap(baseClass, field.getName()));
            }
            i$ = type.getFields().iterator();
            while (i$.hasNext()) {
                field = (AmberField)i$.next();
                fieldMaps.add(new FieldMap(baseClass, field.getName()));
            }
        }
        if (fieldMaps.size() == 0) {
            return;
        }
        FieldFixupAnalyzer analyzer = new FieldFixupAnalyzer(fieldMaps);
        i$ = baseClass.getMethodList().iterator();
        while (i$.hasNext()) {
            JavaMethod javaMethod = (JavaMethod)i$.next();
            CodeVisitor visitor = new CodeVisitor(baseClass, javaMethod.getCode());
            visitor.analyze(analyzer, true);
        }
    }

    public void configure(EntityType type) throws ConfigException, IOException {
        String className = type.getName();
        String xmlName = new CharBuffer().append(className.replace('.', '/')).append(".hbm.xml").toString();
        URL url = null;
        if (url == null) {
            return;
        }
        Path path = Vfs.lookup(url.toString());
        if (type.getInstanceClassName() == null) {
            type.setInstanceClassName(new CharBuffer().append(className).append("__ResinExt").toString());
            type.setEnhanced(true);
        }
        try {
            this.parseHibernateMapping(path);
        }
        catch (Exception e) {
            throw new AmberRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseHibernateMapping(Path path) throws ConfigException, IOException {
        Environment.addDependency(new Depend(path));
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(oldLoader);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.vfs.Path");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("com.caucho.amber.gen.AmberEnhancer");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FieldFixupAnalyzer
    extends Analyzer {
        private ArrayList<FieldMap> _fieldMap;

        FieldFixupAnalyzer(ArrayList<FieldMap> fieldMap) {
            this._fieldMap = fieldMap;
        }

        int getGetter(int fieldRef) {
            for (int i = this._fieldMap.size() - 1; i >= 0; --i) {
                FieldMap fieldMap = this._fieldMap.get(i);
                if (fieldMap.getFieldRef() != fieldRef) continue;
                return fieldMap.getGetterRef();
            }
            return -1;
        }

        @Override
        public void analyze(CodeVisitor visitor) {
            switch (visitor.getOpcode()) {
                case 180: {
                    int getter = this.getGetter(visitor.getShortArg());
                    if (getter <= 0) break;
                    visitor.setByteArg(0, 182);
                    visitor.setShortArg(1, getter);
                    break;
                }
                case 181: {
                    int setter = this.getSetter(visitor.getShortArg());
                    if (setter <= 0) break;
                    visitor.setByteArg(0, 182);
                    visitor.setShortArg(1, setter);
                }
            }
        }

        int getSetter(int fieldRef) {
            for (int i = this._fieldMap.size() - 1; i >= 0; --i) {
                FieldMap fieldMap = this._fieldMap.get(i);
                if (fieldMap.getFieldRef() != fieldRef) continue;
                return fieldMap.getSetterRef();
            }
            return -1;
        }
    }

    static class FieldMap {
        private int _fieldRef = -1;
        private int _getterRef;
        private int _setterRef;

        FieldMap(JavaClass baseClass, String fieldName) {
            ConstantPool pool = baseClass.getConstantPool();
            FieldRefConstant fieldRef = pool.getFieldRef(fieldName);
            if (fieldRef == null) {
                return;
            }
            this._fieldRef = fieldRef.getIndex();
            String getterName = new CharBuffer().append("__caucho_get_").append(fieldName).toString();
            MethodRefConstant methodRef = pool.addMethodRef(baseClass.getThisClass(), getterName, new CharBuffer().append("()").append(fieldRef.getType()).toString());
            this._getterRef = methodRef.getIndex();
            String setterName = new CharBuffer().append("__caucho_set_").append(fieldName).toString();
            methodRef = pool.addMethodRef(baseClass.getThisClass(), setterName, new CharBuffer().append("(").append(fieldRef.getType()).append(")V").toString());
            this._setterRef = methodRef.getIndex();
        }

        int getFieldRef() {
            return this._fieldRef;
        }

        int getGetterRef() {
            return this._getterRef;
        }

        int getSetterRef() {
            return this._setterRef;
        }
    }
}

