/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.entity;

import com.caucho.amber.connection.AmberConnectionImpl;
import com.caucho.amber.connection.CacheConnectionImpl;
import com.caucho.amber.entity.AmberEntityHome;
import com.caucho.amber.entity.Entity;
import com.caucho.amber.entity.EntityItem;
import com.caucho.util.Alarm;
import com.caucho.util.CharBuffer;
import java.sql.SQLException;

public class CacheableEntityItem
extends EntityItem {
    private AmberEntityHome _home;
    private Entity _cacheItem;
    private long _expireTime;

    public CacheableEntityItem(AmberEntityHome home, Entity cacheItem) {
        this._home = home;
        this._cacheItem = cacheItem;
        this._expireTime = Alarm.getCurrentTime() + this._home.getCacheTimeout();
    }

    AmberEntityHome getEntityHome() {
        return this._home;
    }

    public Entity getEntity() {
        long now = Alarm.getCurrentTime();
        if (this._expireTime < now) {
            this._expireTime = now + this._home.getCacheTimeout();
            this._cacheItem.__caucho_expire();
        }
        return this._cacheItem;
    }

    public Entity loadEntity(int loadGroup) {
        long now = Alarm.getCurrentTime();
        if (this._expireTime < now) {
            this._expireTime = now + this._home.getCacheTimeout();
            this._cacheItem.__caucho_expire();
        }
        CacheConnectionImpl aConn = this._home.getManager().getCacheConnection();
        try {
            this._cacheItem.__caucho_setConnection(aConn);
            this._cacheItem.__caucho_retrieve(aConn);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            ((AmberConnectionImpl)aConn).freeConnection();
        }
        return this._cacheItem;
    }

    public Entity copy(AmberConnectionImpl aConn) {
        return this._cacheItem.__caucho_copy(aConn, this);
    }

    public void save(Entity item) {
    }

    public void savePart(Entity item) {
    }

    public void expire() {
        this._cacheItem.__caucho_expire();
    }

    Class getInstanceClass() {
        return this._cacheItem.getClass();
    }

    public String toString() {
        return new CharBuffer().append("CacheableEntityItem[").append(this._cacheItem).append("]").toString();
    }
}

