/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.entity;

import com.caucho.amber.AmberException;
import com.caucho.amber.AmberManager;
import com.caucho.amber.connection.AmberConnectionImpl;
import com.caucho.amber.entity.CacheableEntityItem;
import com.caucho.amber.entity.Entity;
import com.caucho.amber.entity.EntityFactory;
import com.caucho.amber.entity.EntityItem;
import com.caucho.amber.entity.EntityKey;
import com.caucho.amber.query.CacheUpdate;
import com.caucho.amber.type.EntityType;
import com.caucho.config.ConfigException;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AmberEntityHome {
    private static final L10N L = new L10N(AmberEntityHome._resin_compat_class_0());
    private static final Logger log = Log.open(AmberEntityHome._resin_compat_class_0());
    private AmberManager _manager;
    private EntityType _entityType;
    private EntityFactory _entityFactory = new EntityFactory();
    private Entity _homeBean;
    private ArrayList<SoftReference<CacheUpdate>> _cacheUpdates = new ArrayList();
    private EntityKey _cacheKey = new EntityKey();
    private volatile boolean _isInit;
    private ConfigException _configException;
    private Method _cauchoGetBeanMethod;
    private static Class _resin_compat_class_0;

    public AmberEntityHome(AmberManager manager, EntityType type) {
        this._manager = manager;
        this._entityType = type;
        try {
            Class<?> cl = Class.forName("com.caucho.ejb.entity.EntityObject");
            this._cauchoGetBeanMethod = cl.getMethod("_caucho_getBean", new Class[0]);
        }
        catch (Throwable e) {
            log.log(Level.FINEST, e.toString(), e);
        }
    }

    public AmberManager getManager() {
        return this._manager;
    }

    public EntityType getEntityType() {
        return this._entityType;
    }

    public EntityType getRootType() {
        return this._entityType.getRootType();
    }

    public EntityFactory getEntityFactory() {
        return this._entityFactory;
    }

    public void setEntityFactory(EntityFactory factory) {
        this._entityFactory = factory;
    }

    public long getCacheTimeout() {
        return this._entityType.getCacheTimeout();
    }

    public Class getInstanceClass() {
        return this._entityType.getInstanceClass();
    }

    void link() throws ConfigException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws ConfigException {
        AmberEntityHome amberEntityHome = this;
        synchronized (amberEntityHome) {
            if (this._isInit) {
                return;
            }
            this._isInit = true;
        }
        this._entityType.init();
        try {
            this._homeBean = (Entity)this._entityType.getInstanceClass().newInstance();
        }
        catch (Exception e) {
            this._configException = new ConfigException(e);
            throw this._configException;
        }
        this._entityType.start();
    }

    public Object getKeyFromEntity(Entity entity) throws AmberException {
        return null;
    }

    public Object toObjectKey(long key) {
        return this._entityType.getId().toObjectKey(key);
    }

    public Entity load(AmberConnectionImpl aConn, Object key) throws AmberException {
        return this.find(aConn, key, true);
    }

    public Entity loadLazy(AmberConnectionImpl aConn, Object key) throws AmberException {
        return this.find(aConn, key, false);
    }

    public EntityItem findItem(AmberConnectionImpl aConn, ResultSet rs, int index) throws SQLException {
        return this._homeBean.__caucho_home_find(aConn, this, rs, index);
    }

    public Object loadFull(AmberConnectionImpl aConn, ResultSet rs, int index) throws SQLException {
        EntityItem item = this.findItem(aConn, rs, index);
        if (item == null) {
            return null;
        }
        Entity entity = null;
        Object value = this._entityFactory.getEntity(aConn, item);
        if (aConn.isInTransaction()) {
            if (value instanceof Entity) {
                entity = (Entity)value;
            } else if (this._cauchoGetBeanMethod != null) {
                try {
                    entity = (Entity)this._cauchoGetBeanMethod.invoke(value, new Object[0]);
                    entity.__caucho_makePersistent(aConn, item);
                }
                catch (Throwable e) {
                    log.log(Level.FINEST, e.toString(), e);
                }
            }
            if (entity == null) {
                entity = aConn.getEntity(item);
            }
        } else {
            entity = item.getEntity();
        }
        int keyLength = this._entityType.getId().getKeyCount();
        entity.__caucho_load(aConn, rs, index + keyLength);
        return value;
    }

    public Object loadLazy(AmberConnectionImpl aConn, ResultSet rs, int index) throws SQLException {
        EntityItem item = this.findItem(aConn, rs, index);
        if (item == null) {
            return null;
        }
        return this._entityFactory.getEntity(aConn, item);
    }

    public Entity find(AmberConnectionImpl aConn, Object key, boolean isLoad) throws AmberException {
        EntityItem item = this.findEntityItem(aConn, key, isLoad);
        return item.copy(aConn);
    }

    public EntityItem findEntityItem(AmberConnectionImpl aConn, Object key, boolean isLoad) throws AmberException {
        if (key == null) {
            return null;
        }
        try {
            EntityItem item = this._manager.getEntity(this.getRootType(), key);
            if (item == null) {
                if (this._homeBean == null && this._configException != null) {
                    throw this._configException;
                }
                Entity cacheEntity = this._homeBean.__caucho_home_new(aConn, this, key);
                if (isLoad) {
                    cacheEntity.__caucho_retrieve(aConn);
                }
                item = new CacheableEntityItem(this, cacheEntity);
                item = this._manager.putEntity(this.getRootType(), key, item);
            } else if (isLoad) {
                item.loadEntity(0);
            }
            return item;
        }
        catch (Exception e) {
            throw AmberException.create(e);
        }
    }

    public EntityItem setEntityItem(Object key, EntityItem item) throws AmberException {
        if (key == null) {
            throw new NullPointerException("primaryKey");
        }
        try {
            item.getEntity().__caucho_setConnection(this._manager.getCacheConnection());
            return this._manager.putEntity(this.getRootType(), key, item);
        }
        catch (Exception e) {
            throw AmberException.create(e);
        }
    }

    public EntityItem findDiscriminatorEntityItem(AmberConnectionImpl aConn, Object key, String discriminator) throws SQLException {
        EntityItem item = this._manager.getEntity(this.getRootType(), key);
        if (item == null) {
            EntityType subEntity = this._entityType.getSubClass(discriminator);
            Entity cacheEntity = subEntity.createBean();
            cacheEntity.__caucho_setPrimaryKey(key);
            cacheEntity.__caucho_makePersistent((AmberConnectionImpl)this._manager.getCacheConnection(), subEntity);
            item = new CacheableEntityItem(this, cacheEntity);
            item = this._manager.putEntity(this.getRootType(), key, item);
        }
        return item;
    }

    public Entity makePersistent(Entity entity, AmberConnectionImpl aConn, boolean isLazy) throws SQLException {
        entity.__caucho_makePersistent(aConn, this._entityType);
        return entity;
    }

    public void save(AmberConnectionImpl aConn, Entity entity) throws AmberException {
        try {
            entity.__caucho_create(aConn, this._entityType);
        }
        catch (Exception e) {
            throw AmberException.create(e);
        }
    }

    public void delete(AmberConnectionImpl aConn, Object key) throws SQLException {
        this._manager.removeEntity(this.getRootType(), key);
    }

    public void delete(AmberConnectionImpl aConn, long primaryKey) throws SQLException {
    }

    public void update(Entity entity) throws SQLException {
    }

    public void addUpdate(CacheUpdate update) {
        this._cacheUpdates.add(new SoftReference<CacheUpdate>(update));
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.amber.entity.AmberEntityHome");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

