/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.collection;

import com.caucho.amber.AmberConnection;
import com.caucho.amber.AmberQuery;
import com.caucho.amber.AmberRuntimeException;
import com.caucho.amber.collection.AmberCollection;
import com.caucho.amber.connection.AmberConnectionImpl;
import com.caucho.amber.query.UserQuery;
import com.caucho.util.Alarm;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionImpl<E>
extends AbstractList<E>
implements AmberCollection {
    private AmberQuery _query;
    private AmberConnectionImpl _aConn;
    private ArrayList<E> _values = new ArrayList();
    private long _expireTime;

    public CollectionImpl(AmberConnectionImpl aConn, String query) {
        this._aConn = aConn;
        try {
            this._query = this._aConn.prepareQuery(query);
        }
        catch (SQLException e) {
            throw new AmberRuntimeException(e);
        }
    }

    public CollectionImpl(AmberQuery query) {
        this._query = query;
        this.setSession(((UserQuery)this._query).getConnection());
    }

    public void setSession(AmberConnection aConn) {
    }

    public void setSession(AmberConnectionImpl aConn) {
        this._aConn = aConn;
        this._aConn.register(this);
    }

    public AmberQuery getQuery() {
        return this._query;
    }

    @Override
    public int size() {
        this.fill();
        return this._values.size();
    }

    @Override
    public Iterator<E> iterator() {
        this.fill();
        return new ValuesIterator(this._values);
    }

    @Override
    public E get(int index) {
        this.fill();
        return this._values.get(index);
    }

    @Override
    public void clear() {
        this._values.clear();
        this._expireTime = Alarm.getCurrentTime();
    }

    @Override
    public void update() {
        this._expireTime = 0L;
    }

    protected boolean isValid() {
        return Alarm.getCurrentTime() <= this._expireTime;
    }

    private void fill() {
        if (Alarm.getCurrentTime() <= this._expireTime) {
            return;
        }
        try {
            this._expireTime = Alarm.getCurrentTime();
            ((UserQuery)this._query).setSession(this._aConn);
            this._values.clear();
            this._query.list(this._values);
        }
        catch (SQLException e) {
            throw new AmberRuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ValuesIterator
    implements Iterator {
        private ArrayList<E> _values;
        private int i = 0;

        ValuesIterator(ArrayList<E> values) {
            this._values = new ArrayList(values);
        }

        @Override
        public boolean hasNext() {
            return this.i < this._values.size();
        }

        @Override
        public E next() {
            if (this.i < this._values.size()) {
                return this._values.get(this.i++);
            }
            return null;
        }

        @Override
        public void remove() {
            CollectionImpl.this.remove(this._values.get(this.i - 1));
        }
    }
}

