/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber;

import com.caucho.amber.AmberException;
import com.caucho.amber.AmberRuntimeException;
import com.caucho.amber.connection.AmberConnectionImpl;
import com.caucho.amber.connection.CacheConnectionImpl;
import com.caucho.amber.ejb3.EntityManagerProxy;
import com.caucho.amber.entity.AmberCompletion;
import com.caucho.amber.entity.AmberEntityHome;
import com.caucho.amber.entity.EntityItem;
import com.caucho.amber.entity.EntityKey;
import com.caucho.amber.gen.AmberEnhancer;
import com.caucho.amber.gen.AmberGenerator;
import com.caucho.amber.gen.AmberGeneratorImpl;
import com.caucho.amber.idgen.IdGenerator;
import com.caucho.amber.idgen.SequenceIdGenerator;
import com.caucho.amber.query.QueryCacheKey;
import com.caucho.amber.query.ResultSetCacheChunk;
import com.caucho.amber.table.Table;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.GeneratorTableType;
import com.caucho.amber.type.SubEntityType;
import com.caucho.amber.type.Type;
import com.caucho.amber.type.TypeManager;
import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JClassLoader;
import com.caucho.config.ConfigException;
import com.caucho.java.gen.JavaClassGenerator;
import com.caucho.jdbc.JdbcMetaData;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.enhancer.EnhancerManager;
import com.caucho.loader.enhancer.EnhancingClassLoader;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EntityManager;
import javax.sql.DataSource;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmberManager {
    private static final Logger log = Log.open(AmberManager._resin_compat_class_0());
    private static final L10N L = new L10N(AmberManager._resin_compat_class_0());
    private ClassLoader _parentLoader;
    private EnhancingClassLoader _enhancedLoader;
    private AmberEnhancer _enhancer;
    private EntityManagerProxy _entityManagerProxy;
    private DataSource _dataSource;
    private DataSource _readDataSource;
    private DataSource _xaDataSource;
    private JdbcMetaData _jdbcMetaData;
    private boolean _createDatabaseTables;
    private boolean _validateDatabaseTables = true;
    private long _tableCacheTimeout = 250L;
    private JClassLoader _jClassLoader;
    private TypeManager _typeManager = new TypeManager();
    private HashMap<String, Table> _tableMap = new HashMap();
    private HashMap<String, AmberEntityHome> _entityHomeMap = new HashMap();
    private HashMap<String, IdGenerator> _tableGenMap = new HashMap();
    private HashMap<String, SequenceIdGenerator> _sequenceGenMap = new HashMap();
    private LruCache<QueryCacheKey, SoftReference<ResultSetCacheChunk>> _queryCache = new LruCache(1024);
    private LruCache<EntityKey, SoftReference<EntityItem>> _entityCache = new LruCache(32768);
    private EntityKey _entityKey = new EntityKey();
    private ArrayList<EntityType> _lazyConfigure = new ArrayList();
    private ArrayList<EntityType> _lazyGenerate = new ArrayList();
    private ArrayList<AmberEntityHome> _lazyHomeInit = new ArrayList();
    private ArrayList<Table> _lazyTable = new ArrayList();
    private AmberGenerator _generator;
    private CacheConnectionImpl _cacheConn;
    private boolean _supportsGetGeneratedKeys;
    private volatile boolean _isInit;
    private long _xid = 1L;
    private static Class _resin_compat_class_0;

    public AmberManager() {
        this._parentLoader = Thread.currentThread().getContextClassLoader();
        this._jClassLoader = EnhancerManager.create(this._parentLoader).getJavaClassLoader();
        this._enhancer = new AmberEnhancer(this);
        EnhancerManager.create().addClassEnhancer(this._enhancer);
        try {
            if (this._parentLoader instanceof DynamicClassLoader) {
                ((DynamicClassLoader)this._parentLoader).make();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this._entityManagerProxy = new EntityManagerProxy(this);
    }

    public EntityManager getEntityManager() {
        return this._entityManagerProxy;
    }

    public void setDataSource(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this._dataSource;
    }

    public void setReadDataSource(DataSource dataSource) {
        this._readDataSource = dataSource;
    }

    public DataSource getReadDataSource() {
        return this._readDataSource;
    }

    public void setXADataSource(DataSource dataSource) {
        this._xaDataSource = dataSource;
    }

    public DataSource getXADataSource() {
        return this._xaDataSource;
    }

    public JdbcMetaData getMetaData() {
        if (this._jdbcMetaData == null) {
            this._jdbcMetaData = JdbcMetaData.create(this.getDataSource());
        }
        return this._jdbcMetaData;
    }

    public void setCreateDatabaseTables(boolean create) {
        this._createDatabaseTables = create;
    }

    public boolean getCreateDatabaseTables() {
        return this._createDatabaseTables;
    }

    public void setValidateDatabaseTables(boolean validate) {
        this._validateDatabaseTables = validate;
    }

    public boolean getValidateDatabaseTables() {
        return this._validateDatabaseTables;
    }

    public void setTableCacheTimeout(long timeout) {
        this._tableCacheTimeout = timeout;
    }

    public long getTableCacheTimeout() {
        return this._tableCacheTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getXid() {
        AmberManager amberManager = this;
        synchronized (amberManager) {
            return this._xid++;
        }
    }

    public ClassLoader getEnhancedLoader() {
        return this._parentLoader;
    }

    public void setEnhancedLoader(EnhancingClassLoader loader) {
        this._enhancedLoader = loader;
    }

    public JClassLoader getJClassLoader() {
        return this._jClassLoader;
    }

    public Table createTable(String tableName) {
        Table table = this._tableMap.get(tableName);
        if (table == null) {
            table = new Table(this, tableName);
            table.setCacheTimeout(this.getTableCacheTimeout());
            this._tableMap.put(tableName, table);
            this._lazyTable.add(table);
        }
        return table;
    }

    public EntityType createEntity(JClass beanClass) {
        return this.createEntity(beanClass.getName(), beanClass);
    }

    public EntityType createEntity(String name, JClass beanClass) {
        EntityType entityType = (EntityType)this._typeManager.get(name);
        if (entityType != null) {
            return entityType;
        }
        if (entityType == null) {
            EntityType parentType = null;
            for (JClass parentClass = beanClass.getSuperClass(); parentType == null && parentClass != null; parentClass = parentClass.getSuperClass()) {
                parentType = (EntityType)this._typeManager.get(parentClass.getName());
            }
            entityType = parentType != null ? new SubEntityType(this, parentType) : new EntityType(this);
        }
        this._typeManager.put(name, entityType);
        if (this._typeManager.get(beanClass.getName()) == null) {
            this._typeManager.put(beanClass.getName(), entityType);
        }
        entityType.setName(name);
        entityType.setBeanClass(beanClass);
        this._lazyConfigure.add(entityType);
        AmberEntityHome entityHome = this._entityHomeMap.get(beanClass.getName());
        if (entityHome == null) {
            entityHome = new AmberEntityHome(this, entityType);
            this._lazyHomeInit.add(entityHome);
            this._isInit = false;
        }
        this.addEntityHome(name, entityHome);
        this.addEntityHome(beanClass.getName(), entityHome);
        return entityType;
    }

    private void addEntityHome(String name, AmberEntityHome home) {
        this._entityHomeMap.put(name, home);
    }

    public IdGenerator getTableGenerator(String name) {
        return this._tableGenMap.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdGenerator putTableGenerator(String name, IdGenerator gen) {
        HashMap<String, IdGenerator> hashMap = this._tableGenMap;
        synchronized (hashMap) {
            IdGenerator oldGen = this._tableGenMap.get(name);
            if (oldGen != null) {
                return oldGen;
            }
            this._tableGenMap.put(name, gen);
            return gen;
        }
    }

    public GeneratorTableType createGeneratorTable(String name) {
        Type type = this._typeManager.get(name);
        if (type instanceof GeneratorTableType) {
            return (GeneratorTableType)type;
        }
        if (type != null) {
            throw new RuntimeException(L.l("'{0}' is a duplicate generator table.", type));
        }
        GeneratorTableType genType = new GeneratorTableType(this, name);
        this._typeManager.put(name, genType);
        return genType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SequenceIdGenerator createSequenceGenerator(String name, int size) throws ConfigException {
        HashMap<String, SequenceIdGenerator> hashMap = this._sequenceGenMap;
        synchronized (hashMap) {
            SequenceIdGenerator gen = this._sequenceGenMap.get(name);
            if (gen == null) {
                gen = new SequenceIdGenerator(this, name, size);
                this._sequenceGenMap.put(name, gen);
            }
            return gen;
        }
    }

    public void generate() throws Exception {
        this.configure();
        while (this._lazyGenerate.size() > 0) {
            EntityType type = this._lazyGenerate.remove(0);
            type.init();
            this._generator.generate(type);
        }
        this.initTables();
        this._generator.compile();
    }

    public void generate(JavaClassGenerator javaGen) throws Exception {
        this.configure();
        while (this._lazyGenerate.size() > 0) {
            EntityType entityType;
            EntityType type = this._lazyGenerate.remove(0);
            type.init();
            if (type instanceof EntityType && !(entityType = type).isGenerated()) {
                if (entityType.getInstanceClassName() == null) {
                    throw new ConfigException(L.l("'{0}' does not have a configured instance class.", entityType));
                }
                entityType.setGenerated(true);
                try {
                    this.getGenerator().generateJava(javaGen, entityType);
                }
                catch (Throwable e) {
                    log.log(Level.FINER, e.toString(), e);
                }
            }
            this.configure();
        }
        for (SequenceIdGenerator gen : this._sequenceGenMap.values()) {
            gen.init(this);
        }
    }

    public void configure() throws Exception {
        while (this._lazyConfigure.size() > 0) {
            EntityType type = this._lazyConfigure.remove(0);
            if (type.startConfigure()) {
                // empty if block
            }
            if (this._lazyGenerate.contains(type)) continue;
            this._lazyGenerate.add(type);
        }
    }

    public SubEntityType createSubEntity(JClass beanClass, EntityType parent) {
        SubEntityType entityType = (SubEntityType)this._typeManager.get(beanClass.getName());
        if (entityType != null) {
            return entityType;
        }
        entityType = new SubEntityType(this, parent);
        entityType.setBeanClass(beanClass);
        this._typeManager.put(entityType.getName(), entityType);
        this.addEntityHome(entityType.getName(), parent.getHome());
        return entityType;
    }

    public AmberEntityHome getEntityHome(String name) {
        if (!this._isInit) {
            try {
                this.initEntityHomes();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AmberRuntimeException(e);
            }
        }
        return this._entityHomeMap.get(name);
    }

    public AmberEntityHome getHomeBySchema(String name) {
        for (AmberEntityHome home : this._entityHomeMap.values()) {
            if (!name.equals(home.getEntityType().getName())) continue;
            return home;
        }
        try {
            this.createType(name);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this._entityHomeMap.get(name);
    }

    public EntityType getEntity(String className) {
        Type type = this._typeManager.get(className);
        if (type instanceof EntityType) {
            return (EntityType)type;
        }
        return null;
    }

    public EntityType getEntityByInstanceClass(String className) {
        return this._typeManager.getEntityByInstanceClass(className);
    }

    public Type createType(String typeName) throws ConfigException {
        Type type = this._typeManager.get(typeName);
        if (type != null) {
            return type;
        }
        JClass cl = this._jClassLoader.forName(typeName);
        if (cl == null) {
            throw new ConfigException(L.l("'{0}' is an unknown type", typeName));
        }
        return this.createType(cl);
    }

    public Type createType(JClass javaType) throws ConfigException {
        Type type = this._typeManager.create(javaType);
        if (type != null) {
            return type;
        }
        return this.createEntity(javaType);
    }

    public AmberGenerator getGenerator() {
        if (this._generator != null) {
            return this._generator;
        }
        this._generator = new AmberGeneratorImpl(this);
        return this._generator;
    }

    public boolean hasReturnGeneratedKeys() {
        return this._supportsGetGeneratedKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws ConfigException, IOException {
        this.initLoaders();
        if (this._dataSource == null) {
            return;
        }
        try {
            Connection conn = this._dataSource.getConnection();
            try {
                DatabaseMetaData metaData = conn.getMetaData();
                try {
                    this._supportsGetGeneratedKeys = metaData.supportsGetGeneratedKeys();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            finally {
                conn.close();
            }
        }
        catch (SQLException e) {
            throw new ConfigException(e);
        }
    }

    public void initLoaders() throws ConfigException, IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initEntityHomes() throws AmberException, ConfigException {
        AmberManager amberManager = this;
        synchronized (amberManager) {
            if (this._isInit) {
                return;
            }
            this._isInit = true;
        }
        this.initTables();
        while (this._lazyHomeInit.size() > 0) {
            AmberEntityHome home = this._lazyHomeInit.remove(0);
            home.init();
        }
    }

    public void initTables() throws ConfigException {
        while (this._lazyTable.size() > 0) {
            Table table = this._lazyTable.remove(0);
            if (this.getDataSource() == null) {
                throw new ConfigException(L.l("No configured data-source found for <ejb-server>."));
            }
            if (this.getCreateDatabaseTables()) {
                table.createDatabaseTable(this);
            }
            if (!this.getValidateDatabaseTables()) continue;
            table.validateDatabaseTable(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheConnectionImpl getCacheConnection() {
        CacheConnectionImpl conn;
        AmberManager amberManager = this;
        synchronized (amberManager) {
            conn = this._cacheConn;
            this._cacheConn = null;
        }
        if (conn == null) {
            conn = new CacheConnectionImpl(this);
        }
        return conn;
    }

    public AmberConnectionImpl createAmberConnection() {
        return new AmberConnectionImpl(this);
    }

    public void freeCacheConnection(CacheConnectionImpl cacheConn) {
        this._cacheConn = cacheConn;
    }

    public AmberEntityHome getHome(Class cl) {
        return this.getEntityHome(cl.getName());
    }

    public ResultSetCacheChunk getQueryChunk(QueryCacheKey key) {
        SoftReference<ResultSetCacheChunk> ref = this._queryCache.get(key);
        if (ref == null) {
            return null;
        }
        ResultSetCacheChunk chunk = ref.get();
        if (chunk != null && chunk.isValid()) {
            return chunk;
        }
        return null;
    }

    public void putQueryChunk(QueryCacheKey key, ResultSetCacheChunk chunk) {
        this._queryCache.put(key, new SoftReference<ResultSetCacheChunk>(chunk));
    }

    public EntityItem getEntityItem(String homeName, Object key) throws AmberException {
        AmberEntityHome home = this.getEntityHome(homeName);
        return home.findEntityItem(this.getCacheConnection(), key, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityItem getEntity(EntityType rootType, Object key) {
        SoftReference<EntityItem> ref;
        EntityKey entityKey = this._entityKey;
        synchronized (entityKey) {
            this._entityKey.init(rootType, key);
            ref = this._entityCache.get(this._entityKey);
        }
        if (ref != null) {
            return ref.get();
        }
        return null;
    }

    public EntityItem putEntity(EntityType rootType, Object key, EntityItem entity) {
        SoftReference<EntityItem> ref = new SoftReference<EntityItem>(entity);
        EntityKey entityKey = new EntityKey(rootType, key);
        ref = this._entityCache.putIfNew(entityKey, ref);
        return ref.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityItem removeEntity(EntityType rootType, Object key) {
        SoftReference<EntityItem> ref;
        EntityKey entityKey = this._entityKey;
        synchronized (entityKey) {
            this._entityKey.init(rootType, key);
            ref = this._entityCache.remove(this._entityKey);
        }
        if (ref != null) {
            return ref.get();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete(ArrayList<AmberCompletion> completions) {
        Iterator<Object> iter;
        int size = completions.size();
        if (size == 0) {
            return;
        }
        LruCache<Object, SoftReference<Object>> lruCache = this._entityCache;
        synchronized (lruCache) {
            iter = this._entityCache.iterator();
            while (iter.hasNext()) {
                LruCache.Entry<EntityKey, SoftReference<EntityItem>> entry = iter.next();
                EntityKey key = entry.getKey();
                SoftReference<EntityItem> valueRef = entry.getValue();
                EntityItem value = valueRef.get();
                if (value == null) continue;
                EntityType entityRoot = key.getEntityType();
                Object entityKey = key.getKey();
                for (int i = 0; i < size; ++i) {
                    if (!completions.get(i).complete(entityRoot, entityKey, value)) continue;
                }
            }
        }
        lruCache = this._queryCache;
        synchronized (lruCache) {
            iter = this._queryCache.values();
            while (iter.hasNext()) {
                SoftReference ref = (SoftReference)iter.next();
                ResultSetCacheChunk chunk = (ResultSetCacheChunk)ref.get();
                if (chunk == null) continue;
                for (int i = 0; i < size; ++i) {
                    if (!completions.get(i).complete(chunk)) continue;
                }
            }
        }
    }

    public void destroy() {
        this._typeManager = null;
        this._queryCache = null;
        this._entityCache = null;
        this._parentLoader = null;
        this._enhancedLoader = null;
    }

    public String getCreateColumnSQL(int sqlType, int length, int precision, int scale) {
        return this.getMetaData().getCreateColumnSQL(sqlType, length, precision, scale);
    }

    public String toString() {
        return "AmberManager[]";
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.amber.AmberManager");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

