/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.codehaus.janino.Access;
import org.codehaus.janino.CodeContext;
import org.codehaus.janino.CompileException;
import org.codehaus.janino.DebuggingInformation;
import org.codehaus.janino.Descriptor;
import org.codehaus.janino.IClass;
import org.codehaus.janino.IClassLoader;
import org.codehaus.janino.Java;
import org.codehaus.janino.Location;
import org.codehaus.janino.MethodDescriptor;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.Visitor;
import org.codehaus.janino.WarningHandler;
import org.codehaus.janino.util.ClassFile;
import org.codehaus.janino.util.TunnelException;
import org.codehaus.janino.util.enumerator.EnumeratorSet;

public class UnitCompiler {
    private static final boolean DEBUG = false;
    private final Map onDemandImportableTypes = new HashMap();
    private static final HashMap PRIMITIVE_WIDENING_CONVERSIONS = new HashMap();
    private static final HashMap PRIMITIVE_NARROWING_CONVERSIONS;
    private CodeContext codeContext = null;
    private ErrorHandler compileErrorHandler = null;
    private WarningHandler warningHandler = null;
    final Java.CompilationUnit compilationUnit;
    private List generatedClassFiles;
    private IClassLoader iClassLoader;
    private EnumeratorSet debuggingInformation;

    static {
        UnitCompiler.fillConversionMap(new Object[]{new byte[0], "BS", "BI", "SI", "CI", new byte[]{-123}, "BJ", "SJ", "CJ", "IJ", new byte[]{-122}, "BF", "SF", "CF", "IF", new byte[]{-119}, "JF", new byte[]{-121}, "BD", "SD", "CD", "ID", new byte[]{-118}, "JD", new byte[]{-115}, "FD"}, PRIMITIVE_WIDENING_CONVERSIONS);
        PRIMITIVE_NARROWING_CONVERSIONS = new HashMap();
        UnitCompiler.fillConversionMap(new Object[]{new byte[0], "BC", "SC", "CS", new byte[]{-111}, "SB", "CB", "IB", new byte[]{-109}, "IS", "IC", new byte[]{-120, -111}, "JB", new byte[]{-120, -109}, "JS", "JC", new byte[]{-120}, "JI", new byte[]{-117, -111}, "FB", new byte[]{-117, -109}, "FS", "FC", new byte[]{-117}, "FI", new byte[]{-116}, "FJ", new byte[]{-114, -111}, "DB", new byte[]{-114, -109}, "DS", "DC", new byte[]{-114}, "DI", new byte[]{-113}, "DJ", new byte[]{-112}, "DF"}, PRIMITIVE_NARROWING_CONVERSIONS);
    }

    public UnitCompiler(Java.CompilationUnit compilationUnit, IClassLoader iClassLoader) {
        this.compilationUnit = compilationUnit;
        this.iClassLoader = iClassLoader;
    }

    private short addConstantFloatInfo(float f) {
        return this.codeContext.getClassFile().addConstantFloatInfo(f);
    }

    private short addConstantIntegerInfo(int n) {
        return this.codeContext.getClassFile().addConstantIntegerInfo(n);
    }

    private short addConstantStringInfo(String string) {
        return this.codeContext.getClassFile().addConstantStringInfo(string);
    }

    private void addFields(Java.FieldDeclaration fieldDeclaration, ClassFile classFile) throws CompileException {
        int n = 0;
        while (n < fieldDeclaration.variableDeclarators.length) {
            Java.VariableDeclarator variableDeclarator = fieldDeclaration.variableDeclarators[n];
            Java.Type type = fieldDeclaration.type;
            int n2 = 0;
            while (n2 < variableDeclarator.brackets) {
                type = new Java.ArrayType(type);
                ++n2;
            }
            Object object = null;
            if ((fieldDeclaration.modifiers & 0x10) != 0 && variableDeclarator.optionalInitializer != null && (object = this.getConstantValue(variableDeclarator.optionalInitializer)) == Java.Rvalue.CONSTANT_VALUE_NULL) {
                object = null;
            }
            ClassFile.FieldInfo fieldInfo = classFile.addFieldInfo(fieldDeclaration.modifiers, variableDeclarator.name, this.getType(type).getDescriptor(), object);
            if (fieldDeclaration.hasDeprecatedDocTag()) {
                fieldInfo.addAttribute(new ClassFile.DeprecatedAttribute(classFile.addConstantUtf8Info("Deprecated")));
            }
            ++n;
        }
    }

    void assignSyntheticParametersToSyntheticFields(Java.ConstructorDeclarator constructorDeclarator) throws CompileException {
        Iterator iterator = constructorDeclarator.declaringClass.syntheticFields.values().iterator();
        while (iterator.hasNext()) {
            IClass.IField iField = (IClass.IField)iterator.next();
            Java.LocalVariable localVariable = (Java.LocalVariable)constructorDeclarator.syntheticParameters.get(iField.getName());
            if (localVariable == null) {
                throw new RuntimeException("SNO: Synthetic parameter for synthetic field \"" + iField.getName() + "\" not found");
            }
            try {
                this.compile(new Java.ExpressionStatement(new Java.Assignment(constructorDeclarator.getLocation(), new Java.FieldAccess(constructorDeclarator.getLocation(), constructorDeclarator.optionalBody, new Java.ThisReference(constructorDeclarator.getLocation(), constructorDeclarator.declaringClass), iField), "=", new Java.LocalVariableAccess(constructorDeclarator.getLocation(), localVariable)), (Java.Scope)constructorDeclarator));
            }
            catch (Parser.ParseException parseException) {
                throw new RuntimeException("S.N.O.");
            }
        }
    }

    Object assignmentConversion(Java.Located located, Object object, IClass iClass) throws CompileException {
        Object object2 = null;
        if (iClass == IClass.BOOLEAN) {
            if (object instanceof Boolean) {
                object2 = object;
            }
        } else if (iClass == this.iClassLoader.STRING) {
            if (object instanceof String) {
                object2 = object;
            }
        } else if (iClass == IClass.BYTE) {
            char c;
            if (object instanceof Byte) {
                object2 = object;
            } else if (object instanceof Short || object instanceof Integer) {
                int n = ((Number)object).intValue();
                if (n >= -128 && n <= 127) {
                    object2 = new Byte((byte)n);
                }
            } else if (object instanceof Character && (c = ((Character)object).charValue()) >= '\uffffff80' && c <= '\u007f') {
                object2 = new Byte((byte)c);
            }
        } else if (iClass == IClass.SHORT) {
            int n;
            if (object instanceof Byte) {
                object2 = new Short(((Number)object).shortValue());
            } else if (object instanceof Short) {
                object2 = object;
            } else if (object instanceof Character) {
                char c = ((Character)object).charValue();
                if (c >= Short.MIN_VALUE && c <= Short.MAX_VALUE) {
                    object2 = new Short((short)c);
                }
            } else if (object instanceof Integer && (n = ((Integer)object).intValue()) >= Short.MIN_VALUE && n <= Short.MAX_VALUE) {
                object2 = new Short((short)n);
            }
        } else if (iClass == IClass.CHAR) {
            int n;
            if (object instanceof Short) {
                object2 = object;
            } else if ((object instanceof Byte || object instanceof Short || object instanceof Integer) && (n = ((Number)object).intValue()) >= 0 && n <= 65535) {
                object2 = new Character((char)n);
            }
        } else if (iClass == IClass.INT) {
            if (object instanceof Integer) {
                object2 = object;
            } else if (object instanceof Byte || object instanceof Short) {
                object2 = new Integer(((Number)object).intValue());
            } else if (object instanceof Character) {
                object2 = new Integer(((Character)object).charValue());
            }
        } else if (iClass == IClass.LONG) {
            if (object instanceof Long) {
                object2 = object;
            } else if (object instanceof Byte || object instanceof Short || object instanceof Integer) {
                object2 = new Long(((Number)object).longValue());
            } else if (object instanceof Character) {
                object2 = new Long(((Character)object).charValue());
            }
        } else if (iClass == IClass.FLOAT) {
            if (object instanceof Float) {
                object2 = object;
            } else if (object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long) {
                object2 = new Float(((Number)object).floatValue());
            } else if (object instanceof Character) {
                object2 = new Float(((Character)object).charValue());
            }
        } else if (iClass == IClass.DOUBLE) {
            if (object instanceof Double) {
                object2 = object;
            } else if (object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Float) {
                object2 = new Double(((Number)object).doubleValue());
            } else if (object instanceof Character) {
                object2 = new Double(((Character)object).charValue());
            }
        }
        if (object2 == null) {
            this.compileError("Cannot convert constant of type \"" + object.getClass().getName() + "\" to type \"" + iClass.toString() + "\"", located.getLocation());
        }
        return object2;
    }

    private void assignmentConversion(Java.Located located, IClass iClass, IClass iClass2, Object object) throws CompileException {
        if (this.tryIdentityConversion(iClass, iClass2)) {
            return;
        }
        if (this.tryWideningPrimitiveConversion(located, iClass, iClass2)) {
            return;
        }
        if (this.isWideningReferenceConvertible(iClass, iClass2)) {
            return;
        }
        if (object != null && this.isConstantPrimitiveAssignmentConvertible(object, iClass2)) {
            return;
        }
        this.compileError("Assignment conversion not possible from type \"" + iClass + "\" to type \"" + iClass2 + "\"", located.getLocation());
    }

    private IClass binaryNumericPromotion(Java.Located located, IClass iClass, CodeContext.Inserter inserter, IClass iClass2) throws CompileException {
        IClass iClass3 = this.binaryNumericPromotionType(located, iClass, iClass2);
        if (inserter != null) {
            this.codeContext.pushInserter(inserter);
            try {
                if (!this.tryIdentityConversion(iClass, iClass3) && !this.tryWideningPrimitiveConversion(located, iClass, iClass3)) {
                    throw new RuntimeException();
                }
                Object var7_6 = null;
                this.codeContext.popInserter();
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.codeContext.popInserter();
                throw throwable;
            }
        }
        if (!this.tryIdentityConversion(iClass2, iClass3) && !this.tryWideningPrimitiveConversion(located, iClass2, iClass3)) {
            throw new RuntimeException();
        }
        return iClass3;
    }

    private IClass binaryNumericPromotionType(Java.Locatable locatable, IClass iClass, IClass iClass2) throws CompileException {
        if (!iClass.isPrimitiveNumeric() || !iClass2.isPrimitiveNumeric()) {
            this.compileError("Binary numeric promotion not possible on types \"" + iClass + "\" and \"" + iClass2 + "\"", locatable.getLocation());
        }
        return iClass == IClass.DOUBLE || iClass2 == IClass.DOUBLE ? IClass.DOUBLE : (iClass == IClass.FLOAT || iClass2 == IClass.FLOAT ? IClass.FLOAT : (iClass == IClass.LONG || iClass2 == IClass.LONG ? IClass.LONG : IClass.INT));
    }

    private boolean canCompleteNormally(Java.BlockStatement blockStatement) throws CompileException {
        boolean bl;
        CodeContext codeContext = this.replaceCodeContext(this.createDummyCodeContext());
        try {
            bl = this.compile(blockStatement);
            Object var5_4 = null;
            this.replaceCodeContext(codeContext);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.replaceCodeContext(codeContext);
            throw throwable;
        }
        return bl;
    }

    private void checkAccessible(IClass.IMember iMember, Java.BlockStatement blockStatement) throws CompileException {
        IClass iClass;
        IClass iClass2;
        block18: {
            block16: {
                boolean bl;
                block17: {
                    String string;
                    String string2;
                    block15: {
                        if (iMember.getAccess() == Access.PUBLIC) {
                            return;
                        }
                        iClass2 = iMember.getDeclaringIClass();
                        Java.Scope scope = blockStatement.getEnclosingScope();
                        while (true) {
                            if (scope instanceof Java.TypeDeclaration) break;
                            scope = scope.getEnclosingScope();
                        }
                        iClass = this.resolve((Java.TypeDeclaration)scope);
                        if (iClass == iClass2) {
                            return;
                        }
                        IClass iClass3 = iClass2;
                        IClass iClass4 = iClass2;
                        while (iClass4 != null) {
                            iClass3 = iClass4;
                            iClass4 = iClass4.getDeclaringIClass();
                        }
                        IClass iClass5 = iClass;
                        IClass iClass6 = iClass;
                        while (iClass6 != null) {
                            iClass5 = iClass6;
                            iClass6 = iClass6.getDeclaringIClass();
                        }
                        if (iClass3 == iClass5) {
                            if (iMember instanceof IClass.IInvocable && iMember.getAccess() == Access.PRIVATE && (iMember instanceof IClass.IConstructor || !((IClass.IMethod)iMember).isStatic())) {
                                this.compileError("Compiler limitation: Access to private constructor or non-static method \"" + iMember + "\" declared in the same enclosing top-level type \"" + iClass5 + "\" not supported. It is recommended to change its declaration from \"private\" to \"/*private*/\".", blockStatement.getLocation());
                            }
                            return;
                        }
                        if (iMember.getAccess() == Access.PRIVATE) {
                            this.compileError("Private member \"" + iMember + "\" cannot be accessed from type \"" + iClass + "\".", blockStatement.getLocation());
                            return;
                        }
                        String string3 = iClass3.getDescriptor();
                        int n = string3.lastIndexOf(46);
                        string2 = n == -1 ? null : string3.substring(0, n);
                        String string4 = iClass5.getDescriptor();
                        int n2 = string4.lastIndexOf(46);
                        String string5 = string = n2 == -1 ? null : string4.substring(0, n2);
                        if (string2 != null) break block15;
                        if (string == null) break block16;
                        bl = false;
                        break block17;
                    }
                    bl = string2.equals(string);
                }
                if (!bl) break block18;
            }
            return;
        }
        if (iMember.getAccess() == Access.DEFAULT) {
            this.compileError("Member \"" + iMember + "\" with \"" + iMember.getAccess() + "\" visibility cannot be accessed from type \"" + iClass + "\".", blockStatement.getLocation());
            return;
        }
        IClass iClass7 = iClass;
        while (true) {
            if (iClass7 == null) {
                this.compileError("Protected member \"" + iMember + "\" cannot be accessed from type \"" + iClass + "\", which is neither declared in the same package as or is a subclass of \"" + iClass2 + "\".", blockStatement.getLocation());
                return;
            }
            if (iClass7 == iClass2) {
                return;
            }
            iClass7 = iClass7.getDeclaringIClass();
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void checkThrownException(Java.Located var1_1, IClass var2_2, Java.Scope var3_3) throws CompileException {
        if (!this.iClassLoader.THROWABLE.isAssignableFrom(var2_2)) {
            this.compileError("Thrown object of type \"" + var2_2 + "\" is not assignable to \"Throwable\"", var1_1.getLocation());
        }
        if (!this.iClassLoader.RUNTIME_EXCEPTION.isAssignableFrom(var2_2) && !this.iClassLoader.ERROR.isAssignableFrom(var2_2)) ** GOTO lbl16
        return;
lbl-1000:
        // 1 sources

        {
            if (var3_3 instanceof Java.TryStatement) {
                var4_4 /* !! */  = (Java.TryStatement)var3_3;
                var5_5 = 0;
                while (var5_5 < var4_4 /* !! */ .catchClauses.size()) {
                    var6_6 = (Java.CatchClause)var4_4 /* !! */ .catchClauses.get(var5_5);
                    var7_7 = this.getType(var6_6.caughtException.type);
                    if (var7_7.isAssignableFrom(var2_2)) {
                        return;
                    }
                    ++var5_5;
                }
            }
            var3_3 = var3_3.getEnclosingScope();
lbl16:
            // 2 sources

            ** while (var3_3 instanceof Java.Statement)
        }
lbl17:
        // 1 sources

        if (var3_3 instanceof Java.FunctionDeclarator) {
            var4_4 /* !! */  = (Java.FunctionDeclarator)var3_3;
            var5_5 = 0;
            while (var5_5 < var4_4 /* !! */ .thrownExceptions.length) {
                var6_6 = this.getType(var4_4 /* !! */ .thrownExceptions[var5_5]);
                if (var6_6.isAssignableFrom(var2_2)) {
                    return;
                }
                ++var5_5;
            }
        }
        this.compileError("Thrown exception of type \"" + var2_2 + "\" is neither caught by a \"try...catch\" block nor declared in the \"throws\" clause of the declaring function", var1_1.getLocation());
    }

    private boolean compile(Java.BlockStatement blockStatement) throws CompileException {
        final boolean[] blArray = new boolean[1];
        Visitor.BlockStatementVisitor blockStatementVisitor = new Visitor.BlockStatementVisitor(){

            public void visitBlock(Java.Block block) {
                try {
                    blArray[0] = this.compile2(block);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitBreakStatement(Java.BreakStatement breakStatement) {
                try {
                    blArray[0] = this.compile2(breakStatement);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitContinueStatement(Java.ContinueStatement continueStatement) {
                try {
                    blArray[0] = this.compile2(continueStatement);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitDoStatement(Java.DoStatement doStatement) {
                try {
                    blArray[0] = this.compile2(doStatement);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitEmptyStatement(Java.EmptyStatement emptyStatement) {
                blArray[0] = this.compile2(emptyStatement);
            }

            public void visitExpressionStatement(Java.ExpressionStatement expressionStatement) {
                try {
                    blArray[0] = this.compile2(expressionStatement);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitFieldDeclaration(Java.FieldDeclaration fieldDeclaration) {
                try {
                    blArray[0] = this.compile2(fieldDeclaration);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitForStatement(Java.ForStatement forStatement) {
                try {
                    blArray[0] = this.compile2(forStatement);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitIfStatement(Java.IfStatement ifStatement) {
                try {
                    blArray[0] = this.compile2(ifStatement);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitInitializer(Java.Initializer initializer) {
                try {
                    blArray[0] = this.compile2(initializer);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitLabeledStatement(Java.LabeledStatement labeledStatement) {
                try {
                    blArray[0] = this.compile2(labeledStatement);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitLocalClassDeclarationStatement(Java.LocalClassDeclarationStatement localClassDeclarationStatement) {
                try {
                    blArray[0] = this.compile2(localClassDeclarationStatement);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitLocalVariableDeclarationStatement(Java.LocalVariableDeclarationStatement localVariableDeclarationStatement) {
                try {
                    blArray[0] = this.compile2(localVariableDeclarationStatement);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitReturnStatement(Java.ReturnStatement returnStatement) {
                try {
                    blArray[0] = this.compile2(returnStatement);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitSwitchStatement(Java.SwitchStatement switchStatement) {
                try {
                    blArray[0] = this.compile2(switchStatement);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitSynchronizedStatement(Java.SynchronizedStatement synchronizedStatement) {
                try {
                    blArray[0] = this.compile2(synchronizedStatement);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitThrowStatement(Java.ThrowStatement throwStatement) {
                try {
                    blArray[0] = this.compile2(throwStatement);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitTryStatement(Java.TryStatement tryStatement) {
                try {
                    blArray[0] = this.compile2(tryStatement);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitWhileStatement(Java.WhileStatement whileStatement) {
                try {
                    blArray[0] = this.compile2(whileStatement);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }
        };
        try {
            blockStatement.accept(blockStatementVisitor);
            return blArray[0];
        }
        catch (TunnelException tunnelException) {
            throw (CompileException)tunnelException.getDelegate();
        }
    }

    private void compile(Java.ConstructorInvocation constructorInvocation) throws CompileException {
        Visitor.ConstructorInvocationVisitor constructorInvocationVisitor = new Visitor.ConstructorInvocationVisitor(){

            public void visitAlternateConstructorInvocation(Java.AlternateConstructorInvocation alternateConstructorInvocation) {
                try {
                    UnitCompiler.this.compile2(alternateConstructorInvocation);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitSuperConstructorInvocation(Java.SuperConstructorInvocation superConstructorInvocation) {
                try {
                    UnitCompiler.this.compile2(superConstructorInvocation);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }
        };
        try {
            constructorInvocation.accept(constructorInvocationVisitor);
        }
        catch (TunnelException tunnelException) {
            throw (CompileException)tunnelException.getDelegate();
        }
    }

    private void compile(Java.FunctionDeclarator functionDeclarator, ClassFile classFile) throws CompileException {
        CodeContext codeContext;
        CodeContext codeContext2;
        ClassFile.MethodInfo methodInfo;
        block16: {
            methodInfo = classFile.addMethodInfo(functionDeclarator.modifiers, functionDeclarator.name, this.toIInvocable(functionDeclarator).getDescriptor());
            short s = classFile.addConstantUtf8Info("Exceptions");
            short[] sArray = new short[functionDeclarator.thrownExceptions.length];
            int n = 0;
            while (n < functionDeclarator.thrownExceptions.length) {
                sArray[n] = classFile.addConstantClassInfo(this.getType(functionDeclarator.thrownExceptions[n]).getDescriptor());
                ++n;
            }
            methodInfo.addAttribute(new ClassFile.ExceptionsAttribute(s, sArray));
            if (functionDeclarator.hasDeprecatedDocTag()) {
                methodInfo.addAttribute(new ClassFile.DeprecatedAttribute(classFile.addConstantUtf8Info("Deprecated")));
            }
            if ((functionDeclarator.modifiers & 0x500) != 0) {
                return;
            }
            codeContext2 = new CodeContext(methodInfo.getClassFile());
            codeContext = this.replaceCodeContext(codeContext2);
            try {
                boolean bl;
                Object object;
                Object object2;
                if ((functionDeclarator.modifiers & 8) == 0) {
                    this.codeContext.allocateLocalVariable((short)1);
                }
                if (functionDeclarator instanceof Java.ConstructorDeclarator) {
                    Java.ConstructorDeclarator constructorDeclarator = (Java.ConstructorDeclarator)functionDeclarator;
                    object2 = constructorDeclarator.declaringClass.syntheticFields.values().iterator();
                    while (object2.hasNext()) {
                        object = (IClass.IField)object2.next();
                        constructorDeclarator.syntheticParameters.put(((IClass.IField)object).getName(), new Java.LocalVariable(true, ((IClass.IField)object).getType(), this.codeContext.allocateLocalVariable(Descriptor.size(((IClass.IField)object).getDescriptor()))));
                    }
                }
                int n2 = 0;
                while (n2 < functionDeclarator.formalParameters.length) {
                    object2 = functionDeclarator.formalParameters[n2];
                    if (functionDeclarator.parameters.containsKey(((Java.FormalParameter)object2).name)) {
                        this.compileError("Redefinition of formal parameter \"" + ((Java.FormalParameter)object2).name + "\"", functionDeclarator.getLocation());
                    }
                    object = this.getType(((Java.FormalParameter)object2).type);
                    functionDeclarator.parameters.put(((Java.FormalParameter)object2).name, new Java.LocalVariable(((Java.FormalParameter)object2).finaL, (IClass)object, this.codeContext.allocateLocalVariable(Descriptor.size(((IClass)object).getDescriptor()))));
                    ++n2;
                }
                if (functionDeclarator instanceof Java.ConstructorDeclarator) {
                    object2 = (Java.ConstructorDeclarator)functionDeclarator;
                    if (((Java.ConstructorDeclarator)object2).optionalExplicitConstructorInvocation != null) {
                        this.compile(((Java.ConstructorDeclarator)object2).optionalExplicitConstructorInvocation);
                        if (((Java.ConstructorDeclarator)object2).optionalExplicitConstructorInvocation instanceof Java.SuperConstructorInvocation) {
                            this.assignSyntheticParametersToSyntheticFields((Java.ConstructorDeclarator)object2);
                            this.initializeInstanceVariablesAndInvokeInstanceInitializers((Java.ConstructorDeclarator)object2);
                        }
                    } else {
                        object = null;
                        IClass iClass = this.resolve(((Java.ConstructorDeclarator)object2).declaringClass).getSuperclass().getOuterIClass();
                        if (iClass != null) {
                            object = new Java.QualifiedThisReference(((Java.Located)object2).getLocation(), ((Java.ConstructorDeclarator)object2).declaringClass, (Java.TypeBodyDeclaration)object2, iClass);
                        }
                        this.compile(new Java.SuperConstructorInvocation(((Java.Located)object2).getLocation(), ((Java.ConstructorDeclarator)object2).declaringClass, (Java.ConstructorDeclarator)object2, (Java.Rvalue)object, new Java.Rvalue[0]));
                        this.assignSyntheticParametersToSyntheticFields((Java.ConstructorDeclarator)object2);
                        this.initializeInstanceVariablesAndInvokeInstanceInitializers((Java.ConstructorDeclarator)object2);
                    }
                }
                if (!(bl = this.compile(functionDeclarator.optionalBody))) break block16;
                if (this.getReturnType(functionDeclarator) != IClass.VOID) {
                    this.compileError("Method must return a value", functionDeclarator.getLocation());
                }
                this.writeOpcode(functionDeclarator, -79);
            }
            catch (Throwable throwable) {
                Object var10_16 = null;
                this.replaceCodeContext(codeContext);
                throw throwable;
            }
        }
        Object var10_15 = null;
        this.replaceCodeContext(codeContext);
        codeContext2.fixUp();
        codeContext2.relocate();
        codeContext2.flowAnalysis(functionDeclarator.toString());
        final short s = this.debuggingInformation.contains(DebuggingInformation.LINES) ? classFile.addConstantUtf8Info("LineNumberTable") : (short)0;
        methodInfo.addAttribute(new ClassFile.AttributeInfo(classFile.addConstantUtf8Info("Code")){

            protected void storeBody(DataOutputStream dataOutputStream) throws IOException {
                codeContext2.storeCodeAttributeBody(dataOutputStream, s);
            }
        });
    }

    private void compile(Java.Rvalue rvalue) throws CompileException {
        Visitor.RvalueVisitor rvalueVisitor = new Visitor.RvalueVisitor(){

            public void visitAmbiguousName(Java.AmbiguousName ambiguousName) {
                try {
                    UnitCompiler.this.compile2(ambiguousName);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitArrayAccessExpression(Java.ArrayAccessExpression arrayAccessExpression) {
                try {
                    UnitCompiler.this.compile2(arrayAccessExpression);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitArrayInitializer(Java.ArrayInitializer arrayInitializer) {
                try {
                    UnitCompiler.this.compile2(arrayInitializer);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitArrayLength(Java.ArrayLength arrayLength) {
                try {
                    UnitCompiler.this.compile2(arrayLength);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitAssignment(Java.Assignment assignment) {
                try {
                    UnitCompiler.this.compile2(assignment);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitBinaryOperation(Java.BinaryOperation binaryOperation) {
                try {
                    UnitCompiler.this.compile2(binaryOperation);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitCast(Java.Cast cast) {
                try {
                    UnitCompiler.this.compile2(cast);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitClassLiteral(Java.ClassLiteral classLiteral) {
                try {
                    UnitCompiler.this.compile2(classLiteral);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitConditionalExpression(Java.ConditionalExpression conditionalExpression) {
                try {
                    UnitCompiler.this.compile2(conditionalExpression);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitConstantValue(Java.ConstantValue constantValue) {
                try {
                    UnitCompiler.this.compile2(constantValue);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitCrement(Java.Crement crement) {
                try {
                    UnitCompiler.this.compile2(crement);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitFieldAccess(Java.FieldAccess fieldAccess) {
                try {
                    UnitCompiler.this.compile2(fieldAccess);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitFieldAccessExpression(Java.FieldAccessExpression fieldAccessExpression) {
                try {
                    UnitCompiler.this.compile2(fieldAccessExpression);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitInstanceof(Java.Instanceof instanceof_) {
                try {
                    UnitCompiler.this.compile2(instanceof_);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitLiteral(Java.Literal literal) {
                try {
                    UnitCompiler.this.compile2(literal);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitLocalVariableAccess(Java.LocalVariableAccess localVariableAccess) {
                try {
                    UnitCompiler.this.compile2(localVariableAccess);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitMethodInvocation(Java.MethodInvocation methodInvocation) {
                try {
                    UnitCompiler.this.compile2(methodInvocation);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitNewAnonymousClassInstance(Java.NewAnonymousClassInstance newAnonymousClassInstance) {
                try {
                    UnitCompiler.this.compile2(newAnonymousClassInstance);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitNewArray(Java.NewArray newArray) {
                try {
                    UnitCompiler.this.compile2(newArray);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitNewClassInstance(Java.NewClassInstance newClassInstance) {
                try {
                    UnitCompiler.this.compile2(newClassInstance);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitParameterAccess(Java.ParameterAccess parameterAccess) {
                try {
                    UnitCompiler.this.compile2(parameterAccess);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitParenthesizedExpression(Java.ParenthesizedExpression parenthesizedExpression) {
                try {
                    UnitCompiler.this.compile2(parenthesizedExpression);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitQualifiedThisReference(Java.QualifiedThisReference qualifiedThisReference) {
                try {
                    UnitCompiler.this.compile2(qualifiedThisReference);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitSuperclassMethodInvocation(Java.SuperclassMethodInvocation superclassMethodInvocation) {
                try {
                    UnitCompiler.this.compile2(superclassMethodInvocation);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitThisReference(Java.ThisReference thisReference) {
                try {
                    UnitCompiler.this.compile2(thisReference);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitUnaryOperation(Java.UnaryOperation unaryOperation) {
                try {
                    UnitCompiler.this.compile2(unaryOperation);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }
        };
        try {
            rvalue.accept(rvalueVisitor);
        }
        catch (TunnelException tunnelException) {
            throw (CompileException)tunnelException.getDelegate();
        }
    }

    private void compile(Java.TypeDeclaration typeDeclaration) throws CompileException {
        Visitor.TypeDeclarationVisitor typeDeclarationVisitor = new Visitor.TypeDeclarationVisitor(){

            public void visitAnonymousClassDeclaration(Java.AnonymousClassDeclaration anonymousClassDeclaration) {
                try {
                    UnitCompiler.this.compile2(anonymousClassDeclaration);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitLocalClassDeclaration(Java.LocalClassDeclaration localClassDeclaration) {
                try {
                    UnitCompiler.this.compile2(localClassDeclaration);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitMemberClassDeclaration(Java.MemberClassDeclaration memberClassDeclaration) {
                try {
                    UnitCompiler.this.compile2(memberClassDeclaration);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitMemberInterfaceDeclaration(Java.MemberInterfaceDeclaration memberInterfaceDeclaration) {
                try {
                    UnitCompiler.this.compile2(memberInterfaceDeclaration);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitPackageMemberClassDeclaration(Java.PackageMemberClassDeclaration packageMemberClassDeclaration) {
                try {
                    UnitCompiler.this.compile2(packageMemberClassDeclaration);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitPackageMemberInterfaceDeclaration(Java.PackageMemberInterfaceDeclaration packageMemberInterfaceDeclaration) {
                try {
                    UnitCompiler.this.compile2(packageMemberInterfaceDeclaration);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }
        };
        try {
            typeDeclaration.accept(typeDeclarationVisitor);
        }
        catch (TunnelException tunnelException) {
            throw (CompileException)tunnelException.getDelegate();
        }
    }

    void compile2(Java.AlternateConstructorInvocation alternateConstructorInvocation) throws CompileException {
        this.writeOpcode(alternateConstructorInvocation, 42);
        this.invokeConstructor(alternateConstructorInvocation, alternateConstructorInvocation.declaringConstructor, null, this.resolve(alternateConstructorInvocation.declaringClass), alternateConstructorInvocation.arguments);
    }

    public void compile2(Java.AnonymousClassDeclaration anonymousClassDeclaration) throws CompileException {
        Java.Scope scope = anonymousClassDeclaration.getEnclosingScope();
        while (!(scope instanceof Java.TypeBodyDeclaration)) {
            scope = scope.getEnclosingScope();
        }
        Java.TypeBodyDeclaration typeBodyDeclaration = (Java.TypeBodyDeclaration)scope;
        if (!typeBodyDeclaration.isStatic()) {
            int n = UnitCompiler.getOuterClasses(anonymousClassDeclaration).size();
            anonymousClassDeclaration.defineSyntheticField(new SimpleIField(this.resolve(anonymousClassDeclaration), "this$" + (n - 2), this.resolve(typeBodyDeclaration.getDeclaringType())));
        }
        this.compile2((Java.ClassDeclaration)anonymousClassDeclaration);
    }

    void compile2(Java.Assignment assignment) throws CompileException {
        if (assignment.operator == "=") {
            this.compileContext(assignment.lhs);
            this.assignmentConversion(assignment, this.compileGetValue(assignment.rhs), this.getType(assignment.lhs), this.getConstantValue(assignment.rhs));
            this.compileSet(assignment.lhs);
            return;
        }
        int n = this.compileContext(assignment.lhs);
        this.dup(assignment, n);
        IClass iClass = this.compileGet(assignment.lhs);
        IClass iClass2 = this.compileArithmeticBinaryOperation(assignment, iClass, assignment.operator.substring(0, assignment.operator.length() - 1).intern(), assignment.rhs);
        if (!this.tryIdentityConversion(iClass2, iClass) && !this.tryNarrowingPrimitiveConversion(assignment, iClass2, iClass)) {
            throw new RuntimeException();
        }
        this.compileSet(assignment.lhs);
    }

    boolean compile2(Java.Block block) throws CompileException {
        this.codeContext.saveLocalVariables();
        try {
            boolean bl = true;
            block.keepCompiling = true;
            int n = 0;
            while (block.keepCompiling && n < block.statements.size()) {
                Java.BlockStatement blockStatement = (Java.BlockStatement)block.statements.get(n);
                if (!bl) {
                    this.compileError("Statement is unreachable", blockStatement.getLocation());
                    break;
                }
                bl = this.compile(blockStatement);
                ++n;
            }
            boolean bl2 = bl;
            Object var4_6 = null;
            this.codeContext.restoreLocalVariables();
            return bl2;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.codeContext.restoreLocalVariables();
            throw throwable;
        }
    }

    boolean compile2(Java.BreakStatement breakStatement) throws CompileException {
        Java.BreakableStatement breakableStatement = null;
        if (breakStatement.optionalLabel == null) {
            Java.Scope scope = breakStatement.enclosingScope;
            while (scope instanceof Java.Statement) {
                if (scope instanceof Java.BreakableStatement) {
                    breakableStatement = (Java.BreakableStatement)scope;
                    break;
                }
                scope = scope.getEnclosingScope();
            }
            if (breakableStatement == null) {
                this.compileError("\"break\" statement is not enclosed by a breakable statement", breakStatement.getLocation());
                return false;
            }
        } else {
            Java.Scope scope = breakStatement.enclosingScope;
            while (scope instanceof Java.Statement) {
                if (scope instanceof Java.LabeledStatement) {
                    Java.LabeledStatement labeledStatement = (Java.LabeledStatement)scope;
                    if (labeledStatement.label.equals(breakStatement.optionalLabel)) {
                        breakableStatement = labeledStatement;
                        break;
                    }
                }
                scope = scope.getEnclosingScope();
            }
            if (breakableStatement == null) {
                this.compileError("Statement \"break " + breakStatement.optionalLabel + "\" is not enclosed by a breakable statement with label \"" + breakStatement.optionalLabel + "\"", breakStatement.getLocation());
                return false;
            }
        }
        this.leaveStatements(breakStatement.enclosingScope, breakableStatement.enclosingScope, null);
        this.writeBranch(breakStatement, -89, this.getWhereToBreak(breakableStatement));
        return false;
    }

    public void compile2(Java.ClassDeclaration classDeclaration) throws CompileException {
        Object object;
        Object object2;
        IClass[] iClassArray = this.resolve(classDeclaration).getInterfaces();
        String[] stringArray = new String[iClassArray.length];
        int n = 0;
        while (n < iClassArray.length) {
            stringArray[n] = iClassArray[n].getDescriptor();
            ++n;
        }
        ClassFile classFile = new ClassFile((short)(classDeclaration.modifiers | 0x20), this.resolve(classDeclaration).getDescriptor(), this.resolve(classDeclaration).getSuperclass().getDescriptor(), stringArray);
        if (!(classDeclaration.enclosingScope instanceof Java.CompilationUnit)) {
            short s;
            short s2;
            if (classDeclaration.enclosingScope instanceof Java.Block) {
                s2 = classFile.addConstantClassInfo(this.resolve(classDeclaration).getDescriptor());
                s = this instanceof Java.NamedTypeDeclaration ? classFile.addConstantUtf8Info(((Java.NamedTypeDeclaration)((Object)this)).getName()) : (short)0;
                classFile.addInnerClassesAttributeEntry(new ClassFile.InnerClassesAttribute.Entry(s2, 0, s, classDeclaration.modifiers));
            } else if (classDeclaration.enclosingScope instanceof Java.AbstractTypeDeclaration) {
                s2 = classFile.addConstantClassInfo(this.resolve(classDeclaration).getDescriptor());
                s = classFile.addConstantClassInfo(this.resolve((Java.AbstractTypeDeclaration)classDeclaration.enclosingScope).getDescriptor());
                short s3 = classFile.addConstantUtf8Info(((Java.MemberTypeDeclaration)((Object)classDeclaration)).getName());
                classFile.addInnerClassesAttributeEntry(new ClassFile.InnerClassesAttribute.Entry(s2, s, s3, classDeclaration.modifiers));
            }
        }
        if (this.debuggingInformation.contains(DebuggingInformation.SOURCE)) {
            String string = classDeclaration.getLocation().getFileName();
            String string2 = string != null ? new File(string).getName() : (this instanceof Java.NamedTypeDeclaration ? String.valueOf(((Java.NamedTypeDeclaration)((Object)this)).getName()) + ".java" : "ANONYMOUS.java");
            classFile.addSourceFileAttribute(string2);
        }
        if (classDeclaration instanceof Java.DocCommentable && ((Java.DocCommentable)((Object)classDeclaration)).hasDeprecatedDocTag()) {
            classFile.addDeprecatedAttribute();
        }
        Java.MethodDeclarator methodDeclarator = new Java.MethodDeclarator(classDeclaration.getLocation(), classDeclaration, null, 9, (Java.Type)new Java.BasicType(classDeclaration.getLocation(), 0), "<clinit>", new Java.FormalParameter[0], (Java.Type[])new Java.ReferenceType[0]);
        Java.Block block = new Java.Block(classDeclaration.getLocation(), methodDeclarator);
        Iterator iterator = classDeclaration.variableDeclaratorsAndInitializers.iterator();
        while (iterator.hasNext()) {
            Java.TypeBodyDeclaration typeBodyDeclaration = (Java.TypeBodyDeclaration)iterator.next();
            if (!typeBodyDeclaration.isStatic()) continue;
            block.addStatement((Java.BlockStatement)((Object)typeBodyDeclaration));
        }
        methodDeclarator.setBody(block);
        if (this.generatesCode(block)) {
            this.compile(methodDeclarator, classFile);
        }
        int n2 = 0;
        while (n2 < classDeclaration.declaredMethods.size()) {
            this.compile((Java.MethodDeclarator)classDeclaration.declaredMethods.get(n2), classFile);
            ++n2;
        }
        int n3 = classDeclaration.declaredMethods.size();
        int n4 = classDeclaration.syntheticFields.size();
        Java.ConstructorDeclarator[] constructorDeclaratorArray = classDeclaration.getConstructors();
        int n5 = 0;
        while (n5 < constructorDeclaratorArray.length) {
            this.compile(constructorDeclaratorArray[n5], classFile);
            if (n4 != classDeclaration.syntheticFields.size()) {
                throw new RuntimeException("SNO: Compilation of constructor \"" + constructorDeclaratorArray[n5] + "\" (" + constructorDeclaratorArray[n5].getLocation() + ") added synthetic fields!?");
            }
            ++n5;
        }
        int n6 = n3;
        while (n6 < classDeclaration.declaredMethods.size()) {
            this.compile((Java.MethodDeclarator)classDeclaration.declaredMethods.get(n6), classFile);
            ++n6;
        }
        Iterator iterator2 = classDeclaration.variableDeclaratorsAndInitializers.iterator();
        while (iterator2.hasNext()) {
            object2 = (Java.TypeBodyDeclaration)iterator2.next();
            if (!(object2 instanceof Java.FieldDeclaration)) continue;
            this.addFields((Java.FieldDeclaration)object2, classFile);
        }
        object2 = classDeclaration.syntheticFields.values().iterator();
        while (object2.hasNext()) {
            object = (IClass.IField)object2.next();
            classFile.addFieldInfo((short)0, ((IClass.IField)object).getName(), ((IClass.IField)object).getType().getDescriptor(), null);
        }
        object = classDeclaration.getMemberTypeDeclarations().iterator();
        while (object.hasNext()) {
            Java.AbstractTypeDeclaration abstractTypeDeclaration = (Java.AbstractTypeDeclaration)object.next();
            this.compile(abstractTypeDeclaration);
            short s = classFile.addConstantClassInfo(this.resolve(abstractTypeDeclaration).getDescriptor());
            short s4 = classFile.addConstantClassInfo(this.resolve(classDeclaration).getDescriptor());
            short s5 = classFile.addConstantUtf8Info(((Java.MemberTypeDeclaration)((Object)abstractTypeDeclaration)).getName());
            classFile.addInnerClassesAttributeEntry(new ClassFile.InnerClassesAttribute.Entry(s, s4, s5, abstractTypeDeclaration.modifiers));
        }
        this.generatedClassFiles.add(classFile);
    }

    boolean compile2(Java.ContinueStatement continueStatement) throws CompileException {
        Java.ContinuableStatement continuableStatement = null;
        if (continueStatement.optionalLabel == null) {
            Java.Scope scope = continueStatement.enclosingScope;
            while (scope instanceof Java.Statement) {
                if (scope instanceof Java.ContinuableStatement) {
                    continuableStatement = (Java.ContinuableStatement)scope;
                    break;
                }
                scope = scope.getEnclosingScope();
            }
            if (continuableStatement == null) {
                this.compileError("\"continue\" statement is not enclosed by a continuable statement", continueStatement.getLocation());
                return false;
            }
        } else {
            Java.Scope scope = continueStatement.enclosingScope;
            while (scope instanceof Java.Statement) {
                if (scope instanceof Java.LabeledStatement) {
                    Java.LabeledStatement labeledStatement = (Java.LabeledStatement)scope;
                    if (labeledStatement.label.equals(continueStatement.optionalLabel)) {
                        Java.Statement statement = labeledStatement.body;
                        while (statement instanceof Java.LabeledStatement) {
                            statement = ((Java.LabeledStatement)statement).body;
                        }
                        if (!(statement instanceof Java.ContinuableStatement)) {
                            this.compileError("Labeled statement is not continuable", statement.getLocation());
                            return false;
                        }
                        continuableStatement = (Java.ContinuableStatement)statement;
                        break;
                    }
                }
                scope = scope.getEnclosingScope();
            }
            if (continuableStatement == null) {
                this.compileError("Statement \"continue " + continueStatement.optionalLabel + "\" is not enclosed by a continuable statement with label \"" + continueStatement.optionalLabel + "\"", continueStatement.getLocation());
                return false;
            }
        }
        continuableStatement.bodyHasContinue = true;
        this.leaveStatements(continueStatement.enclosingScope, continuableStatement.enclosingScope, null);
        this.writeBranch(continueStatement, -89, continuableStatement.whereToContinue);
        return false;
    }

    void compile2(Java.Crement crement) throws CompileException {
        Java.LocalVariable localVariable = this.isIntLV(crement);
        if (localVariable != null) {
            this.writeOpcode(crement, -124);
            this.writeByte(crement, localVariable.localVariableArrayIndex);
            this.writeByte(crement, crement.operator == "++" ? 1 : -1);
            return;
        }
        int n = this.compileContext(crement.operand);
        this.dup(crement, n);
        IClass iClass = this.compileGet(crement.operand);
        IClass iClass2 = this.unaryNumericPromotion(crement, iClass);
        this.writeOpcode(crement, UnitCompiler.ilfd(iClass2, 4, 10, 12, 15));
        if (crement.operator == "++") {
            this.writeOpcode(crement, 96 + UnitCompiler.ilfd(iClass2));
        } else if (crement.operator == "--") {
            this.writeOpcode(crement, 100 + UnitCompiler.ilfd(iClass2));
        } else {
            this.compileError("Unexpected operator \"" + crement.operator + "\"", crement.getLocation());
        }
        if (!this.tryIdentityConversion(iClass2, iClass) && !this.tryNarrowingPrimitiveConversion(crement, iClass2, iClass)) {
            throw new RuntimeException();
        }
        this.compileSet(crement.operand);
    }

    boolean compile2(Java.DoStatement doStatement) throws CompileException {
        if (Boolean.TRUE.equals(this.getConstantValue(doStatement.condition))) {
            return this.compileUnconditionalLoop(doStatement, doStatement.body, null);
        }
        doStatement.whereToContinue = this.codeContext.new CodeContext.Offset();
        doStatement.bodyHasContinue = false;
        CodeContext.Offset offset = this.codeContext.newOffset();
        if (!this.compile(doStatement.body) && !doStatement.bodyHasContinue) {
            this.compileError("\"do\" statement never tests its condition", doStatement.getLocation());
        }
        doStatement.whereToContinue.set();
        this.compileBoolean(doStatement.condition, offset, true);
        if (doStatement.whereToBreak != null) {
            doStatement.whereToBreak.set();
        }
        return true;
    }

    boolean compile2(Java.EmptyStatement emptyStatement) {
        return true;
    }

    boolean compile2(Java.ExpressionStatement expressionStatement) throws CompileException {
        this.compile(expressionStatement.rvalue);
        return true;
    }

    boolean compile2(Java.FieldDeclaration fieldDeclaration) throws CompileException {
        int n = 0;
        while (n < fieldDeclaration.variableDeclarators.length) {
            Java.VariableDeclarator variableDeclarator = fieldDeclaration.variableDeclarators[n];
            Java.Rvalue rvalue = this.getNonConstantFinalInitializer(fieldDeclaration, variableDeclarator);
            if (rvalue != null) {
                if ((fieldDeclaration.modifiers & 8) == 0) {
                    this.writeOpcode(fieldDeclaration, 42);
                }
                IClass iClass = this.compileGetValue(rvalue);
                IClass iClass2 = this.getType(fieldDeclaration.type);
                iClass2 = this.getArrayType(iClass2, variableDeclarator.brackets);
                this.assignmentConversion(fieldDeclaration, iClass, iClass2, this.getConstantValue(rvalue));
                if ((fieldDeclaration.modifiers & 8) != 0) {
                    this.writeOpcode(fieldDeclaration, -77);
                } else {
                    this.writeOpcode(fieldDeclaration, -75);
                }
                this.writeConstantFieldrefInfo(fieldDeclaration, this.resolve(fieldDeclaration.declaringType).getDescriptor(), variableDeclarator.name, iClass2.getDescriptor());
            }
            ++n;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean compile2(Java.ForStatement forStatement) throws CompileException {
        block9: {
            boolean bl;
            block8: {
                this.codeContext.saveLocalVariables();
                try {
                    if (forStatement.optionalInit != null) {
                        this.compile(forStatement.optionalInit);
                    }
                    if (forStatement.optionalCondition == null || Boolean.TRUE.equals(this.getConstantValue(forStatement.optionalCondition))) {
                        boolean bl2 = this.compileUnconditionalLoop(forStatement, forStatement.body, forStatement.optionalUpdate);
                        Object var4_4 = null;
                        this.codeContext.restoreLocalVariables();
                        return bl2;
                    }
                    CodeContext.Offset offset = this.codeContext.new CodeContext.Offset();
                    this.writeBranch(forStatement, -89, offset);
                    forStatement.whereToContinue = this.codeContext.new CodeContext.Offset();
                    forStatement.bodyHasContinue = false;
                    CodeContext.Offset offset2 = this.codeContext.newOffset();
                    boolean bl3 = this.compile(forStatement.body);
                    forStatement.whereToContinue.set();
                    if (forStatement.optionalUpdate != null) {
                        if (!bl3 && !forStatement.bodyHasContinue) {
                            this.compileError("For update is unreachable", forStatement.getLocation());
                            bl = true;
                            break block8;
                        }
                        int n = 0;
                        while (n < forStatement.optionalUpdate.length) {
                            this.compile(forStatement.optionalUpdate[n]);
                            ++n;
                        }
                    }
                    offset.set();
                    this.compileBoolean(forStatement.optionalCondition, offset2, true);
                    break block9;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    this.codeContext.restoreLocalVariables();
                    throw throwable;
                }
            }
            Object var4_5 = null;
            this.codeContext.restoreLocalVariables();
            return bl;
        }
        Object var4_6 = null;
        this.codeContext.restoreLocalVariables();
        if (forStatement.whereToBreak != null) {
            forStatement.whereToBreak.set();
        }
        return true;
    }

    boolean compile2(Java.IfStatement ifStatement) throws CompileException {
        Java.BlockStatement blockStatement;
        Object object = this.getConstantValue(ifStatement.condition);
        Java.BlockStatement blockStatement2 = blockStatement = ifStatement.optionalElseStatement != null ? ifStatement.optionalElseStatement : new Java.EmptyStatement(ifStatement.thenStatement.getLocation(), ifStatement.thenStatement.getEnclosingScope());
        if (object instanceof Boolean) {
            Java.BlockStatement blockStatement3;
            Java.BlockStatement blockStatement4;
            this.fakeCompile(ifStatement.condition);
            if (((Boolean)object).booleanValue()) {
                blockStatement4 = ifStatement.thenStatement;
                blockStatement3 = blockStatement;
            } else {
                blockStatement4 = blockStatement;
                blockStatement3 = ifStatement.thenStatement;
            }
            boolean bl = this.compile(blockStatement4);
            if (bl) {
                return true;
            }
            if (!this.canCompleteNormally(blockStatement3)) {
                return false;
            }
            Java.Scope scope = ifStatement.getEnclosingScope();
            if (scope instanceof Java.Block) {
                ((Java.Block)scope).followingStatementsAreDead();
            }
            return false;
        }
        if (this.generatesCode(ifStatement.thenStatement)) {
            if (this.generatesCode(blockStatement)) {
                CodeContext.Offset offset = this.codeContext.new CodeContext.Offset();
                CodeContext.Offset offset2 = this.codeContext.new CodeContext.Offset();
                this.compileBoolean(ifStatement.condition, offset, false);
                boolean bl = this.compile(ifStatement.thenStatement);
                if (bl) {
                    this.writeBranch(-89, offset2);
                }
                offset.set();
                boolean bl2 = this.compile(blockStatement);
                offset2.set();
                return bl || bl2;
            }
            CodeContext.Offset offset = this.codeContext.new CodeContext.Offset();
            this.compileBoolean(ifStatement.condition, offset, false);
            this.compile(ifStatement.thenStatement);
            offset.set();
            return true;
        }
        if (this.generatesCode(blockStatement)) {
            CodeContext.Offset offset = this.codeContext.new CodeContext.Offset();
            this.compileBoolean(ifStatement.condition, offset, true);
            this.compile(blockStatement);
            offset.set();
            return true;
        }
        IClass iClass = this.compileGetValue(ifStatement.condition);
        if (iClass != IClass.BOOLEAN) {
            this.compileError("Not a boolean expression", ifStatement.getLocation());
        }
        this.pop(ifStatement, iClass);
        return true;
    }

    boolean compile2(Java.Initializer initializer) throws CompileException {
        return this.compile(initializer.block);
    }

    public void compile2(Java.InterfaceDeclaration interfaceDeclaration) throws CompileException {
        Object object;
        Object object2;
        Object object3;
        interfaceDeclaration.interfaces = new IClass[interfaceDeclaration.extendedTypes.length];
        String[] stringArray = new String[interfaceDeclaration.interfaces.length];
        int n = 0;
        while (n < interfaceDeclaration.extendedTypes.length) {
            interfaceDeclaration.interfaces[n] = this.getType(interfaceDeclaration.extendedTypes[n]);
            stringArray[n] = interfaceDeclaration.interfaces[n].getDescriptor();
            ++n;
        }
        ClassFile classFile = new ClassFile((short)(interfaceDeclaration.modifiers | 0x20 | 0x200 | 0x400), this.resolve(interfaceDeclaration).getDescriptor(), "Ljava/lang/Object;", stringArray);
        if (this.debuggingInformation.contains(DebuggingInformation.SOURCE)) {
            object3 = interfaceDeclaration.getLocation().getFileName();
            object2 = object3 != null ? new File((String)object3).getName() : String.valueOf(interfaceDeclaration.getName()) + ".java";
            classFile.addSourceFileAttribute((String)object2);
        }
        if (interfaceDeclaration.hasDeprecatedDocTag()) {
            classFile.addDeprecatedAttribute();
        }
        if (!interfaceDeclaration.constantDeclarations.isEmpty()) {
            object2 = new Java.MethodDeclarator(interfaceDeclaration.getLocation(), interfaceDeclaration, null, 9, (Java.Type)new Java.BasicType(interfaceDeclaration.getLocation(), 0), "<clinit>", new Java.FormalParameter[0], (Java.Type[])new Java.ReferenceType[0]);
            object3 = new Java.Block(interfaceDeclaration.getLocation(), (Java.Scope)object2);
            ((Java.Block)object3).addStatements(interfaceDeclaration.constantDeclarations);
            ((Java.FunctionDeclarator)object2).setBody((Java.Block)object3);
            if (this.generatesCode((Java.BlockStatement)object3)) {
                this.compile((Java.FunctionDeclarator)object2, classFile);
            }
        }
        int n2 = 0;
        while (n2 < interfaceDeclaration.declaredMethods.size()) {
            this.compile((Java.MethodDeclarator)interfaceDeclaration.declaredMethods.get(n2), classFile);
            ++n2;
        }
        int n3 = 0;
        while (n3 < interfaceDeclaration.constantDeclarations.size()) {
            object = (Java.BlockStatement)interfaceDeclaration.constantDeclarations.get(n3);
            if (object instanceof Java.FieldDeclaration) {
                this.addFields((Java.FieldDeclaration)object, classFile);
            }
            ++n3;
        }
        object = interfaceDeclaration.getMemberTypeDeclarations().iterator();
        while (object.hasNext()) {
            Java.AbstractTypeDeclaration abstractTypeDeclaration = (Java.AbstractTypeDeclaration)object.next();
            this.compile(abstractTypeDeclaration);
            short s = classFile.addConstantClassInfo(this.resolve(abstractTypeDeclaration).getDescriptor());
            short s2 = classFile.addConstantClassInfo(this.resolve(interfaceDeclaration).getDescriptor());
            short s3 = classFile.addConstantUtf8Info(((Java.MemberTypeDeclaration)((Object)abstractTypeDeclaration)).getName());
            classFile.addInnerClassesAttributeEntry(new ClassFile.InnerClassesAttribute.Entry(s, s2, s3, interfaceDeclaration.modifiers));
        }
        this.generatedClassFiles.add(classFile);
    }

    final boolean compile2(Java.LabeledStatement labeledStatement) throws CompileException {
        boolean bl = this.compile(labeledStatement.body);
        if (labeledStatement.whereToBreak != null) {
            labeledStatement.whereToBreak.set();
            bl = true;
        }
        return bl;
    }

    public void compile2(Java.LocalClassDeclaration localClassDeclaration) throws CompileException {
        ((Java.Block)localClassDeclaration.getEnclosingScope()).declaredLocalClasses.put(localClassDeclaration.getName(), this);
        List list = UnitCompiler.getOuterClasses(localClassDeclaration);
        int n = list.size();
        if (n >= 2) {
            IClass iClass = this.resolve((Java.AbstractTypeDeclaration)list.get(1));
            localClassDeclaration.defineSyntheticField(new SimpleIField(this.resolve(localClassDeclaration), "this$" + (n - 2), iClass));
        }
        this.compile(localClassDeclaration);
    }

    boolean compile2(Java.LocalClassDeclarationStatement localClassDeclarationStatement) throws CompileException {
        this.compile(localClassDeclarationStatement.lcd);
        return true;
    }

    boolean compile2(Java.LocalVariableDeclarationStatement localVariableDeclarationStatement) throws CompileException {
        if ((localVariableDeclarationStatement.modifiers & 0xFFFFFFEF) != 0) {
            this.compileError("The only allowed modifier in local variable declarations is \"final\"", localVariableDeclarationStatement.getLocation());
        }
        int n = 0;
        while (n < localVariableDeclarationStatement.variableDeclarators.length) {
            Java.VariableDeclarator variableDeclarator = localVariableDeclarationStatement.variableDeclarators[n];
            Java.Type type = localVariableDeclarationStatement.type;
            int n2 = 0;
            while (n2 < variableDeclarator.brackets) {
                type = new Java.ArrayType(type);
                ++n2;
            }
            IClass iClass = this.getType(type);
            Java.LocalVariable localVariable = this.defineLocalVariable(localVariableDeclarationStatement.declaringBlock, localVariableDeclarationStatement, (localVariableDeclarationStatement.modifiers & 0x10) != 0, iClass, variableDeclarator.name);
            if (variableDeclarator.optionalInitializer != null) {
                Java.Rvalue rvalue = variableDeclarator.optionalInitializer;
                this.assignmentConversion(localVariableDeclarationStatement, this.compileGetValue(rvalue), iClass, this.getConstantValue(rvalue));
                this.store((Java.Located)localVariableDeclarationStatement, iClass, localVariable);
            }
            ++n;
        }
        return true;
    }

    public void compile2(Java.MemberClassDeclaration memberClassDeclaration) throws CompileException {
        if ((memberClassDeclaration.modifiers & 8) == 0) {
            int n = UnitCompiler.getOuterClasses(memberClassDeclaration).size();
            memberClassDeclaration.defineSyntheticField(new SimpleIField(this.resolve(memberClassDeclaration), "this$" + (n - 2), this.resolve(memberClassDeclaration.getDeclaringType())));
        }
        this.compile2((Java.ClassDeclaration)memberClassDeclaration);
    }

    void compile2(Java.ParenthesizedExpression parenthesizedExpression) throws CompileException {
        this.compile(parenthesizedExpression.value);
    }

    boolean compile2(Java.ReturnStatement returnStatement) throws CompileException {
        Java.FunctionDeclarator functionDeclarator = null;
        Java.Scope scope = returnStatement.enclosingScope;
        scope = scope.getEnclosingScope();
        while (scope instanceof Java.Statement) {
            scope = scope.getEnclosingScope();
        }
        functionDeclarator = (Java.FunctionDeclarator)scope;
        IClass iClass = this.getReturnType(functionDeclarator);
        if (iClass == IClass.VOID) {
            if (returnStatement.optionalReturnValue != null) {
                this.compileError("Method must not return a value", returnStatement.getLocation());
            }
            this.leaveStatements(returnStatement.enclosingScope, functionDeclarator, null);
            this.writeOpcode(returnStatement, -79);
            return false;
        }
        if (returnStatement.optionalReturnValue == null) {
            this.compileError("Method must return a value", returnStatement.getLocation());
            return false;
        }
        IClass iClass2 = this.compileGetValue(returnStatement.optionalReturnValue);
        this.assignmentConversion(returnStatement, iClass2, iClass, this.getConstantValue(returnStatement.optionalReturnValue));
        this.leaveStatements(returnStatement.enclosingScope, functionDeclarator, iClass);
        this.writeOpcode(returnStatement, -84 + this.ilfda(iClass));
        return false;
    }

    void compile2(Java.Rvalue rvalue) throws CompileException {
        this.pop(rvalue, this.compileGetValue(rvalue));
    }

    void compile2(Java.SuperConstructorInvocation superConstructorInvocation) throws CompileException {
        IClass iClass;
        this.writeOpcode(superConstructorInvocation, 42);
        IClass iClass2 = this.resolve(superConstructorInvocation.declaringClass).getSuperclass();
        Object object = superConstructorInvocation.optionalQualification != null ? superConstructorInvocation.optionalQualification : ((iClass = iClass2.getOuterIClass()) == null ? null : new Java.QualifiedThisReference(superConstructorInvocation.getLocation(), superConstructorInvocation.declaringClass, superConstructorInvocation.declaringConstructor, iClass));
        this.invokeConstructor(superConstructorInvocation, superConstructorInvocation.declaringConstructor, (Java.Rvalue)object, iClass2, superConstructorInvocation.arguments);
    }

    boolean compile2(Java.SwitchStatement switchStatement) throws CompileException {
        Object object;
        Iterator iterator;
        Object object2;
        int n;
        Object object3;
        IClass iClass = this.compileGetValue(switchStatement.condition);
        this.assignmentConversion(switchStatement, iClass, IClass.INT, null);
        TreeMap<Integer, CodeContext.Offset> treeMap = new TreeMap<Integer, CodeContext.Offset>();
        CodeContext.Offset offset = null;
        CodeContext.Offset[] offsetArray = new CodeContext.Offset[switchStatement.sbsgs.size()];
        int n2 = 0;
        while (n2 < switchStatement.sbsgs.size()) {
            object3 = (Java.SwitchBlockStatementGroup)switchStatement.sbsgs.get(n2);
            offsetArray[n2] = this.codeContext.new CodeContext.Offset();
            n = 0;
            while (n < ((Java.SwitchBlockStatementGroup)object3).caseLabels.size()) {
                object2 = (Java.Rvalue)((Java.SwitchBlockStatementGroup)object3).caseLabels.get(n);
                iterator = this.getConstantValue((Java.Rvalue)object2);
                if (iterator == null) {
                    this.compileError("Value of \"case\" label does not pose a constant value", ((Java.Located)object2).getLocation());
                    iterator = new Integer(99);
                }
                IClass iClass2 = this.getType((Java.Atom)object2);
                this.assignmentConversion(switchStatement, iClass2, iClass, iterator);
                if (iterator instanceof Integer) {
                    object = (Integer)((Object)iterator);
                } else if (iterator instanceof Number) {
                    object = new Integer(((Number)((Object)iterator)).intValue());
                } else if (iterator instanceof Character) {
                    object = new Integer(((Character)((Object)iterator)).charValue());
                } else {
                    throw new RuntimeException();
                }
                if (treeMap.containsKey(object)) {
                    this.compileError("Duplicate \"case\" switch label value", ((Java.Located)object2).getLocation());
                }
                treeMap.put((Integer)object, offsetArray[n2]);
                ++n;
            }
            if (((Java.SwitchBlockStatementGroup)object3).hasDefaultLabel) {
                if (offset != null) {
                    this.compileError("Duplicate \"default\" switch label", ((Java.Located)object3).getLocation());
                }
                offset = offsetArray[n2];
            }
            ++n2;
        }
        if (offset == null) {
            offset = this.getWhereToBreak(switchStatement);
        }
        object3 = this.codeContext.newOffset();
        if (!treeMap.isEmpty() && 2 * treeMap.size() >= (Integer)treeMap.lastKey() - (Integer)treeMap.firstKey()) {
            n = (Integer)treeMap.firstKey();
            int n3 = (Integer)treeMap.lastKey();
            this.writeByte(switchStatement, -86);
            new Java.Padder(this.codeContext).set();
            this.writeOffset(switchStatement, (CodeContext.Offset)object3, offset);
            this.writeInt(switchStatement, n);
            this.writeInt(switchStatement, n3);
            iterator = treeMap.entrySet().iterator();
            int n4 = n;
            while (iterator.hasNext()) {
                object = iterator.next();
                int n5 = (Integer)object.getKey();
                while (n4 < n5) {
                    this.writeOffset(switchStatement, (CodeContext.Offset)object3, offset);
                    ++n4;
                }
                this.writeOffset(switchStatement, (CodeContext.Offset)object3, (CodeContext.Offset)object.getValue());
                ++n4;
            }
        } else {
            this.writeOpcode(switchStatement, -85);
            new Java.Padder(this.codeContext).set();
            this.writeOffset(switchStatement, (CodeContext.Offset)object3, offset);
            this.writeInt(switchStatement, treeMap.size());
            Iterator iterator2 = treeMap.entrySet().iterator();
            while (iterator2.hasNext()) {
                object2 = iterator2.next();
                this.writeInt(switchStatement, (Integer)object2.getKey());
                this.writeOffset(switchStatement, (CodeContext.Offset)object3, (CodeContext.Offset)object2.getValue());
            }
        }
        boolean bl = true;
        int n6 = 0;
        while (n6 < switchStatement.sbsgs.size()) {
            iterator = (Java.SwitchBlockStatementGroup)switchStatement.sbsgs.get(n6);
            offsetArray[n6].set();
            bl = true;
            int n7 = 0;
            while (n7 < ((Java.SwitchBlockStatementGroup)((Object)iterator)).blockStatements.size()) {
                object = (Java.BlockStatement)((Java.SwitchBlockStatementGroup)((Object)iterator)).blockStatements.get(n7);
                if (!bl) {
                    this.compileError("Statement is unreachable", object.getLocation());
                    break;
                }
                bl = this.compile((Java.BlockStatement)object);
                ++n7;
            }
            ++n6;
        }
        if (switchStatement.whereToBreak != null) {
            switchStatement.whereToBreak.set();
            bl = true;
        }
        return bl;
    }

    boolean compile2(Java.SynchronizedStatement synchronizedStatement) throws CompileException {
        boolean bl;
        block4: {
            if (!this.iClassLoader.OBJECT.isAssignableFrom(this.compileGetValue(synchronizedStatement.expression))) {
                this.compileError("Monitor object of \"synchronized\" statement is not a subclass of \"Object\"", synchronizedStatement.getLocation());
            }
            this.codeContext.saveLocalVariables();
            bl = false;
            try {
                synchronizedStatement.monitorLvIndex = this.codeContext.allocateLocalVariable((short)1);
                this.writeOpcode(synchronizedStatement, 89);
                this.store((Java.Located)synchronizedStatement, this.iClassLoader.OBJECT, synchronizedStatement.monitorLvIndex);
                this.writeOpcode(synchronizedStatement, -62);
                CodeContext.Offset offset = this.codeContext.new CodeContext.Offset();
                CodeContext.Offset offset2 = this.codeContext.newOffset();
                bl = this.compile(synchronizedStatement.body);
                if (bl) {
                    this.writeBranch(synchronizedStatement, -89, offset);
                }
                CodeContext.Offset offset3 = this.codeContext.newOffset();
                this.codeContext.addExceptionTableEntry(offset2, offset3, offset3, null);
                this.leave(synchronizedStatement, this.iClassLoader.THROWABLE);
                this.writeOpcode(synchronizedStatement, -65);
                if (!bl) break block4;
                offset.set();
                this.leave(synchronizedStatement, null);
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                this.codeContext.restoreLocalVariables();
                throw throwable;
            }
        }
        Object var4_6 = null;
        this.codeContext.restoreLocalVariables();
        return bl;
    }

    boolean compile2(Java.ThrowStatement throwStatement) throws CompileException {
        IClass iClass = this.compileGetValue(throwStatement.expression);
        this.checkThrownException(throwStatement, iClass, throwStatement.enclosingScope);
        this.writeOpcode(throwStatement, -65);
        return false;
    }

    boolean compile2(Java.TryStatement tryStatement) throws CompileException {
        boolean bl;
        block9: {
            if (tryStatement.optionalFinally != null) {
                tryStatement.finallyOffset = this.codeContext.new CodeContext.Offset();
            }
            CodeContext.Offset offset = this.codeContext.newOffset();
            CodeContext.Offset offset2 = this.codeContext.new CodeContext.Offset();
            this.codeContext.saveLocalVariables();
            tryStatement.stackValueLvIndex = this.codeContext.allocateLocalVariable((short)2);
            this.codeContext.restoreLocalVariables();
            bl = this.compile(tryStatement.body);
            CodeContext.Offset offset3 = this.codeContext.newOffset();
            if (bl) {
                this.writeBranch(tryStatement, -89, offset2);
            }
            this.codeContext.saveLocalVariables();
            try {
                Object object;
                short s = this.codeContext.allocateLocalVariable((short)2);
                int n = 0;
                while (n < tryStatement.catchClauses.size()) {
                    object = (Java.CatchClause)tryStatement.catchClauses.get(n);
                    IClass iClass = this.getType(((Java.CatchClause)object).caughtException.type);
                    this.codeContext.addExceptionTableEntry(offset, offset3, this.codeContext.newOffset(), iClass.getDescriptor());
                    this.store((Java.Located)tryStatement, iClass, s);
                    ((Java.CatchClause)object).body.localVariables.put(((Java.CatchClause)object).caughtException.name, new Java.LocalVariable(false, iClass, s));
                    if (this.compile(((Java.CatchClause)object).body)) {
                        bl = true;
                        if (n < tryStatement.catchClauses.size() - 1 || tryStatement.optionalFinally != null) {
                            this.writeBranch(tryStatement, -89, offset2);
                        }
                    }
                    ++n;
                }
                if (tryStatement.optionalFinally != null) {
                    object = this.codeContext.newOffset();
                    this.codeContext.addExceptionTableEntry(offset, (CodeContext.Offset)object, (CodeContext.Offset)object, null);
                    this.store((Java.Located)tryStatement, this.iClassLoader.OBJECT, s);
                    this.writeBranch(tryStatement, -88, tryStatement.finallyOffset);
                    this.load(tryStatement, this.iClassLoader.OBJECT, s);
                    this.writeOpcode(tryStatement, -65);
                    tryStatement.finallyOffset.set();
                    short s2 = this.codeContext.allocateLocalVariable((short)1);
                    this.store((Java.Located)tryStatement, this.iClassLoader.OBJECT, s2);
                    if (this.compile(tryStatement.optionalFinally)) {
                        this.writeOpcode(tryStatement, -87);
                        this.writeByte(tryStatement, s2);
                    }
                }
                offset2.set();
                if (!bl) break block9;
                this.leave(tryStatement, null);
            }
            catch (Throwable throwable) {
                Object var7_12 = null;
                this.codeContext.restoreLocalVariables();
                throw throwable;
            }
        }
        Object var7_11 = null;
        this.codeContext.restoreLocalVariables();
        return bl;
    }

    boolean compile2(Java.WhileStatement whileStatement) throws CompileException {
        if (Boolean.TRUE.equals(this.getConstantValue(whileStatement.condition))) {
            return this.compileUnconditionalLoop(whileStatement, whileStatement.body, null);
        }
        whileStatement.whereToContinue = this.codeContext.new CodeContext.Offset();
        whileStatement.bodyHasContinue = false;
        this.writeBranch(whileStatement, -89, whileStatement.whereToContinue);
        CodeContext.Offset offset = this.codeContext.newOffset();
        boolean bl = this.compile(whileStatement.body);
        if (bl || whileStatement.bodyHasContinue) {
            whileStatement.whereToContinue.set();
            this.compileBoolean(whileStatement.condition, offset, true);
        }
        if (whileStatement.whereToBreak != null) {
            whileStatement.whereToBreak.set();
        }
        return true;
    }

    private IClass compileArithmeticBinaryOperation(Java.Located located, IClass iClass, String string, Java.Rvalue rvalue) throws CompileException {
        return this.compileArithmeticOperation(located, iClass, Arrays.asList(rvalue).iterator(), string);
    }

    private IClass compileArithmeticOperation(Java.Located located, IClass iClass, Iterator iterator, String string) throws CompileException {
        if (string == "|" || string == "^" || string == "&") {
            int n = string == "&" ? 126 : (string == "|" ? -128 : (string == "^" ? -126 : Integer.MAX_VALUE));
            do {
                Java.Rvalue rvalue = (Java.Rvalue)iterator.next();
                if (iClass == null) {
                    iClass = this.compileGetValue(rvalue);
                    continue;
                }
                CodeContext.Inserter inserter = this.codeContext.newInserter();
                IClass iClass2 = this.compileGetValue(rvalue);
                if (iClass.isPrimitiveNumeric() && iClass2.isPrimitiveNumeric()) {
                    IClass iClass3 = this.binaryNumericPromotion(located, iClass, inserter, iClass2);
                    if (iClass3 == IClass.INT) {
                        this.writeOpcode(located, n);
                    } else if (iClass3 == IClass.LONG) {
                        this.writeOpcode(located, n + 1);
                    } else {
                        this.compileError("Operator \"" + string + "\" not defined on types \"" + iClass + "\" and \"" + iClass2 + "\"", located.getLocation());
                    }
                    iClass = iClass3;
                    continue;
                }
                if (iClass == IClass.BOOLEAN && iClass2 == IClass.BOOLEAN) {
                    this.writeOpcode(located, n);
                    iClass = IClass.BOOLEAN;
                    continue;
                }
                this.compileError("Operator \"" + string + "\" not defined on types \"" + iClass + "\" and \"" + iClass2 + "\"", located.getLocation());
                iClass = IClass.INT;
            } while (iterator.hasNext());
            return iClass;
        }
        if (string == "*" || string == "/" || string == "%" || string == "+" || string == "-") {
            int n = string == "*" ? 104 : (string == "/" ? 108 : (string == "%" ? 112 : (string == "+" ? 96 : (string == "-" ? 100 : Integer.MAX_VALUE))));
            do {
                int n2;
                Object object;
                Object object2;
                Java.Rvalue rvalue = (Java.Rvalue)iterator.next();
                IClass iClass4 = this.getType(rvalue);
                IClassLoader iClassLoader = this.iClassLoader;
                if (string == "+" && (iClass == iClassLoader.STRING || iClass4 == iClassLoader.STRING)) {
                    if (iClass != null) {
                        this.stringConversion(located, iClass);
                    }
                    do {
                        if ((object2 = this.getConstantValue(rvalue)) == null) {
                            this.stringConversion(located, this.compileGetValue(rvalue));
                            rvalue = iterator.hasNext() ? (Java.Rvalue)iterator.next() : null;
                        } else {
                            if (iterator.hasNext()) {
                                rvalue = (Java.Rvalue)iterator.next();
                                object = this.getConstantValue(rvalue);
                                if (object != null) {
                                    StringBuffer stringBuffer = new StringBuffer(object2.toString()).append(object);
                                    while (true) {
                                        if (!iterator.hasNext()) {
                                            rvalue = null;
                                            break;
                                        }
                                        rvalue = (Java.Rvalue)iterator.next();
                                        Object object3 = this.getConstantValue(rvalue);
                                        if (object3 == null) break;
                                        stringBuffer.append(object3);
                                    }
                                    object2 = stringBuffer.toString();
                                }
                            } else {
                                rvalue = null;
                            }
                            this.pushConstant(located, object2.toString());
                        }
                        if (iClass != null) {
                            this.writeOpcode(located, -74);
                            this.writeConstantMethodrefInfo(located, "Ljava/lang/String;", "concat", "(Ljava/lang/String;)Ljava/lang/String;");
                        }
                        iClass = this.iClassLoader.STRING;
                    } while (rvalue != null);
                    return iClass;
                }
                if (iClass == null) {
                    iClass = this.compileGetValue(rvalue);
                    continue;
                }
                object2 = this.codeContext.newInserter();
                if ((iClass = this.binaryNumericPromotion(located, iClass, (CodeContext.Inserter)object2, (IClass)(object = this.compileGetValue(rvalue)))) == IClass.INT) {
                    n2 = n;
                } else if (iClass == IClass.LONG) {
                    n2 = n + 1;
                } else if (iClass == IClass.FLOAT) {
                    n2 = n + 2;
                } else if (iClass == IClass.DOUBLE) {
                    n2 = n + 3;
                } else {
                    this.compileError("Unexpected promoted type \"" + iClass + "\"", located.getLocation());
                    n2 = n;
                }
                this.writeOpcode(located, n2);
            } while (iterator.hasNext());
            return iClass;
        }
        if (string == "<<" || string == ">>" || string == ">>>") {
            int n = string == "<<" ? 120 : (string == ">>" ? 122 : (string == ">>>" ? 124 : Integer.MAX_VALUE));
            do {
                IClass iClass5;
                IClass iClass6;
                Java.Rvalue rvalue = (Java.Rvalue)iterator.next();
                if (iClass == null) {
                    iClass = this.compileGetValue(rvalue);
                    continue;
                }
                CodeContext.Inserter inserter = this.codeContext.newInserter();
                IClass iClass7 = this.compileGetValue(rvalue);
                this.codeContext.pushInserter(inserter);
                try {
                    iClass6 = this.unaryNumericPromotion(located, iClass);
                }
                finally {
                    Object var11_25 = null;
                    this.codeContext.popInserter();
                }
                if (iClass6 != IClass.INT && iClass6 != IClass.LONG) {
                    this.compileError("Shift operation not allowed on operand type \"" + iClass + "\"", located.getLocation());
                }
                if ((iClass5 = this.unaryNumericPromotion(located, iClass7)) != IClass.INT && iClass5 != IClass.LONG) {
                    this.compileError("Shift distance of type \"" + iClass7 + "\" is not allowed", located.getLocation());
                }
                if (iClass5 == IClass.LONG) {
                    this.writeOpcode(located, -120);
                }
                this.writeOpcode(located, iClass6 == IClass.LONG ? n + 1 : n);
                iClass = iClass6;
            } while (iterator.hasNext());
            return iClass;
        }
        throw new RuntimeException("Unexpected operator \"" + string + "\"");
    }

    private void compileBoolean(Java.Rvalue rvalue, final CodeContext.Offset offset, final boolean bl) throws CompileException {
        Visitor.RvalueVisitor rvalueVisitor = new Visitor.RvalueVisitor(){

            public void visitAmbiguousName(Java.AmbiguousName ambiguousName) {
                try {
                    this.compileBoolean2(ambiguousName, offset, bl);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitArrayAccessExpression(Java.ArrayAccessExpression arrayAccessExpression) {
                try {
                    this.compileBoolean2(arrayAccessExpression, offset, bl);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitArrayInitializer(Java.ArrayInitializer arrayInitializer) {
                try {
                    this.compileBoolean2(arrayInitializer, offset, bl);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitArrayLength(Java.ArrayLength arrayLength) {
                try {
                    this.compileBoolean2(arrayLength, offset, bl);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitAssignment(Java.Assignment assignment) {
                try {
                    this.compileBoolean2(assignment, offset, bl);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitBinaryOperation(Java.BinaryOperation binaryOperation) {
                try {
                    this.compileBoolean2(binaryOperation, offset, bl);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitCast(Java.Cast cast) {
                try {
                    this.compileBoolean2(cast, offset, bl);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitClassLiteral(Java.ClassLiteral classLiteral) {
                try {
                    this.compileBoolean2(classLiteral, offset, bl);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitConditionalExpression(Java.ConditionalExpression conditionalExpression) {
                try {
                    this.compileBoolean2(conditionalExpression, offset, bl);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitConstantValue(Java.ConstantValue constantValue) {
                try {
                    this.compileBoolean2(constantValue, offset, bl);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitCrement(Java.Crement crement) {
                try {
                    this.compileBoolean2(crement, offset, bl);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitFieldAccess(Java.FieldAccess fieldAccess) {
                try {
                    this.compileBoolean2(fieldAccess, offset, bl);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitFieldAccessExpression(Java.FieldAccessExpression fieldAccessExpression) {
                try {
                    this.compileBoolean2(fieldAccessExpression, offset, bl);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitInstanceof(Java.Instanceof instanceof_) {
                try {
                    this.compileBoolean2(instanceof_, offset, bl);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitLiteral(Java.Literal literal) {
                try {
                    this.compileBoolean2(literal, offset, bl);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitLocalVariableAccess(Java.LocalVariableAccess localVariableAccess) {
                try {
                    this.compileBoolean2(localVariableAccess, offset, bl);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitMethodInvocation(Java.MethodInvocation methodInvocation) {
                try {
                    this.compileBoolean2(methodInvocation, offset, bl);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitNewAnonymousClassInstance(Java.NewAnonymousClassInstance newAnonymousClassInstance) {
                try {
                    this.compileBoolean2(newAnonymousClassInstance, offset, bl);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitNewArray(Java.NewArray newArray) {
                try {
                    this.compileBoolean2(newArray, offset, bl);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitNewClassInstance(Java.NewClassInstance newClassInstance) {
                try {
                    this.compileBoolean2(newClassInstance, offset, bl);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitParameterAccess(Java.ParameterAccess parameterAccess) {
                try {
                    this.compileBoolean2(parameterAccess, offset, bl);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitParenthesizedExpression(Java.ParenthesizedExpression parenthesizedExpression) {
                try {
                    this.compileBoolean2(parenthesizedExpression, offset, bl);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitQualifiedThisReference(Java.QualifiedThisReference qualifiedThisReference) {
                try {
                    this.compileBoolean2(qualifiedThisReference, offset, bl);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitSuperclassMethodInvocation(Java.SuperclassMethodInvocation superclassMethodInvocation) {
                try {
                    this.compileBoolean2(superclassMethodInvocation, offset, bl);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitThisReference(Java.ThisReference thisReference) {
                try {
                    this.compileBoolean2(thisReference, offset, bl);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitUnaryOperation(Java.UnaryOperation unaryOperation) {
                try {
                    this.compileBoolean2(unaryOperation, offset, bl);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }
        };
        try {
            rvalue.accept(rvalueVisitor);
        }
        catch (TunnelException tunnelException) {
            throw (CompileException)tunnelException.getDelegate();
        }
    }

    void compileBoolean2(Java.BinaryOperation binaryOperation, CodeContext.Offset offset, boolean bl) throws CompileException {
        if (binaryOperation.op == "|" || binaryOperation.op == "^" || binaryOperation.op == "&") {
            this.compileBoolean2((Java.Rvalue)binaryOperation, offset, bl);
            return;
        }
        if (binaryOperation.op == "||" || binaryOperation.op == "&&") {
            Object object = this.getConstantValue(binaryOperation.lhs);
            if (object instanceof Boolean) {
                if ((Boolean)object ^ binaryOperation.op == "||") {
                    this.compileBoolean(binaryOperation.rhs, offset, !bl ^ true);
                } else {
                    this.compileBoolean(binaryOperation.lhs, offset, !bl ^ true);
                    this.fakeCompile(binaryOperation.rhs);
                }
                return;
            }
            Object object2 = this.getConstantValue(binaryOperation.rhs);
            if (object2 instanceof Boolean) {
                if ((Boolean)object2 ^ binaryOperation.op == "||") {
                    this.compileBoolean(binaryOperation.lhs, offset, !bl ^ true);
                } else {
                    this.pop(binaryOperation.lhs, this.compileGetValue(binaryOperation.lhs));
                    this.compileBoolean(binaryOperation.rhs, offset, !bl ^ true);
                }
                return;
            }
            if (binaryOperation.op == "||" ^ !bl) {
                this.compileBoolean(binaryOperation.lhs, offset, !bl ^ true);
                this.compileBoolean(binaryOperation.rhs, offset, !bl ^ true);
            } else {
                CodeContext.Offset offset2 = this.codeContext.new CodeContext.Offset();
                this.compileBoolean(binaryOperation.lhs, offset2, !bl);
                this.compileBoolean(binaryOperation.rhs, offset, !bl ^ true);
                offset2.set();
            }
            return;
        }
        if (binaryOperation.op == "==" || binaryOperation.op == "!=" || binaryOperation.op == "<=" || binaryOperation.op == ">=" || binaryOperation.op == "<" || binaryOperation.op == ">") {
            boolean bl2;
            int n;
            int n2 = binaryOperation.op == "==" ? 0 : (binaryOperation.op == "!=" ? 1 : (binaryOperation.op == "<" ? 2 : (binaryOperation.op == ">=" ? 3 : (binaryOperation.op == ">" ? 4 : (n = binaryOperation.op == "<=" ? 5 : Integer.MIN_VALUE)))));
            if (!bl) {
                n ^= 1;
            }
            boolean bl3 = this.getConstantValue(binaryOperation.lhs) == Java.Rvalue.CONSTANT_VALUE_NULL;
            boolean bl4 = bl2 = this.getConstantValue(binaryOperation.rhs) == Java.Rvalue.CONSTANT_VALUE_NULL;
            if (bl3 || bl2) {
                IClass iClass;
                if (binaryOperation.op != "==" && binaryOperation.op != "!=") {
                    this.compileError("Operator \"" + binaryOperation.op + "\" not allowed on operand \"null\"", binaryOperation.getLocation());
                }
                if ((iClass = this.compileGetValue(bl3 ? binaryOperation.rhs : binaryOperation.lhs)).isPrimitive()) {
                    this.compileError("Cannot compare \"null\" with primitive type \"" + iClass.toString() + "\"", binaryOperation.getLocation());
                }
                this.writeBranch(binaryOperation, -58 + n, offset);
                return;
            }
            IClass iClass = this.compileGetValue(binaryOperation.lhs);
            CodeContext.Inserter inserter = this.codeContext.newInserter();
            IClass iClass2 = this.compileGetValue(binaryOperation.rhs);
            if (iClass.isPrimitiveNumeric() && iClass2.isPrimitiveNumeric()) {
                IClass iClass3 = this.binaryNumericPromotion(binaryOperation, iClass, inserter, iClass2);
                if (iClass3 == IClass.INT) {
                    this.writeBranch(binaryOperation, -97 + n, offset);
                } else if (iClass3 == IClass.LONG) {
                    this.writeOpcode(binaryOperation, -108);
                    this.writeBranch(binaryOperation, -103 + n, offset);
                } else if (iClass3 == IClass.FLOAT) {
                    this.writeOpcode(binaryOperation, -106);
                    this.writeBranch(binaryOperation, -103 + n, offset);
                } else if (iClass3 == IClass.DOUBLE) {
                    this.writeOpcode(binaryOperation, -104);
                    this.writeBranch(binaryOperation, -103 + n, offset);
                } else {
                    throw new RuntimeException("Unexpected promoted type \"" + iClass3 + "\"");
                }
                return;
            }
            if (iClass == IClass.BOOLEAN && iClass2 == IClass.BOOLEAN) {
                if (binaryOperation.op != "==" && binaryOperation.op != "!=") {
                    this.compileError("Operator \"" + binaryOperation.op + "\" not allowed on boolean operands", binaryOperation.getLocation());
                }
                this.writeBranch(binaryOperation, -97 + n, offset);
                return;
            }
            if (!iClass.isPrimitive() && !iClass2.isPrimitive()) {
                if (binaryOperation.op != "==" && binaryOperation.op != "!=") {
                    this.compileError("Operator \"" + binaryOperation.op + "\" not allowed on reference operands", binaryOperation.getLocation());
                }
                this.writeBranch(binaryOperation, -91 + n, offset);
                return;
            }
            this.compileError("Cannot compare types \"" + iClass + "\" and \"" + iClass2 + "\"", binaryOperation.getLocation());
        }
        this.compileError("Boolean expression expected", binaryOperation.getLocation());
    }

    void compileBoolean2(Java.ParenthesizedExpression parenthesizedExpression, CodeContext.Offset offset, boolean bl) throws CompileException {
        this.compileBoolean(parenthesizedExpression.value, offset, bl);
    }

    void compileBoolean2(Java.Rvalue rvalue, CodeContext.Offset offset, boolean bl) throws CompileException {
        if (this.compileGetValue(rvalue) != IClass.BOOLEAN) {
            this.compileError("Not a boolean expression", rvalue.getLocation());
        }
        this.writeBranch(rvalue, bl ? -102 : -103, offset);
    }

    void compileBoolean2(Java.UnaryOperation unaryOperation, CodeContext.Offset offset, boolean bl) throws CompileException {
        if (unaryOperation.operator == "!") {
            this.compileBoolean(unaryOperation.operand, offset, bl ^ true);
            return;
        }
        this.compileError("Boolean expression expected", unaryOperation.getLocation());
    }

    private int compileContext(Java.Rvalue rvalue) throws CompileException {
        final int[] nArray = new int[1];
        Visitor.RvalueVisitor rvalueVisitor = new Visitor.RvalueVisitor(){

            public void visitAmbiguousName(Java.AmbiguousName ambiguousName) {
                try {
                    nArray[0] = this.compileContext2(ambiguousName);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitArrayAccessExpression(Java.ArrayAccessExpression arrayAccessExpression) {
                try {
                    nArray[0] = this.compileContext2(arrayAccessExpression);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitArrayInitializer(Java.ArrayInitializer arrayInitializer) {
                nArray[0] = this.compileContext2(arrayInitializer);
            }

            public void visitArrayLength(Java.ArrayLength arrayLength) {
                try {
                    nArray[0] = this.compileContext2(arrayLength);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitAssignment(Java.Assignment assignment) {
                nArray[0] = this.compileContext2(assignment);
            }

            public void visitBinaryOperation(Java.BinaryOperation binaryOperation) {
                nArray[0] = this.compileContext2(binaryOperation);
            }

            public void visitCast(Java.Cast cast) {
                nArray[0] = this.compileContext2(cast);
            }

            public void visitClassLiteral(Java.ClassLiteral classLiteral) {
                nArray[0] = this.compileContext2(classLiteral);
            }

            public void visitConditionalExpression(Java.ConditionalExpression conditionalExpression) {
                nArray[0] = this.compileContext2(conditionalExpression);
            }

            public void visitConstantValue(Java.ConstantValue constantValue) {
                nArray[0] = this.compileContext2(constantValue);
            }

            public void visitCrement(Java.Crement crement) {
                nArray[0] = this.compileContext2(crement);
            }

            public void visitFieldAccess(Java.FieldAccess fieldAccess) {
                try {
                    nArray[0] = this.compileContext2(fieldAccess);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitFieldAccessExpression(Java.FieldAccessExpression fieldAccessExpression) {
                try {
                    nArray[0] = this.compileContext2(fieldAccessExpression);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitInstanceof(Java.Instanceof instanceof_) {
                nArray[0] = this.compileContext2(instanceof_);
            }

            public void visitLiteral(Java.Literal literal) {
                nArray[0] = this.compileContext2(literal);
            }

            public void visitLocalVariableAccess(Java.LocalVariableAccess localVariableAccess) {
                nArray[0] = this.compileContext2(localVariableAccess);
            }

            public void visitMethodInvocation(Java.MethodInvocation methodInvocation) {
                nArray[0] = this.compileContext2(methodInvocation);
            }

            public void visitNewAnonymousClassInstance(Java.NewAnonymousClassInstance newAnonymousClassInstance) {
                nArray[0] = this.compileContext2(newAnonymousClassInstance);
            }

            public void visitNewArray(Java.NewArray newArray) {
                nArray[0] = this.compileContext2(newArray);
            }

            public void visitNewClassInstance(Java.NewClassInstance newClassInstance) {
                nArray[0] = this.compileContext2(newClassInstance);
            }

            public void visitParameterAccess(Java.ParameterAccess parameterAccess) {
                nArray[0] = this.compileContext2(parameterAccess);
            }

            public void visitParenthesizedExpression(Java.ParenthesizedExpression parenthesizedExpression) {
                try {
                    nArray[0] = this.compileContext2(parenthesizedExpression);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitQualifiedThisReference(Java.QualifiedThisReference qualifiedThisReference) {
                nArray[0] = this.compileContext2(qualifiedThisReference);
            }

            public void visitSuperclassMethodInvocation(Java.SuperclassMethodInvocation superclassMethodInvocation) {
                nArray[0] = this.compileContext2(superclassMethodInvocation);
            }

            public void visitThisReference(Java.ThisReference thisReference) {
                nArray[0] = this.compileContext2(thisReference);
            }

            public void visitUnaryOperation(Java.UnaryOperation unaryOperation) {
                nArray[0] = this.compileContext2(unaryOperation);
            }
        };
        try {
            rvalue.accept(rvalueVisitor);
            return nArray[0];
        }
        catch (TunnelException tunnelException) {
            throw (CompileException)tunnelException.getDelegate();
        }
    }

    int compileContext2(Java.AmbiguousName ambiguousName) throws CompileException {
        return this.compileContext(this.toRvalueOrCE(this.reclassify(ambiguousName)));
    }

    int compileContext2(Java.ArrayAccessExpression arrayAccessExpression) throws CompileException {
        IClass iClass;
        IClass iClass2 = this.compileGetValue(arrayAccessExpression.lhs);
        if (!iClass2.isArray()) {
            this.compileError("Subscript not allowed on non-array type \"" + iClass2.toString() + "\"", arrayAccessExpression.getLocation());
        }
        if (!this.tryIdentityConversion(iClass = this.compileGetValue(arrayAccessExpression.index), IClass.INT) && !this.tryWideningPrimitiveConversion(arrayAccessExpression, iClass, IClass.INT)) {
            this.compileError("Index expression of type \"" + iClass + "\" cannot be widened to \"int\"", arrayAccessExpression.getLocation());
        }
        return 2;
    }

    int compileContext2(Java.ArrayLength arrayLength) throws CompileException {
        if (!this.compileGetValue(arrayLength.lhs).isArray()) {
            this.compileError("Cannot determine length of non-array type", arrayLength.getLocation());
        }
        return 1;
    }

    int compileContext2(Java.FieldAccess fieldAccess) throws CompileException {
        if (fieldAccess.field.isStatic()) {
            this.getType(this.toTypeOrCE(fieldAccess.lhs));
            return 0;
        }
        this.compileGetValue(this.toRvalueOrCE(fieldAccess.lhs));
        return 1;
    }

    int compileContext2(Java.FieldAccessExpression fieldAccessExpression) throws CompileException {
        this.determineValue(fieldAccessExpression);
        return this.compileContext(fieldAccessExpression.value);
    }

    int compileContext2(Java.ParenthesizedExpression parenthesizedExpression) throws CompileException {
        return this.compileContext(parenthesizedExpression.value);
    }

    int compileContext2(Java.Rvalue rvalue) {
        return 0;
    }

    private void compileError(String string) throws CompileException {
        this.compileError(string, null);
    }

    void compileError(String string, Location location) throws CompileException {
        ErrorHandler errorHandler = this.compileErrorHandler;
        if (errorHandler == null) {
            throw new CompileException(string, location);
        }
        errorHandler.handleError(string, location);
    }

    private IClass compileGet(Java.Rvalue rvalue) throws CompileException {
        final IClass[] iClassArray = new IClass[1];
        Visitor.RvalueVisitor rvalueVisitor = new Visitor.RvalueVisitor(){

            public void visitAmbiguousName(Java.AmbiguousName ambiguousName) {
                try {
                    iClassArray[0] = this.compileGet2(ambiguousName);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitArrayAccessExpression(Java.ArrayAccessExpression arrayAccessExpression) {
                try {
                    iClassArray[0] = this.compileGet2(arrayAccessExpression);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitArrayInitializer(Java.ArrayInitializer arrayInitializer) {
                try {
                    iClassArray[0] = this.compileGet2(arrayInitializer);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitArrayLength(Java.ArrayLength arrayLength) {
                iClassArray[0] = this.compileGet2(arrayLength);
            }

            public void visitAssignment(Java.Assignment assignment) {
                try {
                    iClassArray[0] = this.compileGet2(assignment);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitBinaryOperation(Java.BinaryOperation binaryOperation) {
                try {
                    iClassArray[0] = this.compileGet2(binaryOperation);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitCast(Java.Cast cast) {
                try {
                    iClassArray[0] = this.compileGet2(cast);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitClassLiteral(Java.ClassLiteral classLiteral) {
                try {
                    iClassArray[0] = this.compileGet2(classLiteral);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitConditionalExpression(Java.ConditionalExpression conditionalExpression) {
                try {
                    iClassArray[0] = this.compileGet2(conditionalExpression);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitConstantValue(Java.ConstantValue constantValue) {
                iClassArray[0] = this.compileGet2(constantValue);
            }

            public void visitCrement(Java.Crement crement) {
                try {
                    iClassArray[0] = this.compileGet2(crement);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitFieldAccess(Java.FieldAccess fieldAccess) {
                try {
                    iClassArray[0] = this.compileGet2(fieldAccess);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitFieldAccessExpression(Java.FieldAccessExpression fieldAccessExpression) {
                try {
                    iClassArray[0] = this.compileGet2(fieldAccessExpression);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitInstanceof(Java.Instanceof instanceof_) {
                try {
                    iClassArray[0] = this.compileGet2(instanceof_);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitLiteral(Java.Literal literal) {
                try {
                    iClassArray[0] = this.compileGet2(literal);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitLocalVariableAccess(Java.LocalVariableAccess localVariableAccess) {
                iClassArray[0] = this.compileGet2(localVariableAccess);
            }

            public void visitMethodInvocation(Java.MethodInvocation methodInvocation) {
                try {
                    iClassArray[0] = this.compileGet2(methodInvocation);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitNewAnonymousClassInstance(Java.NewAnonymousClassInstance newAnonymousClassInstance) {
                try {
                    iClassArray[0] = this.compileGet2(newAnonymousClassInstance);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitNewArray(Java.NewArray newArray) {
                try {
                    iClassArray[0] = this.compileGet2(newArray);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitNewClassInstance(Java.NewClassInstance newClassInstance) {
                try {
                    iClassArray[0] = this.compileGet2(newClassInstance);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitParameterAccess(Java.ParameterAccess parameterAccess) {
                iClassArray[0] = this.compileGet2(parameterAccess);
            }

            public void visitParenthesizedExpression(Java.ParenthesizedExpression parenthesizedExpression) {
                try {
                    iClassArray[0] = this.compileGet2(parenthesizedExpression);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitQualifiedThisReference(Java.QualifiedThisReference qualifiedThisReference) {
                try {
                    iClassArray[0] = this.compileGet2(qualifiedThisReference);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitSuperclassMethodInvocation(Java.SuperclassMethodInvocation superclassMethodInvocation) {
                try {
                    iClassArray[0] = this.compileGet2(superclassMethodInvocation);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitThisReference(Java.ThisReference thisReference) {
                try {
                    iClassArray[0] = this.compileGet2(thisReference);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitUnaryOperation(Java.UnaryOperation unaryOperation) {
                try {
                    iClassArray[0] = this.compileGet2(unaryOperation);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }
        };
        try {
            rvalue.accept(rvalueVisitor);
            return iClassArray[0];
        }
        catch (TunnelException tunnelException) {
            throw (CompileException)tunnelException.getDelegate();
        }
    }

    IClass compileGet2(Java.AmbiguousName ambiguousName) throws CompileException {
        return this.compileGet(this.toRvalueOrCE(this.reclassify(ambiguousName)));
    }

    IClass compileGet2(Java.ArrayAccessExpression arrayAccessExpression) throws CompileException {
        IClass iClass = this.getType(arrayAccessExpression);
        this.writeOpcode(arrayAccessExpression, 46 + UnitCompiler.ilfdabcs(iClass));
        return iClass;
    }

    IClass compileGet2(Java.ArrayInitializer arrayInitializer) throws CompileException {
        IClass iClass = this.getType(arrayInitializer.arrayType);
        IClass iClass2 = iClass.getComponentType();
        this.pushConstant(arrayInitializer, new Integer(arrayInitializer.values.length));
        this.newArray(arrayInitializer, 1, 0, iClass2);
        int n = 0;
        while (n < arrayInitializer.values.length) {
            Java.Rvalue rvalue = arrayInitializer.values[n];
            this.writeOpcode(arrayInitializer, 89);
            this.pushConstant(arrayInitializer, new Integer(n));
            IClass iClass3 = this.compileGetValue(rvalue);
            this.assignmentConversion(arrayInitializer, iClass3, iClass2, this.getConstantValue(rvalue));
            this.writeOpcode(arrayInitializer, 79 + UnitCompiler.ilfdabcs(iClass2));
            ++n;
        }
        return iClass;
    }

    IClass compileGet2(Java.ArrayLength arrayLength) {
        this.writeOpcode(arrayLength, -66);
        return IClass.INT;
    }

    IClass compileGet2(Java.Assignment assignment) throws CompileException {
        if (assignment.operator == "=") {
            int n = this.compileContext(assignment.lhs);
            IClass iClass = this.compileGetValue(assignment.rhs);
            IClass iClass2 = this.getType(assignment.lhs);
            Object object = this.getConstantValue(assignment.rhs);
            this.assignmentConversion(assignment, iClass, iClass2, object);
            this.dupx(assignment, iClass2, n);
            this.compileSet(assignment.lhs);
            return iClass2;
        }
        int n = this.compileContext(assignment.lhs);
        this.dup(assignment, n);
        IClass iClass = this.compileGet(assignment.lhs);
        IClass iClass3 = this.compileArithmeticBinaryOperation(assignment, iClass, assignment.operator.substring(0, assignment.operator.length() - 1).intern(), assignment.rhs);
        if (!this.tryIdentityConversion(iClass3, iClass) && !this.tryNarrowingPrimitiveConversion(assignment, iClass3, iClass)) {
            throw new RuntimeException();
        }
        this.dupx(assignment, iClass, n);
        this.compileSet(assignment.lhs);
        return iClass;
    }

    IClass compileGet2(Java.BinaryOperation binaryOperation) throws CompileException {
        if (binaryOperation.op == "||" || binaryOperation.op == "&&" || binaryOperation.op == "==" || binaryOperation.op == "!=" || binaryOperation.op == "<" || binaryOperation.op == ">" || binaryOperation.op == "<=" || binaryOperation.op == ">=") {
            return this.compileGet2((Java.BooleanRvalue)binaryOperation);
        }
        return this.compileArithmeticOperation(binaryOperation, null, binaryOperation.unrollLeftAssociation(), binaryOperation.op);
    }

    IClass compileGet2(Java.BooleanRvalue booleanRvalue) throws CompileException {
        CodeContext.Offset offset = this.codeContext.new CodeContext.Offset();
        this.compileBoolean(booleanRvalue, offset, true);
        this.writeOpcode(booleanRvalue, 3);
        CodeContext.Offset offset2 = this.codeContext.new CodeContext.Offset();
        this.writeBranch(booleanRvalue, -89, offset2);
        offset.set();
        this.writeOpcode(booleanRvalue, 4);
        offset2.set();
        return IClass.BOOLEAN;
    }

    IClass compileGet2(Java.Cast cast) throws CompileException {
        IClass iClass = this.getType(cast.targetType);
        IClass iClass2 = this.compileGetValue(cast.value);
        if (!(this.tryIdentityConversion(iClass2, iClass) || this.tryWideningPrimitiveConversion(cast, iClass2, iClass) || this.tryNarrowingPrimitiveConversion(cast, iClass2, iClass) || this.isWideningReferenceConvertible(iClass2, iClass) || this.tryNarrowingReferenceConversion(cast, iClass2, iClass))) {
            this.compileError("Cannot cast \"" + iClass2 + "\" to \"" + iClass + "\"", cast.getLocation());
        }
        return iClass;
    }

    IClass compileGet2(Java.ClassLiteral classLiteral) throws CompileException {
        Java.Located located;
        Java.Locatable locatable;
        Object object;
        Location location = classLiteral.getLocation();
        IClassLoader iClassLoader = this.iClassLoader;
        IClass iClass = this.getType(classLiteral.type);
        if (iClass.isPrimitive()) {
            String string;
            this.writeOpcode(classLiteral, -78);
            String string2 = iClass == IClass.VOID ? "Ljava/lang/Void;" : (iClass == IClass.BYTE ? "Ljava/lang/Byte;" : (iClass == IClass.CHAR ? "Ljava/lang/Character;" : (iClass == IClass.DOUBLE ? "Ljava/lang/Double;" : (iClass == IClass.FLOAT ? "Ljava/lang/Float;" : (iClass == IClass.INT ? "Ljava/lang/Integer;" : (iClass == IClass.LONG ? "Ljava/lang/Long;" : (iClass == IClass.SHORT ? "Ljava/lang/Short;" : (string = iClass == IClass.BOOLEAN ? "Ljava/lang/Boolean;" : null))))))));
            if (string == null) {
                throw new RuntimeException();
            }
            this.writeConstantFieldrefInfo(classLiteral, string, "TYPE", "Ljava/lang/Class;");
            return iClassLoader.CLASS;
        }
        boolean bl = false;
        Iterator iterator = classLiteral.declaringType.declaredMethods.iterator();
        while (iterator.hasNext()) {
            object = (Java.MethodDeclarator)iterator.next();
            if (!((Java.FunctionDeclarator)object).name.equals("class$")) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.declareClassDollarMethod(classLiteral);
        }
        if (classLiteral.declaringType instanceof Java.ClassDeclaration) {
            object = ((Java.ClassDeclaration)classLiteral.declaringType).variableDeclaratorsAndInitializers;
        } else if (classLiteral.declaringType instanceof Java.InterfaceDeclaration) {
            object = ((Java.InterfaceDeclaration)classLiteral.declaringType).constantDeclarations;
        } else {
            throw new RuntimeException();
        }
        String string = Descriptor.toClassName(iClass.getDescriptor());
        String string3 = "class$" + string.replace('.', '$');
        boolean bl2 = false;
        Iterator iterator2 = object.iterator();
        block1: while (iterator2.hasNext()) {
            locatable = (Java.TypeBodyDeclaration)iterator2.next();
            if (!locatable.isStatic() || !(locatable instanceof Java.FieldDeclaration)) continue;
            located = (Java.FieldDeclaration)locatable;
            IClass.IField[] iFieldArray = this.getIFields((Java.FieldDeclaration)located);
            int n = 0;
            while (n < iFieldArray.length) {
                if (iFieldArray[n].getName().equals(string3)) {
                    bl2 = true;
                    break block1;
                }
                ++n;
            }
        }
        if (!bl2) {
            locatable = new Java.SimpleType(location, iClassLoader.CLASS);
            located = new Java.FieldDeclaration(location, classLiteral.declaringType, null, 8, (Java.Type)locatable);
            located.setVariableDeclarators(new Java.VariableDeclarator[]{new Java.VariableDeclarator(location, string3, 0, null)});
            if (classLiteral.declaringType instanceof Java.ClassDeclaration) {
                ((Java.ClassDeclaration)classLiteral.declaringType).addVariableDeclaratorOrInitializer((Java.TypeBodyDeclaration)((Object)located));
            } else if (classLiteral.declaringType instanceof Java.InterfaceDeclaration) {
                ((Java.InterfaceDeclaration)classLiteral.declaringType).addConstantDeclaration((Java.FieldDeclaration)located);
            } else {
                throw new RuntimeException();
            }
        }
        locatable = new Java.SimpleType(location, this.resolve(classLiteral.declaringType));
        located = new Java.FieldAccessExpression(location, classLiteral.enclosingBlockStatement, (Java.Atom)locatable, string3);
        return this.compileGet(new Java.ConditionalExpression(location, new Java.BinaryOperation(location, (Java.Rvalue)located, "!=", new Java.ConstantValue(location, null)), (Java.Rvalue)located, new Java.Assignment(location, (Java.Lvalue)located, "=", new Java.MethodInvocation(location, classLiteral.enclosingBlockStatement, (Java.Atom)locatable, "class$", new Java.Rvalue[]{new Java.ConstantValue(location, string)}))));
    }

    /*
     * Enabled aggressive block sorting
     */
    IClass compileGet2(Java.ConditionalExpression conditionalExpression) throws CompileException {
        Object object;
        IClass iClass;
        CodeContext.Inserter inserter;
        IClass iClass2;
        CodeContext.Offset offset = this.codeContext.new CodeContext.Offset();
        Object object2 = this.getConstantValue(conditionalExpression.lhs);
        if (object2 instanceof Boolean) {
            if (((Boolean)object2).booleanValue()) {
                iClass2 = this.compileGetValue(conditionalExpression.mhs);
                inserter = this.codeContext.newInserter();
                iClass = this.getType(conditionalExpression.rhs);
            } else {
                iClass2 = this.getType(conditionalExpression.mhs);
                inserter = null;
                iClass = this.compileGetValue(conditionalExpression.rhs);
            }
        } else {
            object = this.codeContext.new CodeContext.Offset();
            this.compileBoolean(conditionalExpression.lhs, (CodeContext.Offset)object, false);
            iClass2 = this.compileGetValue(conditionalExpression.mhs);
            inserter = this.codeContext.newInserter();
            this.writeBranch(conditionalExpression, -89, offset);
            ((CodeContext.Offset)object).set();
            iClass = this.compileGetValue(conditionalExpression.rhs);
        }
        if (iClass2 == iClass) {
            object = iClass2;
        } else if (iClass2.isPrimitiveNumeric() && iClass.isPrimitiveNumeric()) {
            object = this.binaryNumericPromotion(conditionalExpression, iClass2, inserter, iClass);
        } else if (this.getConstantValue(conditionalExpression.mhs) == Java.Rvalue.CONSTANT_VALUE_NULL && !iClass.isPrimitive()) {
            object = iClass;
        } else if (!iClass2.isPrimitive() && this.getConstantValue(conditionalExpression.rhs) == Java.Rvalue.CONSTANT_VALUE_NULL) {
            object = iClass2;
        } else if (!iClass2.isPrimitive() && !iClass.isPrimitive()) {
            if (iClass2.isAssignableFrom(iClass)) {
                object = iClass2;
            } else {
                if (!iClass.isAssignableFrom(iClass2)) {
                    this.compileError("Reference types \"" + iClass2 + "\" and \"" + iClass + "\" don't match", conditionalExpression.getLocation());
                    return this.iClassLoader.OBJECT;
                }
                object = iClass;
            }
        } else {
            this.compileError("Incompatible expression types \"" + iClass2 + "\" and \"" + iClass + "\"", conditionalExpression.getLocation());
            return this.iClassLoader.OBJECT;
        }
        offset.set();
        return object;
    }

    IClass compileGet2(Java.ConstantValue constantValue) {
        return this.pushConstant(constantValue, constantValue.constantValue);
    }

    IClass compileGet2(Java.Crement crement) throws CompileException {
        Java.LocalVariable localVariable = this.isIntLV(crement);
        if (localVariable != null) {
            if (!crement.pre) {
                this.load(crement, localVariable);
            }
            this.writeOpcode(crement, -124);
            this.writeByte(crement, localVariable.localVariableArrayIndex);
            this.writeByte(crement, crement.operator == "++" ? 1 : -1);
            if (crement.pre) {
                this.load(crement, localVariable);
            }
            return localVariable.type;
        }
        int n = this.compileContext(crement.operand);
        this.dup(crement, n);
        IClass iClass = this.compileGet(crement.operand);
        if (!crement.pre) {
            this.dupx(crement, iClass, n);
        }
        IClass iClass2 = this.unaryNumericPromotion(crement, iClass);
        this.writeOpcode(crement, UnitCompiler.ilfd(iClass2, 4, 10, 12, 15));
        if (crement.operator == "++") {
            this.writeOpcode(crement, 96 + UnitCompiler.ilfd(iClass2));
        } else if (crement.operator == "--") {
            this.writeOpcode(crement, 100 + UnitCompiler.ilfd(iClass2));
        } else {
            this.compileError("Unexpected operator \"" + crement.operator + "\"", crement.getLocation());
        }
        if (!this.tryIdentityConversion(iClass2, iClass) && !this.tryNarrowingPrimitiveConversion(crement, iClass2, iClass)) {
            throw new RuntimeException();
        }
        if (crement.pre) {
            this.dupx(crement, iClass, n);
        }
        this.compileSet(crement.operand);
        return iClass;
    }

    IClass compileGet2(Java.FieldAccess fieldAccess) throws CompileException {
        this.checkAccessible(fieldAccess.field, fieldAccess.enclosingBlockStatement);
        if (fieldAccess.field.isStatic()) {
            this.writeOpcode(fieldAccess, -78);
        } else {
            this.writeOpcode(fieldAccess, -76);
        }
        this.writeConstantFieldrefInfo(fieldAccess, fieldAccess.field.getDeclaringIClass().getDescriptor(), fieldAccess.field.getName(), fieldAccess.field.getType().getDescriptor());
        return fieldAccess.field.getType();
    }

    IClass compileGet2(Java.FieldAccessExpression fieldAccessExpression) throws CompileException {
        this.determineValue(fieldAccessExpression);
        return this.compileGet(fieldAccessExpression.value);
    }

    IClass compileGet2(Java.Instanceof instanceof_) throws CompileException {
        IClass iClass = this.compileGetValue(instanceof_.lhs);
        IClass iClass2 = this.getType(instanceof_.rhs);
        if (iClass2.isAssignableFrom(iClass)) {
            this.pop(instanceof_, iClass);
            this.writeOpcode(instanceof_, 4);
        } else if (iClass.isInterface() || iClass2.isInterface() || iClass.isAssignableFrom(iClass2)) {
            this.writeOpcode(instanceof_, -63);
            this.writeConstantClassInfo(instanceof_, iClass2.getDescriptor());
        } else {
            this.compileError("\"" + iClass + "\" can never be an instance of \"" + iClass2 + "\"", instanceof_.getLocation());
        }
        return IClass.BOOLEAN;
    }

    IClass compileGet2(Java.Literal literal) throws CompileException {
        if (literal.value == Scanner.MAGIC_INTEGER || literal.value == Scanner.MAGIC_LONG) {
            this.compileError("This literal value may only appear in a negated context", literal.getLocation());
        }
        return this.pushConstant(literal, literal.value == null ? Java.Rvalue.CONSTANT_VALUE_NULL : literal.value);
    }

    IClass compileGet2(Java.LocalVariableAccess localVariableAccess) {
        return this.load(localVariableAccess, localVariableAccess.localVariable);
    }

    IClass compileGet2(Java.MethodInvocation methodInvocation) throws CompileException {
        Java.Locatable locatable;
        IClass[] iClassArray;
        Java.Scope scope;
        IClass.IMethod iMethod = this.findIMethod(methodInvocation);
        if (methodInvocation.optionalTarget == null) {
            scope = methodInvocation.enclosingBlockStatement;
            while (!(scope instanceof Java.TypeBodyDeclaration)) {
                scope = scope.getEnclosingScope();
            }
            iClassArray = (IClass[])scope;
            if (!(scope instanceof Java.ClassDeclaration)) {
                scope = scope.getEnclosingScope();
            }
            locatable = (Java.ClassDeclaration)scope;
            if (iMethod.isStatic()) {
                this.warning("IASM", "Implicit access to static method \"" + iMethod.toString() + "\"", methodInvocation.getLocation());
            } else {
                this.warning("IANSM", "Implicit access to non-static method \"" + iMethod.toString() + "\"", methodInvocation.getLocation());
                if (iClassArray.isStatic()) {
                    this.compileError("Instance method \"" + iMethod.toString() + "\" cannot be invoked in static context", methodInvocation.getLocation());
                }
                this.referenceThis(methodInvocation, (Java.ClassDeclaration)locatable, (Java.TypeBodyDeclaration)iClassArray, iMethod.getDeclaringIClass());
            }
        } else {
            boolean bl = this.isType(methodInvocation.optionalTarget);
            if (!bl) {
                locatable = this.toRvalueOrCE(methodInvocation.optionalTarget);
                if (this.getType((Java.Atom)locatable) != iMethod.getDeclaringIClass() && iMethod.getAccess() == Access.PRIVATE) {
                    this.compileError("Invocation of private methods of enclosing or enclosed type NYI; please change the access of method \"" + iMethod.getName() + "()\" from \"private\" to \"/*private*/\"", methodInvocation.getLocation());
                }
                this.compileGetValue((Java.Rvalue)locatable);
            }
            if (iMethod.isStatic()) {
                if (!bl) {
                    this.pop(methodInvocation.optionalTarget, this.getType(methodInvocation.optionalTarget));
                }
            } else if (bl) {
                this.compileError("Instance method \"" + methodInvocation.methodName + "\" cannot be invoked in static context", methodInvocation.getLocation());
            }
        }
        iClassArray = iMethod.getParameterTypes();
        int n = 0;
        while (n < methodInvocation.arguments.length) {
            this.assignmentConversion(methodInvocation, this.compileGetValue(methodInvocation.arguments[n]), iClassArray[n], this.getConstantValue(methodInvocation.arguments[n]));
            ++n;
        }
        this.checkAccessible(iMethod, methodInvocation.enclosingBlockStatement);
        if (iMethod.getDeclaringIClass().isInterface()) {
            this.writeOpcode(methodInvocation, -71);
            this.writeConstantInterfaceMethodrefInfo(methodInvocation, iMethod.getDeclaringIClass().getDescriptor(), iMethod.getName(), iMethod.getDescriptor());
            scope = iMethod.getParameterTypes();
            int n2 = 1;
            int n3 = 0;
            while (n3 < ((Java.Scope)scope).length) {
                n2 += Descriptor.size(((IClass)((Object)scope[n3])).getDescriptor());
                ++n3;
            }
            this.writeByte(methodInvocation, n2);
            this.writeByte(methodInvocation, 0);
        } else {
            this.writeOpcode(methodInvocation, iMethod.isStatic() ? -72 : (iMethod.getAccess() == Access.PRIVATE ? -73 : -74));
            this.writeConstantMethodrefInfo(methodInvocation, iMethod.getDeclaringIClass().getDescriptor(), iMethod.getName(), iMethod.getDescriptor());
        }
        return iMethod.getReturnType();
    }

    IClass compileGet2(Java.NewAnonymousClassInstance newAnonymousClassInstance) throws CompileException {
        Java.Rvalue[] rvalueArray;
        Java.AnonymousClassDeclaration anonymousClassDeclaration = newAnonymousClassInstance.anonymousClassDeclaration;
        IClass iClass = this.resolve(anonymousClassDeclaration).getSuperclass();
        IClass.IInvocable[] iInvocableArray = iClass.getDeclaredIConstructors();
        if (iInvocableArray.length == 0) {
            throw new RuntimeException();
        }
        IClass.IConstructor iConstructor = (IClass.IConstructor)this.findMostSpecificIInvocable(newAnonymousClassInstance, iInvocableArray, newAnonymousClassInstance.arguments);
        IClass[] iClassArray = iConstructor.getParameterTypes();
        Location location = newAnonymousClassInstance.getLocation();
        ArrayList<Java.FormalParameter> arrayList = new ArrayList<Java.FormalParameter>();
        if (newAnonymousClassInstance.optionalQualification != null) {
            arrayList.add(new Java.FormalParameter(true, new Java.SimpleType(location, this.getType(newAnonymousClassInstance.optionalQualification)), "this$base"));
        }
        int n = 0;
        while (n < iClassArray.length) {
            arrayList.add(new Java.FormalParameter(true, new Java.SimpleType(location, iClassArray[n]), "p" + n));
            ++n;
        }
        Java.FormalParameter[] formalParameterArray = arrayList.toArray(new Java.FormalParameter[arrayList.size()]);
        IClass[] iClassArray2 = iConstructor.getThrownExceptions();
        Java.Type[] typeArray = new Java.Type[iClassArray2.length];
        int n2 = 0;
        while (n2 < iClassArray2.length) {
            typeArray[n2] = new Java.SimpleType(location, iClassArray2[n2]);
            ++n2;
        }
        Java.ConstructorDeclarator constructorDeclarator = new Java.ConstructorDeclarator(location, anonymousClassDeclaration, null, 0, formalParameterArray, typeArray);
        Java.ParameterAccess parameterAccess = newAnonymousClassInstance.optionalQualification == null ? null : new Java.ParameterAccess(location, constructorDeclarator, "this$base");
        Java.Rvalue[] rvalueArray2 = new Java.Rvalue[iClassArray.length];
        int n3 = 0;
        while (n3 < iClassArray.length) {
            rvalueArray2[n3] = new Java.ParameterAccess(location, constructorDeclarator, "p" + n3);
            ++n3;
        }
        constructorDeclarator.setExplicitConstructorInvocation(new Java.SuperConstructorInvocation(location, anonymousClassDeclaration, constructorDeclarator, parameterAccess, rvalueArray2));
        constructorDeclarator.setBody(new Java.Block(location, constructorDeclarator));
        anonymousClassDeclaration.addConstructor(constructorDeclarator);
        this.compile(anonymousClassDeclaration);
        this.writeOpcode(newAnonymousClassInstance, -69);
        this.writeConstantClassInfo(newAnonymousClassInstance, this.resolve(newAnonymousClassInstance.anonymousClassDeclaration).getDescriptor());
        this.writeOpcode(newAnonymousClassInstance, 89);
        if (newAnonymousClassInstance.optionalQualification == null) {
            rvalueArray = newAnonymousClassInstance.arguments;
        } else {
            rvalueArray = new Java.Rvalue[newAnonymousClassInstance.arguments.length + 1];
            rvalueArray[0] = newAnonymousClassInstance.optionalQualification;
            System.arraycopy(newAnonymousClassInstance.arguments, 0, rvalueArray, 1, newAnonymousClassInstance.arguments.length);
        }
        Java.Scope scope = newAnonymousClassInstance.scope;
        while (!(scope instanceof Java.TypeBodyDeclaration)) {
            scope = scope.getEnclosingScope();
        }
        boolean bl = ((Java.TypeBodyDeclaration)scope).isStatic();
        this.invokeConstructor(newAnonymousClassInstance, newAnonymousClassInstance.scope, bl ? null : new Java.ThisReference(location, newAnonymousClassInstance.scope), this.resolve(newAnonymousClassInstance.anonymousClassDeclaration), rvalueArray);
        return this.resolve(newAnonymousClassInstance.anonymousClassDeclaration);
    }

    IClass compileGet2(Java.NewArray newArray) throws CompileException {
        int n = 0;
        while (n < newArray.dimExprs.length) {
            IClass iClass = this.compileGetValue(newArray.dimExprs[n]);
            if (iClass != IClass.INT && this.unaryNumericPromotion(newArray, iClass) != IClass.INT) {
                this.compileError("Invalid array size expression type", newArray.getLocation());
            }
            ++n;
        }
        return this.newArray(newArray, newArray.dimExprs.length, newArray.dims, this.getType(newArray.type));
    }

    IClass compileGet2(Java.NewClassInstance newClassInstance) throws CompileException {
        Java.Rvalue rvalue;
        if (newClassInstance.iClass == null) {
            newClassInstance.iClass = this.getType(newClassInstance.type);
        }
        this.writeOpcode(newClassInstance, -69);
        this.writeConstantClassInfo(newClassInstance, newClassInstance.iClass.getDescriptor());
        this.writeOpcode(newClassInstance, 89);
        if (newClassInstance.optionalQualification != null) {
            rvalue = newClassInstance.optionalQualification;
        } else {
            Java.Scope scope = newClassInstance.scope;
            while (!(scope instanceof Java.TypeBodyDeclaration)) {
                scope = scope.getEnclosingScope();
            }
            Java.TypeBodyDeclaration typeBodyDeclaration = (Java.TypeBodyDeclaration)scope;
            Java.TypeDeclaration typeDeclaration = (Java.TypeDeclaration)scope.getEnclosingScope();
            if (!(typeDeclaration instanceof Java.ClassDeclaration) || typeBodyDeclaration.isStatic()) {
                rvalue = null;
            } else {
                IClass iClass = newClassInstance.iClass.getDeclaringIClass();
                if (iClass == null) {
                    rvalue = new Java.ThisReference(newClassInstance.getLocation(), newClassInstance.scope);
                } else {
                    Java.ClassDeclaration classDeclaration = (Java.ClassDeclaration)typeDeclaration;
                    rvalue = new Java.QualifiedThisReference(newClassInstance.getLocation(), classDeclaration, typeBodyDeclaration, iClass);
                }
            }
        }
        this.invokeConstructor(newClassInstance, newClassInstance.scope, rvalue, newClassInstance.iClass, newClassInstance.arguments);
        return newClassInstance.iClass;
    }

    IClass compileGet2(Java.ParameterAccess parameterAccess) {
        Java.LocalVariable localVariable = (Java.LocalVariable)parameterAccess.declaringFunction.parameters.get(parameterAccess.name);
        this.load(parameterAccess, localVariable);
        return localVariable.type;
    }

    IClass compileGet2(Java.ParenthesizedExpression parenthesizedExpression) throws CompileException {
        return this.compileGet(parenthesizedExpression.value);
    }

    IClass compileGet2(Java.QualifiedThisReference qualifiedThisReference) throws CompileException {
        this.referenceThis(qualifiedThisReference, this.getDeclaringClass(qualifiedThisReference), this.getDeclaringTypeBodyDeclaration(qualifiedThisReference), this.getTargetIClass(qualifiedThisReference));
        return this.getTargetIClass(qualifiedThisReference);
    }

    IClass compileGet2(Java.SuperclassMethodInvocation superclassMethodInvocation) throws CompileException {
        Java.FunctionDeclarator functionDeclarator;
        IClass.IMethod iMethod = this.findIMethod(superclassMethodInvocation);
        Java.Scope scope = superclassMethodInvocation.enclosingBlockStatement;
        while (scope instanceof Java.Statement) {
            scope = scope.getEnclosingScope();
        }
        Java.FunctionDeclarator functionDeclarator2 = functionDeclarator = scope instanceof Java.FunctionDeclarator ? (Java.FunctionDeclarator)scope : null;
        if (functionDeclarator == null) {
            this.compileError("Cannot invoke superclass method in non-method scope", superclassMethodInvocation.getLocation());
            return IClass.INT;
        }
        if ((functionDeclarator.modifiers & 8) != 0) {
            this.compileError("Cannot invoke superclass method in static context", superclassMethodInvocation.getLocation());
        }
        this.load(superclassMethodInvocation, this.resolve(functionDeclarator.getDeclaringType()), 0);
        IClass[] iClassArray = iMethod.getParameterTypes();
        int n = 0;
        while (n < superclassMethodInvocation.arguments.length) {
            this.assignmentConversion(superclassMethodInvocation, this.compileGetValue(superclassMethodInvocation.arguments[n]), iClassArray[n], this.getConstantValue(superclassMethodInvocation.arguments[n]));
            ++n;
        }
        this.writeOpcode(superclassMethodInvocation, -73);
        this.writeConstantMethodrefInfo(superclassMethodInvocation, iMethod.getDeclaringIClass().getDescriptor(), superclassMethodInvocation.methodName, iMethod.getDescriptor());
        return iMethod.getReturnType();
    }

    IClass compileGet2(Java.ThisReference thisReference) throws CompileException {
        this.referenceThis(thisReference);
        return this.getIClass(thisReference);
    }

    IClass compileGet2(Java.UnaryOperation unaryOperation) throws CompileException {
        if (unaryOperation.operator == "!") {
            return this.compileGet2((Java.BooleanRvalue)unaryOperation);
        }
        if (unaryOperation.operator == "+") {
            return this.compileGetValue(unaryOperation.operand);
        }
        if (unaryOperation.operator == "-") {
            IClass iClass;
            Object object;
            if (unaryOperation.operand instanceof Java.Literal) {
                object = (Java.Literal)unaryOperation.operand;
                iClass = this.getType2((Java.Literal)object);
                this.pushConstant(unaryOperation, this.getNegatedConstantValue2((Java.Literal)object));
            } else {
                iClass = this.compileGetValue(unaryOperation.operand);
            }
            object = this.unaryNumericPromotion(unaryOperation, iClass);
            this.writeOpcode(unaryOperation, 116 + UnitCompiler.ilfd((IClass)object));
            return object;
        }
        if (unaryOperation.operator == "~") {
            IClass iClass = this.compileGetValue(unaryOperation.operand);
            IClass iClass2 = this.unaryNumericPromotion(unaryOperation, iClass);
            if (iClass2 == IClass.INT) {
                this.writeOpcode(unaryOperation, 2);
                this.writeOpcode(unaryOperation, -126);
                return IClass.INT;
            }
            if (iClass2 == IClass.LONG) {
                this.writeOpcode(unaryOperation, 20);
                this.writeConstantLongInfo(unaryOperation, -1L);
                this.writeOpcode(unaryOperation, -125);
                return IClass.LONG;
            }
            this.compileError("Operator \"~\" not applicable to type \"" + iClass2 + "\"", unaryOperation.getLocation());
        }
        this.compileError("Unexpected operator \"" + unaryOperation.operator + "\"", unaryOperation.getLocation());
        return this.iClassLoader.OBJECT;
    }

    private IClass compileGetValue(Java.Rvalue rvalue) throws CompileException {
        Object object = this.getConstantValue(rvalue);
        if (object != null) {
            this.fakeCompile(rvalue);
            this.pushConstant(rvalue, object);
            return this.getType(rvalue);
        }
        this.compileContext(rvalue);
        return this.compileGet(rvalue);
    }

    private void compileSet(Java.Lvalue lvalue) throws CompileException {
        Visitor.LvalueVisitor lvalueVisitor = new Visitor.LvalueVisitor(){

            public void visitAmbiguousName(Java.AmbiguousName ambiguousName) {
                try {
                    UnitCompiler.this.compileSet2(ambiguousName);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitArrayAccessExpression(Java.ArrayAccessExpression arrayAccessExpression) {
                try {
                    UnitCompiler.this.compileSet2(arrayAccessExpression);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitFieldAccess(Java.FieldAccess fieldAccess) {
                try {
                    UnitCompiler.this.compileSet2(fieldAccess);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitFieldAccessExpression(Java.FieldAccessExpression fieldAccessExpression) {
                try {
                    UnitCompiler.this.compileSet2(fieldAccessExpression);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitLocalVariableAccess(Java.LocalVariableAccess localVariableAccess) {
                UnitCompiler.this.compileSet2(localVariableAccess);
            }

            public void visitParenthesizedExpression(Java.ParenthesizedExpression parenthesizedExpression) {
                try {
                    UnitCompiler.this.compileSet2(parenthesizedExpression);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }
        };
        try {
            lvalue.accept(lvalueVisitor);
        }
        catch (TunnelException tunnelException) {
            throw (CompileException)tunnelException.getDelegate();
        }
    }

    void compileSet2(Java.AmbiguousName ambiguousName) throws CompileException {
        this.compileSet(this.toLvalueOrCE(this.reclassify(ambiguousName)));
    }

    void compileSet2(Java.ArrayAccessExpression arrayAccessExpression) throws CompileException {
        this.writeOpcode(arrayAccessExpression, 79 + UnitCompiler.ilfdabcs(this.getType(arrayAccessExpression)));
    }

    void compileSet2(Java.FieldAccess fieldAccess) throws CompileException {
        this.checkAccessible(fieldAccess.field, fieldAccess.enclosingBlockStatement);
        this.writeOpcode(fieldAccess, fieldAccess.field.isStatic() ? -77 : -75);
        this.writeConstantFieldrefInfo(fieldAccess, fieldAccess.field.getDeclaringIClass().getDescriptor(), fieldAccess.field.getName(), fieldAccess.field.getDescriptor());
    }

    void compileSet2(Java.FieldAccessExpression fieldAccessExpression) throws CompileException {
        this.determineValue(fieldAccessExpression);
        this.compileSet(this.toLvalueOrCE(fieldAccessExpression.value));
    }

    void compileSet2(Java.LocalVariableAccess localVariableAccess) {
        this.store((Java.Located)localVariableAccess, localVariableAccess.localVariable.type, localVariableAccess.localVariable);
    }

    void compileSet2(Java.ParenthesizedExpression parenthesizedExpression) throws CompileException {
        this.compileSet(this.toLvalueOrCE(parenthesizedExpression.value));
    }

    private boolean compileUnconditionalLoop(Java.ContinuableStatement continuableStatement, Java.BlockStatement blockStatement, Java.Rvalue[] rvalueArray) throws CompileException {
        if (rvalueArray != null) {
            return this.compileUnconditionalLoopWithUpdate(continuableStatement, blockStatement, rvalueArray);
        }
        continuableStatement.whereToContinue = this.codeContext.newOffset();
        continuableStatement.bodyHasContinue = false;
        if (this.compile(blockStatement)) {
            this.writeBranch(continuableStatement, -89, continuableStatement.whereToContinue);
        }
        if (continuableStatement.whereToBreak == null) {
            return false;
        }
        continuableStatement.whereToBreak.set();
        return true;
    }

    private boolean compileUnconditionalLoopWithUpdate(Java.ContinuableStatement continuableStatement, Java.BlockStatement blockStatement, Java.Rvalue[] rvalueArray) throws CompileException {
        continuableStatement.whereToContinue = this.codeContext.new CodeContext.Offset();
        continuableStatement.bodyHasContinue = false;
        CodeContext.Offset offset = this.codeContext.newOffset();
        boolean bl = this.compile(blockStatement);
        continuableStatement.whereToContinue.set();
        if (!bl && !continuableStatement.bodyHasContinue) {
            this.compileError("Loop update is unreachable", rvalueArray[0].getLocation());
            return continuableStatement.whereToBreak != null;
        }
        int n = 0;
        while (n < rvalueArray.length) {
            this.compile(rvalueArray[n]);
            ++n;
        }
        this.writeBranch(continuableStatement, -89, offset);
        if (continuableStatement.whereToBreak == null) {
            return false;
        }
        continuableStatement.whereToBreak.set();
        return true;
    }

    public ClassFile[] compileUnit(EnumeratorSet enumeratorSet) throws CompileException {
        this.generatedClassFiles = new ArrayList();
        this.debuggingInformation = enumeratorSet;
        Iterator iterator = this.compilationUnit.packageMemberTypeDeclarations.iterator();
        while (iterator.hasNext()) {
            this.compile((Java.PackageMemberTypeDeclaration)iterator.next());
        }
        List list = this.generatedClassFiles;
        return list.toArray(new ClassFile[list.size()]);
    }

    private CodeContext createDummyCodeContext() {
        return new CodeContext(this.getCodeContext().getClassFile());
    }

    private void declareClassDollarMethod(Java.ClassLiteral classLiteral) {
        Location location = classLiteral.getLocation();
        Java.SimpleType simpleType = new Java.SimpleType(location, this.iClassLoader.STRING);
        Java.SimpleType simpleType2 = new Java.SimpleType(location, this.iClassLoader.CLASS);
        Java.FormalParameter formalParameter = new Java.FormalParameter(false, simpleType, "className");
        Java.MethodDeclarator methodDeclarator = new Java.MethodDeclarator(location, classLiteral.declaringType, null, 8, (Java.Type)simpleType2, "class$", new Java.FormalParameter[]{formalParameter}, new Java.Type[0]);
        Java.Block block = new Java.Block(location, methodDeclarator);
        Java.TryStatement tryStatement = new Java.TryStatement(location, methodDeclarator);
        Java.MethodInvocation methodInvocation = new Java.MethodInvocation(location, tryStatement, simpleType2, "forName", new Java.Rvalue[]{new Java.AmbiguousName(location, tryStatement, new String[]{"className"})});
        tryStatement.setBody(new Java.ReturnStatement(location, tryStatement, methodInvocation));
        IClass iClass = this.iClassLoader.loadIClass("Ljava/lang/ClassNotFoundException;");
        if (iClass == null) {
            throw new RuntimeException();
        }
        IClass iClass2 = this.iClassLoader.loadIClass("Ljava/lang/NoClassDefFoundError;");
        if (iClass2 == null) {
            throw new RuntimeException();
        }
        Java.Block block2 = new Java.Block(location, tryStatement);
        Java.CatchClause catchClause = new Java.CatchClause(new Java.FormalParameter(true, new Java.SimpleType(location, iClass), "ex"), block2);
        Java.NewClassInstance newClassInstance = new Java.NewClassInstance(location, (Java.Scope)block2, null, new Java.SimpleType(location, iClass2), new Java.Rvalue[]{new Java.MethodInvocation(location, block2, new Java.AmbiguousName(location, block2, new String[]{"ex"}), "getMessage", new Java.Rvalue[0])});
        block2.addStatement(new Java.ThrowStatement(location, block2, newClassInstance));
        tryStatement.addCatchClause(catchClause);
        block.addStatement(tryStatement);
        methodDeclarator.setBody(block);
        classLiteral.declaringType.declaredMethods.add(methodDeclarator);
        if (classLiteral.declaringType.resolvedType != null) {
            classLiteral.declaringType.resolvedType.declaredIMethods = null;
            classLiteral.declaringType.resolvedType.declaredIMethodCache = null;
        }
    }

    private Java.LocalVariable defineLocalVariable(Java.Block block, Java.Located located, boolean bl, IClass iClass, String string) throws CompileException {
        Java.Scope scope = block;
        while (scope instanceof Java.Statement) {
            if (scope instanceof Java.Block && scope.localVariables.containsKey(string)) {
                this.compileError("Redefinition of local variable \"" + string + "\"", located.getLocation());
            }
            scope = scope.getEnclosingScope();
        }
        Java.LocalVariable localVariable = new Java.LocalVariable(bl, iClass, this.codeContext.allocateLocalVariable(Descriptor.size(iClass.getDescriptor())));
        block.localVariables.put(string, localVariable);
        return localVariable;
    }

    private void determineValue(Java.FieldAccessExpression fieldAccessExpression) throws CompileException {
        if (fieldAccessExpression.value != null) {
            return;
        }
        IClass iClass = this.getType(fieldAccessExpression.lhs);
        if (fieldAccessExpression.fieldName.equals("length") && iClass.isArray()) {
            fieldAccessExpression.value = new Java.ArrayLength(fieldAccessExpression.getLocation(), this.toRvalueOrCE(fieldAccessExpression.lhs));
        } else {
            IClass.IField iField = this.findIField(iClass, fieldAccessExpression.fieldName, fieldAccessExpression.getLocation());
            if (iField == null) {
                this.compileError("\"" + this.getType(fieldAccessExpression.lhs).toString() + "\" has no field \"" + fieldAccessExpression.fieldName + "\"", fieldAccessExpression.getLocation());
                fieldAccessExpression.value = new Java.Rvalue(fieldAccessExpression.getLocation()){

                    public final void accept(Visitor.AtomVisitor atomVisitor) {
                    }

                    public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
                    }

                    public String toString() {
                        return "???";
                    }
                };
                return;
            }
            fieldAccessExpression.value = new Java.FieldAccess(fieldAccessExpression.getLocation(), fieldAccessExpression.enclosingBlockStatement, fieldAccessExpression.lhs, iField);
        }
    }

    private void dup(Java.Located located, int n) {
        switch (n) {
            case 1: {
                this.writeOpcode(located, 89);
                break;
            }
            case 2: {
                this.writeOpcode(located, 92);
                break;
            }
            default: {
                throw new RuntimeException("dup(" + n + ")");
            }
            case 0: 
        }
    }

    private void dupx(Java.Located located, IClass iClass, int n) {
        if (n < 0 || n > 2) {
            throw new RuntimeException();
        }
        int n2 = 89 + n;
        int n3 = 92 + n;
        this.writeOpcode(located, iClass == IClass.LONG || iClass == IClass.DOUBLE ? n3 : n2);
    }

    private void fakeCompile(Java.Rvalue rvalue) throws CompileException {
        CodeContext codeContext = this.replaceCodeContext(this.createDummyCodeContext());
        try {
            this.compileContext(rvalue);
            this.compileGet(rvalue);
        }
        finally {
            Object var4_3 = null;
            this.replaceCodeContext(codeContext);
        }
    }

    private static void fillConversionMap(Object[] objectArray, HashMap hashMap) {
        byte[] byArray = null;
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            if (object instanceof byte[]) {
                byArray = (byte[])object;
            } else {
                hashMap.put(object, byArray);
            }
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public IClass findClass(String var1_1) {
        v0 = var2_2 = this.compilationUnit.optionalPackageDeclaration == null ? null : this.compilationUnit.optionalPackageDeclaration.packageName;
        if (var2_2 != null) {
            if (!var1_1.startsWith(String.valueOf(var2_2) + '.')) {
                return null;
            }
            var1_1 = var1_1.substring(var2_2.length() + 1);
        }
        if ((var4_4 /* !! */  = this.compilationUnit.getPackageMemberTypeDeclaration((var3_3 = new StringTokenizer(var1_1, "$")).nextToken())) != null) ** GOTO lbl10
        return null;
lbl-1000:
        // 1 sources

        {
            if ((var4_4 /* !! */  = var4_4 /* !! */ .getMemberTypeDeclaration(var3_3.nextToken())) != null) continue;
            return null;
lbl10:
            // 2 sources

            ** while (var3_3.hasMoreTokens())
        }
lbl11:
        // 1 sources

        return this.resolve((Java.AbstractTypeDeclaration)var4_4 /* !! */ );
    }

    private IClass.IField findIField(IClass iClass, String string, Location location) throws CompileException {
        IClass.IField iField;
        IClass.IField[] iFieldArray = iClass.getDeclaredIFields();
        int n = 0;
        while (n < iFieldArray.length) {
            iField = iFieldArray[n];
            if (string.equals(iField.getName())) {
                return iField;
            }
            ++n;
        }
        iField = null;
        IClass iClass2 = iClass.getSuperclass();
        if (iClass2 != null) {
            iField = this.findIField(iClass2, string, location);
        }
        IClass[] iClassArray = iClass.getInterfaces();
        int n2 = 0;
        while (n2 < iClassArray.length) {
            IClass.IField iField2 = this.findIField(iClassArray[n2], string, location);
            if (iField2 != null) {
                if (iField != null) {
                    throw new CompileException("Access to field \"" + string + "\" is ambiguous - both \"" + iField.getDeclaringIClass() + "\" and \"" + iField2.getDeclaringIClass() + "\" declare it", location);
                }
                iField = iField2;
            }
            ++n2;
        }
        return iField;
    }

    private IClass.IMethod findIMethod(Java.Located located, IClass iClass, final String string, Java.Rvalue[] rvalueArray) throws CompileException {
        IClass iClass2 = iClass;
        while (iClass2 != null) {
            ArrayList arrayList = new ArrayList();
            this.getIMethods(iClass2, string, arrayList);
            if (arrayList.size() > 0) {
                IClass.IMethod iMethod = (IClass.IMethod)this.findMostSpecificIInvocable(located, arrayList.toArray(new IClass.IMethod[arrayList.size()]), rvalueArray);
                return iMethod;
            }
            iClass2 = iClass2.getDeclaringIClass();
        }
        this.compileError("Class \"" + iClass + "\" has no method named \"" + string + "\"", located.getLocation());
        return new IClass.IMethod(iClass){

            public Access getAccess() {
                return Access.PUBLIC;
            }

            public String getName() {
                return string;
            }

            public IClass[] getParameterTypes() throws CompileException {
                return new IClass[0];
            }

            public IClass getReturnType() throws CompileException {
                return IClass.INT;
            }

            public IClass[] getThrownExceptions() throws CompileException {
                return new IClass[0];
            }

            public boolean isAbstract() {
                return false;
            }

            public boolean isStatic() {
                return false;
            }
        };
    }

    private IClass.IMethod findIMethod(Java.MethodInvocation methodInvocation) throws CompileException {
        Java.Scope scope = methodInvocation.enclosingBlockStatement;
        while (!(scope instanceof Java.CompilationUnit)) {
            if (scope instanceof Java.TypeDeclaration) {
                Java.TypeDeclaration typeDeclaration = (Java.TypeDeclaration)scope;
                IClass.IMethod iMethod = this.findIMethod(methodInvocation, methodInvocation.optionalTarget == null ? this.resolve(typeDeclaration) : this.getType(methodInvocation.optionalTarget), methodInvocation.methodName, methodInvocation.arguments);
                IClass[] iClassArray = iMethod.getThrownExceptions();
                int n = 0;
                while (n < iClassArray.length) {
                    this.checkThrownException(methodInvocation, iClassArray[n], methodInvocation.enclosingBlockStatement);
                    ++n;
                }
                return iMethod;
            }
            scope = scope.getEnclosingScope();
        }
        return null;
    }

    private IClass.IMethod findIMethod(Java.SuperclassMethodInvocation superclassMethodInvocation) throws CompileException {
        Java.Scope scope = superclassMethodInvocation.enclosingBlockStatement;
        while (true) {
            if (scope instanceof Java.FunctionDeclarator) {
                Java.FunctionDeclarator functionDeclarator = (Java.FunctionDeclarator)scope;
                if ((functionDeclarator.modifiers & 8) != 0) {
                    this.compileError("Superclass method cannot be invoked in static context", superclassMethodInvocation.getLocation());
                }
            }
            if (scope instanceof Java.ClassDeclaration) break;
            scope = scope.getEnclosingScope();
        }
        Java.ClassDeclaration classDeclaration = (Java.ClassDeclaration)scope;
        return this.findIMethod(superclassMethodInvocation, this.resolve(classDeclaration).getSuperclass(), superclassMethodInvocation.methodName, superclassMethodInvocation.arguments);
    }

    private IClass findMemberType(IClass iClass, String string, Location location) throws CompileException {
        IClass[] iClassArray = iClass.findMemberType(string);
        if (iClassArray.length == 0) {
            return null;
        }
        if (iClassArray.length == 1) {
            return iClassArray[0];
        }
        StringBuffer stringBuffer = new StringBuffer("Type \"" + string + "\" is ambiguous: " + iClassArray[0].toString());
        int n = 1;
        while (n < iClassArray.length) {
            stringBuffer.append(" vs. ").append(iClassArray[n].toString());
            ++n;
        }
        this.compileError(stringBuffer.toString(), location);
        return iClassArray[0];
    }

    /*
     * Unable to fully structure code
     */
    private IClass.IInvocable findMostSpecificIInvocable(Java.Located var1_1, final IClass.IInvocable[] var2_2, Java.Rvalue[] var3_3) throws CompileException {
        block40: {
            if (var2_2.length == 0) {
                throw new RuntimeException();
            }
            var4_4 = new IClass[var3_3.length];
            var5_5 = 0;
            while (var5_5 < var3_3.length) {
                var4_4[var5_5] = this.getType(var3_3[var5_5]);
                ++var5_5;
            }
            var6_6 = new ArrayList<ArrayList<E>>();
            var7_7 = 0;
            while (var7_7 < var2_2.length) {
                block39: {
                    var8_8 = var2_2[var7_7];
                    var9_9 = var8_8.getParameterTypes();
                    if (((IClass[])var9_9).length == var3_3.length) {
                        var10_12 = 0;
                        while (var10_12 < var3_3.length) {
                            if (this.isMethodInvocationConvertible(var4_4[var10_12], var9_9[var10_12])) {
                                ++var10_12;
                                continue;
                            }
                            break block39;
                        }
                        var6_6.add(var8_8);
                    }
                }
                ++var7_7;
            }
            if (var6_6.size() == 0) {
                var8_8 = new StringBuffer();
                if (var4_4.length == 0) {
                    var8_8.append("zero actual parameters");
                } else {
                    var8_8.append("actual parameters \"").append(var4_4[0]);
                    var9_10 = 1;
                    while (var9_10 < var4_4.length) {
                        var8_8.append(", ").append(var4_4[var9_10]);
                        ++var9_10;
                    }
                    var8_8.append("\"");
                }
                var9_9 = new StringBuffer(String.valueOf('\"') + var2_2[0].toString() + '\"');
                var10_12 = 1;
                while (var10_12 < var2_2.length) {
                    var9_9.append(", ").append(String.valueOf('\"') + var2_2[var10_12].toString() + '\"');
                    ++var10_12;
                }
                this.compileError("No applicable constructor/method found for " + var8_8.toString() + "; candidates are: " + var9_9.toString(), var1_1.getLocation());
                if (var2_2[0] instanceof IClass.IConstructor) {
                    return new IClass.IConstructor(var2_2[0].getDeclaringIClass()){

                        public Access getAccess() {
                            return Access.PUBLIC;
                        }

                        public IClass[] getParameterTypes() {
                            return var4_4;
                        }

                        public IClass[] getThrownExceptions() {
                            return new IClass[0];
                        }
                    };
                }
                if (var2_2[0] instanceof IClass.IMethod) {
                    return new IClass.IMethod(var2_2[0].getDeclaringIClass()){

                        public Access getAccess() {
                            return Access.PUBLIC;
                        }

                        public String getName() {
                            return ((IClass.IMethod)var2_2[0]).getName();
                        }

                        public IClass[] getParameterTypes() {
                            return var4_4;
                        }

                        public IClass getReturnType() {
                            return IClass.INT;
                        }

                        public IClass[] getThrownExceptions() {
                            return new IClass[0];
                        }

                        public boolean isAbstract() {
                            return false;
                        }

                        public boolean isStatic() {
                            return true;
                        }
                    };
                }
                return var2_2[0];
            }
            if (var6_6.size() == 1) {
                return (IClass.IInvocable)var6_6.get(0);
            }
            var8_8 = new ArrayList<IClass.IInvocable>();
            var9_11 = 0;
            while (var9_11 < var6_6.size()) {
                var10_14 = (IClass.IInvocable)var6_6.get(var9_11);
                var11_17 = 0;
                var12_20 = 0;
                var13_23 = 0;
                while (var13_23 < var8_8.size()) {
                    var14_26 = (IClass[])var8_8.get(var13_23);
                    if (var10_14.isMoreSpecificThan((IClass.IInvocable)var14_26)) {
                        ++var11_17;
                    } else if (var10_14.isLessSpecificThan((IClass.IInvocable)var14_26)) {
                        ++var12_20;
                    }
                    ++var13_23;
                }
                if (var11_17 == var8_8.size()) {
                    var8_8.clear();
                    var8_8.add(var10_14);
                } else if (var12_20 < var8_8.size()) {
                    var8_8.add(var10_14);
                }
                ++var9_11;
            }
            if (var8_8.size() == 1) {
                return (IClass.IInvocable)var8_8.get(0);
            }
            if (var8_8.size() <= 1 || !(var2_2[0] instanceof IClass.IMethod)) break block40;
            var10_15 = (IClass.IMethod)var8_8.get(0);
            var11_18 = null;
            var12_21 = var8_8.iterator();
            var13_24 = (IClass.IMethod)var12_21.next();
            var14_26 = var13_24.getParameterTypes();
            block7: while (true) {
                if (!var13_24.isAbstract()) {
                    if (var11_18 != null) {
                        throw new RuntimeException("SNO: More than one non-abstract method with same signature and same declaring class!?");
                    }
                    var11_18 = var13_24;
                }
                if (!var12_21.hasNext()) break;
                var13_24 = (IClass.IMethod)var12_21.next();
                var15_27 = var13_24.getParameterTypes();
                var16_28 = 0;
                while (true) {
                    if (var16_28 >= var15_27.length) continue block7;
                    if (var15_27[var16_28] == var14_26[var16_28]) {
                        ++var16_28;
                        continue;
                    }
                    break block40;
                    break;
                }
                break;
            }
            if (var11_18 != null) {
                return var11_18;
            }
            var15_27 = new HashSet();
            var16_29 = new IClass[var8_8.size()][];
            var17_30 = var8_8.iterator();
            var18_31 = 0;
            while (var18_31 < var16_29.length) {
                var16_29[var18_31] = ((IClass.IMethod)var17_30.next()).getThrownExceptions();
                ++var18_31;
            }
            var19_32 = 0;
            while (var19_32 < var16_29.length) {
                var20_33 = 0;
                while (var20_33 < var16_29[var19_32].length) {
                    block41: {
                        var21_35 = var16_29[var19_32][var20_33];
                        var22_36 = 0;
                        block12: while (var22_36 < var16_29.length) {
                            if (var22_36 == var19_32) ** GOTO lbl136
                            var23_37 = 0;
                            while (var23_37 < var16_29[var22_36].length) {
                                var24_38 = var16_29[var22_36][var23_37];
                                if (!var24_38.isAssignableFrom(var21_35)) {
                                    ++var23_37;
                                    continue;
                                }
lbl136:
                                // 3 sources

                                ++var22_36;
                                continue block12;
                            }
                            break block41;
                        }
                        var15_27.add(var21_35);
                    }
                    ++var20_33;
                }
                ++var19_32;
            }
            var20_34 = var15_27.toArray(new IClass[var15_27.size()]);
            return new IClass.IMethod(var10_15.getDeclaringIClass()){

                public Access getAccess() {
                    return var10_15.getAccess();
                }

                public String getName() {
                    return var10_15.getName();
                }

                public IClass[] getParameterTypes() throws CompileException {
                    return var10_15.getParameterTypes();
                }

                public IClass getReturnType() throws CompileException {
                    return var10_15.getReturnType();
                }

                public IClass[] getThrownExceptions() {
                    return var20_34;
                }

                public boolean isAbstract() {
                    return true;
                }

                public boolean isStatic() {
                    return false;
                }
            };
        }
        var10_16 = new StringBuffer("Invocation of constructor/method with actual parameter type(s) \"");
        var11_19 = 0;
        while (var11_19 < var3_3.length) {
            if (var11_19 > 0) {
                var10_16.append(", ");
            }
            var10_16.append(Descriptor.toString(var4_4[var11_19].getDescriptor()));
            ++var11_19;
        }
        var10_16.append("\" is ambiguous: ");
        var12_22 = 0;
        while (var12_22 < var8_8.size()) {
            if (var12_22 > 0) {
                var10_16.append(" vs. ");
            }
            var10_16.append("\"" + var8_8.get(var12_22) + "\"");
            ++var12_22;
        }
        this.compileError(var10_16.toString(), var1_1.getLocation());
        return (IClass.IMethod)var2_2[0];
    }

    private boolean generatesCode(Java.BlockStatement blockStatement) throws CompileException {
        final boolean[] blArray = new boolean[1];
        Visitor.BlockStatementVisitor blockStatementVisitor = new Visitor.BlockStatementVisitor(){

            public void visitBlock(Java.Block block) {
                try {
                    blArray[0] = this.generatesCode2(block);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitBreakStatement(Java.BreakStatement breakStatement) {
                blArray[0] = this.generatesCode2(breakStatement);
            }

            public void visitContinueStatement(Java.ContinueStatement continueStatement) {
                blArray[0] = this.generatesCode2(continueStatement);
            }

            public void visitDoStatement(Java.DoStatement doStatement) {
                blArray[0] = this.generatesCode2(doStatement);
            }

            public void visitEmptyStatement(Java.EmptyStatement emptyStatement) {
                blArray[0] = this.generatesCode2(emptyStatement);
            }

            public void visitExpressionStatement(Java.ExpressionStatement expressionStatement) {
                blArray[0] = this.generatesCode2(expressionStatement);
            }

            public void visitFieldDeclaration(Java.FieldDeclaration fieldDeclaration) {
                try {
                    blArray[0] = this.generatesCode2(fieldDeclaration);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitForStatement(Java.ForStatement forStatement) {
                blArray[0] = this.generatesCode2(forStatement);
            }

            public void visitIfStatement(Java.IfStatement ifStatement) {
                blArray[0] = this.generatesCode2(ifStatement);
            }

            public void visitInitializer(Java.Initializer initializer) {
                try {
                    blArray[0] = this.generatesCode2(initializer);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitLabeledStatement(Java.LabeledStatement labeledStatement) {
                blArray[0] = this.generatesCode2(labeledStatement);
            }

            public void visitLocalClassDeclarationStatement(Java.LocalClassDeclarationStatement localClassDeclarationStatement) {
                blArray[0] = this.generatesCode2(localClassDeclarationStatement);
            }

            public void visitLocalVariableDeclarationStatement(Java.LocalVariableDeclarationStatement localVariableDeclarationStatement) {
                blArray[0] = this.generatesCode2(localVariableDeclarationStatement);
            }

            public void visitReturnStatement(Java.ReturnStatement returnStatement) {
                blArray[0] = this.generatesCode2(returnStatement);
            }

            public void visitSwitchStatement(Java.SwitchStatement switchStatement) {
                blArray[0] = this.generatesCode2(switchStatement);
            }

            public void visitSynchronizedStatement(Java.SynchronizedStatement synchronizedStatement) {
                blArray[0] = this.generatesCode2(synchronizedStatement);
            }

            public void visitThrowStatement(Java.ThrowStatement throwStatement) {
                blArray[0] = this.generatesCode2(throwStatement);
            }

            public void visitTryStatement(Java.TryStatement tryStatement) {
                blArray[0] = this.generatesCode2(tryStatement);
            }

            public void visitWhileStatement(Java.WhileStatement whileStatement) {
                blArray[0] = this.generatesCode2(whileStatement);
            }
        };
        try {
            blockStatement.accept(blockStatementVisitor);
            return blArray[0];
        }
        catch (TunnelException tunnelException) {
            throw (CompileException)tunnelException.getDelegate();
        }
    }

    public boolean generatesCode2(Java.Block block) throws CompileException {
        int n = 0;
        while (n < block.statements.size()) {
            if (this.generatesCode((Java.BlockStatement)block.statements.get(n))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean generatesCode2(Java.BlockStatement blockStatement) {
        return true;
    }

    public boolean generatesCode2(Java.EmptyStatement emptyStatement) {
        return false;
    }

    public boolean generatesCode2(Java.FieldDeclaration fieldDeclaration) throws CompileException {
        int n = 0;
        while (n < fieldDeclaration.variableDeclarators.length) {
            Java.VariableDeclarator variableDeclarator = fieldDeclaration.variableDeclarators[n];
            if (this.getNonConstantFinalInitializer(fieldDeclaration, variableDeclarator) != null) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean generatesCode2(Java.Initializer initializer) throws CompileException {
        return this.generatesCode(initializer.block);
    }

    public boolean generatesCode2(Java.LocalClassDeclarationStatement localClassDeclarationStatement) {
        return false;
    }

    private IClass getArrayType(IClass iClass) {
        return this.iClassLoader.loadArrayIClass(iClass);
    }

    IClass getArrayType(IClass iClass, int n) {
        if (n == 0) {
            return iClass;
        }
        int n2 = 0;
        while (n2 < n) {
            iClass = this.iClassLoader.loadArrayIClass(iClass);
            ++n2;
        }
        return iClass;
    }

    private CodeContext getCodeContext() {
        CodeContext codeContext = this.codeContext;
        if (codeContext == null) {
            throw new RuntimeException("S.N.O.: Null CodeContext");
        }
        return codeContext;
    }

    final Object getConstantValue(Java.Rvalue rvalue) throws CompileException {
        if (rvalue.constantValue != Java.Rvalue.CONSTANT_VALUE_UNKNOWN) {
            return rvalue.constantValue;
        }
        rvalue.constantValue = this.getConstantValue2(rvalue);
        final Object[] objectArray = new Object[1];
        Visitor.RvalueVisitor rvalueVisitor = new Visitor.RvalueVisitor(){

            public void visitAmbiguousName(Java.AmbiguousName ambiguousName) {
                try {
                    objectArray[0] = this.getConstantValue2(ambiguousName);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitArrayAccessExpression(Java.ArrayAccessExpression arrayAccessExpression) {
                objectArray[0] = this.getConstantValue2(arrayAccessExpression);
            }

            public void visitArrayInitializer(Java.ArrayInitializer arrayInitializer) {
                objectArray[0] = this.getConstantValue2(arrayInitializer);
            }

            public void visitArrayLength(Java.ArrayLength arrayLength) {
                objectArray[0] = this.getConstantValue2(arrayLength);
            }

            public void visitAssignment(Java.Assignment assignment) {
                objectArray[0] = this.getConstantValue2(assignment);
            }

            public void visitBinaryOperation(Java.BinaryOperation binaryOperation) {
                try {
                    objectArray[0] = this.getConstantValue2(binaryOperation);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitCast(Java.Cast cast) {
                try {
                    objectArray[0] = this.getConstantValue2(cast);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitClassLiteral(Java.ClassLiteral classLiteral) {
                objectArray[0] = this.getConstantValue2(classLiteral);
            }

            public void visitConditionalExpression(Java.ConditionalExpression conditionalExpression) {
                objectArray[0] = this.getConstantValue2(conditionalExpression);
            }

            public void visitConstantValue(Java.ConstantValue constantValue) {
                objectArray[0] = this.getConstantValue2(constantValue);
            }

            public void visitCrement(Java.Crement crement) {
                objectArray[0] = this.getConstantValue2(crement);
            }

            public void visitFieldAccess(Java.FieldAccess fieldAccess) {
                try {
                    objectArray[0] = this.getConstantValue2(fieldAccess);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitFieldAccessExpression(Java.FieldAccessExpression fieldAccessExpression) {
                objectArray[0] = this.getConstantValue2(fieldAccessExpression);
            }

            public void visitInstanceof(Java.Instanceof instanceof_) {
                objectArray[0] = this.getConstantValue2(instanceof_);
            }

            public void visitLiteral(Java.Literal literal) {
                try {
                    objectArray[0] = this.getConstantValue2(literal);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitLocalVariableAccess(Java.LocalVariableAccess localVariableAccess) {
                objectArray[0] = this.getConstantValue2(localVariableAccess);
            }

            public void visitMethodInvocation(Java.MethodInvocation methodInvocation) {
                objectArray[0] = this.getConstantValue2(methodInvocation);
            }

            public void visitNewAnonymousClassInstance(Java.NewAnonymousClassInstance newAnonymousClassInstance) {
                objectArray[0] = this.getConstantValue2(newAnonymousClassInstance);
            }

            public void visitNewArray(Java.NewArray newArray) {
                objectArray[0] = this.getConstantValue2(newArray);
            }

            public void visitNewClassInstance(Java.NewClassInstance newClassInstance) {
                objectArray[0] = this.getConstantValue2(newClassInstance);
            }

            public void visitParameterAccess(Java.ParameterAccess parameterAccess) {
                objectArray[0] = this.getConstantValue2(parameterAccess);
            }

            public void visitParenthesizedExpression(Java.ParenthesizedExpression parenthesizedExpression) {
                try {
                    objectArray[0] = this.getConstantValue2(parenthesizedExpression);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitQualifiedThisReference(Java.QualifiedThisReference qualifiedThisReference) {
                objectArray[0] = this.getConstantValue2(qualifiedThisReference);
            }

            public void visitSuperclassMethodInvocation(Java.SuperclassMethodInvocation superclassMethodInvocation) {
                objectArray[0] = this.getConstantValue2(superclassMethodInvocation);
            }

            public void visitThisReference(Java.ThisReference thisReference) {
                objectArray[0] = this.getConstantValue2(thisReference);
            }

            public void visitUnaryOperation(Java.UnaryOperation unaryOperation) {
                try {
                    objectArray[0] = this.getConstantValue2(unaryOperation);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }
        };
        try {
            rvalue.accept(rvalueVisitor);
            rvalue.constantValue = objectArray[0];
            return rvalue.constantValue;
        }
        catch (TunnelException tunnelException) {
            throw (CompileException)tunnelException.getDelegate();
        }
    }

    Object getConstantValue2(Java.AmbiguousName ambiguousName) throws CompileException {
        return this.getConstantValue(this.toRvalueOrCE(this.reclassify(ambiguousName)));
    }

    Object getConstantValue2(Java.BinaryOperation binaryOperation) throws CompileException {
        Object object;
        if ((binaryOperation.op == "==" || binaryOperation.op == "!=") && this.getConstantValue(binaryOperation.lhs) == Java.Rvalue.CONSTANT_VALUE_NULL && this.getConstantValue(binaryOperation.rhs) == Java.Rvalue.CONSTANT_VALUE_NULL) {
            return binaryOperation.op == "==" ? Boolean.TRUE : Boolean.FALSE;
        }
        if (binaryOperation.op == "|" || binaryOperation.op == "^" || binaryOperation.op == "&" || binaryOperation.op == "*" || binaryOperation.op == "/" || binaryOperation.op == "%" || binaryOperation.op == "+" || binaryOperation.op == "-") {
            Object object2;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Iterator iterator = binaryOperation.unrollLeftAssociation();
            while (iterator.hasNext()) {
                object2 = this.getConstantValue((Java.Rvalue)iterator.next());
                if (object2 == null) {
                    return null;
                }
                arrayList.add(object2);
            }
            object2 = arrayList.iterator();
            Object object3 = object2.next();
            while (object2.hasNext()) {
                int n;
                Object e = object2.next();
                if (binaryOperation.op == "+" && (object3 instanceof String || e instanceof String)) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(object3.toString()).append(e.toString());
                    while (object2.hasNext()) {
                        stringBuffer.append(object2.next().toString());
                    }
                    return stringBuffer.toString();
                }
                if (!(object3 instanceof Number) || !(e instanceof Number)) {
                    return null;
                }
                if (object3 instanceof Double || e instanceof Double) {
                    double d;
                    double d2 = ((Number)object3).doubleValue();
                    double d3 = ((Number)e).doubleValue();
                    if (binaryOperation.op == "*") {
                        d = d2 * d3;
                    } else if (binaryOperation.op == "/") {
                        d = d2 / d3;
                    } else if (binaryOperation.op == "%") {
                        d = d2 % d3;
                    } else if (binaryOperation.op == "+") {
                        d = d2 + d3;
                    } else if (binaryOperation.op == "-") {
                        d = d2 - d3;
                    } else {
                        return null;
                    }
                    object3 = new Double(d);
                    continue;
                }
                if (object3 instanceof Float || e instanceof Float) {
                    float f;
                    float f2 = ((Number)object3).floatValue();
                    float f3 = ((Number)e).floatValue();
                    if (binaryOperation.op == "*") {
                        f = f2 * f3;
                    } else if (binaryOperation.op == "/") {
                        f = f2 / f3;
                    } else if (binaryOperation.op == "%") {
                        f = f2 % f3;
                    } else if (binaryOperation.op == "+") {
                        f = f2 + f3;
                    } else if (binaryOperation.op == "-") {
                        f = f2 - f3;
                    } else {
                        return null;
                    }
                    object3 = new Float(f);
                    continue;
                }
                if (object3 instanceof Long || e instanceof Long) {
                    long l;
                    long l2 = ((Number)object3).longValue();
                    long l3 = ((Number)e).longValue();
                    if (binaryOperation.op == "|") {
                        l = l2 | l3;
                    } else if (binaryOperation.op == "^") {
                        l = l2 ^ l3;
                    } else if (binaryOperation.op == "&") {
                        l = l2 & l3;
                    } else if (binaryOperation.op == "*") {
                        l = l2 * l3;
                    } else if (binaryOperation.op == "/") {
                        l = l2 / l3;
                    } else if (binaryOperation.op == "%") {
                        l = l2 % l3;
                    } else if (binaryOperation.op == "+") {
                        l = l2 + l3;
                    } else if (binaryOperation.op == "-") {
                        l = l2 - l3;
                    } else {
                        return null;
                    }
                    object3 = new Long(l);
                    continue;
                }
                int n2 = ((Number)object3).intValue();
                int n3 = ((Number)e).intValue();
                if (binaryOperation.op == "|") {
                    n = n2 | n3;
                } else if (binaryOperation.op == "^") {
                    n = n2 ^ n3;
                } else if (binaryOperation.op == "&") {
                    n = n2 & n3;
                } else if (binaryOperation.op == "*") {
                    n = n2 * n3;
                } else if (binaryOperation.op == "/") {
                    n = n2 / n3;
                } else if (binaryOperation.op == "%") {
                    n = n2 % n3;
                } else if (binaryOperation.op == "+") {
                    n = n2 + n3;
                } else if (binaryOperation.op == "-") {
                    n = n2 - n3;
                } else {
                    return null;
                }
                object3 = new Integer(n);
            }
            return object3;
        }
        if ((binaryOperation.op == "&&" || binaryOperation.op == "||") && (object = this.getConstantValue(binaryOperation.lhs)) instanceof Boolean) {
            boolean bl = (Boolean)object;
            return binaryOperation.op == "&&" ? (bl ? this.getConstantValue(binaryOperation.rhs) : Boolean.FALSE) : (bl ? Boolean.TRUE : this.getConstantValue(binaryOperation.rhs));
        }
        return null;
    }

    Object getConstantValue2(Java.Cast cast) throws CompileException {
        Object object = this.getConstantValue(cast.value);
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            IClass iClass = this.getType(cast.targetType);
            if (iClass == IClass.BYTE) {
                return new Byte(((Number)object).byteValue());
            }
            if (iClass == IClass.SHORT) {
                return new Short(((Number)object).shortValue());
            }
            if (iClass == IClass.INT) {
                return new Integer(((Number)object).intValue());
            }
            if (iClass == IClass.LONG) {
                return new Long(((Number)object).longValue());
            }
            if (iClass == IClass.FLOAT) {
                return new Float(((Number)object).floatValue());
            }
            if (iClass == IClass.DOUBLE) {
                return new Double(((Number)object).doubleValue());
            }
        }
        return null;
    }

    Object getConstantValue2(Java.ConstantValue constantValue) {
        return constantValue.constantValue;
    }

    Object getConstantValue2(Java.FieldAccess fieldAccess) throws CompileException {
        return fieldAccess.field.getConstantValue();
    }

    Object getConstantValue2(Java.Literal literal) throws CompileException {
        if (literal.value == Scanner.MAGIC_INTEGER || literal.value == Scanner.MAGIC_LONG) {
            this.compileError("This literal value may only appear in a negated context", literal.getLocation());
        }
        return literal.value == null ? Java.Rvalue.CONSTANT_VALUE_NULL : literal.value;
    }

    Object getConstantValue2(Java.ParenthesizedExpression parenthesizedExpression) throws CompileException {
        return this.getConstantValue(parenthesizedExpression.value);
    }

    Object getConstantValue2(Java.Rvalue rvalue) {
        return null;
    }

    Object getConstantValue2(Java.UnaryOperation unaryOperation) throws CompileException {
        if (unaryOperation.operator.equals("+")) {
            return this.getConstantValue(unaryOperation.operand);
        }
        if (unaryOperation.operator.equals("-")) {
            return this.getNegatedConstantValue(unaryOperation.operand);
        }
        if (unaryOperation.operator.equals("!")) {
            Object object = this.getConstantValue(unaryOperation.operand);
            return object instanceof Boolean ? (((Boolean)object).booleanValue() ? Boolean.FALSE : Boolean.TRUE) : null;
        }
        return null;
    }

    private Java.ClassDeclaration getDeclaringClass(Java.QualifiedThisReference qualifiedThisReference) throws CompileException {
        if (qualifiedThisReference.declaringClass == null) {
            this.getDeclaringTypeBodyDeclaration(qualifiedThisReference);
        }
        return qualifiedThisReference.declaringClass;
    }

    private Java.TypeBodyDeclaration getDeclaringTypeBodyDeclaration(Java.QualifiedThisReference qualifiedThisReference) throws CompileException {
        if (qualifiedThisReference.declaringTypeBodyDeclaration == null) {
            Java.Scope scope = qualifiedThisReference.scope;
            while (!(scope instanceof Java.TypeBodyDeclaration)) {
                scope = scope.getEnclosingScope();
            }
            qualifiedThisReference.declaringTypeBodyDeclaration = (Java.TypeBodyDeclaration)scope;
            if (qualifiedThisReference.declaringTypeBodyDeclaration.isStatic()) {
                this.compileError("No current instance available in static method", qualifiedThisReference.getLocation());
            }
            qualifiedThisReference.declaringClass = (Java.ClassDeclaration)qualifiedThisReference.declaringTypeBodyDeclaration.getDeclaringType();
        }
        return qualifiedThisReference.declaringTypeBodyDeclaration;
    }

    private IClass getIClass(Java.ThisReference thisReference) throws CompileException {
        if (thisReference.iClass == null) {
            Java.Scope scope = thisReference.scope;
            while (scope instanceof Java.Statement) {
                scope = scope.getEnclosingScope();
            }
            if (scope instanceof Java.FunctionDeclarator) {
                Java.FunctionDeclarator functionDeclarator = (Java.FunctionDeclarator)scope;
                if ((functionDeclarator.modifiers & 8) != 0) {
                    this.compileError("No current instance available in static method", thisReference.getLocation());
                }
            }
            while (!(scope instanceof Java.TypeDeclaration)) {
                scope = scope.getEnclosingScope();
            }
            if (!(scope instanceof Java.ClassDeclaration)) {
                this.compileError("Only methods of classes can have a current instance", thisReference.getLocation());
            }
            thisReference.iClass = this.resolve((Java.ClassDeclaration)scope);
        }
        return thisReference.iClass;
    }

    IClass.IField[] getIFields(final Java.FieldDeclaration fieldDeclaration) {
        IClass.IField[] iFieldArray = new IClass.IField[fieldDeclaration.variableDeclarators.length];
        int n = 0;
        while (n < iFieldArray.length) {
            final Java.VariableDeclarator variableDeclarator = fieldDeclaration.variableDeclarators[n];
            iFieldArray[n] = new IClass.IField(this.resolve(fieldDeclaration.declaringType)){

                public Access getAccess() {
                    switch (fieldDeclaration.modifiers & 7) {
                        case 2: {
                            return Access.PRIVATE;
                        }
                        case 4: {
                            return Access.PROTECTED;
                        }
                        case 0: {
                            return Access.DEFAULT;
                        }
                        case 1: {
                            return Access.PUBLIC;
                        }
                    }
                    throw new RuntimeException("Invalid access");
                }

                public Object getConstantValue() throws CompileException {
                    Object object;
                    if ((fieldDeclaration.modifiers & 0x10) != 0 && variableDeclarator.optionalInitializer != null && (object = this.getConstantValue(variableDeclarator.optionalInitializer)) != null) {
                        return this.assignmentConversion(variableDeclarator.optionalInitializer, object, this.getType());
                    }
                    return null;
                }

                public String getName() {
                    return variableDeclarator.name;
                }

                public IClass getType() throws CompileException {
                    IClass iClass = this.getType(fieldDeclaration.type);
                    return this.getArrayType(iClass, variableDeclarator.brackets);
                }

                public boolean isStatic() {
                    return (fieldDeclaration.modifiers & 8) != 0;
                }
            };
            ++n;
        }
        return iFieldArray;
    }

    private void getIMethods(IClass iClass, String string, List list) throws CompileException {
        IClass.IMethod[] iMethodArray = iClass.getDeclaredIMethods(string);
        int n = 0;
        while (n < iMethodArray.length) {
            list.add(iMethodArray[n]);
            ++n;
        }
        IClass iClass2 = iClass.getSuperclass();
        if (iClass2 != null) {
            this.getIMethods(iClass2, string, list);
        }
        IClass[] iClassArray = iClass.getInterfaces();
        int n2 = 0;
        while (n2 < iClassArray.length) {
            this.getIMethods(iClassArray[n2], string, list);
            ++n2;
        }
        if (iClass2 == null && iClassArray.length == 0 && iClass.isInterface()) {
            IClass.IMethod[] iMethodArray2 = this.iClassLoader.OBJECT.getDeclaredIMethods(string);
            int n3 = 0;
            while (n3 < iMethodArray2.length) {
                IClass.IMethod iMethod = iMethodArray2[n3];
                if (!iMethod.isStatic() && iMethod.getAccess() == Access.PUBLIC) {
                    list.add(iMethod);
                }
                ++n3;
            }
        }
    }

    private final Object getNegatedConstantValue(Java.Rvalue rvalue) throws CompileException {
        final Object[] objectArray = new Object[1];
        Visitor.RvalueVisitor rvalueVisitor = new Visitor.RvalueVisitor(){

            public void visitAmbiguousName(Java.AmbiguousName ambiguousName) {
                objectArray[0] = this.getNegatedConstantValue2(ambiguousName);
            }

            public void visitArrayAccessExpression(Java.ArrayAccessExpression arrayAccessExpression) {
                objectArray[0] = this.getNegatedConstantValue2(arrayAccessExpression);
            }

            public void visitArrayInitializer(Java.ArrayInitializer arrayInitializer) {
                objectArray[0] = this.getNegatedConstantValue2(arrayInitializer);
            }

            public void visitArrayLength(Java.ArrayLength arrayLength) {
                objectArray[0] = this.getNegatedConstantValue2(arrayLength);
            }

            public void visitAssignment(Java.Assignment assignment) {
                objectArray[0] = this.getNegatedConstantValue2(assignment);
            }

            public void visitBinaryOperation(Java.BinaryOperation binaryOperation) {
                objectArray[0] = this.getNegatedConstantValue2(binaryOperation);
            }

            public void visitCast(Java.Cast cast) {
                objectArray[0] = this.getNegatedConstantValue2(cast);
            }

            public void visitClassLiteral(Java.ClassLiteral classLiteral) {
                objectArray[0] = this.getNegatedConstantValue2(classLiteral);
            }

            public void visitConditionalExpression(Java.ConditionalExpression conditionalExpression) {
                objectArray[0] = this.getNegatedConstantValue2(conditionalExpression);
            }

            public void visitConstantValue(Java.ConstantValue constantValue) {
                objectArray[0] = this.getNegatedConstantValue2(constantValue);
            }

            public void visitCrement(Java.Crement crement) {
                objectArray[0] = this.getNegatedConstantValue2(crement);
            }

            public void visitFieldAccess(Java.FieldAccess fieldAccess) {
                objectArray[0] = this.getNegatedConstantValue2(fieldAccess);
            }

            public void visitFieldAccessExpression(Java.FieldAccessExpression fieldAccessExpression) {
                objectArray[0] = this.getNegatedConstantValue2(fieldAccessExpression);
            }

            public void visitInstanceof(Java.Instanceof instanceof_) {
                objectArray[0] = this.getNegatedConstantValue2(instanceof_);
            }

            public void visitLiteral(Java.Literal literal) {
                try {
                    objectArray[0] = this.getNegatedConstantValue2(literal);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitLocalVariableAccess(Java.LocalVariableAccess localVariableAccess) {
                objectArray[0] = this.getNegatedConstantValue2(localVariableAccess);
            }

            public void visitMethodInvocation(Java.MethodInvocation methodInvocation) {
                objectArray[0] = this.getNegatedConstantValue2(methodInvocation);
            }

            public void visitNewAnonymousClassInstance(Java.NewAnonymousClassInstance newAnonymousClassInstance) {
                objectArray[0] = this.getNegatedConstantValue2(newAnonymousClassInstance);
            }

            public void visitNewArray(Java.NewArray newArray) {
                objectArray[0] = this.getNegatedConstantValue2(newArray);
            }

            public void visitNewClassInstance(Java.NewClassInstance newClassInstance) {
                objectArray[0] = this.getNegatedConstantValue2(newClassInstance);
            }

            public void visitParameterAccess(Java.ParameterAccess parameterAccess) {
                objectArray[0] = this.getNegatedConstantValue2(parameterAccess);
            }

            public void visitParenthesizedExpression(Java.ParenthesizedExpression parenthesizedExpression) {
                try {
                    objectArray[0] = this.getNegatedConstantValue2(parenthesizedExpression);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitQualifiedThisReference(Java.QualifiedThisReference qualifiedThisReference) {
                objectArray[0] = this.getNegatedConstantValue2(qualifiedThisReference);
            }

            public void visitSuperclassMethodInvocation(Java.SuperclassMethodInvocation superclassMethodInvocation) {
                objectArray[0] = this.getNegatedConstantValue2(superclassMethodInvocation);
            }

            public void visitThisReference(Java.ThisReference thisReference) {
                objectArray[0] = this.getNegatedConstantValue2(thisReference);
            }

            public void visitUnaryOperation(Java.UnaryOperation unaryOperation) {
                try {
                    objectArray[0] = this.getNegatedConstantValue2(unaryOperation);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }
        };
        try {
            rvalue.accept(rvalueVisitor);
            return objectArray[0];
        }
        catch (TunnelException tunnelException) {
            throw (CompileException)tunnelException.getDelegate();
        }
    }

    Object getNegatedConstantValue2(Java.Literal literal) throws CompileException {
        if (literal.value instanceof Integer) {
            return new Integer(-((Integer)literal.value).intValue());
        }
        if (literal.value instanceof Long) {
            return new Long(-((Long)literal.value).longValue());
        }
        if (literal.value instanceof Float) {
            return new Float(-((Float)literal.value).floatValue());
        }
        if (literal.value instanceof Double) {
            return new Double(-((Double)literal.value).doubleValue());
        }
        this.compileError("Cannot negate this literal", literal.getLocation());
        return null;
    }

    Object getNegatedConstantValue2(Java.ParenthesizedExpression parenthesizedExpression) throws CompileException {
        return this.getNegatedConstantValue(parenthesizedExpression.value);
    }

    Object getNegatedConstantValue2(Java.Rvalue rvalue) {
        return null;
    }

    Object getNegatedConstantValue2(Java.UnaryOperation unaryOperation) throws CompileException {
        return unaryOperation.operator.equals("+") ? this.getNegatedConstantValue(unaryOperation.operand) : (unaryOperation.operator.equals("-") ? this.getConstantValue(unaryOperation.operand) : null);
    }

    Java.Rvalue getNonConstantFinalInitializer(Java.FieldDeclaration fieldDeclaration, Java.VariableDeclarator variableDeclarator) throws CompileException {
        if (variableDeclarator.optionalInitializer == null) {
            return null;
        }
        if ((fieldDeclaration.modifiers & 8) != 0 && (fieldDeclaration.modifiers & 0x10) != 0 && this.getConstantValue(variableDeclarator.optionalInitializer) != null) {
            return null;
        }
        return variableDeclarator.optionalInitializer;
    }

    static Java.TypeDeclaration getOuterClass(Java.TypeDeclaration typeDeclaration) {
        if (typeDeclaration instanceof Java.PackageMemberClassDeclaration) {
            return null;
        }
        if (typeDeclaration instanceof Java.LocalClassDeclaration) {
            Java.Scope scope = typeDeclaration.getEnclosingScope();
            while (!(scope instanceof Java.FunctionDeclarator)) {
                scope = scope.getEnclosingScope();
            }
            boolean bl = scope instanceof Java.MethodDeclarator && (((Java.FunctionDeclarator)scope).modifiers & 8) != 0;
            while (!(scope instanceof Java.TypeDeclaration)) {
                scope = scope.getEnclosingScope();
            }
            Java.TypeDeclaration typeDeclaration2 = (Java.TypeDeclaration)scope;
            return typeDeclaration2 instanceof Java.ClassDeclaration && !bl ? typeDeclaration2 : null;
        }
        if (typeDeclaration instanceof Java.MemberClassDeclaration && (((Java.MemberClassDeclaration)typeDeclaration).modifiers & 8) != 0) {
            return null;
        }
        Java.Scope scope = typeDeclaration;
        while (!(scope instanceof Java.TypeBodyDeclaration)) {
            if (scope instanceof Java.CompilationUnit) {
                return null;
            }
            scope = scope.getEnclosingScope();
        }
        if (((Java.TypeBodyDeclaration)scope).isStatic()) {
            return null;
        }
        return (Java.AbstractTypeDeclaration)scope.getEnclosingScope();
    }

    private static List getOuterClasses(Java.TypeDeclaration typeDeclaration) {
        ArrayList<Java.TypeDeclaration> arrayList = new ArrayList<Java.TypeDeclaration>();
        Java.TypeDeclaration typeDeclaration2 = typeDeclaration;
        while (typeDeclaration2 != null) {
            arrayList.add(typeDeclaration2);
            typeDeclaration2 = UnitCompiler.getOuterClass(typeDeclaration2);
        }
        return arrayList;
    }

    IClass getReturnType(Java.FunctionDeclarator functionDeclarator) throws CompileException {
        if (functionDeclarator.returnType == null) {
            functionDeclarator.returnType = this.getType(functionDeclarator.type);
        }
        return functionDeclarator.returnType;
    }

    private IClass getTargetIClass(Java.QualifiedThisReference qualifiedThisReference) throws CompileException {
        if (qualifiedThisReference.targetIClass == null) {
            qualifiedThisReference.targetIClass = this.getType(qualifiedThisReference.qualification);
        }
        return qualifiedThisReference.targetIClass;
    }

    IClass getType(Java.Atom atom) throws CompileException {
        final IClass[] iClassArray = new IClass[1];
        Visitor.AtomVisitor atomVisitor = new Visitor.AtomVisitor(){

            public void visitAlternateConstructorInvocation(Java.AlternateConstructorInvocation alternateConstructorInvocation) {
                iClassArray[0] = this.getType2(alternateConstructorInvocation);
            }

            public void visitAmbiguousName(Java.AmbiguousName ambiguousName) {
                try {
                    iClassArray[0] = this.getType2(ambiguousName);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitArrayAccessExpression(Java.ArrayAccessExpression arrayAccessExpression) {
                try {
                    iClassArray[0] = this.getType2(arrayAccessExpression);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitArrayInitializer(Java.ArrayInitializer arrayInitializer) {
                try {
                    iClassArray[0] = this.getType2(arrayInitializer);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitArrayLength(Java.ArrayLength arrayLength) {
                iClassArray[0] = this.getType2(arrayLength);
            }

            public void visitArrayType(Java.ArrayType arrayType) {
                try {
                    iClassArray[0] = this.getType2(arrayType);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitAssignment(Java.Assignment assignment) {
                try {
                    iClassArray[0] = this.getType2(assignment);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitBasicType(Java.BasicType basicType) {
                iClassArray[0] = this.getType2(basicType);
            }

            public void visitBinaryOperation(Java.BinaryOperation binaryOperation) {
                try {
                    iClassArray[0] = this.getType2(binaryOperation);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitCast(Java.Cast cast) {
                try {
                    iClassArray[0] = this.getType2(cast);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitClassLiteral(Java.ClassLiteral classLiteral) {
                iClassArray[0] = this.getType2(classLiteral);
            }

            public void visitConditionalExpression(Java.ConditionalExpression conditionalExpression) {
                try {
                    iClassArray[0] = this.getType2(conditionalExpression);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitConstantValue(Java.ConstantValue constantValue) {
                iClassArray[0] = this.getType2(constantValue);
            }

            public void visitCrement(Java.Crement crement) {
                try {
                    iClassArray[0] = this.getType2(crement);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitFieldAccess(Java.FieldAccess fieldAccess) {
                try {
                    iClassArray[0] = this.getType2(fieldAccess);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitFieldAccessExpression(Java.FieldAccessExpression fieldAccessExpression) {
                try {
                    iClassArray[0] = this.getType2(fieldAccessExpression);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitInstanceof(Java.Instanceof instanceof_) {
                iClassArray[0] = this.getType2(instanceof_);
            }

            public void visitLiteral(Java.Literal literal) {
                iClassArray[0] = this.getType2(literal);
            }

            public void visitLocalVariableAccess(Java.LocalVariableAccess localVariableAccess) {
                iClassArray[0] = this.getType2(localVariableAccess);
            }

            public void visitMethodInvocation(Java.MethodInvocation methodInvocation) {
                try {
                    iClassArray[0] = this.getType2(methodInvocation);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitNewAnonymousClassInstance(Java.NewAnonymousClassInstance newAnonymousClassInstance) {
                iClassArray[0] = this.getType2(newAnonymousClassInstance);
            }

            public void visitNewArray(Java.NewArray newArray) {
                try {
                    iClassArray[0] = this.getType2(newArray);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitNewClassInstance(Java.NewClassInstance newClassInstance) {
                try {
                    iClassArray[0] = this.getType2(newClassInstance);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitPackage(Java.Package package_) {
                try {
                    iClassArray[0] = this.getType2(package_);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitParameterAccess(Java.ParameterAccess parameterAccess) {
                iClassArray[0] = this.getType2(parameterAccess);
            }

            public void visitParenthesizedExpression(Java.ParenthesizedExpression parenthesizedExpression) {
                try {
                    iClassArray[0] = this.getType2(parenthesizedExpression);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitQualifiedThisReference(Java.QualifiedThisReference qualifiedThisReference) {
                try {
                    iClassArray[0] = this.getType2(qualifiedThisReference);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitReferenceType(Java.ReferenceType referenceType) {
                try {
                    iClassArray[0] = this.getType2(referenceType);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitRvalueMemberType(Java.RvalueMemberType rvalueMemberType) {
                try {
                    iClassArray[0] = this.getType2(rvalueMemberType);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitSimpleType(Java.SimpleType simpleType) {
                iClassArray[0] = this.getType2(simpleType);
            }

            public void visitSuperConstructorInvocation(Java.SuperConstructorInvocation superConstructorInvocation) {
                iClassArray[0] = this.getType2(superConstructorInvocation);
            }

            public void visitSuperclassMethodInvocation(Java.SuperclassMethodInvocation superclassMethodInvocation) {
                try {
                    iClassArray[0] = this.getType2(superclassMethodInvocation);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitThisReference(Java.ThisReference thisReference) {
                try {
                    iClassArray[0] = this.getType2(thisReference);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitUnaryOperation(Java.UnaryOperation unaryOperation) {
                try {
                    iClassArray[0] = this.getType2(unaryOperation);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }
        };
        try {
            atom.accept(atomVisitor);
            return iClassArray[0] != null ? iClassArray[0] : this.iClassLoader.OBJECT;
        }
        catch (TunnelException tunnelException) {
            throw (CompileException)tunnelException.getDelegate();
        }
    }

    IClass getType2(Java.AmbiguousName ambiguousName) throws CompileException {
        return this.getType(this.reclassify(ambiguousName));
    }

    IClass getType2(Java.ArrayAccessExpression arrayAccessExpression) throws CompileException {
        return this.getType(arrayAccessExpression.lhs).getComponentType();
    }

    IClass getType2(Java.ArrayInitializer arrayInitializer) throws CompileException {
        return this.getType(arrayInitializer.arrayType);
    }

    IClass getType2(Java.ArrayLength arrayLength) {
        return IClass.INT;
    }

    IClass getType2(Java.ArrayType arrayType) throws CompileException {
        return this.getArrayType(this.getType(arrayType.componentType));
    }

    IClass getType2(Java.Assignment assignment) throws CompileException {
        return this.getType(assignment.lhs);
    }

    IClass getType2(Java.BasicType basicType) {
        switch (basicType.index) {
            case 0: {
                return IClass.VOID;
            }
            case 1: {
                return IClass.BYTE;
            }
            case 2: {
                return IClass.SHORT;
            }
            case 3: {
                return IClass.CHAR;
            }
            case 4: {
                return IClass.INT;
            }
            case 5: {
                return IClass.LONG;
            }
            case 6: {
                return IClass.FLOAT;
            }
            case 7: {
                return IClass.DOUBLE;
            }
            case 8: {
                return IClass.BOOLEAN;
            }
        }
        throw new RuntimeException("Invalid index " + basicType.index);
    }

    IClass getType2(Java.BinaryOperation binaryOperation) throws CompileException {
        if (binaryOperation.op == "||" || binaryOperation.op == "&&" || binaryOperation.op == "==" || binaryOperation.op == "!=" || binaryOperation.op == "<" || binaryOperation.op == ">" || binaryOperation.op == "<=" || binaryOperation.op == ">=") {
            return IClass.BOOLEAN;
        }
        if (binaryOperation.op == "|" || binaryOperation.op == "^" || binaryOperation.op == "&") {
            return this.getType(binaryOperation.lhs) == IClass.BOOLEAN ? IClass.BOOLEAN : this.binaryNumericPromotionType(binaryOperation, this.getType(binaryOperation.lhs), this.getType(binaryOperation.rhs));
        }
        if (binaryOperation.op == "*" || binaryOperation.op == "/" || binaryOperation.op == "%" || binaryOperation.op == "+" || binaryOperation.op == "-") {
            IClassLoader iClassLoader = this.iClassLoader;
            Iterator iterator = binaryOperation.unrollLeftAssociation();
            IClass iClass = this.getType((Java.Rvalue)iterator.next());
            if (binaryOperation.op == "+" && iClass == iClassLoader.STRING) {
                return iClassLoader.STRING;
            }
            do {
                IClass iClass2 = this.getType((Java.Rvalue)iterator.next());
                if (binaryOperation.op == "+" && iClass2 == iClassLoader.STRING) {
                    return iClassLoader.STRING;
                }
                iClass = this.binaryNumericPromotionType(binaryOperation, iClass, iClass2);
            } while (iterator.hasNext());
            return iClass;
        }
        if (binaryOperation.op == "<<" || binaryOperation.op == ">>" || binaryOperation.op == ">>>") {
            IClass iClass = this.getType(binaryOperation.lhs);
            return this.unaryNumericPromotionType(binaryOperation, iClass);
        }
        this.compileError("Unexpected operator \"" + binaryOperation.op + "\"", binaryOperation.getLocation());
        return this.iClassLoader.OBJECT;
    }

    IClass getType2(Java.Cast cast) throws CompileException {
        return this.getType(cast.targetType);
    }

    IClass getType2(Java.ClassLiteral classLiteral) {
        return this.iClassLoader.CLASS;
    }

    IClass getType2(Java.ConditionalExpression conditionalExpression) throws CompileException {
        return this.getType(conditionalExpression.mhs);
    }

    IClass getType2(Java.ConstantValue constantValue) {
        IClass iClass;
        IClass iClass2 = constantValue.constantValue instanceof Integer ? IClass.INT : (constantValue.constantValue instanceof Long ? IClass.LONG : (constantValue.constantValue instanceof Float ? IClass.FLOAT : (constantValue.constantValue instanceof Double ? IClass.DOUBLE : (constantValue.constantValue instanceof String ? this.iClassLoader.STRING : (constantValue.constantValue instanceof Character ? IClass.CHAR : (constantValue.constantValue instanceof Boolean ? IClass.BOOLEAN : (iClass = constantValue.constantValue == Java.Rvalue.CONSTANT_VALUE_NULL ? IClass.VOID : null)))))));
        if (iClass == null) {
            throw new RuntimeException();
        }
        return iClass;
    }

    IClass getType2(Java.ConstructorInvocation constructorInvocation) {
        throw new RuntimeException();
    }

    IClass getType2(Java.Crement crement) throws CompileException {
        return this.getType(crement.operand);
    }

    IClass getType2(Java.FieldAccess fieldAccess) throws CompileException {
        return fieldAccess.field.getType();
    }

    IClass getType2(Java.FieldAccessExpression fieldAccessExpression) throws CompileException {
        this.determineValue(fieldAccessExpression);
        return this.getType(fieldAccessExpression.value);
    }

    IClass getType2(Java.Instanceof instanceof_) {
        return IClass.BOOLEAN;
    }

    IClass getType2(Java.Literal literal) {
        if (literal.value instanceof Integer) {
            return IClass.INT;
        }
        if (literal.value instanceof Long) {
            return IClass.LONG;
        }
        if (literal.value instanceof Float) {
            return IClass.FLOAT;
        }
        if (literal.value instanceof Double) {
            return IClass.DOUBLE;
        }
        if (literal.value instanceof String) {
            return this.iClassLoader.STRING;
        }
        if (literal.value instanceof Character) {
            return IClass.CHAR;
        }
        if (literal.value instanceof Boolean) {
            return IClass.BOOLEAN;
        }
        if (literal.value == null) {
            return IClass.VOID;
        }
        throw new RuntimeException();
    }

    IClass getType2(Java.LocalVariableAccess localVariableAccess) {
        return localVariableAccess.localVariable.type;
    }

    IClass getType2(Java.MethodInvocation methodInvocation) throws CompileException {
        if (methodInvocation.iMethod == null) {
            methodInvocation.iMethod = this.findIMethod(methodInvocation);
        }
        return methodInvocation.iMethod.getReturnType();
    }

    IClass getType2(Java.NewAnonymousClassInstance newAnonymousClassInstance) {
        return this.resolve(newAnonymousClassInstance.anonymousClassDeclaration);
    }

    IClass getType2(Java.NewArray newArray) throws CompileException {
        IClass iClass = this.getType(newArray.type);
        return this.getArrayType(iClass, newArray.dimExprs.length + newArray.dims);
    }

    IClass getType2(Java.NewClassInstance newClassInstance) throws CompileException {
        if (newClassInstance.iClass == null) {
            newClassInstance.iClass = this.getType(newClassInstance.type);
        }
        return newClassInstance.iClass;
    }

    IClass getType2(Java.Package package_) throws CompileException {
        this.compileError("Unknown variable or type \"" + package_.name + "\"", package_.getLocation());
        return this.iClassLoader.OBJECT;
    }

    IClass getType2(Java.ParameterAccess parameterAccess) {
        return ((Java.LocalVariable)parameterAccess.declaringFunction.parameters.get((Object)parameterAccess.name)).type;
    }

    IClass getType2(Java.ParenthesizedExpression parenthesizedExpression) throws CompileException {
        return this.getType(parenthesizedExpression.value);
    }

    IClass getType2(Java.QualifiedThisReference qualifiedThisReference) throws CompileException {
        return this.getTargetIClass(qualifiedThisReference);
    }

    IClass getType2(Java.ReferenceType referenceType) throws CompileException {
        Java.TypeDeclaration typeDeclaration = null;
        Java.Scope scope = referenceType.scope;
        if (scope instanceof Java.Statement) {
            scope = scope.getEnclosingScope();
            while (scope instanceof Java.Statement) {
                scope = scope.getEnclosingScope();
            }
        }
        if (scope instanceof Java.FunctionDeclarator) {
            scope = scope.getEnclosingScope();
        }
        if (scope instanceof Java.TypeDeclaration) {
            typeDeclaration = (Java.TypeDeclaration)scope;
        }
        while (!(scope instanceof Java.CompilationUnit)) {
            scope = scope.getEnclosingScope();
        }
        Java.CompilationUnit compilationUnit = (Java.CompilationUnit)scope;
        if (referenceType.identifiers.length == 1) {
            IClass iClass;
            Object object;
            IClass iClass2;
            Java.Scope scope2;
            String string = referenceType.identifiers[0];
            Java.Scope scope3 = referenceType.scope;
            while (scope3 != null) {
                if (scope3 instanceof Java.Block && (scope2 = ((Java.Block)scope3).getLocalClassDeclaration(string)) != null) {
                    return this.resolve((Java.TypeDeclaration)scope2);
                }
                scope3 = scope3.getEnclosingScope();
            }
            scope2 = typeDeclaration;
            while (scope2 != null) {
                if (scope2 instanceof Java.TypeDeclaration && (iClass2 = this.findMemberType(this.resolve((Java.AbstractTypeDeclaration)scope2), string, referenceType.getLocation())) != null) {
                    return iClass2;
                }
                scope2 = scope2.getEnclosingScope();
            }
            if (compilationUnit != null) {
                iClass2 = this.importSingleType(string, referenceType.getLocation());
                if (iClass2 != null) {
                    return iClass2;
                }
                object = compilationUnit.getPackageMemberTypeDeclaration(string);
                if (object != null) {
                    return this.resolve((Java.AbstractTypeDeclaration)object);
                }
            }
            if ((iClass = ((IClassLoader)(object = this.iClassLoader)).loadIClass(Descriptor.fromClassName((iClass2 = compilationUnit.optionalPackageDeclaration == null ? null : compilationUnit.optionalPackageDeclaration.packageName) == null ? string : String.valueOf(iClass2) + "." + string))) != null) {
                return iClass;
            }
            IClass iClass3 = this.importTypeOnDemand(string, referenceType.getLocation());
            if (iClass3 != null) {
                return iClass3;
            }
            this.compileError("Cannot determine simple type name \"" + string + "\"", referenceType.getLocation());
            return this.iClassLoader.OBJECT;
        }
        Java.Atom atom = this.reclassifyName(referenceType.getLocation(), referenceType.scope, referenceType.identifiers, referenceType.identifiers.length - 1);
        String string = atom instanceof Java.Package ? Java.join(referenceType.identifiers, ".") : String.valueOf(Descriptor.toClassName(this.getType(this.toTypeOrCE(atom)).getDescriptor())) + '$' + referenceType.identifiers[referenceType.identifiers.length - 1];
        IClass iClass = this.iClassLoader.loadIClass(Descriptor.fromClassName(string));
        if (iClass != null) {
            return iClass;
        }
        this.compileError("Class \"" + string + "\" not found", referenceType.getLocation());
        return this.iClassLoader.OBJECT;
    }

    IClass getType2(Java.RvalueMemberType rvalueMemberType) throws CompileException {
        IClass iClass = this.getType(rvalueMemberType.rvalue);
        IClass iClass2 = this.findMemberType(iClass, rvalueMemberType.identifier, rvalueMemberType.getLocation());
        if (iClass2 == null) {
            this.compileError("\"" + iClass + "\" has no member type \"" + rvalueMemberType.identifier + "\"", rvalueMemberType.getLocation());
        }
        return iClass2;
    }

    IClass getType2(Java.SimpleType simpleType) {
        return simpleType.iClass;
    }

    IClass getType2(Java.SuperclassMethodInvocation superclassMethodInvocation) throws CompileException {
        return this.findIMethod(superclassMethodInvocation).getReturnType();
    }

    IClass getType2(Java.ThisReference thisReference) throws CompileException {
        return this.getIClass(thisReference);
    }

    IClass getType2(Java.UnaryOperation unaryOperation) throws CompileException {
        if (unaryOperation.operator == "!") {
            return IClass.BOOLEAN;
        }
        if (unaryOperation.operator == "+") {
            return this.getType(unaryOperation.operand);
        }
        if (unaryOperation.operator == "-" || unaryOperation.operator == "~") {
            return this.unaryNumericPromotionType(unaryOperation, this.getType(unaryOperation.operand));
        }
        this.compileError("Unexpected operator \"" + unaryOperation.operator + "\"", unaryOperation.getLocation());
        return IClass.BOOLEAN;
    }

    public CodeContext.Offset getWhereToBreak(Java.BreakableStatement breakableStatement) {
        if (breakableStatement.whereToBreak == null) {
            breakableStatement.whereToBreak = this.codeContext.new CodeContext.Offset();
        }
        return breakableStatement.whereToBreak;
    }

    static int ilfd(IClass iClass) {
        if (iClass == IClass.BYTE || iClass == IClass.CHAR || iClass == IClass.INT || iClass == IClass.SHORT || iClass == IClass.BOOLEAN) {
            return 0;
        }
        if (iClass == IClass.LONG) {
            return 1;
        }
        if (iClass == IClass.FLOAT) {
            return 2;
        }
        if (iClass == IClass.DOUBLE) {
            return 3;
        }
        throw new RuntimeException("Unexpected type \"" + iClass + "\"");
    }

    static int ilfd(IClass iClass, int n, int n2, int n3, int n4) {
        if (iClass == IClass.BYTE || iClass == IClass.CHAR || iClass == IClass.INT || iClass == IClass.SHORT || iClass == IClass.BOOLEAN) {
            return n;
        }
        if (iClass == IClass.LONG) {
            return n2;
        }
        if (iClass == IClass.FLOAT) {
            return n3;
        }
        if (iClass == IClass.DOUBLE) {
            return n4;
        }
        throw new RuntimeException("Unexpected type \"" + iClass + "\"");
    }

    private int ilfda(IClass iClass) {
        return !iClass.isPrimitive() ? 4 : UnitCompiler.ilfd(iClass);
    }

    static int ilfdabcs(IClass iClass) {
        if (iClass == IClass.INT) {
            return 0;
        }
        if (iClass == IClass.LONG) {
            return 1;
        }
        if (iClass == IClass.FLOAT) {
            return 2;
        }
        if (iClass == IClass.DOUBLE) {
            return 3;
        }
        if (!iClass.isPrimitive()) {
            return 4;
        }
        if (iClass == IClass.BOOLEAN || iClass == IClass.BYTE) {
            return 5;
        }
        if (iClass == IClass.CHAR) {
            return 6;
        }
        if (iClass == IClass.SHORT) {
            return 7;
        }
        throw new RuntimeException("Unexpected type \"" + iClass + "\"");
    }

    private IClass importSingleType(String string, Location location) throws CompileException {
        Object[] objectArray = this.compilationUnit.getSingleTypeImport(string);
        if (objectArray == null) {
            return null;
        }
        IClass iClass = this.loadFullyQualifiedClass((String[])objectArray);
        if (iClass == null) {
            this.compileError("Imported class \"" + Java.join(objectArray, ".") + "\" could not be loaded", location);
            return this.iClassLoader.OBJECT;
        }
        return iClass;
    }

    public IClass importTypeOnDemand(String string, Location location) throws CompileException {
        Object object;
        IClass iClass = (IClass)this.onDemandImportableTypes.get(string);
        if (iClass != null) {
            return iClass;
        }
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        arrayList.add(new String[]{"java", "lang"});
        Iterator iterator = this.compilationUnit.importDeclarations.iterator();
        while (iterator.hasNext()) {
            object = (Java.ImportDeclaration)iterator.next();
            if (!(object instanceof Java.TypeImportOnDemandDeclaration)) continue;
            arrayList.add(((Java.TypeImportOnDemandDeclaration)object).identifiers);
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            String[] stringArray = (String[])object.next();
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray2[stringArray.length] = string;
            IClass iClass2 = this.loadFullyQualifiedClass(stringArray2);
            if (iClass2 == null) continue;
            if (iClass != null && iClass != iClass2) {
                this.compileError("Ambiguous class name: \"" + iClass + "\" vs. \"" + iClass2 + "\"", location);
            }
            iClass = iClass2;
        }
        if (iClass == null) {
            return null;
        }
        this.onDemandImportableTypes.put(string, iClass);
        return iClass;
    }

    void initializeInstanceVariablesAndInvokeInstanceInitializers(Java.ConstructorDeclarator constructorDeclarator) throws CompileException {
        Iterator iterator = constructorDeclarator.declaringClass.variableDeclaratorsAndInitializers.iterator();
        while (iterator.hasNext()) {
            Java.BlockStatement blockStatement;
            Java.TypeBodyDeclaration typeBodyDeclaration = (Java.TypeBodyDeclaration)iterator.next();
            if (typeBodyDeclaration.isStatic() || this.compile(blockStatement = (Java.BlockStatement)((Object)typeBodyDeclaration))) continue;
            this.compileError("Instance variable declarator or instance initializer does not complete normally", blockStatement.getLocation());
        }
    }

    private void invokeConstructor(Java.Located located, Java.Scope scope, Java.Rvalue rvalue, IClass iClass, Java.Rvalue[] rvalueArray) throws CompileException {
        int n;
        IClass[] iClassArray;
        Object object;
        IClass.IInvocable[] iInvocableArray = iClass.getDeclaredIConstructors();
        if (iInvocableArray.length == 0) {
            throw new RuntimeException();
        }
        IClass.IConstructor iConstructor = (IClass.IConstructor)this.findMostSpecificIInvocable(located, iInvocableArray, rvalueArray);
        IClass[] iClassArray2 = iConstructor.getThrownExceptions();
        int n2 = 0;
        while (n2 < iClassArray2.length) {
            this.checkThrownException(located, iClassArray2[n2], scope);
            ++n2;
        }
        IClass iClass2 = iClass.getOuterIClass();
        if (iClass2 != null) {
            if (rvalue == null) {
                this.compileError("Enclosing instance for initialization of inner class \"" + iClass + "\" missing", located.getLocation());
            }
            if (!iClass2.isAssignableFrom((IClass)(object = this.compileGetValue(rvalue)))) {
                this.compileError("Type of enclosing instance (\"" + object + "\") is not assignable to \"" + iClass2 + "\"", located.getLocation());
            }
        }
        object = iClass.getSyntheticIFields();
        Java.Scope scope2 = scope;
        while (!(scope2 instanceof Java.TypeBodyDeclaration)) {
            scope2 = scope2.getEnclosingScope();
        }
        Java.TypeBodyDeclaration typeBodyDeclaration = (Java.TypeBodyDeclaration)scope2;
        Java.TypeDeclaration typeDeclaration = typeBodyDeclaration.getDeclaringType();
        if (!(typeDeclaration instanceof Java.ClassDeclaration)) {
            if (((IClass.IField[])object).length > 0) {
                throw new RuntimeException();
            }
        } else {
            iClassArray = (IClass[])typeDeclaration;
            n = 0;
            while (n < ((IClass.IField[])object).length) {
                IClass.IField iField = object[n];
                if (iField.getName().startsWith("val$")) {
                    Java.LocalVariable localVariable;
                    Object object2;
                    IClass.IField iField2 = (IClass.IField)iClassArray.syntheticFields.get(iField.getName());
                    if (iField2 != null) {
                        if (typeBodyDeclaration instanceof Java.MethodDeclarator) {
                            this.load(located, this.resolve((Java.TypeDeclaration)iClassArray), 0);
                            this.writeOpcode(located, -76);
                            this.writeConstantFieldrefInfo(located, this.resolve((Java.TypeDeclaration)iClassArray).getDescriptor(), iField.getName(), iField.getDescriptor());
                        } else if (typeBodyDeclaration instanceof Java.ConstructorDeclarator) {
                            object2 = (Java.ConstructorDeclarator)typeBodyDeclaration;
                            localVariable = (Java.LocalVariable)((Java.ConstructorDeclarator)object2).syntheticParameters.get(iField.getName());
                            if (localVariable == null) {
                                this.compileError("Compiler limitation: Constructor cannot access local variable \"" + iField.getName().substring(4) + "\" declared in an enclosing block because none of the methods accesses it. As a workaround, declare a dummy method that accesses the local variable.", located.getLocation());
                                this.writeOpcode(located, 1);
                            } else {
                                this.load(located, localVariable);
                            }
                        } else {
                            this.compileError("Compiler limitation: Initializers cannot access local variables declared in an enclosing block.", located.getLocation());
                            this.writeOpcode(located, 1);
                        }
                    } else {
                        object2 = iField.getName().substring(4);
                        localVariable = null;
                        Java.Scope scope3 = scope;
                        while (scope3 instanceof Java.Block) {
                            localVariable = (Java.LocalVariable)((Java.Block)scope3).localVariables.get(object2);
                            if (localVariable != null) break;
                            scope3 = scope3.getEnclosingScope();
                        }
                        if (localVariable == null) {
                            while (!(scope3 instanceof Java.FunctionDeclarator)) {
                                scope3 = scope3.getEnclosingScope();
                            }
                            Java.FunctionDeclarator functionDeclarator = (Java.FunctionDeclarator)scope3;
                            localVariable = (Java.LocalVariable)functionDeclarator.parameters.get(object2);
                        }
                        if (localVariable == null) {
                            throw new RuntimeException("SNO: Synthetic field \"" + iField.getName() + "\" neither maps a synthetic field of an enclosing instance nor a local variable");
                        }
                        this.load(located, localVariable);
                    }
                }
                ++n;
            }
        }
        iClassArray = iConstructor.getParameterTypes();
        n = 0;
        while (n < rvalueArray.length) {
            this.assignmentConversion(located, this.compileGetValue(rvalueArray[n]), iClassArray[n], this.getConstantValue(rvalueArray[n]));
            ++n;
        }
        this.writeOpcode(located, -73);
        this.writeConstantMethodrefInfo(located, iClass.getDescriptor(), "<init>", iConstructor.getDescriptor());
    }

    private boolean isConstantPrimitiveAssignmentConvertible(Object object, IClass iClass) {
        int n;
        if (object instanceof Byte || object instanceof Short || object instanceof Integer) {
            n = ((Number)object).intValue();
        } else if (object instanceof Character) {
            n = ((Character)object).charValue();
        } else {
            return false;
        }
        if (iClass == IClass.BYTE) {
            return n >= -128 && n <= 127;
        }
        if (iClass == IClass.SHORT) {
            return n >= Short.MIN_VALUE && n <= Short.MAX_VALUE;
        }
        if (iClass == IClass.CHAR) {
            return n >= 0 && n <= 65535;
        }
        return false;
    }

    Java.LocalVariable isIntLV(Java.Crement crement) throws CompileException {
        if (!(crement.operand instanceof Java.AmbiguousName)) {
            return null;
        }
        Java.AmbiguousName ambiguousName = (Java.AmbiguousName)crement.operand;
        Java.Atom atom = this.reclassify(ambiguousName);
        if (!(atom instanceof Java.LocalVariableAccess)) {
            return null;
        }
        Java.LocalVariableAccess localVariableAccess = (Java.LocalVariableAccess)atom;
        Java.LocalVariable localVariable = localVariableAccess.localVariable;
        if (localVariable.finaL) {
            this.compileError("Must not increment or decrement \"final\" local variable", localVariableAccess.getLocation());
        }
        if (localVariable.type == IClass.BYTE || localVariable.type == IClass.SHORT || localVariable.type == IClass.INT || localVariable.type == IClass.CHAR) {
            return localVariable;
        }
        return null;
    }

    private boolean isMethodInvocationConvertible(IClass iClass, IClass iClass2) throws CompileException {
        if (iClass == iClass2) {
            return true;
        }
        if (this.isWideningPrimitiveConvertible(iClass, iClass2)) {
            return true;
        }
        return this.isWideningReferenceConvertible(iClass, iClass2);
    }

    private boolean isNarrowingPrimitiveConvertible(IClass iClass, IClass iClass2) {
        return PRIMITIVE_NARROWING_CONVERSIONS.containsKey(String.valueOf(iClass.getDescriptor()) + iClass2.getDescriptor());
    }

    private boolean isNarrowingReferenceConvertible(IClass iClass, IClass iClass2) throws CompileException {
        IClass iClass3;
        IClass iClass4;
        if (iClass.isPrimitive()) {
            return false;
        }
        if (iClass == iClass2) {
            return false;
        }
        if (iClass.isAssignableFrom(iClass2)) {
            return true;
        }
        if (iClass2.isInterface() && !iClass.isFinal() && !iClass2.isAssignableFrom(iClass)) {
            return true;
        }
        if (iClass == this.iClassLoader.OBJECT && iClass2.isArray()) {
            return true;
        }
        if (iClass == this.iClassLoader.OBJECT && iClass2.isInterface()) {
            return true;
        }
        if (iClass.isInterface() && !iClass2.isFinal()) {
            return true;
        }
        if (iClass.isInterface() && iClass2.isFinal() && iClass.isAssignableFrom(iClass2)) {
            return true;
        }
        if (iClass.isInterface() && iClass2.isInterface() && !iClass2.isAssignableFrom(iClass)) {
            return true;
        }
        return iClass.isArray() && iClass2.isArray() && (this.isNarrowingPrimitiveConvertible(iClass4 = iClass.getComponentType(), iClass3 = iClass2.getComponentType()) || this.isNarrowingReferenceConvertible(iClass4, iClass3));
    }

    private boolean isType(Java.Atom atom) throws CompileException {
        final boolean[] blArray = new boolean[1];
        Visitor.AtomVisitor atomVisitor = new Visitor.AtomVisitor(){

            public void visitAlternateConstructorInvocation(Java.AlternateConstructorInvocation alternateConstructorInvocation) {
                blArray[0] = this.isType2(alternateConstructorInvocation);
            }

            public void visitAmbiguousName(Java.AmbiguousName ambiguousName) {
                try {
                    blArray[0] = this.isType2(ambiguousName);
                }
                catch (CompileException compileException) {
                    throw new TunnelException(compileException);
                }
            }

            public void visitArrayAccessExpression(Java.ArrayAccessExpression arrayAccessExpression) {
                blArray[0] = this.isType2(arrayAccessExpression);
            }

            public void visitArrayInitializer(Java.ArrayInitializer arrayInitializer) {
                blArray[0] = this.isType2(arrayInitializer);
            }

            public void visitArrayLength(Java.ArrayLength arrayLength) {
                blArray[0] = this.isType2(arrayLength);
            }

            public void visitArrayType(Java.ArrayType arrayType) {
                blArray[0] = this.isType2(arrayType);
            }

            public void visitAssignment(Java.Assignment assignment) {
                blArray[0] = this.isType2(assignment);
            }

            public void visitBasicType(Java.BasicType basicType) {
                blArray[0] = this.isType2(basicType);
            }

            public void visitBinaryOperation(Java.BinaryOperation binaryOperation) {
                blArray[0] = this.isType2(binaryOperation);
            }

            public void visitCast(Java.Cast cast) {
                blArray[0] = this.isType2(cast);
            }

            public void visitClassLiteral(Java.ClassLiteral classLiteral) {
                blArray[0] = this.isType2(classLiteral);
            }

            public void visitConditionalExpression(Java.ConditionalExpression conditionalExpression) {
                blArray[0] = this.isType2(conditionalExpression);
            }

            public void visitConstantValue(Java.ConstantValue constantValue) {
                blArray[0] = this.isType2(constantValue);
            }

            public void visitCrement(Java.Crement crement) {
                blArray[0] = this.isType2(crement);
            }

            public void visitFieldAccess(Java.FieldAccess fieldAccess) {
                blArray[0] = this.isType2(fieldAccess);
            }

            public void visitFieldAccessExpression(Java.FieldAccessExpression fieldAccessExpression) {
                blArray[0] = this.isType2(fieldAccessExpression);
            }

            public void visitInstanceof(Java.Instanceof instanceof_) {
                blArray[0] = this.isType2(instanceof_);
            }

            public void visitLiteral(Java.Literal literal) {
                blArray[0] = this.isType2(literal);
            }

            public void visitLocalVariableAccess(Java.LocalVariableAccess localVariableAccess) {
                blArray[0] = this.isType2(localVariableAccess);
            }

            public void visitMethodInvocation(Java.MethodInvocation methodInvocation) {
                blArray[0] = this.isType2(methodInvocation);
            }

            public void visitNewAnonymousClassInstance(Java.NewAnonymousClassInstance newAnonymousClassInstance) {
                blArray[0] = this.isType2(newAnonymousClassInstance);
            }

            public void visitNewArray(Java.NewArray newArray) {
                blArray[0] = this.isType2(newArray);
            }

            public void visitNewClassInstance(Java.NewClassInstance newClassInstance) {
                blArray[0] = this.isType2(newClassInstance);
            }

            public void visitPackage(Java.Package package_) {
                blArray[0] = this.isType2(package_);
            }

            public void visitParameterAccess(Java.ParameterAccess parameterAccess) {
                blArray[0] = this.isType2(parameterAccess);
            }

            public void visitParenthesizedExpression(Java.ParenthesizedExpression parenthesizedExpression) {
                blArray[0] = this.isType2(parenthesizedExpression);
            }

            public void visitQualifiedThisReference(Java.QualifiedThisReference qualifiedThisReference) {
                blArray[0] = this.isType2(qualifiedThisReference);
            }

            public void visitReferenceType(Java.ReferenceType referenceType) {
                blArray[0] = this.isType2(referenceType);
            }

            public void visitRvalueMemberType(Java.RvalueMemberType rvalueMemberType) {
                blArray[0] = this.isType2(rvalueMemberType);
            }

            public void visitSimpleType(Java.SimpleType simpleType) {
                blArray[0] = this.isType2(simpleType);
            }

            public void visitSuperConstructorInvocation(Java.SuperConstructorInvocation superConstructorInvocation) {
                blArray[0] = this.isType2(superConstructorInvocation);
            }

            public void visitSuperclassMethodInvocation(Java.SuperclassMethodInvocation superclassMethodInvocation) {
                blArray[0] = this.isType2(superclassMethodInvocation);
            }

            public void visitThisReference(Java.ThisReference thisReference) {
                blArray[0] = this.isType2(thisReference);
            }

            public void visitUnaryOperation(Java.UnaryOperation unaryOperation) {
                blArray[0] = this.isType2(unaryOperation);
            }
        };
        try {
            atom.accept(atomVisitor);
            return blArray[0];
        }
        catch (TunnelException tunnelException) {
            throw (CompileException)tunnelException.getDelegate();
        }
    }

    boolean isType2(Java.AmbiguousName ambiguousName) throws CompileException {
        return this.isType(this.reclassify(ambiguousName));
    }

    boolean isType2(Java.Atom atom) {
        return atom instanceof Java.Type;
    }

    private boolean isWideningPrimitiveConvertible(IClass iClass, IClass iClass2) {
        return PRIMITIVE_WIDENING_CONVERSIONS.get(String.valueOf(iClass.getDescriptor()) + iClass2.getDescriptor()) != null;
    }

    private boolean isWideningReferenceConvertible(IClass iClass, IClass iClass2) throws CompileException {
        if (iClass2.isPrimitive() || iClass == iClass2) {
            return false;
        }
        return iClass2.isAssignableFrom(iClass);
    }

    private void leave(Java.BlockStatement blockStatement, final IClass iClass) {
        Visitor.BlockStatementVisitor blockStatementVisitor = new Visitor.BlockStatementVisitor(){

            public void visitBlock(Java.Block block) {
                this.leave2(block, iClass);
            }

            public void visitBreakStatement(Java.BreakStatement breakStatement) {
                this.leave2(breakStatement, iClass);
            }

            public void visitContinueStatement(Java.ContinueStatement continueStatement) {
                this.leave2(continueStatement, iClass);
            }

            public void visitDoStatement(Java.DoStatement doStatement) {
                this.leave2(doStatement, iClass);
            }

            public void visitEmptyStatement(Java.EmptyStatement emptyStatement) {
                this.leave2(emptyStatement, iClass);
            }

            public void visitExpressionStatement(Java.ExpressionStatement expressionStatement) {
                this.leave2(expressionStatement, iClass);
            }

            public void visitFieldDeclaration(Java.FieldDeclaration fieldDeclaration) {
                this.leave2(fieldDeclaration, iClass);
            }

            public void visitForStatement(Java.ForStatement forStatement) {
                this.leave2(forStatement, iClass);
            }

            public void visitIfStatement(Java.IfStatement ifStatement) {
                this.leave2(ifStatement, iClass);
            }

            public void visitInitializer(Java.Initializer initializer) {
                this.leave2(initializer, iClass);
            }

            public void visitLabeledStatement(Java.LabeledStatement labeledStatement) {
                this.leave2(labeledStatement, iClass);
            }

            public void visitLocalClassDeclarationStatement(Java.LocalClassDeclarationStatement localClassDeclarationStatement) {
                this.leave2(localClassDeclarationStatement, iClass);
            }

            public void visitLocalVariableDeclarationStatement(Java.LocalVariableDeclarationStatement localVariableDeclarationStatement) {
                this.leave2(localVariableDeclarationStatement, iClass);
            }

            public void visitReturnStatement(Java.ReturnStatement returnStatement) {
                this.leave2(returnStatement, iClass);
            }

            public void visitSwitchStatement(Java.SwitchStatement switchStatement) {
                this.leave2(switchStatement, iClass);
            }

            public void visitSynchronizedStatement(Java.SynchronizedStatement synchronizedStatement) {
                this.leave2(synchronizedStatement, iClass);
            }

            public void visitThrowStatement(Java.ThrowStatement throwStatement) {
                this.leave2(throwStatement, iClass);
            }

            public void visitTryStatement(Java.TryStatement tryStatement) {
                this.leave2(tryStatement, iClass);
            }

            public void visitWhileStatement(Java.WhileStatement whileStatement) {
                this.leave2(whileStatement, iClass);
            }
        };
        blockStatement.accept(blockStatementVisitor);
    }

    public void leave2(Java.BlockStatement blockStatement, IClass iClass) {
    }

    public void leave2(Java.SynchronizedStatement synchronizedStatement, IClass iClass) {
        this.load(synchronizedStatement, this.iClassLoader.OBJECT, synchronizedStatement.monitorLvIndex);
        this.writeOpcode(synchronizedStatement, -61);
    }

    public void leave2(Java.TryStatement tryStatement, IClass iClass) {
        if (tryStatement.finallyOffset != null) {
            if (iClass != null) {
                this.store((Java.Located)tryStatement, iClass, tryStatement.stackValueLvIndex);
            }
            this.writeBranch(tryStatement, -88, tryStatement.finallyOffset);
            if (iClass != null) {
                this.load(tryStatement, iClass, tryStatement.stackValueLvIndex);
            }
        }
    }

    private void leaveStatements(Java.Scope scope, Java.Scope scope2, IClass iClass) {
        Java.Scope scope3 = scope;
        while (scope3 != scope2) {
            if (scope3 instanceof Java.BlockStatement) {
                this.leave((Java.BlockStatement)scope3, iClass);
            }
            scope3 = scope3.getEnclosingScope();
        }
    }

    private void load(Java.Located located, IClass iClass, int n) {
        if (n <= 3) {
            this.writeOpcode(located, 26 + 4 * this.ilfda(iClass) + n);
        } else if (n <= 255) {
            this.writeOpcode(located, 21 + this.ilfda(iClass));
            this.writeByte(located, n);
        } else {
            this.writeOpcode(located, -60);
            this.writeOpcode(located, 21 + this.ilfda(iClass));
            this.writeShort(located, n);
        }
    }

    private IClass load(Java.Located located, Java.LocalVariable localVariable) {
        this.load(located, localVariable.type, localVariable.localVariableArrayIndex);
        return localVariable.type;
    }

    private IClass loadFullyQualifiedClass(String[] stringArray) {
        int[] nArray = new int[stringArray.length - 1];
        StringBuffer stringBuffer = new StringBuffer("L");
        int n = 0;
        while (true) {
            stringBuffer.append(stringArray[n]);
            if (n == stringArray.length - 1) break;
            nArray[n] = stringBuffer.length();
            stringBuffer.append('/');
            ++n;
        }
        stringBuffer.append(';');
        int n2 = nArray.length - 1;
        while (true) {
            IClass iClass;
            if ((iClass = this.iClassLoader.loadIClass(stringBuffer.toString())) != null) {
                return iClass;
            }
            if (n2 < 0) break;
            stringBuffer.setCharAt(nArray[n2], '$');
            --n2;
        }
        return null;
    }

    private IClass newArray(Java.Located located, int n, int n2, IClass iClass) {
        if (n == 1 && n2 == 0 && iClass.isPrimitive()) {
            this.writeOpcode(located, -68);
            this.writeByte(located, iClass == IClass.BOOLEAN ? 4 : (iClass == IClass.CHAR ? 5 : (iClass == IClass.FLOAT ? 6 : (iClass == IClass.DOUBLE ? 7 : (iClass == IClass.BYTE ? 8 : (iClass == IClass.SHORT ? 9 : (iClass == IClass.INT ? 10 : (iClass == IClass.LONG ? 11 : -1))))))));
            return this.getArrayType(iClass);
        }
        if (n == 1) {
            IClass iClass2 = this.getArrayType(iClass, n2);
            this.writeOpcode(located, -67);
            this.writeConstantClassInfo(located, iClass2.getDescriptor());
            return this.getArrayType(iClass2, 1);
        }
        IClass iClass3 = this.getArrayType(iClass, n + n2);
        this.writeOpcode(located, -59);
        this.writeConstantClassInfo(located, iClass3.getDescriptor());
        this.writeByte(located, n);
        return iClass3;
    }

    private void pop(Java.Located located, IClass iClass) {
        if (iClass == IClass.VOID) {
            return;
        }
        this.writeOpcode(located, iClass == IClass.LONG || iClass == IClass.DOUBLE ? 88 : 87);
    }

    private IClass pushConstant(Java.Located located, Object object) {
        if (object instanceof Integer || object instanceof Short || object instanceof Character || object instanceof Byte) {
            int n;
            int n2 = n = object instanceof Character ? ((Character)object).charValue() : ((Number)object).intValue();
            if (n >= -1 && n <= 5) {
                this.writeOpcode(located, 3 + n);
            } else if (n >= -128 && n <= 127) {
                this.writeOpcode(located, 16);
                this.writeByte(located, (byte)n);
            } else {
                this.writeLDC(located, this.addConstantIntegerInfo(n));
            }
            return IClass.INT;
        }
        if (object instanceof Long) {
            long l = (Long)object;
            if (l >= 0L && l <= 1L) {
                this.writeOpcode(located, 9 + (int)l);
            } else {
                this.writeOpcode(located, 20);
                this.writeConstantLongInfo(located, l);
            }
            return IClass.LONG;
        }
        if (object instanceof Float) {
            float f = ((Float)object).floatValue();
            if (Float.floatToIntBits(f) == Float.floatToIntBits(0.0f) || f == 1.0f || f == 2.0f) {
                this.writeOpcode(located, 11 + (int)f);
            } else {
                this.writeLDC(located, this.addConstantFloatInfo(f));
            }
            return IClass.FLOAT;
        }
        if (object instanceof Double) {
            double d = (Double)object;
            if (Double.doubleToLongBits(d) == Double.doubleToLongBits(0.0) || d == 1.0) {
                this.writeOpcode(located, 14 + (int)d);
            } else {
                this.writeOpcode(located, 20);
                this.writeConstantDoubleInfo(located, d);
            }
            return IClass.DOUBLE;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() < 21845) {
                this.writeLDC(located, this.addConstantStringInfo((String)object));
                return this.iClassLoader.STRING;
            }
            int n = string.length();
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (true) {
                char c;
                if (n5 == n || n3 >= 65532) {
                    this.writeLDC(located, this.addConstantStringInfo(string.substring(n4, n5)));
                    if (n4 != 0) {
                        this.writeOpcode(located, -74);
                        this.writeConstantMethodrefInfo(located, "Ljava/lang/String;", "concat", "(Ljava/lang/String;)Ljava/lang/String;");
                    }
                    if (n5 == n) break;
                    n4 = n5;
                    n3 = 0;
                }
                n3 = (c = string.charAt(n5)) >= '\u0001' && c <= '\u007f' ? ++n3 : (c > '\u07ff' ? (n3 += 3) : (n3 += 2));
                ++n5;
            }
            return this.iClassLoader.STRING;
        }
        if (object instanceof Boolean) {
            this.writeOpcode(located, (Boolean)object != false ? 4 : 3);
            return IClass.BOOLEAN;
        }
        if (object == Java.Rvalue.CONSTANT_VALUE_NULL) {
            this.writeOpcode(located, 1);
            return IClass.VOID;
        }
        throw new RuntimeException("Unknown literal type \"" + object.getClass().getName() + "\"");
    }

    private Java.Atom reclassify(Java.AmbiguousName ambiguousName) throws CompileException {
        if (ambiguousName.reclassified == null) {
            ambiguousName.reclassified = this.reclassifyName(ambiguousName.getLocation(), ambiguousName.scope, ambiguousName.identifiers, ambiguousName.n);
        }
        return ambiguousName.reclassified;
    }

    private Java.Atom reclassifyName(Location location, Java.Scope scope, String string) throws CompileException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Java.TypeBodyDeclaration typeBodyDeclaration = null;
        Java.AbstractTypeDeclaration abstractTypeDeclaration = null;
        Java.Scope scope2 = scope;
        while (scope2 instanceof Java.Statement && !(scope2 instanceof Java.TypeBodyDeclaration)) {
            scope2 = scope2.getEnclosingScope();
        }
        if (scope2 instanceof Java.TypeBodyDeclaration) {
            typeBodyDeclaration = (Java.TypeBodyDeclaration)scope2;
            scope2 = scope2.getEnclosingScope();
        }
        if (scope2 instanceof Java.TypeDeclaration) {
            abstractTypeDeclaration = (Java.AbstractTypeDeclaration)scope2;
            scope2 = scope2.getEnclosingScope();
        }
        while (!(scope2 instanceof Java.CompilationUnit)) {
            scope2 = scope2.getEnclosingScope();
        }
        Java.CompilationUnit compilationUnit = (Java.CompilationUnit)scope2;
        Java.InnerClassDeclaration innerClassDeclaration = null;
        Java.BlockStatement blockStatement = null;
        Java.Scope scope3 = scope;
        while (!(scope3 instanceof Java.CompilationUnit)) {
            if (scope3 instanceof Java.InnerClassDeclaration) {
                innerClassDeclaration = (Java.InnerClassDeclaration)scope3;
            } else {
                if (blockStatement == null && scope3 instanceof Java.BlockStatement) {
                    blockStatement = (Java.BlockStatement)scope3;
                }
                object5 = null;
                if (scope3 instanceof Java.Block) {
                    object4 = (Java.Block)scope3;
                    object5 = (Java.LocalVariable)((Java.Block)object4).localVariables.get(string);
                } else if (scope3 instanceof Java.FunctionDeclarator) {
                    object4 = (Java.FunctionDeclarator)scope3;
                    object5 = (Java.LocalVariable)((Java.FunctionDeclarator)object4).parameters.get(string);
                }
                if (object5 != null) {
                    if (innerClassDeclaration == null) {
                        return new Java.LocalVariableAccess(location, (Java.LocalVariable)object5);
                    }
                    if (!((Java.LocalVariable)object5).finaL) {
                        this.compileError("Cannot access non-final local variable \"" + string + "\" from inner class");
                    }
                    object4 = ((Java.LocalVariable)object5).type;
                    SimpleIField simpleIField = new SimpleIField(this.resolve(innerClassDeclaration), "val$" + string, (IClass)object4);
                    innerClassDeclaration.defineSyntheticField(simpleIField);
                    return new Java.FieldAccess(location, blockStatement, new Java.QualifiedThisReference(location, typeBodyDeclaration, new Java.SimpleType(location, this.resolve(innerClassDeclaration))), simpleIField);
                }
            }
            scope3 = scope3.getEnclosingScope();
        }
        object5 = null;
        object4 = scope;
        while (!(object4 instanceof Java.CompilationUnit)) {
            if (object4 instanceof Java.BlockStatement) {
                object5 = (Java.BlockStatement)object4;
            } else if (object4 instanceof Java.TypeDeclaration && (object3 = this.findIField((IClass)(object2 = this.resolve((Java.AbstractTypeDeclaration)object4)), string, location)) != null) {
                if (((IClass.IField)object3).isStatic()) {
                    this.warning("IASF", "Implicit access to static field \"" + string + "\" of declaring class (better write \"" + ((IClass.IField)object3).getDeclaringIClass() + '.' + ((IClass.IField)object3).getName() + "\")", location);
                } else if (((IClass.IField)object3).getDeclaringIClass() == object2) {
                    this.warning("IANSF", "Implicit access to non-static field \"" + string + "\" of declaring class (better write \"this." + ((IClass.IField)object3).getName() + "\")", location);
                } else {
                    this.warning("IANSFEI", "Implicit access to non-static field \"" + string + "\" of enclosing instance (better write \"" + ((IClass.IField)object3).getDeclaringIClass() + ".this." + ((IClass.IField)object3).getName() + "\")", location);
                }
                Java.SimpleType simpleType = new Java.SimpleType(abstractTypeDeclaration.getLocation(), (IClass)object2);
                Java.Atom atom = typeBodyDeclaration.isStatic() ? simpleType : (((IClass.IField)object3).isStatic() ? simpleType : new Java.QualifiedThisReference(location, typeBodyDeclaration, simpleType));
                return new Java.FieldAccess(location, (Java.BlockStatement)object5, atom, (IClass.IField)object3);
            }
            object4 = object4.getEnclosingScope();
        }
        if (string.equals("java")) {
            return new Java.Package(location, string);
        }
        object2 = scope;
        while (object2 instanceof Java.Block) {
            object3 = (Java.Block)object2;
            object = ((Java.Block)object3).getLocalClassDeclaration(string);
            if (object != null) {
                return new Java.SimpleType(location, this.resolve((Java.TypeDeclaration)object));
            }
            object2 = object2.getEnclosingScope();
        }
        if (abstractTypeDeclaration != null && (object3 = this.findMemberType(this.resolve(abstractTypeDeclaration), string, location)) != null) {
            return new Java.SimpleType(location, (IClass)object3);
        }
        if (compilationUnit != null && (object3 = this.importSingleType(string, location)) != null) {
            return new Java.SimpleType(location, (IClass)object3);
        }
        if (compilationUnit != null && (object3 = compilationUnit.getPackageMemberTypeDeclaration(string)) != null) {
            return new Java.SimpleType(location, this.resolve((Java.AbstractTypeDeclaration)object3));
        }
        if (compilationUnit != null && (object = this.iClassLoader.loadIClass(Descriptor.fromClassName((String)(object3 = compilationUnit.optionalPackageDeclaration == null ? string : String.valueOf(compilationUnit.optionalPackageDeclaration.packageName) + '.' + string)))) != null) {
            return new Java.SimpleType(location, (IClass)object);
        }
        if (compilationUnit != null && (object3 = this.importTypeOnDemand(string, location)) != null) {
            return new Java.SimpleType(location, (IClass)object3);
        }
        return new Java.Package(location, string);
    }

    private Java.Atom reclassifyName(Location location, Java.Scope scope, final String[] stringArray, int n) throws CompileException {
        if (n == 1) {
            return this.reclassifyName(location, scope, stringArray[0]);
        }
        Java.Atom atom = this.reclassifyName(location, scope, stringArray, n - 1);
        String string = stringArray[n - 1];
        if (atom instanceof Java.Package) {
            String string2 = String.valueOf(((Java.Package)atom).name) + '.' + string;
            IClass iClass = this.iClassLoader.loadIClass(Descriptor.fromClassName(string2));
            if (iClass != null) {
                return new Java.SimpleType(location, iClass);
            }
            return new Java.Package(location, string2);
        }
        if (string.equals("length") && this.getType(atom).isArray()) {
            return new Java.ArrayLength(location, this.toRvalueOrCE(atom));
        }
        IClass iClass = this.getType(atom);
        IClass.IField iField = this.findIField(iClass, string, location);
        if (iField != null) {
            return new Java.FieldAccess(location, (Java.BlockStatement)scope, atom, iField);
        }
        IClass[] iClassArray = iClass.getDeclaredIClasses();
        int n2 = 0;
        while (n2 < iClassArray.length) {
            IClass iClass2 = iClassArray[n2];
            String string3 = Descriptor.toClassName(iClass2.getDescriptor());
            if ((string3 = string3.substring(string3.lastIndexOf(36) + 1)).equals(string)) {
                return new Java.SimpleType(location, iClass2);
            }
            ++n2;
        }
        this.compileError("\"" + string + "\" is neither a method, a field, nor a member class of \"" + iClass + "\"", location);
        return new Java.Atom(location){

            public final void accept(Visitor.AtomVisitor atomVisitor) {
            }

            public String toString() {
                return Java.join(stringArray, ".");
            }
        };
    }

    private void referenceThis(Java.Located located) {
        this.writeOpcode(located, 42);
    }

    private void referenceThis(Java.Located located, Java.ClassDeclaration classDeclaration, Java.TypeBodyDeclaration typeBodyDeclaration, IClass iClass) throws CompileException {
        int n;
        Object object;
        Object object2;
        int n2;
        List list;
        block8: {
            list = UnitCompiler.getOuterClasses(classDeclaration);
            if (typeBodyDeclaration.isStatic()) {
                this.compileError("No current instance available in static context", located.getLocation());
            }
            n2 = 0;
            while (n2 < list.size()) {
                if (!iClass.isAssignableFrom(this.resolve((Java.AbstractTypeDeclaration)list.get(n2)))) {
                    ++n2;
                    continue;
                }
                break block8;
            }
            this.compileError("\"" + classDeclaration + "\" is not enclosed by \"" + iClass + "\"", located.getLocation());
        }
        if (typeBodyDeclaration instanceof Java.ConstructorDeclarator) {
            if (n2 == 0) {
                this.writeOpcode(located, 42);
                return;
            }
            object2 = (Java.ConstructorDeclarator)typeBodyDeclaration;
            object = (Java.LocalVariable)((Java.ConstructorDeclarator)object2).syntheticParameters.get("this$" + (list.size() - 2));
            if (object == null) {
                throw new RuntimeException();
            }
            this.load(located, (Java.LocalVariable)object);
            n = 1;
        } else {
            this.writeOpcode(located, 42);
            n = 0;
        }
        while (n < n2) {
            object2 = "this$" + (list.size() - n - 2);
            object = (Java.InnerClassDeclaration)list.get(n);
            IClass iClass2 = this.resolve((Java.AbstractTypeDeclaration)object);
            Java.TypeDeclaration typeDeclaration = (Java.TypeDeclaration)list.get(n + 1);
            IClass iClass3 = this.resolve((Java.AbstractTypeDeclaration)typeDeclaration);
            object.defineSyntheticField(new SimpleIField(iClass2, (String)object2, iClass3));
            this.writeOpcode(located, -76);
            this.writeConstantFieldrefInfo(located, iClass2.getDescriptor(), (String)object2, iClass3.getDescriptor());
            ++n;
        }
    }

    private CodeContext replaceCodeContext(CodeContext codeContext) {
        CodeContext codeContext2 = this.codeContext;
        this.codeContext = codeContext;
        return codeContext2;
    }

    IClass resolve(final Java.TypeDeclaration typeDeclaration) {
        final Java.AbstractTypeDeclaration abstractTypeDeclaration = (Java.AbstractTypeDeclaration)typeDeclaration;
        if (abstractTypeDeclaration.resolvedType == null) {
            abstractTypeDeclaration.resolvedType = new IClass(){
                private IClass[] declaredClasses = null;

                protected IClass getComponentType2() {
                    throw new RuntimeException();
                }

                protected IClass[] getDeclaredIClasses2() {
                    if (this.declaredClasses == null) {
                        IClass[] iClassArray = new IClass[abstractTypeDeclaration.declaredClassesAndInterfaces.size()];
                        int n = 0;
                        Iterator iterator = abstractTypeDeclaration.declaredClassesAndInterfaces.iterator();
                        while (iterator.hasNext()) {
                            iClassArray[n++] = this.resolve((Java.AbstractTypeDeclaration)iterator.next());
                        }
                        this.declaredClasses = iClassArray;
                    }
                    return this.declaredClasses;
                }

                protected IClass.IConstructor[] getDeclaredIConstructors2() {
                    if (abstractTypeDeclaration instanceof Java.ClassDeclaration) {
                        Java.ConstructorDeclarator[] constructorDeclaratorArray = ((Java.ClassDeclaration)abstractTypeDeclaration).getConstructors();
                        IClass.IConstructor[] iConstructorArray = new IClass.IConstructor[constructorDeclaratorArray.length];
                        int n = 0;
                        while (n < constructorDeclaratorArray.length) {
                            iConstructorArray[n] = this.toIConstructor(constructorDeclaratorArray[n]);
                            ++n;
                        }
                        return iConstructorArray;
                    }
                    return new IClass.IConstructor[0];
                }

                protected IClass.IField[] getDeclaredIFields2() {
                    if (abstractTypeDeclaration instanceof Java.ClassDeclaration) {
                        Java.ClassDeclaration classDeclaration = (Java.ClassDeclaration)abstractTypeDeclaration;
                        ArrayList<IClass.IField> arrayList = new ArrayList<IClass.IField>();
                        int n = 0;
                        while (n < classDeclaration.variableDeclaratorsAndInitializers.size()) {
                            Java.BlockStatement blockStatement = (Java.BlockStatement)classDeclaration.variableDeclaratorsAndInitializers.get(n);
                            if (blockStatement instanceof Java.FieldDeclaration) {
                                Java.FieldDeclaration fieldDeclaration = (Java.FieldDeclaration)blockStatement;
                                IClass.IField[] iFieldArray = this.getIFields(fieldDeclaration);
                                int n2 = 0;
                                while (n2 < iFieldArray.length) {
                                    arrayList.add(iFieldArray[n2]);
                                    ++n2;
                                }
                            }
                            ++n;
                        }
                        return arrayList.toArray(new IClass.IField[arrayList.size()]);
                    }
                    if (abstractTypeDeclaration instanceof Java.InterfaceDeclaration) {
                        Java.InterfaceDeclaration interfaceDeclaration = (Java.InterfaceDeclaration)abstractTypeDeclaration;
                        ArrayList<IClass.IField> arrayList = new ArrayList<IClass.IField>();
                        int n = 0;
                        while (n < interfaceDeclaration.constantDeclarations.size()) {
                            Java.BlockStatement blockStatement = (Java.BlockStatement)interfaceDeclaration.constantDeclarations.get(n);
                            if (blockStatement instanceof Java.FieldDeclaration) {
                                Java.FieldDeclaration fieldDeclaration = (Java.FieldDeclaration)blockStatement;
                                IClass.IField[] iFieldArray = this.getIFields(fieldDeclaration);
                                int n3 = 0;
                                while (n3 < iFieldArray.length) {
                                    arrayList.add(iFieldArray[n3]);
                                    ++n3;
                                }
                            }
                            ++n;
                        }
                        return arrayList.toArray(new IClass.IField[arrayList.size()]);
                    }
                    throw new RuntimeException();
                }

                protected IClass.IMethod[] getDeclaredIMethods2() {
                    IClass.IMethod[] iMethodArray = new IClass.IMethod[abstractTypeDeclaration.declaredMethods.size()];
                    int n = 0;
                    Iterator iterator = abstractTypeDeclaration.declaredMethods.iterator();
                    while (iterator.hasNext()) {
                        iMethodArray[n++] = this.toIMethod((Java.MethodDeclarator)iterator.next());
                    }
                    return iMethodArray;
                }

                protected IClass getDeclaringIClass2() {
                    Java.Scope scope = abstractTypeDeclaration;
                    while (!(scope instanceof Java.TypeBodyDeclaration)) {
                        if (scope instanceof Java.CompilationUnit) {
                            return null;
                        }
                        scope = scope.getEnclosingScope();
                    }
                    return this.resolve((Java.AbstractTypeDeclaration)scope.getEnclosingScope());
                }

                protected final String getDescriptor2() {
                    return Descriptor.fromClassName(abstractTypeDeclaration.getClassName());
                }

                protected IClass[] getInterfaces2() throws CompileException {
                    if (abstractTypeDeclaration instanceof Java.AnonymousClassDeclaration) {
                        IClass[] iClassArray;
                        IClass iClass = this.getType(((Java.AnonymousClassDeclaration)abstractTypeDeclaration).baseType);
                        if (iClass.isInterface()) {
                            IClass[] iClassArray2 = new IClass[1];
                            iClassArray = iClassArray2;
                            iClassArray2[0] = iClass;
                        } else {
                            iClassArray = new IClass[]{};
                        }
                        return iClassArray;
                    }
                    if (abstractTypeDeclaration instanceof Java.NamedClassDeclaration) {
                        Java.NamedClassDeclaration namedClassDeclaration = (Java.NamedClassDeclaration)abstractTypeDeclaration;
                        IClass[] iClassArray = new IClass[namedClassDeclaration.implementedTypes.length];
                        int n = 0;
                        while (n < iClassArray.length) {
                            iClassArray[n] = this.getType(namedClassDeclaration.implementedTypes[n]);
                            if (!iClassArray[n].isInterface()) {
                                this.compileError("\"" + iClassArray[n].toString() + "\" is not an interface; classes can only implement interfaces", typeDeclaration.getLocation());
                            }
                            ++n;
                        }
                        return iClassArray;
                    }
                    if (abstractTypeDeclaration instanceof Java.InterfaceDeclaration) {
                        Java.InterfaceDeclaration interfaceDeclaration = (Java.InterfaceDeclaration)abstractTypeDeclaration;
                        IClass[] iClassArray = new IClass[interfaceDeclaration.extendedTypes.length];
                        int n = 0;
                        while (n < iClassArray.length) {
                            iClassArray[n] = this.getType(interfaceDeclaration.extendedTypes[n]);
                            if (!iClassArray[n].isInterface()) {
                                this.compileError("\"" + iClassArray[n].toString() + "\" is not an interface; interfaces can only extend interfaces", typeDeclaration.getLocation());
                            }
                            ++n;
                        }
                        return iClassArray;
                    }
                    throw new RuntimeException();
                }

                protected IClass getOuterIClass2() throws CompileException {
                    Java.AbstractTypeDeclaration abstractTypeDeclaration2 = (Java.AbstractTypeDeclaration)UnitCompiler.getOuterClass(abstractTypeDeclaration);
                    if (abstractTypeDeclaration2 == null) {
                        return null;
                    }
                    return this.resolve(abstractTypeDeclaration2);
                }

                protected IClass getSuperclass2() throws CompileException {
                    if (abstractTypeDeclaration instanceof Java.AnonymousClassDeclaration) {
                        IClass iClass = this.getType(((Java.AnonymousClassDeclaration)abstractTypeDeclaration).baseType);
                        return iClass.isInterface() ? ((UnitCompiler)this).iClassLoader.OBJECT : iClass;
                    }
                    if (abstractTypeDeclaration instanceof Java.NamedClassDeclaration) {
                        Java.NamedClassDeclaration namedClassDeclaration = (Java.NamedClassDeclaration)abstractTypeDeclaration;
                        if (namedClassDeclaration.optionalExtendedType == null) {
                            return ((UnitCompiler)this).iClassLoader.OBJECT;
                        }
                        IClass iClass = this.getType(namedClassDeclaration.optionalExtendedType);
                        if (iClass.isInterface()) {
                            this.compileError("\"" + iClass.toString() + "\" is an interface; classes can only extend a class", typeDeclaration.getLocation());
                        }
                        return iClass;
                    }
                    return null;
                }

                public IClass.IField[] getSyntheticIFields() {
                    if (abstractTypeDeclaration instanceof Java.ClassDeclaration) {
                        Collection collection = ((Java.ClassDeclaration)abstractTypeDeclaration).syntheticFields.values();
                        return collection.toArray(new IClass.IField[collection.size()]);
                    }
                    return new IClass.IField[0];
                }

                public boolean isAbstract() {
                    return abstractTypeDeclaration instanceof Java.InterfaceDeclaration || (abstractTypeDeclaration.modifiers & 0x400) != 0;
                }

                public boolean isArray() {
                    return false;
                }

                public boolean isFinal() {
                    return (abstractTypeDeclaration.modifiers & 0x10) != 0;
                }

                public boolean isInterface() {
                    return abstractTypeDeclaration instanceof Java.InterfaceDeclaration;
                }

                public boolean isPrimitive() {
                    return false;
                }

                public boolean isPrimitiveNumeric() {
                    return false;
                }

                public boolean isPublic() {
                    return (abstractTypeDeclaration.modifiers & 1) != 0;
                }
            };
        }
        return abstractTypeDeclaration.resolvedType;
    }

    public void setCompileErrorHandler(ErrorHandler errorHandler) {
        this.compileErrorHandler = errorHandler;
    }

    public void setWarningHandler(WarningHandler warningHandler) {
        this.warningHandler = warningHandler;
    }

    private void store(Java.Located located, IClass iClass, Java.LocalVariable localVariable) {
        this.store(located, localVariable.type, localVariable.localVariableArrayIndex);
    }

    private void store(Java.Located located, IClass iClass, short s) {
        if (s <= 3) {
            this.writeOpcode(located, 59 + 4 * this.ilfda(iClass) + s);
        } else if (s <= 255) {
            this.writeOpcode(located, 54 + this.ilfda(iClass));
            this.writeByte(located, s);
        } else {
            this.writeOpcode(located, -60);
            this.writeOpcode(located, 54 + this.ilfda(iClass));
            this.writeShort(located, s);
        }
    }

    private void stringConversion(Java.Located located, IClass iClass) {
        this.writeOpcode(located, -72);
        this.writeConstantMethodrefInfo(located, "Ljava/lang/String;", "valueOf", "(" + (iClass == IClass.BOOLEAN || iClass == IClass.CHAR || iClass == IClass.LONG || iClass == IClass.FLOAT || iClass == IClass.DOUBLE ? iClass.getDescriptor() : (iClass == IClass.BYTE || iClass == IClass.SHORT || iClass == IClass.INT ? "I" : "Ljava/lang/Object;")) + ")" + "Ljava/lang/String;");
    }

    IClass.IConstructor toIConstructor(final Java.ConstructorDeclarator constructorDeclarator) {
        if (constructorDeclarator.iConstructor != null) {
            return constructorDeclarator.iConstructor;
        }
        constructorDeclarator.iConstructor = new IClass.IConstructor(this.resolve((Java.AbstractTypeDeclaration)constructorDeclarator.getDeclaringType())){

            public Access getAccess() {
                switch (constructorDeclarator.modifiers & 7) {
                    case 2: {
                        return Access.PRIVATE;
                    }
                    case 4: {
                        return Access.PROTECTED;
                    }
                    case 0: {
                        return Access.DEFAULT;
                    }
                    case 1: {
                        return Access.PUBLIC;
                    }
                }
                throw new RuntimeException("Invalid access");
            }

            public String getDescriptor() throws CompileException {
                Object object;
                if (!(constructorDeclarator.declaringClass instanceof Java.InnerClassDeclaration)) {
                    return super.getDescriptor();
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                IClass iClass = this.resolve(constructorDeclarator.declaringClass).getOuterIClass();
                if (iClass != null) {
                    arrayList.add(iClass.getDescriptor());
                }
                Iterator iterator = constructorDeclarator.declaringClass.syntheticFields.values().iterator();
                while (iterator.hasNext()) {
                    object = (IClass.IField)iterator.next();
                    if (!((IClass.IField)object).getName().startsWith("val$")) continue;
                    arrayList.add(((IClass.IField)object).getType().getDescriptor());
                }
                object = constructorDeclarator.formalParameters;
                int n = 0;
                while (n < ((Object)object).length) {
                    arrayList.add(this.getType(((Java.FormalParameter)object[n]).type).getDescriptor());
                    ++n;
                }
                String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
                return new MethodDescriptor(stringArray, "V").toString();
            }

            public IClass[] getParameterTypes() throws CompileException {
                Java.FormalParameter[] formalParameterArray = constructorDeclarator.formalParameters;
                IClass[] iClassArray = new IClass[formalParameterArray.length];
                int n = 0;
                while (n < formalParameterArray.length) {
                    iClassArray[n] = this.getType(formalParameterArray[n].type);
                    ++n;
                }
                return iClassArray;
            }

            public IClass[] getThrownExceptions() throws CompileException {
                IClass[] iClassArray = new IClass[constructorDeclarator.thrownExceptions.length];
                int n = 0;
                while (n < iClassArray.length) {
                    iClassArray[n] = this.getType(constructorDeclarator.thrownExceptions[n]);
                    ++n;
                }
                return iClassArray;
            }

            public String toString() {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(constructorDeclarator.getDeclaringType().getClassName());
                stringBuffer.append('(');
                Java.FormalParameter[] formalParameterArray = constructorDeclarator.formalParameters;
                int n = 0;
                while (n < formalParameterArray.length) {
                    if (n != 0) {
                        stringBuffer.append(", ");
                    }
                    try {
                        stringBuffer.append(this.getType(formalParameterArray[n].type).toString());
                    }
                    catch (CompileException compileException) {
                        stringBuffer.append("???");
                    }
                    ++n;
                }
                return stringBuffer.append(')').toString();
            }
        };
        return constructorDeclarator.iConstructor;
    }

    private IClass.IInvocable toIInvocable(Java.FunctionDeclarator functionDeclarator) {
        if (functionDeclarator instanceof Java.ConstructorDeclarator) {
            return this.toIConstructor((Java.ConstructorDeclarator)functionDeclarator);
        }
        if (functionDeclarator instanceof Java.MethodDeclarator) {
            return this.toIMethod((Java.MethodDeclarator)functionDeclarator);
        }
        throw new RuntimeException();
    }

    public IClass.IMethod toIMethod(final Java.MethodDeclarator methodDeclarator) {
        if (methodDeclarator.iMethod != null) {
            return methodDeclarator.iMethod;
        }
        methodDeclarator.iMethod = new IClass.IMethod(this.resolve((Java.AbstractTypeDeclaration)methodDeclarator.getDeclaringType())){

            public Access getAccess() {
                switch (methodDeclarator.modifiers & 7) {
                    case 2: {
                        return Access.PRIVATE;
                    }
                    case 4: {
                        return Access.PROTECTED;
                    }
                    case 0: {
                        return Access.DEFAULT;
                    }
                    case 1: {
                        return Access.PUBLIC;
                    }
                }
                throw new RuntimeException("Invalid access");
            }

            public String getName() {
                return methodDeclarator.name;
            }

            public IClass[] getParameterTypes() throws CompileException {
                Java.FormalParameter[] formalParameterArray = methodDeclarator.formalParameters;
                IClass[] iClassArray = new IClass[formalParameterArray.length];
                int n = 0;
                while (n < formalParameterArray.length) {
                    iClassArray[n] = this.getType(formalParameterArray[n].type);
                    ++n;
                }
                return iClassArray;
            }

            public IClass getReturnType() throws CompileException {
                return this.getReturnType(methodDeclarator);
            }

            public IClass[] getThrownExceptions() throws CompileException {
                IClass[] iClassArray = new IClass[methodDeclarator.thrownExceptions.length];
                int n = 0;
                while (n < iClassArray.length) {
                    iClassArray[n] = this.getType(methodDeclarator.thrownExceptions[n]);
                    ++n;
                }
                return iClassArray;
            }

            public boolean isAbstract() {
                return methodDeclarator.getDeclaringType() instanceof Java.InterfaceDeclaration || (methodDeclarator.modifiers & 0x400) != 0;
            }

            public boolean isStatic() {
                return (methodDeclarator.modifiers & 8) != 0;
            }
        };
        return methodDeclarator.iMethod;
    }

    public final Java.Lvalue toLvalueOrCE(final Java.Atom atom) throws CompileException {
        Java.Lvalue lvalue = atom.toLvalue();
        if (lvalue == null) {
            this.compileError("Expression \"" + atom.toString() + "\" is not an lvalue", atom.getLocation());
            return new Java.Lvalue(atom.getLocation()){

                public void accept(Visitor.AtomVisitor atomVisitor) {
                }

                public void accept(Visitor.LvalueVisitor lvalueVisitor) {
                }

                public void accept(Visitor.RvalueVisitor rvalueVisitor) {
                }

                public IClass compileGet() {
                    return ((UnitCompiler)this).iClassLoader.OBJECT;
                }

                public String toString() {
                    return atom.toString();
                }
            };
        }
        return lvalue;
    }

    private final Java.Rvalue toRvalueOrCE(final Java.Atom atom) throws CompileException {
        Java.Rvalue rvalue = atom.toRvalue();
        if (rvalue == null) {
            this.compileError("Expression \"" + atom.toString() + "\" is not an rvalue", atom.getLocation());
            return new Java.Rvalue(atom.getLocation()){

                public void accept(Visitor.AtomVisitor atomVisitor) {
                }

                public void accept(Visitor.RvalueVisitor rvalueVisitor) {
                }

                public IClass compileGet() {
                    return ((UnitCompiler)this).iClassLoader.OBJECT;
                }

                public String toString() {
                    return atom.toString();
                }
            };
        }
        return rvalue;
    }

    private final Java.Type toTypeOrCE(Java.Atom atom) throws CompileException {
        Java.Type type = atom.toType();
        if (type == null) {
            this.compileError("Expression \"" + atom.toString() + "\" is not a type", atom.getLocation());
            return new Java.SimpleType(atom.getLocation(), this.iClassLoader.OBJECT);
        }
        return type;
    }

    private boolean tryIdentityConversion(IClass iClass, IClass iClass2) {
        return iClass == iClass2;
    }

    private boolean tryNarrowingPrimitiveConversion(Java.Located located, IClass iClass, IClass iClass2) {
        byte[] byArray = (byte[])PRIMITIVE_NARROWING_CONVERSIONS.get(String.valueOf(iClass.getDescriptor()) + iClass2.getDescriptor());
        if (byArray != null) {
            this.write(located, byArray);
            return true;
        }
        return false;
    }

    private boolean tryNarrowingReferenceConversion(Java.Located located, IClass iClass, IClass iClass2) throws CompileException {
        if (!this.isNarrowingReferenceConvertible(iClass, iClass2)) {
            return false;
        }
        this.writeOpcode(located, -64);
        this.writeConstantClassInfo(located, iClass2.getDescriptor());
        return true;
    }

    private boolean tryWideningPrimitiveConversion(Java.Located located, IClass iClass, IClass iClass2) {
        byte[] byArray = (byte[])PRIMITIVE_WIDENING_CONVERSIONS.get(String.valueOf(iClass.getDescriptor()) + iClass2.getDescriptor());
        if (byArray != null) {
            this.write(located, byArray);
            return true;
        }
        return false;
    }

    private IClass unaryNumericPromotion(Java.Located located, IClass iClass) throws CompileException {
        IClass iClass2 = this.unaryNumericPromotionType(located, iClass);
        if (!this.tryIdentityConversion(iClass, iClass2) && !this.tryWideningPrimitiveConversion(located, iClass, iClass2)) {
            throw new RuntimeException();
        }
        return iClass2;
    }

    private IClass unaryNumericPromotionType(Java.Located located, IClass iClass) throws CompileException {
        if (!iClass.isPrimitiveNumeric()) {
            this.compileError("Unary numeric promotion not possible on non-numeric-primitive type \"" + iClass + "\"", located.getLocation());
        }
        return iClass == IClass.DOUBLE ? IClass.DOUBLE : (iClass == IClass.FLOAT ? IClass.FLOAT : (iClass == IClass.LONG ? IClass.LONG : IClass.INT));
    }

    private void warning(String string, String string2, Location location) {
        WarningHandler warningHandler = this.warningHandler;
        if (warningHandler != null) {
            warningHandler.handleWarning(string, string2, location);
        }
    }

    private void write(Java.Locatable locatable, byte[] byArray) {
        this.codeContext.write(locatable.getLocation().getLineNumber(), byArray);
    }

    private void writeBranch(int n, CodeContext.Offset offset) {
        this.codeContext.writeBranch((short)-1, n, offset);
    }

    private void writeBranch(Java.Locatable locatable, int n, CodeContext.Offset offset) {
        this.codeContext.writeBranch(locatable.getLocation().getLineNumber(), n, offset);
    }

    private void writeByte(Java.Locatable locatable, int n) {
        this.codeContext.write(locatable.getLocation().getLineNumber(), new byte[]{(byte)n});
    }

    private void writeConstantClassInfo(Java.Locatable locatable, String string) {
        CodeContext codeContext = this.codeContext;
        codeContext.writeShort(locatable.getLocation().getLineNumber(), codeContext.getClassFile().addConstantClassInfo(string));
    }

    private void writeConstantDoubleInfo(Java.Locatable locatable, double d) {
        CodeContext codeContext = this.codeContext;
        codeContext.writeShort(locatable.getLocation().getLineNumber(), codeContext.getClassFile().addConstantDoubleInfo(d));
    }

    private void writeConstantFieldrefInfo(Java.Locatable locatable, String string, String string2, String string3) {
        CodeContext codeContext = this.codeContext;
        codeContext.writeShort(locatable.getLocation().getLineNumber(), codeContext.getClassFile().addConstantFieldrefInfo(string, string2, string3));
    }

    private void writeConstantInterfaceMethodrefInfo(Java.Locatable locatable, String string, String string2, String string3) {
        CodeContext codeContext = this.codeContext;
        codeContext.writeShort(locatable.getLocation().getLineNumber(), codeContext.getClassFile().addConstantInterfaceMethodrefInfo(string, string2, string3));
    }

    private void writeConstantLongInfo(Java.Locatable locatable, long l) {
        CodeContext codeContext = this.codeContext;
        codeContext.writeShort(locatable.getLocation().getLineNumber(), codeContext.getClassFile().addConstantLongInfo(l));
    }

    private void writeConstantMethodrefInfo(Java.Locatable locatable, String string, String string2, String string3) {
        CodeContext codeContext = this.codeContext;
        codeContext.writeShort(locatable.getLocation().getLineNumber(), codeContext.getClassFile().addConstantMethodrefInfo(string, string2, string3));
    }

    private void writeInt(Java.Locatable locatable, int n) {
        this.codeContext.write(locatable.getLocation().getLineNumber(), new byte[]{(byte)(n >> 24), (byte)(n >> 16), (byte)(n >> 8), (byte)n});
    }

    private void writeLDC(Java.Located located, short s) {
        if (s <= 255) {
            this.writeOpcode(located, 18);
            this.writeByte(located, (byte)s);
        } else {
            this.writeOpcode(located, 19);
            this.writeShort(located, s);
        }
    }

    private void writeOffset(Java.Locatable locatable, CodeContext.Offset offset, CodeContext.Offset offset2) {
        this.codeContext.writeOffset(locatable.getLocation().getLineNumber(), offset, offset2);
    }

    private void writeOpcode(Java.Locatable locatable, int n) {
        this.writeByte(locatable, n);
    }

    private void writeShort(Java.Locatable locatable, int n) {
        this.codeContext.write(locatable.getLocation().getLineNumber(), new byte[]{(byte)(n >> 8), (byte)n});
    }

    public static interface ErrorHandler {
        public void handleError(String var1, Location var2) throws CompileException;
    }

    public static class SimpleIField
    extends IClass.IField {
        private final String name;
        private final IClass type;

        public SimpleIField(IClass iClass, String string, IClass iClass2) {
            this.name = string;
            this.type = iClass2;
        }

        public Access getAccess() {
            return Access.DEFAULT;
        }

        public Object getConstantValue() {
            return null;
        }

        public String getName() {
            return this.name;
        }

        public IClass getType() {
            return this.type;
        }

        public boolean isStatic() {
            return false;
        }
    }
}

