/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.codehaus.janino.CodeContext;
import org.codehaus.janino.CompileException;
import org.codehaus.janino.IClass;
import org.codehaus.janino.Location;
import org.codehaus.janino.Mod;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.Visitor;
import org.codehaus.janino.util.iterator.ReverseListIterator;

public class Java {
    private Java() {
    }

    public static String join(Object[] objectArray, String string) {
        return Java.join(objectArray, string, 0, objectArray.length);
    }

    public static String join(Object[] objectArray, String string, int n, int n2) {
        if (objectArray == null) {
            return "(null)";
        }
        if (n >= n2) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(objectArray[n].toString());
        ++n;
        while (n < n2) {
            stringBuffer.append(string);
            stringBuffer.append(objectArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static interface Scope {
        public Scope getEnclosingScope();
    }

    public static interface Locatable {
        public Location getLocation();

        public void throwParseException(String var1) throws Parser.ParseException;
    }

    public static abstract class Located
    implements Locatable {
        private final Location location;

        protected Located(Location location) {
            this.location = location;
        }

        public Location getLocation() {
            return this.location;
        }

        public void throwParseException(String string) throws Parser.ParseException {
            throw new Parser.ParseException(string, this.location);
        }
    }

    public static final class CompilationUnit
    implements Scope {
        public String optionalFileName;
        public PackageDeclaration optionalPackageDeclaration = null;
        public final List importDeclarations = new ArrayList();
        public final List packageMemberTypeDeclarations = new ArrayList();

        public CompilationUnit(String string) {
            this.optionalFileName = string;
        }

        public void addImportDeclaration(ImportDeclaration importDeclaration) throws Parser.ParseException {
            if (importDeclaration instanceof SingleTypeImportDeclaration) {
                Object[] objectArray = ((SingleTypeImportDeclaration)importDeclaration).identifiers;
                String string = objectArray[objectArray.length - 1];
                Iterator iterator = this.importDeclarations.iterator();
                while (iterator.hasNext()) {
                    Object[] objectArray2;
                    ImportDeclaration importDeclaration2 = (ImportDeclaration)iterator.next();
                    if (!(importDeclaration2 instanceof SingleTypeImportDeclaration) || !(objectArray2 = ((SingleTypeImportDeclaration)importDeclaration2).identifiers)[objectArray2.length - 1].equals(string) || Java.join(objectArray, ".").equals(Java.join(objectArray2, "."))) continue;
                    importDeclaration.throwParseException("Class \"" + string + "\" was first imported from \"" + Java.join(objectArray, ".") + "\", now again from \"" + Java.join(objectArray2, ".") + "\"");
                }
            }
            this.importDeclarations.add(importDeclaration);
        }

        public void addPackageMemberTypeDeclaration(PackageMemberTypeDeclaration packageMemberTypeDeclaration) {
            this.packageMemberTypeDeclarations.add(packageMemberTypeDeclaration);
        }

        public Scope getEnclosingScope() {
            return null;
        }

        public PackageMemberTypeDeclaration getPackageMemberTypeDeclaration(String string) {
            Iterator iterator = this.packageMemberTypeDeclarations.iterator();
            while (iterator.hasNext()) {
                PackageMemberTypeDeclaration packageMemberTypeDeclaration = (PackageMemberTypeDeclaration)iterator.next();
                if (!packageMemberTypeDeclaration.getName().equals(string)) continue;
                return packageMemberTypeDeclaration;
            }
            return null;
        }

        public PackageMemberTypeDeclaration[] getPackageMemberTypeDeclarations() {
            return this.packageMemberTypeDeclarations.toArray(new PackageMemberTypeDeclaration[this.packageMemberTypeDeclarations.size()]);
        }

        public String[] getSingleTypeImport(String string) {
            Iterator iterator = this.importDeclarations.iterator();
            while (iterator.hasNext()) {
                String[] stringArray;
                ImportDeclaration importDeclaration = (ImportDeclaration)iterator.next();
                if (!(importDeclaration instanceof SingleTypeImportDeclaration) || !(stringArray = ((SingleTypeImportDeclaration)importDeclaration).identifiers)[stringArray.length - 1].equals(string)) continue;
                return stringArray;
            }
            return null;
        }

        public void setPackageDeclaration(PackageDeclaration packageDeclaration) {
            if (this.optionalPackageDeclaration != null) {
                throw new RuntimeException("Re-setting package declaration");
            }
            this.optionalPackageDeclaration = packageDeclaration;
        }
    }

    public static class PackageDeclaration
    extends Located {
        public final String packageName;

        public PackageDeclaration(Location location, String string) {
            super(location);
            this.packageName = string;
        }
    }

    public static abstract class ImportDeclaration
    extends Located {
        public ImportDeclaration(Location location) {
            super(location);
        }

        public abstract void accept(Visitor.ComprehensiveVisitor var1);
    }

    public static class SingleTypeImportDeclaration
    extends ImportDeclaration {
        public final String[] identifiers;

        public SingleTypeImportDeclaration(Location location, String[] stringArray) {
            super(location);
            this.identifiers = stringArray;
        }

        public final void accept(Visitor.ComprehensiveVisitor comprehensiveVisitor) {
            comprehensiveVisitor.visitSingleTypeImportDeclaration(this);
        }
    }

    public static class TypeImportOnDemandDeclaration
    extends ImportDeclaration {
        public final String[] identifiers;

        public TypeImportOnDemandDeclaration(Location location, String[] stringArray) {
            super(location);
            this.identifiers = stringArray;
        }

        public final void accept(Visitor.ComprehensiveVisitor comprehensiveVisitor) {
            comprehensiveVisitor.visitTypeImportOnDemandDeclaration(this);
        }
    }

    public static interface TypeDeclaration
    extends Locatable,
    Scope {
        public void accept(Visitor.TypeDeclarationVisitor var1);

        public String createAnonymousClassName();

        public String createLocalTypeName(String var1);

        public String getClassName();

        public MemberTypeDeclaration getMemberTypeDeclaration(String var1);
    }

    public static interface DocCommentable {
        public String getDocComment();

        public boolean hasDeprecatedDocTag();
    }

    public static interface PackageMemberTypeDeclaration
    extends NamedTypeDeclaration {
    }

    public static interface MemberTypeDeclaration
    extends NamedTypeDeclaration,
    TypeBodyDeclaration {
    }

    public static interface NamedTypeDeclaration
    extends TypeDeclaration {
        public String getName();
    }

    static interface InnerClassDeclaration
    extends TypeDeclaration {
        public void defineSyntheticField(IClass.IField var1) throws CompileException;
    }

    public static abstract class AbstractTypeDeclaration
    implements TypeDeclaration {
        private final Location location;
        protected final Scope enclosingScope;
        protected final short modifiers;
        public final List declaredMethods = new ArrayList();
        public final List declaredClassesAndInterfaces = new ArrayList();
        IClass resolvedType = null;
        public int anonymousClassCount = 0;
        public int localClassCount = 0;

        public AbstractTypeDeclaration(Location location, Scope scope, short s) {
            this.location = location;
            this.enclosingScope = scope;
            this.modifiers = s;
        }

        public abstract void accept(Visitor.TypeDeclarationVisitor var1);

        public void addDeclaredMethod(MethodDeclarator methodDeclarator) {
            this.declaredMethods.add(methodDeclarator);
        }

        public void addMemberTypeDeclaration(MemberTypeDeclaration memberTypeDeclaration) {
            this.declaredClassesAndInterfaces.add(memberTypeDeclaration);
        }

        public String createAnonymousClassName() {
            return String.valueOf(this.getClassName()) + '$' + ++this.anonymousClassCount;
        }

        public String createLocalTypeName(String string) {
            return String.valueOf(this.getClassName()) + '$' + ++this.localClassCount + '$' + string;
        }

        public abstract String getClassName();

        public Scope getEnclosingScope() {
            return this.enclosingScope;
        }

        public Location getLocation() {
            return this.location;
        }

        public MemberTypeDeclaration getMemberTypeDeclaration(String string) {
            Iterator iterator = this.declaredClassesAndInterfaces.iterator();
            while (iterator.hasNext()) {
                MemberTypeDeclaration memberTypeDeclaration = (MemberTypeDeclaration)iterator.next();
                if (!memberTypeDeclaration.getName().equals(string)) continue;
                return memberTypeDeclaration;
            }
            return null;
        }

        public Collection getMemberTypeDeclarations() {
            return this.declaredClassesAndInterfaces;
        }

        public void throwParseException(String string) throws Parser.ParseException {
            throw new Parser.ParseException(string, this.location);
        }

        public abstract String toString();
    }

    public static abstract class ClassDeclaration
    extends AbstractTypeDeclaration {
        public final List constructors = new ArrayList();
        public final List variableDeclaratorsAndInitializers = new ArrayList();
        final SortedMap syntheticFields = new TreeMap();

        public ClassDeclaration(Location location, Scope scope, short s) {
            super(location, scope, s);
        }

        public void addConstructor(ConstructorDeclarator constructorDeclarator) {
            this.constructors.add(constructorDeclarator);
        }

        public void addVariableDeclaratorOrInitializer(TypeBodyDeclaration typeBodyDeclaration) {
            this.variableDeclaratorsAndInitializers.add(typeBodyDeclaration);
            if (this.resolvedType != null) {
                this.resolvedType.declaredIFields = null;
            }
        }

        public void defineSyntheticField(IClass.IField iField) throws CompileException {
            if (!(this instanceof InnerClassDeclaration)) {
                throw new RuntimeException();
            }
            IClass.IField iField2 = (IClass.IField)this.syntheticFields.get(iField.getName());
            if (iField2 != null) {
                if (iField.getType() != iField2.getType()) {
                    throw new RuntimeException();
                }
                return;
            }
            this.syntheticFields.put(iField.getName(), iField);
        }

        ConstructorDeclarator[] getConstructors() {
            if (this.constructors.isEmpty()) {
                ConstructorDeclarator constructorDeclarator = new ConstructorDeclarator(this.getLocation(), this, null, 1, new FormalParameter[0], new Type[0]);
                constructorDeclarator.setBody(new Block(this.getLocation(), this));
                return new ConstructorDeclarator[]{constructorDeclarator};
            }
            return this.constructors.toArray(new ConstructorDeclarator[this.constructors.size()]);
        }
    }

    public static final class AnonymousClassDeclaration
    extends ClassDeclaration
    implements InnerClassDeclaration {
        public Type baseType;
        private String className;

        public AnonymousClassDeclaration(Location location, Scope scope, Type type) {
            super(location, scope, (short)18);
            this.baseType = type;
            Scope scope2 = this.getEnclosingScope();
            while (!(scope2 instanceof TypeDeclaration)) {
                scope2 = scope2.getEnclosingScope();
            }
            TypeDeclaration typeDeclaration = (TypeDeclaration)scope2;
            this.className = typeDeclaration.createAnonymousClassName();
        }

        public final void accept(Visitor.TypeDeclarationVisitor typeDeclarationVisitor) {
            typeDeclarationVisitor.visitAnonymousClassDeclaration(this);
        }

        public String getClassName() {
            return this.className;
        }

        public String toString() {
            return "ANONYMOUS";
        }
    }

    public static abstract class NamedClassDeclaration
    extends ClassDeclaration
    implements NamedTypeDeclaration,
    DocCommentable {
        private final String optionalDocComment;
        public final String name;
        public final Type optionalExtendedType;
        public final Type[] implementedTypes;

        public NamedClassDeclaration(Location location, Scope scope, String string, short s, String string2, Type type, Type[] typeArray) {
            super(location, scope, s);
            this.optionalDocComment = string;
            this.name = string2;
            this.optionalExtendedType = type;
            this.implementedTypes = typeArray;
        }

        public String getDocComment() {
            return this.optionalDocComment;
        }

        public String getName() {
            return this.name;
        }

        public boolean hasDeprecatedDocTag() {
            return this.optionalDocComment != null && this.optionalDocComment.indexOf("@deprecated") != -1;
        }

        public String toString() {
            return this.name;
        }
    }

    public static final class MemberClassDeclaration
    extends NamedClassDeclaration
    implements MemberTypeDeclaration,
    InnerClassDeclaration {
        public MemberClassDeclaration(Location location, NamedTypeDeclaration namedTypeDeclaration, String string, short s, String string2, Type type, Type[] typeArray) throws Parser.ParseException {
            super(location, namedTypeDeclaration, string, s, string2, type, typeArray);
            MemberTypeDeclaration memberTypeDeclaration = namedTypeDeclaration.getMemberTypeDeclaration(string2);
            if (memberTypeDeclaration != null) {
                this.throwParseException("Redeclaration of class \"" + string2 + "\", previously declared in " + memberTypeDeclaration.getLocation());
            }
        }

        public void accept(Visitor.TypeBodyDeclarationVisitor typeBodyDeclarationVisitor) {
            typeBodyDeclarationVisitor.visitMemberClassDeclaration(this);
        }

        public void accept(Visitor.TypeDeclarationVisitor typeDeclarationVisitor) {
            typeDeclarationVisitor.visitMemberClassDeclaration(this);
        }

        public String getClassName() {
            return String.valueOf(this.getDeclaringType().getClassName()) + '$' + this.getName();
        }

        public TypeDeclaration getDeclaringType() {
            return (TypeDeclaration)this.getEnclosingScope();
        }

        public boolean isStatic() {
            return (this.modifiers & 8) != 0;
        }
    }

    public static final class LocalClassDeclaration
    extends NamedClassDeclaration
    implements InnerClassDeclaration {
        private final String className;

        public LocalClassDeclaration(Location location, Block block, String string, short s, String string2, Type type, Type[] typeArray) throws Parser.ParseException {
            super(location, block, string, s, string2, type, typeArray);
            TypeDeclaration typeDeclaration;
            Scope scope;
            Scope scope2 = block;
            while (scope2 instanceof Block) {
                scope = scope2;
                typeDeclaration = ((Block)scope).getLocalClassDeclaration(string2);
                if (typeDeclaration != null) {
                    this.throwParseException("Redeclaration of local class \"" + string2 + "\"; previously declared in " + ((AbstractTypeDeclaration)typeDeclaration).getLocation());
                }
                scope2 = scope2.getEnclosingScope();
            }
            scope = this.getEnclosingScope();
            while (!(scope instanceof TypeDeclaration)) {
                scope = scope.getEnclosingScope();
            }
            typeDeclaration = (TypeDeclaration)scope;
            this.className = typeDeclaration.createLocalTypeName(string2);
        }

        public final void accept(Visitor.TypeDeclarationVisitor typeDeclarationVisitor) {
            typeDeclarationVisitor.visitLocalClassDeclaration(this);
        }

        public String getClassName() {
            return this.className;
        }

        protected IClass getOuterIClass2() {
            Scope scope = this.getEnclosingScope();
            while (!(scope instanceof FunctionDeclarator)) {
                scope = scope.getEnclosingScope();
            }
            boolean bl = scope instanceof MethodDeclarator && (((FunctionDeclarator)scope).modifiers & 8) != 0;
            while (!(scope instanceof TypeDeclaration)) {
                scope = scope.getEnclosingScope();
            }
            TypeDeclaration typeDeclaration = (TypeDeclaration)scope;
            return typeDeclaration instanceof ClassDeclaration && !bl ? (IClass)((Object)typeDeclaration) : null;
        }
    }

    public static final class PackageMemberClassDeclaration
    extends NamedClassDeclaration
    implements PackageMemberTypeDeclaration {
        public PackageMemberClassDeclaration(Location location, CompilationUnit compilationUnit, String string, short s, String string2, Type type, Type[] typeArray) throws Parser.ParseException {
            super(location, compilationUnit, string, s, string2, type, typeArray);
            PackageMemberTypeDeclaration packageMemberTypeDeclaration;
            Object[] objectArray;
            if ((s & 0xE) != 0) {
                this.throwParseException("Modifiers \"protected\", \"private\" and \"static\" not allowed in package member class declaration");
            }
            if ((objectArray = compilationUnit.getSingleTypeImport(string2)) != null) {
                this.throwParseException("Package member class declaration \"" + string2 + "\" conflicts with single-type-import \"" + Java.join(objectArray, ".") + "\"");
            }
            if ((packageMemberTypeDeclaration = compilationUnit.getPackageMemberTypeDeclaration(string2)) != null) {
                this.throwParseException("Redeclaration of class \"" + string2 + "\", previously declared in " + packageMemberTypeDeclaration.getLocation());
            }
        }

        public final void accept(Visitor.TypeDeclarationVisitor typeDeclarationVisitor) {
            typeDeclarationVisitor.visitPackageMemberClassDeclaration(this);
        }

        public String getClassName() {
            String string = this.getName();
            CompilationUnit compilationUnit = (CompilationUnit)this.getEnclosingScope();
            if (compilationUnit.optionalPackageDeclaration != null) {
                string = String.valueOf(compilationUnit.optionalPackageDeclaration.packageName) + '.' + string;
            }
            return string;
        }

        protected IClass getOuterIClass2() {
            return null;
        }
    }

    public static abstract class InterfaceDeclaration
    extends AbstractTypeDeclaration
    implements NamedTypeDeclaration,
    DocCommentable {
        private final String optionalDocComment;
        public String name;
        public Type[] extendedTypes;
        public final List constantDeclarations = new ArrayList();
        IClass[] interfaces = null;

        protected InterfaceDeclaration(Location location, Scope scope, String string, short s, String string2, Type[] typeArray) {
            super(location, scope, s);
            this.optionalDocComment = string;
            this.name = string2;
            this.extendedTypes = typeArray;
        }

        public void addConstantDeclaration(FieldDeclaration fieldDeclaration) {
            this.constantDeclarations.add(fieldDeclaration);
            if (this.resolvedType != null) {
                this.resolvedType.declaredIFields = null;
            }
        }

        public String getDocComment() {
            return this.optionalDocComment;
        }

        public String getName() {
            return this.name;
        }

        public boolean hasDeprecatedDocTag() {
            return this.optionalDocComment != null && this.optionalDocComment.indexOf("@deprecated") != -1;
        }

        public String toString() {
            return this.name;
        }
    }

    public static final class MemberInterfaceDeclaration
    extends InterfaceDeclaration
    implements MemberTypeDeclaration {
        public MemberInterfaceDeclaration(Location location, NamedTypeDeclaration namedTypeDeclaration, String string, short s, String string2, Type[] typeArray) throws Parser.ParseException {
            super(location, namedTypeDeclaration, string, s, string2, typeArray);
            MemberTypeDeclaration memberTypeDeclaration = namedTypeDeclaration.getMemberTypeDeclaration(string2);
            if (memberTypeDeclaration != null) {
                this.throwParseException("Redeclaration of interface \"" + string2 + "\", previously declared in " + memberTypeDeclaration.getLocation());
            }
        }

        public final void accept(Visitor.TypeBodyDeclarationVisitor typeBodyDeclarationVisitor) {
            typeBodyDeclarationVisitor.visitMemberInterfaceDeclaration(this);
        }

        public final void accept(Visitor.TypeDeclarationVisitor typeDeclarationVisitor) {
            typeDeclarationVisitor.visitMemberInterfaceDeclaration(this);
        }

        public String getClassName() {
            NamedTypeDeclaration namedTypeDeclaration = (NamedTypeDeclaration)this.getEnclosingScope();
            return String.valueOf(namedTypeDeclaration.getClassName()) + '$' + this.getName();
        }

        public TypeDeclaration getDeclaringType() {
            return (TypeDeclaration)this.getEnclosingScope();
        }

        public boolean isStatic() {
            return (this.modifiers & 8) != 0;
        }
    }

    public static final class PackageMemberInterfaceDeclaration
    extends InterfaceDeclaration
    implements PackageMemberTypeDeclaration {
        public PackageMemberInterfaceDeclaration(Location location, CompilationUnit compilationUnit, String string, short s, String string2, Type[] typeArray) throws Parser.ParseException {
            super(location, compilationUnit, string, s, string2, typeArray);
            PackageMemberTypeDeclaration packageMemberTypeDeclaration;
            Object[] objectArray;
            if ((s & 0xE) != 0) {
                this.throwParseException("Modifiers \"protected\", \"private\" and \"static\" not allowed in package member interface declaration");
            }
            if ((objectArray = compilationUnit.getSingleTypeImport(string2)) != null) {
                this.throwParseException("Package member interface declaration \"" + string2 + "\" conflicts with single-type-import \"" + Java.join(objectArray, ".") + "\"");
            }
            if ((packageMemberTypeDeclaration = compilationUnit.getPackageMemberTypeDeclaration(string2)) != null) {
                this.throwParseException("Redeclaration of interface \"" + string2 + "\", previously declared in " + packageMemberTypeDeclaration.getLocation());
            }
        }

        public final void accept(Visitor.TypeDeclarationVisitor typeDeclarationVisitor) {
            typeDeclarationVisitor.visitPackageMemberInterfaceDeclaration(this);
        }

        public String getClassName() {
            String string = this.getName();
            CompilationUnit compilationUnit = (CompilationUnit)this.getEnclosingScope();
            if (compilationUnit.optionalPackageDeclaration != null) {
                string = String.valueOf(compilationUnit.optionalPackageDeclaration.packageName) + '.' + string;
            }
            return string;
        }
    }

    public static interface TypeBodyDeclaration
    extends Locatable,
    Scope {
        public void accept(Visitor.TypeBodyDeclarationVisitor var1);

        public TypeDeclaration getDeclaringType();

        public boolean isStatic();
    }

    public static abstract class AbstractTypeBodyDeclaration
    extends Located
    implements TypeBodyDeclaration {
        final TypeDeclaration declaringType;
        final boolean statiC;

        protected AbstractTypeBodyDeclaration(Location location, TypeDeclaration typeDeclaration, boolean bl) {
            super(location);
            this.declaringType = typeDeclaration;
            this.statiC = bl;
        }

        public abstract void accept(Visitor.TypeBodyDeclarationVisitor var1);

        public TypeDeclaration getDeclaringType() {
            return this.declaringType;
        }

        public Scope getEnclosingScope() {
            return this.declaringType;
        }

        public boolean isStatic() {
            return this.statiC;
        }
    }

    public static final class Initializer
    extends AbstractTypeBodyDeclaration
    implements BlockStatement {
        public Block block = null;

        public Initializer(Location location, TypeDeclaration typeDeclaration, boolean bl) {
            super(location, typeDeclaration, bl);
        }

        public final void accept(Visitor.BlockStatementVisitor blockStatementVisitor) {
            blockStatementVisitor.visitInitializer(this);
        }

        public final void accept(Visitor.TypeBodyDeclarationVisitor typeBodyDeclarationVisitor) {
            typeBodyDeclarationVisitor.visitInitializer(this);
        }

        public void setBlock(Block block) {
            if (this.block != null) {
                throw new RuntimeException();
            }
            this.block = block;
        }
    }

    public static abstract class FunctionDeclarator
    extends AbstractTypeBodyDeclaration
    implements DocCommentable {
        private final String optionalDocComment;
        public final short modifiers;
        final Type type;
        public final String name;
        public final FormalParameter[] formalParameters;
        protected final Type[] thrownExceptions;
        public Block optionalBody = null;
        IClass returnType = null;
        final HashMap parameters = new HashMap();

        public FunctionDeclarator(Location location, TypeDeclaration typeDeclaration, String string, short s, Type type, String string2, FormalParameter[] formalParameterArray, Type[] typeArray) {
            super(location, typeDeclaration, (s & 8) != 0);
            this.optionalDocComment = string;
            this.modifiers = s;
            this.type = type;
            this.name = string2;
            this.formalParameters = formalParameterArray;
            this.thrownExceptions = typeArray;
        }

        public String getDocComment() {
            return this.optionalDocComment;
        }

        public Scope getEnclosingScope() {
            return this.getDeclaringType();
        }

        public boolean hasDeprecatedDocTag() {
            return this.optionalDocComment != null && this.optionalDocComment.indexOf("@deprecated") != -1;
        }

        public void setBody(Block block) {
            if (this.optionalBody != null) {
                throw new RuntimeException("Body must be set exactly once");
            }
            this.optionalBody = block;
        }
    }

    public static final class ConstructorDeclarator
    extends FunctionDeclarator {
        final ClassDeclaration declaringClass;
        IClass.IConstructor iConstructor = null;
        public ConstructorInvocation optionalExplicitConstructorInvocation = null;
        Map syntheticParameters = new HashMap();

        public ConstructorDeclarator(Location location, ClassDeclaration classDeclaration, String string, short s, FormalParameter[] formalParameterArray, Type[] typeArray) {
            super(location, classDeclaration, string, s, new BasicType(location, 0), "<init>", formalParameterArray, typeArray);
            this.declaringClass = classDeclaration;
        }

        public final void accept(Visitor.TypeBodyDeclarationVisitor typeBodyDeclarationVisitor) {
            typeBodyDeclarationVisitor.visitConstructorDeclarator(this);
        }

        public void setExplicitConstructorInvocation(ConstructorInvocation constructorInvocation) {
            this.optionalExplicitConstructorInvocation = constructorInvocation;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.declaringClass.getClassName());
            stringBuffer.append('(');
            FormalParameter[] formalParameterArray = this.formalParameters;
            int n = 0;
            while (n < formalParameterArray.length) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(formalParameterArray[n].toString());
                ++n;
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
    }

    public static final class MethodDeclarator
    extends FunctionDeclarator {
        IClass.IMethod iMethod = null;

        public MethodDeclarator(Location location, AbstractTypeDeclaration abstractTypeDeclaration, String string, short s, Type type, String string2, FormalParameter[] formalParameterArray, Type[] typeArray) {
            super(location, abstractTypeDeclaration, string, s, type, string2, formalParameterArray, typeArray);
        }

        public final void accept(Visitor.TypeBodyDeclarationVisitor typeBodyDeclarationVisitor) {
            typeBodyDeclarationVisitor.visitMethodDeclarator(this);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.name);
            stringBuffer.append('(');
            FormalParameter[] formalParameterArray = this.formalParameters;
            int n = 0;
            while (n < formalParameterArray.length) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(formalParameterArray[n].toString());
                ++n;
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
    }

    public static final class FieldDeclaration
    extends Statement
    implements TypeBodyDeclaration,
    DocCommentable {
        private final String optionalDocComment;
        final AbstractTypeDeclaration declaringType;
        final short modifiers;
        public final Type type;
        public VariableDeclarator[] variableDeclarators = null;

        public FieldDeclaration(Location location, AbstractTypeDeclaration abstractTypeDeclaration, String string, short s, Type type) {
            super(location, abstractTypeDeclaration);
            this.optionalDocComment = string;
            this.modifiers = s;
            this.declaringType = abstractTypeDeclaration;
            this.type = type;
        }

        public final void accept(Visitor.BlockStatementVisitor blockStatementVisitor) {
            blockStatementVisitor.visitFieldDeclaration(this);
        }

        public final void accept(Visitor.TypeBodyDeclarationVisitor typeBodyDeclarationVisitor) {
            typeBodyDeclarationVisitor.visitFieldDeclaration(this);
        }

        public TypeDeclaration getDeclaringType() {
            return this.declaringType;
        }

        public String getDocComment() {
            return this.optionalDocComment;
        }

        public boolean hasDeprecatedDocTag() {
            return this.optionalDocComment != null && this.optionalDocComment.indexOf("@deprecated") != -1;
        }

        public boolean isStatic() {
            return (this.modifiers & 8) != 0;
        }

        public void setVariableDeclarators(VariableDeclarator[] variableDeclaratorArray) {
            this.variableDeclarators = variableDeclaratorArray;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(Mod.shortToString(this.modifiers)).append(' ').append(this.type).append(' ').append(this.variableDeclarators[0]);
            int n = 1;
            while (n < this.variableDeclarators.length) {
                stringBuffer.append(", ").append(this.variableDeclarators[n]);
                ++n;
            }
            return stringBuffer.toString();
        }
    }

    public static final class VariableDeclarator
    extends Located {
        public final String name;
        public final int brackets;
        public final Rvalue optionalInitializer;

        public VariableDeclarator(Location location, String string, int n, Rvalue rvalue) {
            super(location);
            this.name = string;
            this.brackets = n;
            this.optionalInitializer = rvalue;
        }
    }

    public static final class FormalParameter {
        final boolean finaL;
        public final Type type;
        final String name;

        public FormalParameter(boolean bl, Type type, String string) {
            this.finaL = bl;
            this.type = type;
            this.name = string;
        }

        public String toString() {
            return String.valueOf(this.type.toString()) + ' ' + this.name;
        }
    }

    public static interface BlockStatement
    extends Locatable,
    Scope {
        public void accept(Visitor.BlockStatementVisitor var1);
    }

    public static abstract class Statement
    extends Located
    implements BlockStatement {
        protected final Scope enclosingScope;

        protected Statement(Location location, Scope scope) {
            super(location);
            this.enclosingScope = scope;
        }

        public abstract void accept(Visitor.BlockStatementVisitor var1);

        public Scope getEnclosingScope() {
            return this.enclosingScope;
        }
    }

    public static final class LabeledStatement
    extends BreakableStatement {
        String label;
        public Statement body = null;

        public LabeledStatement(Location location, Scope scope, String string) {
            super(location, scope);
            this.label = string;
        }

        public final void accept(Visitor.BlockStatementVisitor blockStatementVisitor) {
            blockStatementVisitor.visitLabeledStatement(this);
        }

        public void setBody(Statement statement) {
            this.body = statement;
        }
    }

    public static final class Block
    extends Statement {
        public final List statements = new ArrayList();
        final Map declaredLocalClasses = new HashMap();
        HashMap localVariables = new HashMap();
        boolean keepCompiling;

        public Block(Location location, Scope scope) {
            super(location, scope);
        }

        public final void accept(Visitor.BlockStatementVisitor blockStatementVisitor) {
            blockStatementVisitor.visitBlock(this);
        }

        public void addStatement(BlockStatement blockStatement) {
            this.statements.add(blockStatement);
        }

        public void addStatements(List list) {
            this.statements.addAll(list);
        }

        void followingStatementsAreDead() {
            this.keepCompiling = false;
        }

        public LocalClassDeclaration getLocalClassDeclaration(String string) {
            return (LocalClassDeclaration)this.declaredLocalClasses.get(string);
        }

        public BlockStatement[] getStatements() {
            return this.statements.toArray(new BlockStatement[this.statements.size()]);
        }
    }

    public static abstract class BreakableStatement
    extends Statement {
        CodeContext.Offset whereToBreak = null;

        protected BreakableStatement(Location location, Scope scope) {
            super(location, scope);
        }
    }

    public static abstract class ContinuableStatement
    extends BreakableStatement {
        protected CodeContext.Offset whereToContinue = null;
        protected boolean bodyHasContinue = false;

        protected ContinuableStatement(Location location, Scope scope) {
            super(location, scope);
        }
    }

    public static final class ExpressionStatement
    extends Statement {
        public final Rvalue rvalue;

        public ExpressionStatement(Rvalue rvalue, Scope scope) throws Parser.ParseException {
            super(rvalue.getLocation(), scope);
            if (!(rvalue instanceof Assignment || rvalue instanceof Crement || rvalue instanceof MethodInvocation || rvalue instanceof SuperclassMethodInvocation || rvalue instanceof NewClassInstance)) {
                this.throwParseException("This kind of expression is not allowed in an expression statement");
            }
            this.rvalue = rvalue;
        }

        public final void accept(Visitor.BlockStatementVisitor blockStatementVisitor) {
            blockStatementVisitor.visitExpressionStatement(this);
        }
    }

    public static final class LocalClassDeclarationStatement
    extends Statement {
        public final LocalClassDeclaration lcd;

        public LocalClassDeclarationStatement(Scope scope, LocalClassDeclaration localClassDeclaration) {
            super(localClassDeclaration.getLocation(), scope);
            this.lcd = localClassDeclaration;
        }

        public final void accept(Visitor.BlockStatementVisitor blockStatementVisitor) {
            blockStatementVisitor.visitLocalClassDeclarationStatement(this);
        }
    }

    public static final class IfStatement
    extends Statement {
        public final Rvalue condition;
        public final BlockStatement thenStatement;
        public final BlockStatement optionalElseStatement;

        public IfStatement(Location location, Scope scope, Rvalue rvalue, BlockStatement blockStatement, BlockStatement blockStatement2) {
            super(location, scope);
            this.condition = rvalue;
            this.thenStatement = blockStatement;
            this.optionalElseStatement = blockStatement2;
        }

        public final void accept(Visitor.BlockStatementVisitor blockStatementVisitor) {
            blockStatementVisitor.visitIfStatement(this);
        }
    }

    public static final class ForStatement
    extends ContinuableStatement {
        public final Block implicitBlock = (Block)this.enclosingScope;
        public BlockStatement optionalInit = null;
        public Rvalue optionalCondition = null;
        public Rvalue[] optionalUpdate = null;
        public BlockStatement body;

        public ForStatement(Location location, Scope scope) {
            super(location, new Block(location, scope));
            this.body = new Block(location, this);
        }

        public final void accept(Visitor.BlockStatementVisitor blockStatementVisitor) {
            blockStatementVisitor.visitForStatement(this);
        }

        public void set(BlockStatement blockStatement, Rvalue rvalue, Rvalue[] rvalueArray, BlockStatement blockStatement2) {
            this.optionalInit = blockStatement;
            this.optionalCondition = rvalue;
            this.optionalUpdate = rvalueArray;
            this.body = blockStatement2;
        }
    }

    public static final class WhileStatement
    extends ContinuableStatement {
        public final Rvalue condition;
        public BlockStatement body = null;

        public WhileStatement(Location location, Scope scope, Rvalue rvalue) {
            super(location, scope);
            this.condition = rvalue;
        }

        public final void accept(Visitor.BlockStatementVisitor blockStatementVisitor) {
            blockStatementVisitor.visitWhileStatement(this);
        }

        public void setBody(BlockStatement blockStatement) {
            this.body = blockStatement;
        }
    }

    public static final class TryStatement
    extends Statement {
        public BlockStatement body = null;
        public final List catchClauses = new ArrayList();
        public Block optionalFinally = null;
        short stackValueLvIndex;
        CodeContext.Offset finallyOffset = null;

        public TryStatement(Location location, Scope scope) {
            super(location, scope);
        }

        public final void accept(Visitor.BlockStatementVisitor blockStatementVisitor) {
            blockStatementVisitor.visitTryStatement(this);
        }

        public void addCatchClause(CatchClause catchClause) {
            this.catchClauses.add(catchClause);
        }

        public void setBody(BlockStatement blockStatement) {
            this.body = blockStatement;
        }

        public void setFinally(Block block) {
            this.optionalFinally = block;
        }
    }

    public static class CatchClause {
        public final FormalParameter caughtException;
        public final Block body;

        public CatchClause(FormalParameter formalParameter, Block block) {
            this.caughtException = formalParameter;
            this.body = block;
        }
    }

    public static final class SwitchStatement
    extends BreakableStatement {
        public Rvalue condition = null;
        public final List sbsgs = new ArrayList();

        public SwitchStatement(Location location, Scope scope) {
            super(location, scope);
        }

        public final void accept(Visitor.BlockStatementVisitor blockStatementVisitor) {
            blockStatementVisitor.visitSwitchStatement(this);
        }

        public void addSwitchBlockStatementGroup(SwitchBlockStatementGroup switchBlockStatementGroup) {
            this.sbsgs.add(switchBlockStatementGroup);
        }

        public void setCondition(Rvalue rvalue) {
            this.condition = rvalue;
        }
    }

    static class Padder
    extends CodeContext.Inserter
    implements CodeContext.FixUp {
        public Padder(CodeContext codeContext) {
        }

        public void fixUp() {
            int n = this.offset % 4;
            if (n != 0) {
                CodeContext codeContext = this.getCodeContext();
                codeContext.pushInserter(this);
                codeContext.write((short)-1, new byte[4 - n]);
                codeContext.popInserter();
            }
        }
    }

    public static class SwitchBlockStatementGroup
    extends Located {
        public final List caseLabels = new ArrayList();
        public boolean hasDefaultLabel = false;
        public List blockStatements;

        public SwitchBlockStatementGroup(Location location) {
            super(location);
        }

        public void addDefaultSwitchLabel() throws Parser.ParseException {
            if (this.hasDefaultLabel) {
                this.throwParseException("Duplicate \"default\" switch label");
            }
            this.hasDefaultLabel = true;
        }

        public void addSwitchLabel(Rvalue rvalue) {
            this.caseLabels.add(rvalue);
        }

        public void setBlockStatements(List list) {
            this.blockStatements = list;
        }
    }

    public static final class SynchronizedStatement
    extends Statement {
        public final Rvalue expression;
        public BlockStatement body = null;
        short monitorLvIndex = (short)-1;

        public SynchronizedStatement(Location location, Scope scope, Rvalue rvalue) {
            super(location, scope);
            this.expression = rvalue;
        }

        public final void accept(Visitor.BlockStatementVisitor blockStatementVisitor) {
            blockStatementVisitor.visitSynchronizedStatement(this);
        }

        public void setBody(BlockStatement blockStatement) {
            this.body = blockStatement;
        }
    }

    public static final class DoStatement
    extends ContinuableStatement {
        public BlockStatement body = null;
        public Rvalue condition = null;

        public DoStatement(Location location, Scope scope) {
            super(location, scope);
        }

        public final void accept(Visitor.BlockStatementVisitor blockStatementVisitor) {
            blockStatementVisitor.visitDoStatement(this);
        }

        public void setBody(BlockStatement blockStatement) {
            this.body = blockStatement;
        }

        public void setCondition(Rvalue rvalue) {
            this.condition = rvalue;
        }
    }

    public static final class LocalVariableDeclarationStatement
    extends Statement {
        final Block declaringBlock;
        public final short modifiers;
        public final Type type;
        public final VariableDeclarator[] variableDeclarators;

        public LocalVariableDeclarationStatement(Location location, Block block, short s, Type type, VariableDeclarator[] variableDeclaratorArray) {
            super(location, block);
            this.declaringBlock = block;
            this.modifiers = s;
            this.type = type;
            this.variableDeclarators = variableDeclaratorArray;
        }

        public final void accept(Visitor.BlockStatementVisitor blockStatementVisitor) {
            blockStatementVisitor.visitLocalVariableDeclarationStatement(this);
        }
    }

    public static final class ReturnStatement
    extends Statement {
        public final Rvalue optionalReturnValue;

        public ReturnStatement(Location location, Scope scope, Rvalue rvalue) {
            super(location, scope);
            this.optionalReturnValue = rvalue;
        }

        public final void accept(Visitor.BlockStatementVisitor blockStatementVisitor) {
            blockStatementVisitor.visitReturnStatement(this);
        }
    }

    public static final class ThrowStatement
    extends Statement {
        public final Rvalue expression;

        public ThrowStatement(Location location, Scope scope, Rvalue rvalue) {
            super(location, scope);
            this.expression = rvalue;
        }

        public final void accept(Visitor.BlockStatementVisitor blockStatementVisitor) {
            blockStatementVisitor.visitThrowStatement(this);
        }
    }

    public static final class BreakStatement
    extends Statement {
        public final String optionalLabel;

        public BreakStatement(Location location, Scope scope, String string) {
            super(location, scope);
            this.optionalLabel = string;
        }

        public final void accept(Visitor.BlockStatementVisitor blockStatementVisitor) {
            blockStatementVisitor.visitBreakStatement(this);
        }
    }

    public static final class ContinueStatement
    extends Statement {
        public final String optionalLabel;

        public ContinueStatement(Location location, Scope scope, String string) {
            super(location, scope);
            this.optionalLabel = string;
        }

        public final void accept(Visitor.BlockStatementVisitor blockStatementVisitor) {
            blockStatementVisitor.visitContinueStatement(this);
        }
    }

    public static final class EmptyStatement
    extends Statement {
        public EmptyStatement(Location location, Scope scope) {
            super(location, scope);
        }

        public final void accept(Visitor.BlockStatementVisitor blockStatementVisitor) {
            blockStatementVisitor.visitEmptyStatement(this);
        }
    }

    public static abstract class Atom
    extends Located {
        public Atom(Location location) {
            super(location);
        }

        public abstract void accept(Visitor.AtomVisitor var1);

        public Lvalue toLvalue() {
            return null;
        }

        public final Lvalue toLvalueOrPE() throws Parser.ParseException {
            Lvalue lvalue = this.toLvalue();
            if (lvalue == null) {
                this.throwParseException("Expression \"" + this.toString() + "\" is not an lvalue");
            }
            return lvalue;
        }

        public Rvalue toRvalue() {
            return null;
        }

        public final Rvalue toRvalueOrPE() throws Parser.ParseException {
            Rvalue rvalue = this.toRvalue();
            if (rvalue == null) {
                this.throwParseException("Expression \"" + this.toString() + "\" is not an rvalue");
            }
            return rvalue;
        }

        public abstract String toString();

        public Type toType() {
            return null;
        }

        public final Type toTypeOrPE() throws Parser.ParseException {
            Type type = this.toType();
            if (type == null) {
                this.throwParseException("Expression \"" + this.toString() + "\" is not a type");
            }
            return type;
        }
    }

    public static abstract class Type
    extends Atom {
        protected Type(Location location) {
            super(location);
        }

        public abstract void accept(Visitor.TypeVisitor var1);

        public Type toType() {
            return this;
        }
    }

    public static final class SimpleType
    extends Type {
        public final IClass iClass;

        public SimpleType(Location location, IClass iClass) {
            super(location);
            this.iClass = iClass;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitSimpleType(this);
        }

        public final void accept(Visitor.TypeVisitor typeVisitor) {
            typeVisitor.visitSimpleType(this);
        }

        public String toString() {
            return this.iClass.toString();
        }
    }

    public static final class BasicType
    extends Type {
        public int index;
        public static final int VOID = 0;
        public static final int BYTE = 1;
        public static final int SHORT = 2;
        public static final int CHAR = 3;
        public static final int INT = 4;
        public static final int LONG = 5;
        public static final int FLOAT = 6;
        public static final int DOUBLE = 7;
        public static final int BOOLEAN = 8;

        public BasicType(Location location, int n) {
            super(location);
            this.index = n;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitBasicType(this);
        }

        public final void accept(Visitor.TypeVisitor typeVisitor) {
            typeVisitor.visitBasicType(this);
        }

        public String toString() {
            switch (this.index) {
                case 0: {
                    return "void";
                }
                case 1: {
                    return "byte";
                }
                case 2: {
                    return "short";
                }
                case 3: {
                    return "char";
                }
                case 4: {
                    return "int";
                }
                case 5: {
                    return "long";
                }
                case 6: {
                    return "float";
                }
                case 7: {
                    return "double";
                }
                case 8: {
                    return "boolean";
                }
            }
            throw new RuntimeException("Invalid index " + this.index);
        }
    }

    public static final class ReferenceType
    extends Type {
        public final String[] identifiers;
        public final Scope scope;

        public ReferenceType(Location location, Scope scope, String[] stringArray) {
            super(location);
            this.scope = scope;
            this.identifiers = stringArray;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitReferenceType(this);
        }

        public final void accept(Visitor.TypeVisitor typeVisitor) {
            typeVisitor.visitReferenceType(this);
        }

        public String toString() {
            return Java.join(this.identifiers, ".");
        }
    }

    public static final class RvalueMemberType
    extends Type {
        public final Rvalue rvalue;
        public final String identifier;

        public RvalueMemberType(Location location, Rvalue rvalue, String string) {
            super(location);
            this.rvalue = rvalue;
            this.identifier = string;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitRvalueMemberType(this);
        }

        public final void accept(Visitor.TypeVisitor typeVisitor) {
            typeVisitor.visitRvalueMemberType(this);
        }

        public String toString() {
            return this.identifier;
        }
    }

    public static final class ArrayType
    extends Type {
        public final Type componentType;

        public ArrayType(Type type) {
            super(type.getLocation());
            this.componentType = type;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitArrayType(this);
        }

        public final void accept(Visitor.TypeVisitor typeVisitor) {
            typeVisitor.visitArrayType(this);
        }

        public String toString() {
            return String.valueOf(this.componentType.toString()) + "[]";
        }
    }

    public static abstract class Rvalue
    extends Atom {
        static final Object CONSTANT_VALUE_UNKNOWN = new Object();
        Object constantValue = CONSTANT_VALUE_UNKNOWN;
        public static final Object CONSTANT_VALUE_NULL = new Throwable();
        public static final boolean JUMP_IF_TRUE = true;
        public static final boolean JUMP_IF_FALSE = false;

        protected Rvalue(Location location) {
            super(location);
        }

        public abstract void accept(Visitor.RvalueVisitor var1);

        public Rvalue toRvalue() {
            return this;
        }
    }

    public static abstract class BooleanRvalue
    extends Rvalue {
        protected BooleanRvalue(Location location) {
            super(location);
        }
    }

    public static abstract class Lvalue
    extends Rvalue {
        protected Lvalue(Location location) {
            super(location);
        }

        public abstract void accept(Visitor.LvalueVisitor var1);

        public Lvalue toLvalue() {
            return this;
        }
    }

    public static final class AmbiguousName
    extends Lvalue {
        private Type type = null;
        Atom reclassified = null;
        public final Scope scope;
        public final String[] identifiers;
        final int n;

        public AmbiguousName(Location location, Scope scope, String[] stringArray) {
            this(location, scope, stringArray, stringArray.length);
        }

        public AmbiguousName(Location location, Scope scope, String[] stringArray, int n) {
            super(location);
            this.scope = scope;
            this.identifiers = stringArray;
            this.n = n;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitAmbiguousName(this);
        }

        public final void accept(Visitor.LvalueVisitor lvalueVisitor) {
            lvalueVisitor.visitAmbiguousName(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitAmbiguousName(this);
        }

        public String toString() {
            return Java.join(this.identifiers, ".", 0, this.n);
        }

        public Type toType() {
            if (this.type == null) {
                this.type = new ReferenceType(this.getLocation(), this.scope, this.identifiers);
            }
            return this.type;
        }
    }

    public static final class Package
    extends Atom {
        public final String name;

        public Package(Location location, String string) {
            super(location);
            this.name = string;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitPackage(this);
        }

        public String toString() {
            return this.name;
        }
    }

    public static final class LocalVariableAccess
    extends Lvalue {
        public LocalVariable localVariable;

        public LocalVariableAccess(Location location, LocalVariable localVariable) {
            super(location);
            this.localVariable = localVariable;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitLocalVariableAccess(this);
        }

        public final void accept(Visitor.LvalueVisitor lvalueVisitor) {
            lvalueVisitor.visitLocalVariableAccess(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitLocalVariableAccess(this);
        }

        public String toString() {
            return this.localVariable.toString();
        }
    }

    public static final class FieldAccess
    extends Lvalue {
        public final BlockStatement enclosingBlockStatement;
        public final Atom lhs;
        public final IClass.IField field;

        public FieldAccess(Location location, BlockStatement blockStatement, Atom atom, IClass.IField iField) {
            super(location);
            this.enclosingBlockStatement = blockStatement;
            this.lhs = atom;
            this.field = iField;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitFieldAccess(this);
        }

        public final void accept(Visitor.LvalueVisitor lvalueVisitor) {
            lvalueVisitor.visitFieldAccess(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitFieldAccess(this);
        }

        public String toString() {
            return String.valueOf(this.lhs.toString()) + '.' + this.field.toString();
        }
    }

    public static final class ArrayLength
    extends Rvalue {
        public final Rvalue lhs;

        public ArrayLength(Location location, Rvalue rvalue) {
            super(location);
            this.lhs = rvalue;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitArrayLength(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitArrayLength(this);
        }

        public String toString() {
            return String.valueOf(this.lhs.toString()) + ".length";
        }
    }

    public static final class ThisReference
    extends Rvalue {
        final Scope scope;
        IClass iClass = null;

        public ThisReference(Location location, Scope scope) {
            super(location);
            this.scope = scope;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitThisReference(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitThisReference(this);
        }

        public String toString() {
            return "this";
        }
    }

    public static final class QualifiedThisReference
    extends Rvalue {
        public final Scope scope;
        public final Type qualification;
        ClassDeclaration declaringClass = null;
        TypeBodyDeclaration declaringTypeBodyDeclaration = null;
        IClass targetIClass = null;

        public QualifiedThisReference(Location location, ClassDeclaration classDeclaration, TypeBodyDeclaration typeBodyDeclaration, IClass iClass) {
            super(location);
            if (classDeclaration == null) {
                throw new NullPointerException();
            }
            if (typeBodyDeclaration == null) {
                throw new NullPointerException();
            }
            if (iClass == null) {
                throw new NullPointerException();
            }
            this.scope = null;
            this.qualification = null;
            this.declaringClass = classDeclaration;
            this.declaringTypeBodyDeclaration = typeBodyDeclaration;
            this.targetIClass = iClass;
        }

        public QualifiedThisReference(Location location, Scope scope, Type type) {
            super(location);
            if (scope == null) {
                throw new NullPointerException();
            }
            if (type == null) {
                throw new NullPointerException();
            }
            this.scope = scope;
            this.qualification = type;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitQualifiedThisReference(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitQualifiedThisReference(this);
        }

        public String toString() {
            return String.valueOf(this.qualification.toString()) + ".this";
        }
    }

    public static final class ClassLiteral
    extends Rvalue {
        final AbstractTypeDeclaration declaringType;
        final BlockStatement enclosingBlockStatement;
        public final Type type;

        public ClassLiteral(Location location, BlockStatement blockStatement, Type type) {
            super(location);
            this.enclosingBlockStatement = blockStatement;
            Scope scope = blockStatement;
            while (!(scope instanceof AbstractTypeDeclaration)) {
                scope = scope.getEnclosingScope();
            }
            this.declaringType = (AbstractTypeDeclaration)scope;
            this.type = type;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitClassLiteral(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitClassLiteral(this);
        }

        public String toString() {
            return String.valueOf(this.type.toString()) + ".class";
        }
    }

    public static final class Assignment
    extends Rvalue {
        public final Lvalue lhs;
        public final String operator;
        public final Rvalue rhs;

        public Assignment(Location location, Lvalue lvalue, String string, Rvalue rvalue) {
            super(location);
            this.lhs = lvalue;
            this.operator = string;
            this.rhs = rvalue;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitAssignment(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitAssignment(this);
        }

        public String toString() {
            return String.valueOf(this.lhs.toString()) + ' ' + this.operator + ' ' + this.rhs.toString();
        }
    }

    public static final class ConditionalExpression
    extends Rvalue {
        public final Rvalue lhs;
        public final Rvalue mhs;
        public final Rvalue rhs;

        public ConditionalExpression(Location location, Rvalue rvalue, Rvalue rvalue2, Rvalue rvalue3) {
            super(location);
            this.lhs = rvalue;
            this.mhs = rvalue2;
            this.rhs = rvalue3;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitConditionalExpression(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitConditionalExpression(this);
        }

        public String toString() {
            return String.valueOf(this.lhs.toString()) + " ? " + this.mhs.toString() + " : " + this.rhs.toString();
        }
    }

    public static final class Crement
    extends Rvalue {
        public final boolean pre;
        public final String operator;
        public final Lvalue operand;

        public Crement(Location location, String string, Lvalue lvalue) {
            super(location);
            this.pre = true;
            this.operator = string;
            this.operand = lvalue;
        }

        public Crement(Location location, Lvalue lvalue, String string) {
            super(location);
            this.pre = false;
            this.operator = string;
            this.operand = lvalue;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitCrement(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitCrement(this);
        }

        public String toString() {
            return this.pre ? String.valueOf(this.operator) + this.operand : String.valueOf(String.valueOf(this.operand)) + this.operator;
        }
    }

    public static final class ArrayAccessExpression
    extends Lvalue {
        public final Rvalue lhs;
        public final Rvalue index;

        public ArrayAccessExpression(Location location, Rvalue rvalue, Rvalue rvalue2) {
            super(location);
            this.lhs = rvalue;
            this.index = rvalue2;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitArrayAccessExpression(this);
        }

        public final void accept(Visitor.LvalueVisitor lvalueVisitor) {
            lvalueVisitor.visitArrayAccessExpression(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitArrayAccessExpression(this);
        }

        public String toString() {
            return String.valueOf(this.lhs.toString()) + '[' + this.index + ']';
        }
    }

    public static final class FieldAccessExpression
    extends Lvalue {
        public final BlockStatement enclosingBlockStatement;
        public final Atom lhs;
        public final String fieldName;
        Rvalue value = null;

        public FieldAccessExpression(Location location, BlockStatement blockStatement, Atom atom, String string) {
            super(location);
            this.enclosingBlockStatement = blockStatement;
            this.lhs = atom;
            this.fieldName = string;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitFieldAccessExpression(this);
        }

        public final void accept(Visitor.LvalueVisitor lvalueVisitor) {
            lvalueVisitor.visitFieldAccessExpression(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitFieldAccessExpression(this);
        }

        public String toString() {
            return String.valueOf(this.lhs.toString()) + '.' + this.fieldName;
        }
    }

    public static final class UnaryOperation
    extends BooleanRvalue {
        public final String operator;
        public final Rvalue operand;

        public UnaryOperation(Location location, String string, Rvalue rvalue) {
            super(location);
            this.operator = string;
            this.operand = rvalue;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitUnaryOperation(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitUnaryOperation(this);
        }

        public String toString() {
            return String.valueOf(this.operator) + this.operand.toString();
        }
    }

    public static final class Instanceof
    extends Rvalue {
        public final Rvalue lhs;
        public final Type rhs;

        public Instanceof(Location location, Rvalue rvalue, Type type) {
            super(location);
            this.lhs = rvalue;
            this.rhs = type;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitInstanceof(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitInstanceof(this);
        }

        public String toString() {
            return String.valueOf(this.lhs.toString()) + " instanceof " + this.rhs.toString();
        }
    }

    public static final class BinaryOperation
    extends BooleanRvalue {
        public final Rvalue lhs;
        public final String op;
        public final Rvalue rhs;

        public BinaryOperation(Location location, Rvalue rvalue, String string, Rvalue rvalue2) {
            super(location);
            this.lhs = rvalue;
            this.op = string;
            this.rhs = rvalue2;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitBinaryOperation(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitBinaryOperation(this);
        }

        public String toString() {
            return String.valueOf(this.lhs.toString()) + ' ' + this.op + ' ' + this.rhs.toString();
        }

        public Iterator unrollLeftAssociation() {
            Rvalue rvalue;
            ArrayList<Rvalue> arrayList = new ArrayList<Rvalue>();
            BinaryOperation binaryOperation = this;
            while (true) {
                arrayList.add(binaryOperation.rhs);
                rvalue = binaryOperation.lhs;
                if (!(rvalue instanceof BinaryOperation) || ((BinaryOperation)rvalue).op != this.op) break;
                binaryOperation = (BinaryOperation)rvalue;
            }
            arrayList.add(rvalue);
            return new ReverseListIterator(arrayList.listIterator(arrayList.size()));
        }
    }

    public static final class Cast
    extends Rvalue {
        public final Type targetType;
        public final Rvalue value;

        public Cast(Location location, Type type, Rvalue rvalue) {
            super(location);
            this.targetType = type;
            this.value = rvalue;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitCast(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitCast(this);
        }

        public String toString() {
            return String.valueOf('(') + this.targetType.toString() + ") " + this.value.toString();
        }
    }

    public static final class ParenthesizedExpression
    extends Lvalue {
        public final Rvalue value;

        public ParenthesizedExpression(Location location, Rvalue rvalue) {
            super(location);
            this.value = rvalue;
        }

        public void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitParenthesizedExpression(this);
        }

        public void accept(Visitor.LvalueVisitor lvalueVisitor) {
            lvalueVisitor.visitParenthesizedExpression(this);
        }

        public void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitParenthesizedExpression(this);
        }

        public String toString() {
            return String.valueOf('(') + this.value.toString() + ')';
        }
    }

    public static abstract class ConstructorInvocation
    extends Atom {
        protected final ClassDeclaration declaringClass;
        protected final ConstructorDeclarator declaringConstructor;
        public final Rvalue[] arguments;

        protected ConstructorInvocation(Location location, ClassDeclaration classDeclaration, ConstructorDeclarator constructorDeclarator, Rvalue[] rvalueArray) {
            super(location);
            this.declaringClass = classDeclaration;
            this.declaringConstructor = constructorDeclarator;
            this.arguments = rvalueArray;
        }

        public abstract void accept(Visitor.ConstructorInvocationVisitor var1);
    }

    public static final class AlternateConstructorInvocation
    extends ConstructorInvocation {
        public AlternateConstructorInvocation(Location location, ClassDeclaration classDeclaration, ConstructorDeclarator constructorDeclarator, Rvalue[] rvalueArray) {
            super(location, classDeclaration, constructorDeclarator, rvalueArray);
        }

        public void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitAlternateConstructorInvocation(this);
        }

        public void accept(Visitor.ConstructorInvocationVisitor constructorInvocationVisitor) {
            constructorInvocationVisitor.visitAlternateConstructorInvocation(this);
        }

        public String toString() {
            return "this()";
        }
    }

    public static final class SuperConstructorInvocation
    extends ConstructorInvocation {
        public final Rvalue optionalQualification;

        public SuperConstructorInvocation(Location location, ClassDeclaration classDeclaration, ConstructorDeclarator constructorDeclarator, Rvalue rvalue, Rvalue[] rvalueArray) {
            super(location, classDeclaration, constructorDeclarator, rvalueArray);
            this.optionalQualification = rvalue;
        }

        public void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitSuperConstructorInvocation(this);
        }

        public void accept(Visitor.ConstructorInvocationVisitor constructorInvocationVisitor) {
            constructorInvocationVisitor.visitSuperConstructorInvocation(this);
        }

        public String toString() {
            return "super()";
        }
    }

    public static final class MethodInvocation
    extends Invocation {
        public final Atom optionalTarget;
        public final String methodName;
        IClass.IMethod iMethod;

        public MethodInvocation(Location location, BlockStatement blockStatement, Atom atom, String string, Rvalue[] rvalueArray) {
            super(location, blockStatement, rvalueArray);
            this.optionalTarget = atom;
            this.methodName = string;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitMethodInvocation(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitMethodInvocation(this);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.optionalTarget != null) {
                stringBuffer.append(this.optionalTarget.toString()).append('.');
            }
            stringBuffer.append(this.methodName).append('(');
            int n = 0;
            while (n < this.arguments.length) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.arguments[n].toString());
                ++n;
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
    }

    public static final class SuperclassMethodInvocation
    extends Invocation {
        public final String methodName;

        public SuperclassMethodInvocation(Location location, BlockStatement blockStatement, String string, Rvalue[] rvalueArray) {
            super(location, blockStatement, rvalueArray);
            this.methodName = string;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitSuperclassMethodInvocation(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitSuperclassMethodInvocation(this);
        }

        public String toString() {
            return "super." + this.methodName + "()";
        }
    }

    public static abstract class Invocation
    extends Rvalue {
        protected final BlockStatement enclosingBlockStatement;
        public final Rvalue[] arguments;

        protected Invocation(Location location, BlockStatement blockStatement, Rvalue[] rvalueArray) {
            super(location);
            this.enclosingBlockStatement = blockStatement;
            this.arguments = rvalueArray;
        }
    }

    public static final class NewClassInstance
    extends Rvalue {
        public final Scope scope;
        public final Rvalue optionalQualification;
        public final Type type;
        public final Rvalue[] arguments;
        protected IClass iClass = null;

        public NewClassInstance(Location location, Scope scope, Rvalue rvalue, IClass iClass, Rvalue[] rvalueArray) {
            super(location);
            this.scope = scope;
            this.optionalQualification = rvalue;
            this.type = null;
            this.arguments = rvalueArray;
            this.iClass = iClass;
        }

        public NewClassInstance(Location location, Scope scope, Rvalue rvalue, Type type, Rvalue[] rvalueArray) {
            super(location);
            this.scope = scope;
            this.optionalQualification = rvalue;
            this.type = type;
            this.arguments = rvalueArray;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitNewClassInstance(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitNewClassInstance(this);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.optionalQualification != null) {
                stringBuffer.append(this.optionalQualification.toString()).append('.');
            }
            stringBuffer.append("new ");
            if (this.type != null) {
                stringBuffer.append(this.type.toString());
            } else if (this.iClass != null) {
                stringBuffer.append(this.iClass.toString());
            } else {
                stringBuffer.append("???");
            }
            stringBuffer.append("()");
            return stringBuffer.toString();
        }
    }

    public static final class NewAnonymousClassInstance
    extends Rvalue {
        final Scope scope;
        public final Rvalue optionalQualification;
        public final AnonymousClassDeclaration anonymousClassDeclaration;
        public final Rvalue[] arguments;

        public NewAnonymousClassInstance(Location location, Scope scope, Rvalue rvalue, AnonymousClassDeclaration anonymousClassDeclaration, Rvalue[] rvalueArray) {
            super(location);
            this.scope = scope;
            this.optionalQualification = rvalue;
            this.anonymousClassDeclaration = anonymousClassDeclaration;
            this.arguments = rvalueArray;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitNewAnonymousClassInstance(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitNewAnonymousClassInstance(this);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.optionalQualification != null) {
                stringBuffer.append(this.optionalQualification.toString()).append('.');
            }
            stringBuffer.append("new ").append(this.anonymousClassDeclaration.toString()).append("() { ... }");
            return stringBuffer.toString();
        }
    }

    public static final class ParameterAccess
    extends Rvalue {
        public final FunctionDeclarator declaringFunction;
        public final String name;

        public ParameterAccess(Location location, FunctionDeclarator functionDeclarator, String string) {
            super(location);
            this.declaringFunction = functionDeclarator;
            this.name = string;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitParameterAccess(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitParameterAccess(this);
        }

        public String toString() {
            return this.name;
        }
    }

    public static final class NewArray
    extends Rvalue {
        public final Type type;
        public final Rvalue[] dimExprs;
        public final int dims;

        public NewArray(Location location, Type type, Rvalue[] rvalueArray, int n) {
            super(location);
            this.type = type;
            this.dimExprs = rvalueArray;
            this.dims = n;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitNewArray(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitNewArray(this);
        }

        public String toString() {
            return "new " + this.type.toString() + "[]...";
        }
    }

    public static final class ArrayInitializer
    extends Rvalue {
        final ArrayType arrayType;
        public final Rvalue[] values;

        public ArrayInitializer(Location location, ArrayType arrayType, Rvalue[] rvalueArray) {
            super(location);
            this.arrayType = arrayType;
            this.values = rvalueArray;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitArrayInitializer(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitArrayInitializer(this);
        }

        public String toString() {
            return "{ ... }";
        }
    }

    public static final class Literal
    extends Rvalue {
        public final Object value;

        public Literal(Location location, Object object) {
            super(location);
            this.value = object;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitLiteral(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitLiteral(this);
        }

        public String toString() {
            return Scanner.literalValueToString(this.value);
        }
    }

    public static final class ConstantValue
    extends Rvalue {
        public final Object constantValue;

        public ConstantValue(Location location, Object object) {
            super(location);
            this.constantValue = object == null ? Rvalue.CONSTANT_VALUE_NULL : object;
        }

        public final void accept(Visitor.AtomVisitor atomVisitor) {
            atomVisitor.visitConstantValue(this);
        }

        public final void accept(Visitor.RvalueVisitor rvalueVisitor) {
            rvalueVisitor.visitConstantValue(this);
        }

        public String toString() {
            return this.constantValue.toString();
        }
    }

    public static class LocalVariable {
        public final boolean finaL;
        public final IClass type;
        public final short localVariableArrayIndex;

        public LocalVariable(boolean bl, IClass iClass, short s) {
            this.finaL = bl;
            this.type = iClass;
            this.localVariableArrayIndex = s;
        }
    }
}

