/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.codehaus.janino.IClass;
import org.codehaus.janino.Java;
import org.codehaus.janino.Location;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.Visitor;

public class AstGeneratorVisitor
implements Visitor.ComprehensiveVisitor {
    private static final int TAB_SIZE = 4;
    private static final String TAB_FILLER = "                                ";
    private final String name;
    private final PrintWriter pw;
    private int level = 0;
    private Set instances = new HashSet();
    private static final short[] MODS = new short[]{1, 2, 4, 8, 16, 32, 32, 64, 128, 256, 512, 1024, 2048};
    private static final String[] MOD_NAMES = new String[]{"Mod.PUBLIC", "Mod.PRIVATE", "Mod.PROTECTED", "Mod.STATIC", "Mod.FINAL", "Mod.SUPER", "Mod.SYNCHRONIZED", "Mod.VOLATILE", "Mod.TRANSIENT", "Mod.NATIVE", "Mod.INTERFACE", "Mod.ABSTRACT", "Mod.STRICTFP"};
    static /* synthetic */ Class class$org$codehaus$janino$AstCompilationUnitGenerator;

    public AstGeneratorVisitor(Writer writer, String string) {
        this.pw = new PrintWriter(writer);
        this.name = string;
    }

    private String arrayToString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("new String[] { ");
        String string = "";
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(string).append("\"" + stringArray[n] + "\"");
            string = ", ";
            ++n;
        }
        return stringBuffer.append("}").toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private String escape(char c) {
        switch (c) {
            case '\"': {
                return "\\\"";
            }
            case '\'': {
                return "\\'";
            }
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\t': {
                return "\\t";
            }
            case '\\': {
                return "\\\\";
            }
        }
        return String.valueOf(c);
    }

    private String escape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            stringBuffer.append(this.escape(string.charAt(n)));
            ++n;
        }
        return stringBuffer.toString();
    }

    private void generateAbstractTypeDeclarationBody(Java.AbstractTypeDeclaration abstractTypeDeclaration) {
        Object object;
        Iterator iterator = abstractTypeDeclaration.declaredMethods.iterator();
        while (iterator.hasNext()) {
            object = (Java.MethodDeclarator)iterator.next();
            this.write("declaration.addDeclaredMethod(generateMethodDeclarator" + this.getSuffix(object) + "(declaration));");
        }
        object = abstractTypeDeclaration.declaredClassesAndInterfaces.iterator();
        while (object.hasNext()) {
            Java.MemberTypeDeclaration memberTypeDeclaration = (Java.MemberTypeDeclaration)object.next();
            this.write("declaration.addMemberTypeDeclaration(generateMemberTypeDeclaration" + this.getSuffix(memberTypeDeclaration) + "(declaration));");
        }
    }

    private void generateAbstractTypeDeclarationBodyMethods(Java.AbstractTypeDeclaration abstractTypeDeclaration) {
        Iterator iterator = abstractTypeDeclaration.declaredMethods.iterator();
        while (iterator.hasNext()) {
            ((Java.MethodDeclarator)iterator.next()).accept(this);
        }
        Iterator iterator2 = abstractTypeDeclaration.declaredClassesAndInterfaces.iterator();
        while (iterator2.hasNext()) {
            ((Java.MemberTypeDeclaration)iterator2.next()).accept(this);
        }
    }

    private void generateClassDeclarationBody(Java.ClassDeclaration classDeclaration) {
        Object object;
        Iterator iterator = classDeclaration.constructors.iterator();
        while (iterator.hasNext()) {
            object = (Java.ConstructorDeclarator)iterator.next();
            this.write("declaration.addConstructor(generateConstructorDeclarator" + this.getSuffix(object) + "(declaration));");
        }
        this.generateAbstractTypeDeclarationBody(classDeclaration);
        object = classDeclaration.variableDeclaratorsAndInitializers.iterator();
        while (object.hasNext()) {
            Java.TypeBodyDeclaration typeBodyDeclaration = (Java.TypeBodyDeclaration)object.next();
            this.write("declaration.addVariableDeclaratorOrInitializer(generateFieldDeclaration" + this.getSuffix(typeBodyDeclaration) + "(declaration));");
        }
    }

    private void generateClassDeclarationBodyMethods(Java.ClassDeclaration classDeclaration) {
        Iterator iterator = classDeclaration.constructors.iterator();
        while (iterator.hasNext()) {
            ((Java.ConstructorDeclarator)iterator.next()).accept(this);
        }
        Iterator iterator2 = classDeclaration.variableDeclaratorsAndInitializers.iterator();
        while (iterator2.hasNext()) {
            ((Java.TypeBodyDeclaration)iterator2.next()).accept(this);
        }
        this.generateAbstractTypeDeclarationBodyMethods(classDeclaration);
    }

    public void generateCompilationUnit(Java.CompilationUnit compilationUnit) {
        Object object;
        this.write("package org.codehaus.janino;");
        this.write();
        this.write("import org.codehaus.janino.Java;");
        this.write("import org.codehaus.janino.Mod;");
        this.write("import java.util.*;");
        this.write();
        this.write("public class " + this.name + " implements " + (class$org$codehaus$janino$AstCompilationUnitGenerator != null ? class$org$codehaus$janino$AstCompilationUnitGenerator : (class$org$codehaus$janino$AstCompilationUnitGenerator = AstGeneratorVisitor.class$("org.codehaus.janino.AstCompilationUnitGenerator"))).getName() + " {");
        ++this.level;
        this.write("public static final String FILE_NAME = \"" + compilationUnit.optionalFileName + "\";");
        this.write();
        this.write("public Java.CompilationUnit generate() throws Exception {");
        ++this.level;
        this.write("Java.CompilationUnit cu = new Java.CompilationUnit(\"" + compilationUnit.optionalFileName + "\");");
        if (compilationUnit.optionalPackageDeclaration != null) {
            this.write("cu.setPackageDeclaration(new Java.PackageDeclaration(" + this.getLocation(compilationUnit.optionalPackageDeclaration) + ", \"" + compilationUnit.optionalPackageDeclaration.packageName + "\"));");
        }
        Iterator iterator = compilationUnit.importDeclarations.iterator();
        while (iterator.hasNext()) {
            this.write("cu.addImportDeclaration(generateImportDeclaration" + this.getSuffix(iterator.next()) + "());");
        }
        Iterator iterator2 = compilationUnit.packageMemberTypeDeclarations.iterator();
        while (iterator2.hasNext()) {
            object = (Java.PackageMemberTypeDeclaration)iterator2.next();
            this.write("cu.addPackageMemberTypeDeclaration(generateMemberTypeDeclaration" + this.getSuffix(object) + "(cu));");
        }
        this.write("return cu;");
        --this.level;
        this.write("}");
        this.write();
        object = compilationUnit.importDeclarations.iterator();
        while (object.hasNext()) {
            ((Java.ImportDeclaration)object.next()).accept(this);
        }
        Iterator iterator3 = compilationUnit.packageMemberTypeDeclarations.iterator();
        while (iterator3.hasNext()) {
            ((Java.PackageMemberTypeDeclaration)iterator3.next()).accept(this);
        }
        this.write("private Location getLocation(int line, int column) {");
        ++this.level;
        this.write("return new Location(FILE_NAME, (short) line, (short) column);");
        --this.level;
        this.write("}");
        this.write();
        --this.level;
        this.write("}");
        this.write();
    }

    public void generateFormalParameter(Java.FormalParameter formalParameter) {
        this.write("private Java.FormalParameter generateFormalParameter" + this.getSuffix(formalParameter) + "(Java.Scope scope) throws Exception {");
        ++this.level;
        this.write("return new Java.FormalParameter(" + formalParameter.finaL + ", generateType" + this.getSuffix(formalParameter.type) + "(scope), \"" + formalParameter.name + "\");");
        --this.level;
        this.write("}");
        this.write();
        formalParameter.type.accept((Visitor.TypeVisitor)this);
    }

    private void generateFormalParameters(Java.FormalParameter[] formalParameterArray) {
        if (formalParameterArray == null || formalParameterArray.length == 0) {
            return;
        }
        this.write("private Java.FormalParameter[] generateFormalParameters" + this.getSuffix(formalParameterArray) + "(Java.Scope scope) throws Exception {");
        ++this.level;
        this.write("return new Java.FormalParameter[] {");
        ++this.level;
        ++this.level;
        int n = 0;
        while (n < formalParameterArray.length) {
            this.write("generateFormalParameter" + this.getSuffix(formalParameterArray[n]) + "(scope),");
            ++n;
        }
        --this.level;
        this.write("};");
        --this.level;
        --this.level;
        this.write("}");
        this.write();
        int n2 = 0;
        while (n2 < formalParameterArray.length) {
            this.generateFormalParameter(formalParameterArray[n2]);
            ++n2;
        }
    }

    private void generateIClass(IClass iClass) {
        this.write("private IClass generateIClass" + this.getSuffix(iClass) + "() throws Exception {");
        ++this.level;
        this.write("return null;");
        --this.level;
        this.write("}");
        this.write();
    }

    private void generateRvalues(Java.Rvalue[] rvalueArray) {
        if (rvalueArray == null || rvalueArray.length == 0) {
            return;
        }
        this.write("private Java.Rvalue[] generateRvalues" + this.getSuffix(rvalueArray) + "(Java.BlockStatement enclosingBlockStatement) throws Exception {");
        ++this.level;
        this.write("return new Java.Rvalue[] {");
        ++this.level;
        ++this.level;
        int n = 0;
        while (n < rvalueArray.length) {
            this.write("generateAtom" + this.getSuffix(rvalueArray[n]) + "(enclosingBlockStatement),");
            ++n;
        }
        --this.level;
        this.write("};");
        --this.level;
        --this.level;
        this.write("}");
        this.write();
        int n2 = 0;
        while (n2 < rvalueArray.length) {
            rvalueArray[n2].accept((Visitor.RvalueVisitor)this);
            ++n2;
        }
    }

    private void generateSwitchBlockStatementGroup(Java.SwitchBlockStatementGroup switchBlockStatementGroup) {
        Object object;
        Object object2;
        this.write("private Java.SwitchBlockStatementGroup generateSwitchBlockStatementGroup" + this.getSuffix(switchBlockStatementGroup) + "(Java.Block statement) throws Exception {");
        ++this.level;
        this.write("Java.SwitchBlockStatementGroup group = new Java.SwitchBlockStatementGroup(" + this.getLocation(switchBlockStatementGroup) + ");");
        Iterator iterator = switchBlockStatementGroup.caseLabels.iterator();
        while (iterator.hasNext()) {
            object2 = (Java.Rvalue)iterator.next();
            this.write("group.addSwitchLabel(generateAtom" + this.getSuffix(object2) + "(statement));");
        }
        if (switchBlockStatementGroup.hasDefaultLabel) {
            this.write("group.hasDefaultLabel = " + switchBlockStatementGroup.hasDefaultLabel + ";");
        }
        this.write("List blockStatements = new ArrayList();");
        object2 = switchBlockStatementGroup.blockStatements.iterator();
        while (object2.hasNext()) {
            object = (Java.BlockStatement)object2.next();
            this.write("blockStatements.add(generateStatement" + this.getSuffix(object) + "(statement));");
        }
        this.write("group.setBlockStatements(blockStatements);");
        this.write("return group;");
        --this.level;
        this.write("}");
        this.write();
        object = switchBlockStatementGroup.caseLabels.iterator();
        while (object.hasNext()) {
            ((Java.Rvalue)object.next()).accept((Visitor.RvalueVisitor)this);
        }
        Iterator iterator2 = switchBlockStatementGroup.blockStatements.iterator();
        while (iterator2.hasNext()) {
            ((Java.BlockStatement)iterator2.next()).accept(this);
        }
    }

    private void generateTypes(Java.Type[] typeArray) {
        if (typeArray == null || typeArray.length == 0) {
            return;
        }
        this.write("private Java.Type[] generateTypes" + this.getSuffix(typeArray) + "(Java.Scope scope) throws Exception {");
        ++this.level;
        this.write("return new Java.Type[] {");
        ++this.level;
        ++this.level;
        int n = 0;
        while (n < typeArray.length) {
            this.write("generateType" + this.getSuffix(typeArray[n]) + "(scope),");
            ++n;
        }
        --this.level;
        this.write("};");
        --this.level;
        --this.level;
        this.write("}");
        this.write();
        int n2 = 0;
        while (n2 < typeArray.length) {
            typeArray[n2].accept((Visitor.TypeVisitor)this);
            ++n2;
        }
    }

    public void generateVariableDeclarator(Java.VariableDeclarator variableDeclarator) {
        this.write("private Java.VariableDeclarator generateVariableDeclarator" + this.getSuffix(variableDeclarator) + "(Java.Scope scope, Java.BlockStatement enclosingBlockStatement) throws Exception {");
        ++this.level;
        this.write("return new Java.VariableDeclarator(" + this.getLocation(variableDeclarator) + ", \"" + variableDeclarator.name + "\", " + variableDeclarator.brackets + ", " + (variableDeclarator.optionalInitializer == null ? "null" : "generateAtom" + this.getSuffix(variableDeclarator.optionalInitializer) + "(enclosingBlockStatement)") + ");");
        --this.level;
        this.write("}");
        this.write();
        if (variableDeclarator.optionalInitializer != null) {
            variableDeclarator.optionalInitializer.accept((Visitor.RvalueVisitor)this);
        }
    }

    private void generateVariableDeclarators(Java.VariableDeclarator[] variableDeclaratorArray) {
        if (variableDeclaratorArray == null) {
            return;
        }
        this.write("private Java.VariableDeclarator[] generateVariableDeclarators" + this.getSuffix(variableDeclaratorArray) + "(Java.Scope scope, Java.BlockStatement enclosingBlockStatement) throws Exception {");
        ++this.level;
        this.write("Java.VariableDeclarator[] variables = new Java.VariableDeclarator[" + variableDeclaratorArray.length + "];");
        int n = 0;
        while (n < variableDeclaratorArray.length) {
            this.write("variables[" + n + "] = generateVariableDeclarator" + this.getSuffix(variableDeclaratorArray[n]) + "(scope, enclosingBlockStatement);");
            ++n;
        }
        this.write("return variables;");
        --this.level;
        this.write("}");
        this.write();
        int n2 = 0;
        while (n2 < variableDeclaratorArray.length) {
            this.generateVariableDeclarator(variableDeclaratorArray[n2]);
            ++n2;
        }
    }

    private String getGenerateRvalues(Java.Rvalue[] rvalueArray, String string) {
        return rvalueArray == null ? "null" : (rvalueArray.length == 0 ? "new Java.Rvalue[0]" : "generateRvalues" + this.getSuffix(rvalueArray) + "(" + string + ")");
    }

    private String getGenerateTypes(Java.Type[] typeArray, String string) {
        return typeArray == null ? "null" : (typeArray.length == 0 ? "new Java.Type[0]" : "generateTypes" + this.getSuffix(typeArray) + "(" + string + ")");
    }

    private String getLocation(Java.Locatable locatable) {
        Location location = locatable.getLocation();
        return "getLocation(" + location.getLineNumber() + ", " + location.getColumnNumber() + ")";
    }

    private String getModifiers(short s) {
        if (s == 0) {
            return "Mod.NONE";
        }
        StringBuffer stringBuffer = new StringBuffer("(short)(");
        String string = "";
        int n = 0;
        while (n < MODS.length) {
            if ((s & MODS[n]) > 0) {
                stringBuffer.append(string).append(MOD_NAMES[n]);
                string = " | ";
            }
            ++n;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private String getSuffix(Object object) {
        return String.valueOf(System.identityHashCode(object));
    }

    public static void main(String[] stringArray) throws Exception {
        int n = 0;
        while (n < stringArray.length) {
            Java.CompilationUnit compilationUnit = new Parser(new Scanner(stringArray[n])).parseCompilationUnit();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(System.out);
            new AstGeneratorVisitor(outputStreamWriter, "MyAstGenerator").generateCompilationUnit(compilationUnit);
            outputStreamWriter.flush();
            ++n;
        }
    }

    public void visitAlternateConstructorInvocation(Java.AlternateConstructorInvocation alternateConstructorInvocation) {
        if (this.instances.contains(alternateConstructorInvocation)) {
            return;
        }
        this.instances.add(alternateConstructorInvocation);
        this.write("private Java.AlternateConstructorInvocation generateConstructorInvocation" + this.getSuffix(alternateConstructorInvocation) + "(" + "Java.ClassDeclaration declaringClass, Java.ConstructorDeclarator declaringConstructor, Java.BlockStatement enclosingBlockStatement) throws Exception {");
        ++this.level;
        this.write("return new Java.AlternateConstructorInvocation(" + this.getLocation(alternateConstructorInvocation) + ", " + "declaringClass, declaringConstructor, " + this.getGenerateRvalues(alternateConstructorInvocation.arguments, "new Java.Block(" + this.getLocation(alternateConstructorInvocation) + ", declaringConstructor)") + ");");
        --this.level;
        this.write("}");
        this.write();
        this.generateRvalues(alternateConstructorInvocation.arguments);
    }

    public void visitAmbiguousName(Java.AmbiguousName ambiguousName) {
        if (this.instances.contains(ambiguousName)) {
            return;
        }
        this.instances.add(ambiguousName);
        this.write("// bridge method for AmbiguousName to Type conversion");
        this.write("private Java.Type generateType" + this.getSuffix(ambiguousName.toType()) + "(Java.Scope scope) throws Exception {");
        ++this.level;
        this.write("return generateAtom" + this.getSuffix(ambiguousName) + "(scope).toType();");
        --this.level;
        this.write("}");
        this.write("private Java.AmbiguousName generateAtom" + this.getSuffix(ambiguousName) + "(Java.Scope scope) throws Exception {");
        ++this.level;
        this.write("return new Java.AmbiguousName(" + this.getLocation(ambiguousName) + ", scope, " + this.arrayToString(ambiguousName.identifiers) + ", " + ambiguousName.n + ");");
        --this.level;
        this.write("}");
        this.write("private Java.AmbiguousName generateAtom" + this.getSuffix(ambiguousName) + "(Java.BlockStatement enclosingBlockStatement) throws Exception {");
        ++this.level;
        this.write("return new Java.AmbiguousName(" + this.getLocation(ambiguousName) + ", enclosingBlockStatement, " + this.arrayToString(ambiguousName.identifiers) + ", " + ambiguousName.n + ");");
        --this.level;
        this.write("}");
        this.write();
    }

    public void visitAnonymousClassDeclaration(Java.AnonymousClassDeclaration anonymousClassDeclaration) {
        this.write("private Java.AnonymousClassDeclaration generateLocalClassDeclaration" + this.getSuffix(anonymousClassDeclaration) + "(Java.Scope scope) throws Exception {");
        ++this.level;
        this.write("Java.AnonymousClassDeclaration declaration = new Java.AnonymousClassDeclaration(" + this.getLocation(anonymousClassDeclaration) + ", scope, " + "generateType" + this.getSuffix(anonymousClassDeclaration.baseType) + "(scope));");
        this.generateClassDeclarationBody(anonymousClassDeclaration);
        this.write("return declaration;");
        --this.level;
        this.write("}");
        this.write();
        anonymousClassDeclaration.baseType.accept((Visitor.TypeVisitor)this);
        this.generateClassDeclarationBodyMethods(anonymousClassDeclaration);
    }

    public void visitArrayAccessExpression(Java.ArrayAccessExpression arrayAccessExpression) {
        if (this.instances.contains(arrayAccessExpression)) {
            return;
        }
        this.instances.add(arrayAccessExpression);
        this.write("private Java.ArrayAccessExpression generateAtom" + this.getSuffix(arrayAccessExpression) + "(Java.BlockStatement enclosingBlockStatement) throws Exception {");
        ++this.level;
        this.write("return new Java.ArrayAccessExpression(" + this.getLocation(arrayAccessExpression) + ", " + "generateAtom" + this.getSuffix(arrayAccessExpression.lhs) + "(enclosingBlockStatement), " + "generateAtom" + this.getSuffix(arrayAccessExpression.index) + "(enclosingBlockStatement)" + ");");
        --this.level;
        this.write("}");
        this.write();
        arrayAccessExpression.lhs.accept((Visitor.RvalueVisitor)this);
        arrayAccessExpression.index.accept((Visitor.RvalueVisitor)this);
    }

    public void visitArrayInitializer(Java.ArrayInitializer arrayInitializer) {
        if (this.instances.contains(arrayInitializer)) {
            return;
        }
        this.instances.add(arrayInitializer);
        this.write("private Java.ArrayInitializer generateAtom" + this.getSuffix(arrayInitializer) + "(Java.BlockStatement enclosingBlockStatement) throws Exception {");
        ++this.level;
        this.write("return new Java.ArrayInitializer(" + this.getLocation(arrayInitializer) + ", " + "generateType" + this.getSuffix(arrayInitializer.arrayType) + "(enclosingBlockStatement), " + this.getGenerateRvalues(arrayInitializer.values, "enclosingBlockStatement") + ");");
        --this.level;
        this.write("}");
        this.write();
        arrayInitializer.arrayType.accept(this);
        this.generateRvalues(arrayInitializer.values);
    }

    public void visitArrayLength(Java.ArrayLength arrayLength) {
        if (this.instances.contains(arrayLength)) {
            return;
        }
        this.instances.add(arrayLength);
        this.write("private Java.ArrayLength generateAtom" + this.getSuffix(arrayLength) + "(Java.BlockStatement enclosingBlockStatement) throws Exception {");
        ++this.level;
        this.write("return new Java.ArrayAccessExpression(" + this.getLocation(arrayLength) + ", generateAtom" + this.getSuffix(arrayLength.lhs) + "(enclosingBlockStatement));");
        --this.level;
        this.write("}");
        this.write();
        arrayLength.lhs.accept((Visitor.RvalueVisitor)this);
    }

    public void visitArrayType(Java.ArrayType arrayType) {
        if (this.instances.contains(arrayType)) {
            return;
        }
        this.instances.add(arrayType);
        this.write("private Java.ArrayType generateType" + this.getSuffix(arrayType) + "(Java.Scope scope) throws Exception {");
        ++this.level;
        this.write("return new Java.ArrayType(generateType" + this.getSuffix(arrayType.componentType) + "(scope).toType());");
        --this.level;
        this.write("}");
        this.write();
        arrayType.componentType.accept((Visitor.TypeVisitor)this);
    }

    public void visitAssignment(Java.Assignment assignment) {
        if (this.instances.contains(assignment)) {
            return;
        }
        this.instances.add(assignment);
        this.write("private Java.Assignment generateAtom" + this.getSuffix(assignment) + "(Java.BlockStatement enclosingBlockStatement) throws Exception {");
        ++this.level;
        this.write("return new Java.Assignment(" + this.getLocation(assignment) + ", " + "generateAtom" + this.getSuffix(assignment.lhs) + "(enclosingBlockStatement), \"" + assignment.operator + "\", " + "generateAtom" + this.getSuffix(assignment.rhs) + "(enclosingBlockStatement));");
        --this.level;
        this.write("}");
        this.write();
        assignment.lhs.accept((Visitor.LvalueVisitor)this);
        assignment.rhs.accept((Visitor.RvalueVisitor)this);
    }

    public void visitBasicType(Java.BasicType basicType) {
        if (this.instances.contains(basicType)) {
            return;
        }
        this.instances.add(basicType);
        this.write("private Java.BasicType generateType" + this.getSuffix(basicType) + "(Java.Scope scope) throws Exception {");
        ++this.level;
        String string = "";
        switch (basicType.index) {
            case 0: {
                string = "Java.BasicType.VOID";
                break;
            }
            case 1: {
                string = "Java.BasicType.BYTE";
                break;
            }
            case 2: {
                string = "Java.BasicType.SHORT";
                break;
            }
            case 3: {
                string = "Java.BasicType.CHAR";
                break;
            }
            case 4: {
                string = "Java.BasicType.INT";
                break;
            }
            case 5: {
                string = "Java.BasicType.LONG";
                break;
            }
            case 6: {
                string = "Java.BasicType.FLOAT";
                break;
            }
            case 7: {
                string = "Java.BasicType.DOUBLE";
                break;
            }
            case 8: {
                string = "Java.BasicType.BOOLEAN";
                break;
            }
        }
        this.write("return new Java.BasicType(" + this.getLocation(basicType) + ", " + string + ");");
        --this.level;
        this.write("}");
        this.write();
    }

    public void visitBinaryOperation(Java.BinaryOperation binaryOperation) {
        if (this.instances.contains(binaryOperation)) {
            return;
        }
        this.instances.add(binaryOperation);
        this.write("private Java.BinaryOperation generateAtom" + this.getSuffix(binaryOperation) + "(Java.BlockStatement enclosingBlockStatement) throws Exception {");
        ++this.level;
        this.write("return new Java.BinaryOperation(" + this.getLocation(binaryOperation) + ", " + "generateAtom" + this.getSuffix(binaryOperation.lhs) + "(enclosingBlockStatement), " + "\"" + binaryOperation.op + "\", " + "generateAtom" + this.getSuffix(binaryOperation.rhs) + "(enclosingBlockStatement)" + ");");
        --this.level;
        this.write("}");
        this.write();
        binaryOperation.lhs.accept((Visitor.RvalueVisitor)this);
        binaryOperation.rhs.accept((Visitor.RvalueVisitor)this);
    }

    public void visitBlock(Java.Block block) {
        Object object;
        this.write("private Java.Block generateStatement" + this.getSuffix(block) + "(Java.Scope scope) throws Exception {");
        ++this.level;
        this.write("Java.Block statement = new Java.Block(" + this.getLocation(block) + ", scope);");
        Iterator iterator = block.statements.iterator();
        while (iterator.hasNext()) {
            object = (Java.BlockStatement)iterator.next();
            this.write("statement.addStatement(generateStatement" + this.getSuffix(object) + "(statement));");
        }
        this.write("return statement;");
        --this.level;
        this.write("}");
        this.write();
        object = block.statements.iterator();
        while (object.hasNext()) {
            ((Java.BlockStatement)object.next()).accept(this);
        }
    }

    public void visitBreakStatement(Java.BreakStatement breakStatement) {
        this.write("private Java.BreakStatement generateStatement" + this.getSuffix(breakStatement) + "(Java.Scope scope) throws Exception {");
        ++this.level;
        this.write("return new Java.BreakStatement(" + this.getLocation(breakStatement) + ", scope, " + (breakStatement.optionalLabel == null ? "null" : "\"" + breakStatement.optionalLabel + "\"") + ");");
        --this.level;
        this.write("}");
        this.write();
    }

    public void visitCast(Java.Cast cast) {
        if (this.instances.contains(cast)) {
            return;
        }
        this.instances.add(cast);
        this.write("private Java.Cast generateAtom" + this.getSuffix(cast) + "(Java.BlockStatement enclosingBlockStatement) throws Exception {");
        ++this.level;
        this.write("return new Java.Cast(" + this.getLocation(cast) + ", " + "generateType" + this.getSuffix(cast.targetType) + "(enclosingBlockStatement).toType(), " + "generateAtom" + this.getSuffix(cast.value) + "(enclosingBlockStatement));");
        --this.level;
        this.write("}");
        this.write();
        cast.targetType.accept((Visitor.TypeVisitor)this);
        cast.value.accept((Visitor.RvalueVisitor)this);
    }

    public void visitClassLiteral(Java.ClassLiteral classLiteral) {
        if (this.instances.contains(classLiteral)) {
            return;
        }
        this.instances.add(classLiteral);
        this.write("private Java.ClassLiteral generateAtom" + this.getSuffix(classLiteral) + "(Java.BlockStatement enclosingBlockStatement) throws Exception {");
        ++this.level;
        this.write("return new Java.ClassLiteral(" + this.getLocation(classLiteral) + ", enclosingBlockStatement, " + "generateType" + this.getSuffix(classLiteral.type) + "(enclosingBlockStatement).toType());");
        --this.level;
        this.write("}");
        this.write();
        classLiteral.type.accept((Visitor.TypeVisitor)this);
    }

    public void visitConditionalExpression(Java.ConditionalExpression conditionalExpression) {
        if (this.instances.contains(conditionalExpression)) {
            return;
        }
        this.instances.add(conditionalExpression);
        this.write("private Java.ConditionalExpression generateAtom" + this.getSuffix(conditionalExpression) + "(Java.BlockStatement enclosingBlockStatement) throws Exception {");
        ++this.level;
        this.write("return new Java.ConditionalExpression(" + this.getLocation(conditionalExpression) + ", " + "generateAtom" + this.getSuffix(conditionalExpression.lhs) + "(enclosingBlockStatement), " + "generateAtom" + this.getSuffix(conditionalExpression.mhs) + "(enclosingBlockStatement), " + "generateAtom" + this.getSuffix(conditionalExpression.rhs) + "(enclosingBlockStatement));");
        --this.level;
        this.write("}");
        this.write();
        conditionalExpression.lhs.accept((Visitor.RvalueVisitor)this);
        conditionalExpression.mhs.accept((Visitor.RvalueVisitor)this);
        conditionalExpression.rhs.accept((Visitor.RvalueVisitor)this);
    }

    public void visitConstantValue(Java.ConstantValue constantValue) {
        if (this.instances.contains(constantValue)) {
            return;
        }
        this.instances.add(constantValue);
        this.write("private Java.ConstantValue generateAtom" + this.getSuffix(constantValue) + "(Java.BlockStatement enclosingBlockStatement) throws Exception {");
        ++this.level;
        String string = "";
        Object object = constantValue.constantValue;
        if (object instanceof Integer) {
            string = "new Integer(" + object + ")";
        } else if (object instanceof Long) {
            string = "new Long(" + object + ")";
        } else if (object instanceof Float) {
            string = "new Float(" + object + "f)";
        } else if (object instanceof Double) {
            string = "new Double(" + object + "d)";
        } else if (object instanceof String) {
            string = "\"" + object + "\"";
        } else if (object instanceof Character) {
            string = "new Character(" + object + ")";
        } else if (object instanceof Boolean) {
            string = "new Boolean(" + object + ")";
        } else if (object == Java.Rvalue.CONSTANT_VALUE_NULL) {
            string = "null";
        }
        this.write("return new Java.ConstantValue(" + this.getLocation(constantValue) + ", " + string + ");");
        --this.level;
        this.write("}");
        this.write();
    }

    public void visitConstructorDeclarator(Java.ConstructorDeclarator constructorDeclarator) {
        this.write("private Java.ConstructorDeclarator generateConstructorDeclarator" + this.getSuffix(constructorDeclarator) + "(Java.ClassDeclaration declaringClass) throws Exception {");
        ++this.level;
        this.write("Java.ConstructorDeclarator declaration = new Java.ConstructorDeclarator(" + this.getLocation(constructorDeclarator) + ", " + "declaringClass, null, " + this.getModifiers(constructorDeclarator.modifiers) + ", " + (constructorDeclarator.formalParameters == null ? "null" : (constructorDeclarator.formalParameters.length == 0 ? "new Java.FormalParameter[0]" : "generateFormalParameters" + this.getSuffix(constructorDeclarator.formalParameters) + "(declaringClass)")) + ", " + this.getGenerateTypes(constructorDeclarator.thrownExceptions, "declaringClass") + ");");
        if (constructorDeclarator.optionalBody != null) {
            this.write("Java.Block body = generateStatement" + this.getSuffix(constructorDeclarator.optionalBody) + "(declaration);");
        } else {
            this.write("Java.Block body = new Java.Block(" + this.getLocation(constructorDeclarator) + ", declaration);");
        }
        this.write("declaration.setBody(body);");
        if (constructorDeclarator.optionalExplicitConstructorInvocation != null) {
            Java.ConstructorInvocation constructorInvocation = constructorDeclarator.optionalExplicitConstructorInvocation;
            this.write("declaration.setExplicitConstructorInvocation(generateConstructorInvocation" + this.getSuffix(constructorInvocation) + "(declaringClass, declaration, body));");
        }
        this.write("return declaration;");
        --this.level;
        this.write("}");
        this.write();
        this.generateFormalParameters(constructorDeclarator.formalParameters);
        this.generateTypes(constructorDeclarator.thrownExceptions);
        if (constructorDeclarator.optionalExplicitConstructorInvocation != null) {
            constructorDeclarator.optionalExplicitConstructorInvocation.accept((Visitor.ConstructorInvocationVisitor)this);
        }
        if (constructorDeclarator.optionalBody != null) {
            constructorDeclarator.optionalBody.accept(this);
        }
    }

    public void visitContinueStatement(Java.ContinueStatement continueStatement) {
        this.write("private Java.ContinueStatement generateStatement" + this.getSuffix(continueStatement) + "(Java.Scope scope) throws Exception {");
        ++this.level;
        this.write("return new Java.ContinueStatement(" + this.getLocation(continueStatement) + ", scope, " + (continueStatement.optionalLabel == null ? "null" : "\"" + continueStatement.optionalLabel + "\"") + ");");
        --this.level;
        this.write("}");
        this.write();
    }

    public void visitCrement(Java.Crement crement) {
        if (this.instances.contains(crement)) {
            return;
        }
        this.instances.add(crement);
        this.write("private Java.Crement generateAtom" + this.getSuffix(crement) + "(Java.BlockStatement enclosingBlockStatement) throws Exception {");
        ++this.level;
        if (crement.pre) {
            this.write("return new Java.Crement(" + this.getLocation(crement) + ", \"" + crement.operator + "\", " + "generateAtom" + this.getSuffix(crement.operand) + "(enclosingBlockStatement)" + ");");
        } else {
            this.write("return new Java.Crement(" + this.getLocation(crement) + ", " + "generateAtom" + this.getSuffix(crement.operand) + "(enclosingBlockStatement), " + "\"" + crement.operator + "\");");
        }
        --this.level;
        this.write("}");
        this.write();
        crement.operand.accept((Visitor.LvalueVisitor)this);
    }

    public void visitDoStatement(Java.DoStatement doStatement) {
        this.write("private Java.DoStatement generateStatement" + this.getSuffix(doStatement) + "(Java.Scope scope) throws Exception {");
        ++this.level;
        this.write("Java.DoStatement statement = new Java.DoStatement(" + this.getLocation(doStatement) + ", scope);");
        this.write("statement.setBody(generateStatement" + this.getSuffix(doStatement.body) + "(scope));");
        this.write("statement.setCondition(generateAtom" + this.getSuffix(doStatement.condition) + "(statement));");
        this.write("return statement;");
        --this.level;
        this.write("}");
        this.write();
        doStatement.body.accept(this);
        doStatement.condition.accept((Visitor.RvalueVisitor)this);
    }

    public void visitEmptyStatement(Java.EmptyStatement emptyStatement) {
        this.write("private Java.EmptyStatement generateStatement" + this.getSuffix(emptyStatement) + "(Java.Scope scope) throws Exception {");
        ++this.level;
        this.write("return new Java.EmptyStatement(" + this.getLocation(emptyStatement) + ", scope);");
        --this.level;
        this.write("}");
        this.write();
    }

    public void visitExpressionStatement(Java.ExpressionStatement expressionStatement) {
        this.write("private Java.ExpressionStatement generateStatement" + this.getSuffix(expressionStatement) + "(Java.BlockStatement enclosingBlockStatement) throws Exception {");
        ++this.level;
        this.write("return new Java.ExpressionStatement(generateAtom" + this.getSuffix(expressionStatement.rvalue) + "(enclosingBlockStatement), enclosingBlockStatement);");
        --this.level;
        this.write("}");
        this.write();
        expressionStatement.rvalue.accept((Visitor.RvalueVisitor)this);
    }

    public void visitFieldAccess(Java.FieldAccess fieldAccess) {
        if (this.instances.contains(fieldAccess)) {
            return;
        }
        this.instances.add(fieldAccess);
        this.write("private Java.VariableDeclarator generateVariableDeclarator" + this.getSuffix(fieldAccess) + "(Java.Scope scope, Java.BlockStatement enclosingBlockStatement) throws Exception {");
        ++this.level;
        this.write("Java.Atom atom = generateAtom" + this.getSuffix(fieldAccess.lhs) + "(scope)");
        this.write("return new Java.FieldAccess(" + this.getLocation(fieldAccess) + ", " + "atom, Java.findIField(atom.getType(), \"" + fieldAccess.field.getName() + "\", " + this.getLocation(fieldAccess) + "));");
        --this.level;
        this.write("}");
        this.write();
        fieldAccess.lhs.accept(this);
    }

    public void visitFieldAccessExpression(Java.FieldAccessExpression fieldAccessExpression) {
        if (this.instances.contains(fieldAccessExpression)) {
            return;
        }
        this.instances.add(fieldAccessExpression);
        this.write("private Java.FieldAccessExpression generateAtom" + this.getSuffix(fieldAccessExpression) + "(Java.BlockStatement enclosingBlockStatement) throws Exception {");
        ++this.level;
        this.write("return new Java.FieldAccessExpression(" + this.getLocation(fieldAccessExpression) + ", " + "enclosingBlockStatement, " + "generateAtom" + this.getSuffix(fieldAccessExpression.lhs) + "(enclosingBlockStatement), " + "\"" + fieldAccessExpression.fieldName + "\");");
        --this.level;
        this.write("}");
        this.write();
        fieldAccessExpression.lhs.accept(this);
    }

    public void visitFieldDeclaration(Java.FieldDeclaration fieldDeclaration) {
        this.write("private Java.FieldDeclaration generateFieldDeclaration" + this.getSuffix(fieldDeclaration) + "(Java.AbstractTypeDeclaration declaringType) throws Exception {");
        ++this.level;
        this.write("Java.FieldDeclaration declaration = new Java.FieldDeclaration(" + this.getLocation(fieldDeclaration) + ", " + "declaringType, null, " + this.getModifiers(fieldDeclaration.modifiers) + ", " + "generateType" + this.getSuffix(fieldDeclaration.type) + "(declaringType)" + ");");
        this.write("declaration.setVariableDeclarators(generateVariableDeclarators" + this.getSuffix(fieldDeclaration.variableDeclarators) + "(declaration, declaration));");
        this.write("return declaration;");
        --this.level;
        this.write("}");
        this.write();
        fieldDeclaration.type.accept((Visitor.TypeVisitor)this);
        this.generateVariableDeclarators(fieldDeclaration.variableDeclarators);
    }

    public void visitForStatement(Java.ForStatement forStatement) {
        this.write("private Java.ForStatement generateStatement" + this.getSuffix(forStatement) + "(Java.Block scope) throws Exception {");
        ++this.level;
        this.write("Java.ForStatement statement = new Java.ForStatement(" + this.getLocation(forStatement) + ", scope);");
        this.write("statement.set(" + (forStatement.optionalInit == null ? "null" : "generateStatement" + this.getSuffix(forStatement.optionalInit) + "(scope)") + ", " + (forStatement.optionalCondition == null ? "null" : "generateAtom" + this.getSuffix(forStatement.optionalCondition) + "(scope)") + ", " + this.getGenerateRvalues(forStatement.optionalUpdate, "statement") + ", " + (forStatement.body == null ? "null" : "generateStatement" + this.getSuffix(forStatement.body) + "(scope)") + ");");
        this.write("return statement;");
        --this.level;
        this.write("}");
        this.write();
        if (forStatement.optionalInit != null) {
            forStatement.optionalInit.accept(this);
        }
        if (forStatement.optionalCondition != null) {
            forStatement.optionalCondition.accept((Visitor.RvalueVisitor)this);
        }
        this.generateRvalues(forStatement.optionalUpdate);
        if (forStatement.body != null) {
            forStatement.body.accept(this);
        }
    }

    public void visitIfStatement(Java.IfStatement ifStatement) {
        this.write("private Java.IfStatement generateStatement" + this.getSuffix(ifStatement) + "(Java.Block scope) throws Exception {");
        ++this.level;
        this.write("return new Java.IfStatement(" + this.getLocation(ifStatement) + ", scope, " + "generateAtom" + this.getSuffix(ifStatement.condition) + "(scope), " + "generateStatement" + this.getSuffix(ifStatement.thenStatement) + "(scope), " + (ifStatement.optionalElseStatement == null ? "null" : "generateStatement" + this.getSuffix(ifStatement.optionalElseStatement) + "(scope)") + ");");
        --this.level;
        this.write("}");
        this.write();
        ifStatement.condition.accept((Visitor.RvalueVisitor)this);
        ifStatement.thenStatement.accept(this);
        if (ifStatement.optionalElseStatement != null) {
            ifStatement.optionalElseStatement.accept(this);
        }
    }

    public void visitInitializer(Java.Initializer initializer) {
        this.write("private Java.Initializer generateFieldDeclaration" + this.getSuffix(initializer) + "(Java.TypeDeclaration declaringType) throws Exception {");
        ++this.level;
        this.write("Java.Initializer declaration = new Java.Initializer(" + this.getLocation(initializer) + ", declaringType, " + (initializer.statiC ? "true" : "false") + ");");
        if (initializer.block != null) {
            this.write("declaration.setBlock(generateStatement" + this.getSuffix(initializer.block) + "(declaration));");
        }
        this.write("return declaration;");
        --this.level;
        this.write("}");
        this.write();
        if (initializer.block != null) {
            initializer.block.accept(this);
        }
    }

    public void visitInstanceof(Java.Instanceof instanceof_) {
        if (this.instances.contains(instanceof_)) {
            return;
        }
        this.instances.add(instanceof_);
        this.write("private Java.Instanceof generateAtom" + this.getSuffix(instanceof_) + "(Java.BlockStatement enclosingBlockStatement) throws Exception {");
        ++this.level;
        this.write("return new Java.Instanceof(" + this.getLocation(instanceof_) + ", " + "generateAtom" + this.getSuffix(instanceof_.lhs) + "(enclosingBlockStatement), " + "generateType" + this.getSuffix(instanceof_.rhs) + "(enclosingBlockStatement));");
        --this.level;
        this.write("}");
        this.write();
        instanceof_.lhs.accept((Visitor.RvalueVisitor)this);
        instanceof_.rhs.accept((Visitor.TypeVisitor)this);
    }

    public void visitLabeledStatement(Java.LabeledStatement labeledStatement) {
        this.write("private Java.LabeledStatement generateStatement" + this.getSuffix(labeledStatement) + "(Java.Block scope) throws Exception {");
        ++this.level;
        this.write("Java.LabeledStatement statement = new Java.LabeledStatement(" + this.getLocation(labeledStatement) + ", scope, \"" + labeledStatement.label + "\");");
        this.write("statement.setBody(generateStatement" + this.getSuffix(labeledStatement.body) + "(scope));");
        this.write("return statement;");
        --this.level;
        this.write("}");
        this.write();
        labeledStatement.body.accept(this);
    }

    public void visitLiteral(Java.Literal literal) {
        if (this.instances.contains(literal)) {
            return;
        }
        this.instances.add(literal);
        this.write("private Java.Literal generateAtom" + this.getSuffix(literal) + "(Java.BlockStatement enclosingBlockStatement) throws Exception {");
        ++this.level;
        String string = "null";
        Object object = literal.value;
        if (object instanceof String) {
            string = "\"" + this.escape((String)object) + "\"";
        } else if (object instanceof Integer) {
            string = "new Integer(" + object + ")";
        } else if (object instanceof Long) {
            string = "new Long(" + object + "L)";
        } else if (object instanceof Float) {
            string = "new Float(" + object + "f)";
        } else if (object instanceof Double) {
            string = "new Double(" + object + "d)";
        } else if (object instanceof Character) {
            string = "new Character('" + this.escape(((Character)object).charValue()) + "')";
        } else if (object instanceof Boolean) {
            string = (Boolean)object != false ? "Boolean.TRUE" : "Boolean.FALSE";
        }
        this.write("return new Java.Literal(" + this.getLocation(literal) + ", " + string + ");");
        --this.level;
        this.write("}");
        this.write();
    }

    public void visitLocalClassDeclaration(Java.LocalClassDeclaration localClassDeclaration) {
        this.write("private Java.LocalClassDeclaration generateLocalClassDeclaration" + this.getSuffix(localClassDeclaration) + "(Java.Block scope) throws Exception {");
        ++this.level;
        this.write("Java.LocalClassDeclaration declaration = new Java.LocalClassDeclaration(" + this.getLocation(localClassDeclaration) + ", scope, " + this.getModifiers(localClassDeclaration.modifiers) + ", \"" + localClassDeclaration.name + "\", " + (localClassDeclaration.optionalExtendedType == null ? "null, " : "generateType" + this.getSuffix(localClassDeclaration.optionalExtendedType) + "(scope), ") + this.getGenerateTypes(localClassDeclaration.implementedTypes, "scope") + ");");
        this.generateClassDeclarationBody(localClassDeclaration);
        this.write("return declaration;");
        --this.level;
        this.write("}");
        this.write();
        if (localClassDeclaration.optionalExtendedType != null) {
            localClassDeclaration.optionalExtendedType.accept((Visitor.TypeVisitor)this);
        }
        this.generateTypes(localClassDeclaration.implementedTypes);
        this.generateClassDeclarationBodyMethods(localClassDeclaration);
    }

    public void visitLocalClassDeclarationStatement(Java.LocalClassDeclarationStatement localClassDeclarationStatement) {
        this.write("private Java.LocalClassDeclarationStatement generateStatement" + this.getSuffix(localClassDeclarationStatement) + "(Java.Block scope) throws Exception {");
        ++this.level;
        this.write("return new Java.LocalClassDeclarationStatement(scope, generateLocalClassDeclaration" + this.getSuffix(localClassDeclarationStatement.lcd) + "(scope));");
        --this.level;
        this.write("}");
        this.write();
        localClassDeclarationStatement.lcd.accept(this);
    }

    public void visitLocalVariableAccess(Java.LocalVariableAccess localVariableAccess) {
        if (this.instances.contains(localVariableAccess)) {
            return;
        }
        this.instances.add(localVariableAccess);
        this.write("private Java.VariableDeclarator generateVariableDeclarator" + this.getSuffix(localVariableAccess) + "(Java.Scope scope, Java.BlockStatement enclosingBlockStatement) throws Exception {");
        ++this.level;
        Java.LocalVariable localVariable = localVariableAccess.localVariable;
        this.write("return new Java.LocalVariableAccess(" + this.getLocation(localVariableAccess) + ", " + "new Java.LocalVariable(" + localVariable.finaL + ", " + "generateIClass" + this.getSuffix(localVariable.type) + "(), " + localVariable.localVariableArrayIndex + "));");
        --this.level;
        this.write("}");
        this.write();
        this.generateIClass(localVariable.type);
    }

    public void visitLocalVariableDeclarationStatement(Java.LocalVariableDeclarationStatement localVariableDeclarationStatement) {
        this.write("private Java.LocalVariableDeclarationStatement generateStatement" + this.getSuffix(localVariableDeclarationStatement) + "(Java.Block declaringBlock) throws Exception {");
        ++this.level;
        this.write("return new Java.LocalVariableDeclarationStatement(" + this.getLocation(localVariableDeclarationStatement) + ", declaringBlock, " + this.getModifiers(localVariableDeclarationStatement.modifiers) + ", " + "generateType" + this.getSuffix(localVariableDeclarationStatement.type) + "(declaringBlock), " + "generateVariableDeclarators" + this.getSuffix(localVariableDeclarationStatement.variableDeclarators) + "(declaringBlock, declaringBlock));");
        --this.level;
        this.write("}");
        this.write();
        localVariableDeclarationStatement.type.accept((Visitor.TypeVisitor)this);
        this.generateVariableDeclarators(localVariableDeclarationStatement.variableDeclarators);
    }

    public void visitMemberClassDeclaration(Java.MemberClassDeclaration memberClassDeclaration) {
        this.write("private Java.MemberClassDeclaration generateMemberTypeDeclaration" + this.getSuffix(memberClassDeclaration) + "(Java.NamedTypeDeclaration declaringType) throws Exception {");
        ++this.level;
        this.write("Java.MemberClassDeclaration declaration = new Java.MemberClassDeclaration(" + this.getLocation(memberClassDeclaration) + ", declaringType, null, " + this.getModifiers(memberClassDeclaration.modifiers) + ", \"" + memberClassDeclaration.name + "\", " + (memberClassDeclaration.optionalExtendedType == null ? "null" : "generateType" + this.getSuffix(memberClassDeclaration.optionalExtendedType) + "(declaringType)") + ", " + this.getGenerateTypes(memberClassDeclaration.implementedTypes, "declaringType") + ");");
        this.generateClassDeclarationBody(memberClassDeclaration);
        this.write("return declaration;");
        --this.level;
        this.write("}");
        this.write();
        if (memberClassDeclaration.optionalExtendedType != null) {
            memberClassDeclaration.optionalExtendedType.accept((Visitor.TypeVisitor)this);
        }
        this.generateTypes(memberClassDeclaration.implementedTypes);
        this.generateClassDeclarationBodyMethods(memberClassDeclaration);
    }

    public void visitMemberInterfaceDeclaration(Java.MemberInterfaceDeclaration memberInterfaceDeclaration) {
        Object object;
        this.write("private Java.MemberInterfaceDeclaration generateMemberTypeDeclaration" + this.getSuffix(memberInterfaceDeclaration) + "(Java.NamedTypeDeclaration declaringType) throws Exception {");
        ++this.level;
        this.write("Java.MemberInterfaceDeclaration declaration = new Java.MemberInterfaceDeclaration(" + this.getLocation(memberInterfaceDeclaration) + ", declaringType, null, " + this.getModifiers(memberInterfaceDeclaration.modifiers) + ", \"" + memberInterfaceDeclaration.name + "\", " + this.getGenerateTypes(memberInterfaceDeclaration.extendedTypes, "declaringType") + ");");
        this.generateAbstractTypeDeclarationBody(memberInterfaceDeclaration);
        Iterator iterator = memberInterfaceDeclaration.constantDeclarations.iterator();
        while (iterator.hasNext()) {
            object = (Java.FieldDeclaration)iterator.next();
            this.write("declaration.addConstantDeclaration(generateFieldDeclaration" + this.getSuffix(object) + "(declaration));");
        }
        this.write("return declaration;");
        --this.level;
        this.write("}");
        this.write();
        this.generateTypes(memberInterfaceDeclaration.extendedTypes);
        this.generateAbstractTypeDeclarationBodyMethods(memberInterfaceDeclaration);
        object = memberInterfaceDeclaration.constantDeclarations.iterator();
        while (object.hasNext()) {
            ((Java.FieldDeclaration)object.next()).accept(this);
        }
    }

    public void visitMethodDeclarator(Java.MethodDeclarator methodDeclarator) {
        this.write("private Java.MethodDeclarator generateMethodDeclarator" + this.getSuffix(methodDeclarator) + "(Java.AbstractTypeDeclaration declaringType) throws Exception {");
        ++this.level;
        if (methodDeclarator.optionalBody == null) {
            this.write("return new Java.MethodDeclarator(" + this.getLocation(methodDeclarator) + ", " + "declaringType, null, " + this.getModifiers(methodDeclarator.modifiers) + ", " + (methodDeclarator.type == null ? "null" : "generateType" + this.getSuffix(methodDeclarator.type) + "(declaringType)") + ", \"" + methodDeclarator.name + "\", " + (methodDeclarator.formalParameters == null ? "null" : (methodDeclarator.formalParameters.length == 0 ? "new Java.FormalParameter[0]" : "generateFormalParameters" + this.getSuffix(methodDeclarator.formalParameters) + "(declaringType)")) + ", " + this.getGenerateTypes(methodDeclarator.thrownExceptions, "declaringType") + ");");
        } else {
            this.write("Java.MethodDeclarator declaration = new Java.MethodDeclarator(" + this.getLocation(methodDeclarator) + ", " + "declaringType, null, " + this.getModifiers(methodDeclarator.modifiers) + ", " + (methodDeclarator.type == null ? "null" : "generateType" + this.getSuffix(methodDeclarator.type) + "(declaringType)") + ", \"" + methodDeclarator.name + "\", " + (methodDeclarator.formalParameters == null ? "null" : (methodDeclarator.formalParameters.length == 0 ? "new Java.FormalParameter[0]" : "generateFormalParameters" + this.getSuffix(methodDeclarator.formalParameters) + "(declaringType)")) + ", " + this.getGenerateTypes(methodDeclarator.thrownExceptions, "declaringType") + ");");
            this.write("declaration.setBody(generateStatement" + this.getSuffix(methodDeclarator.optionalBody) + "(declaration));");
            this.write("return declaration;");
        }
        --this.level;
        this.write("}");
        this.write();
        if (methodDeclarator.type != null) {
            methodDeclarator.type.accept((Visitor.TypeVisitor)this);
        }
        this.generateTypes(methodDeclarator.thrownExceptions);
        this.generateFormalParameters(methodDeclarator.formalParameters);
        if (methodDeclarator.optionalBody != null) {
            methodDeclarator.optionalBody.accept(this);
        }
    }

    public void visitMethodInvocation(Java.MethodInvocation methodInvocation) {
        this.write("private Java.MethodInvocation generateAtom" + this.getSuffix(methodInvocation) + "(Java.BlockStatement enclosingBlockStatement) throws Exception {");
        ++this.level;
        this.write("return new Java.MethodInvocation(" + this.getLocation(methodInvocation) + ", enclosingBlockStatement, " + (methodInvocation.optionalTarget == null ? "null" : "generateAtom" + this.getSuffix(methodInvocation.optionalTarget) + "(enclosingBlockStatement)") + ", " + "\"" + methodInvocation.methodName + "\", " + this.getGenerateRvalues(methodInvocation.arguments, "enclosingBlockStatement") + ");");
        --this.level;
        this.write("}");
        this.write();
        if (methodInvocation.optionalTarget != null) {
            methodInvocation.optionalTarget.accept(this);
        }
        this.generateRvalues(methodInvocation.arguments);
    }

    public void visitNewAnonymousClassInstance(Java.NewAnonymousClassInstance newAnonymousClassInstance) {
        this.write("private Java.NewAnonymousClassInstance generateAtom" + this.getSuffix(newAnonymousClassInstance) + "(Java.BlockStatement enclosingBlockStatement) throws Exception {");
        ++this.level;
        this.write("return new Java.NewAnonymousClassInstance(" + this.getLocation(newAnonymousClassInstance) + ", enclosingBlockStatement, " + (newAnonymousClassInstance.optionalQualification == null ? "null" : "generateAtom" + this.getSuffix(newAnonymousClassInstance.optionalQualification) + "(enclosingBlockStatement)") + ", " + "generateLocalClassDeclaration" + this.getSuffix(newAnonymousClassInstance.anonymousClassDeclaration) + "(enclosingBlockStatement)" + ", " + this.getGenerateRvalues(newAnonymousClassInstance.arguments, "enclosingBlockStatement") + ");");
        --this.level;
        this.write("}");
        this.write();
        if (newAnonymousClassInstance.optionalQualification != null) {
            newAnonymousClassInstance.optionalQualification.accept((Visitor.RvalueVisitor)this);
        }
        newAnonymousClassInstance.anonymousClassDeclaration.accept(this);
        this.generateRvalues(newAnonymousClassInstance.arguments);
    }

    public void visitNewArray(Java.NewArray newArray) {
        if (this.instances.contains(newArray)) {
            return;
        }
        this.instances.add(newArray);
        this.write("private Java.NewArray generateAtom" + this.getSuffix(newArray) + "(Java.BlockStatement enclosingBlockStatement) throws Exception {");
        ++this.level;
        this.write("return new Java.NewArray(" + this.getLocation(newArray) + ", " + "generateType" + this.getSuffix(newArray.type) + "(enclosingBlockStatement), " + this.getGenerateRvalues(newArray.dimExprs, "enclosingBlockStatement") + ", " + newArray.dims + ");");
        --this.level;
        this.write("}");
        this.write();
        newArray.type.accept((Visitor.TypeVisitor)this);
        this.generateRvalues(newArray.dimExprs);
    }

    public void visitNewClassInstance(Java.NewClassInstance newClassInstance) {
        if (this.instances.contains(newClassInstance)) {
            return;
        }
        this.instances.add(newClassInstance);
        this.write("private Java.NewClassInstance generateAtom" + this.getSuffix(newClassInstance) + "(Java.BlockStatement enclosingBlockStatement) throws Exception {");
        ++this.level;
        this.write("return new Java.NewClassInstance(" + this.getLocation(newClassInstance) + ", enclosingBlockStatement, " + (newClassInstance.optionalQualification == null ? "null" : "generateAtom" + this.getSuffix(newClassInstance.optionalQualification) + "(enclosingBlockStatement)") + ", " + "generateType" + this.getSuffix(newClassInstance.type) + "(enclosingBlockStatement), " + this.getGenerateRvalues(newClassInstance.arguments, "enclosingBlockStatement") + ");");
        --this.level;
        this.write("}");
        this.write();
        if (newClassInstance.optionalQualification != null) {
            newClassInstance.optionalQualification.accept((Visitor.RvalueVisitor)this);
        }
        newClassInstance.type.accept((Visitor.TypeVisitor)this);
        this.generateRvalues(newClassInstance.arguments);
    }

    public void visitPackage(Java.Package package_) {
        if (this.instances.contains(package_)) {
            return;
        }
        this.instances.add(package_);
        this.write("private Java.Package generatePackage" + this.getSuffix(package_) + "() throws Exception {");
        ++this.level;
        this.write("return new Java.Package(" + this.getLocation(package_) + ", \"" + package_.name + "\");");
        --this.level;
        this.write("}");
        this.write();
    }

    public void visitPackageMemberClassDeclaration(Java.PackageMemberClassDeclaration packageMemberClassDeclaration) {
        this.write("private Java.PackageMemberTypeDeclaration generateMemberTypeDeclaration" + this.getSuffix(packageMemberClassDeclaration) + "(Java.CompilationUnit cu) throws Exception {");
        ++this.level;
        this.write("Java.PackageMemberClassDeclaration declaration = new Java.PackageMemberClassDeclaration(" + this.getLocation(packageMemberClassDeclaration) + ", cu, null, " + this.getModifiers(packageMemberClassDeclaration.modifiers) + ", \"" + packageMemberClassDeclaration.name + "\", " + (packageMemberClassDeclaration.optionalExtendedType == null ? "null" : "generateType" + this.getSuffix(packageMemberClassDeclaration.optionalExtendedType) + "(cu)") + ", " + this.getGenerateTypes(packageMemberClassDeclaration.implementedTypes, "cu") + ");");
        this.write();
        this.generateClassDeclarationBody(packageMemberClassDeclaration);
        this.write("return declaration;");
        --this.level;
        this.write("}");
        this.write();
        this.generateTypes(packageMemberClassDeclaration.implementedTypes);
        if (packageMemberClassDeclaration.optionalExtendedType != null) {
            packageMemberClassDeclaration.optionalExtendedType.accept((Visitor.TypeVisitor)this);
        }
        this.generateClassDeclarationBodyMethods(packageMemberClassDeclaration);
    }

    public void visitPackageMemberInterfaceDeclaration(Java.PackageMemberInterfaceDeclaration packageMemberInterfaceDeclaration) {
        Object object;
        this.write("private Java.PackageMemberInterfaceDeclaration generateMemberTypeDeclaration" + this.getSuffix(packageMemberInterfaceDeclaration) + "(Java.CompilationUnit cu) throws Exception {");
        ++this.level;
        this.write("Java.PackageMemberInterfaceDeclaration declaration = new Java.PackageMemberInterfaceDeclaration(null, cu, null, " + this.getModifiers(packageMemberInterfaceDeclaration.modifiers) + ", \"" + packageMemberInterfaceDeclaration.name + "\", " + this.getGenerateTypes(packageMemberInterfaceDeclaration.extendedTypes, "cu") + ");");
        this.generateAbstractTypeDeclarationBody(packageMemberInterfaceDeclaration);
        Iterator iterator = packageMemberInterfaceDeclaration.constantDeclarations.iterator();
        while (iterator.hasNext()) {
            object = (Java.FieldDeclaration)iterator.next();
            this.write("declaration.addConstantDeclaration(generateFieldDeclaration" + this.getSuffix(object) + "(declaration));");
        }
        this.write("return declaration;");
        --this.level;
        this.write("}");
        this.write();
        this.generateTypes(packageMemberInterfaceDeclaration.extendedTypes);
        this.generateAbstractTypeDeclarationBodyMethods(packageMemberInterfaceDeclaration);
        object = packageMemberInterfaceDeclaration.constantDeclarations.iterator();
        while (object.hasNext()) {
            ((Java.FieldDeclaration)object.next()).accept(this);
        }
    }

    public void visitParameterAccess(Java.ParameterAccess parameterAccess) {
        if (this.instances.contains(parameterAccess)) {
            return;
        }
        this.instances.add(parameterAccess);
        this.write("private Java.ParameterAccess generateAtom" + this.getSuffix(parameterAccess) + "(Java.BlockStatement enclosingBlockStatement) throws Exception {");
        ++this.level;
        Java.FunctionDeclarator functionDeclarator = parameterAccess.declaringFunction;
        this.write("final Java.FunctionDeclarator declarator = null;  // TODO " + functionDeclarator.getClass().getName() + " : " + functionDeclarator.toString());
        this.write("return new Java.ParameterAccess(" + this.getLocation(parameterAccess) + ", declarator, \"" + parameterAccess.name + "\");");
        --this.level;
        this.write("}");
        this.write();
    }

    public void visitParenthesizedExpression(Java.ParenthesizedExpression parenthesizedExpression) {
        if (this.instances.contains(parenthesizedExpression)) {
            return;
        }
        this.instances.add(parenthesizedExpression);
        this.write("private Java.ParenthesizedExpression generateAtom" + this.getSuffix(parenthesizedExpression) + "(Java.BlockStatement enclosingBlockStatement) throws Exception {");
        ++this.level;
        this.write("return new Java.ParenthesizedExpression(" + this.getLocation(parenthesizedExpression) + ", " + "generateAtom" + this.getSuffix(parenthesizedExpression.value) + "(enclosingBlockStatement));");
        --this.level;
        this.write("}");
        this.write();
        parenthesizedExpression.value.accept((Visitor.RvalueVisitor)this);
    }

    public void visitQualifiedThisReference(Java.QualifiedThisReference qualifiedThisReference) {
        if (this.instances.contains(qualifiedThisReference)) {
            return;
        }
        this.instances.add(qualifiedThisReference);
        this.write("private Java.QualifiedThisReference generateAtom" + this.getSuffix(qualifiedThisReference) + "(Java.BlockStatement enclosingBlockStatement) throws Exception {");
        ++this.level;
        this.write("return new Java.QualifiedThisReference(" + this.getLocation(qualifiedThisReference) + ", enclosingBlockStatement, " + "generateType" + this.getSuffix(qualifiedThisReference.qualification) + "(enclosingBlockStatement).toType()" + ");");
        --this.level;
        this.write("}");
        this.write();
        qualifiedThisReference.qualification.accept((Visitor.TypeVisitor)this);
    }

    public void visitReferenceType(Java.ReferenceType referenceType) {
        if (this.instances.contains(referenceType)) {
            return;
        }
        this.instances.add(referenceType);
        this.write("private Java.ReferenceType generateType" + this.getSuffix(referenceType) + "(Java.Scope scope) throws Exception {");
        ++this.level;
        this.write("return new Java.ReferenceType(" + this.getLocation(referenceType) + ", scope, " + this.arrayToString(referenceType.identifiers) + ");");
        --this.level;
        this.write("}");
        this.write();
    }

    public void visitReturnStatement(Java.ReturnStatement returnStatement) {
        this.write("private Java.ReturnStatement generateStatement" + this.getSuffix(returnStatement) + "(Java.BlockStatement enclosingBlockStatement) throws Exception {");
        ++this.level;
        this.write("return new Java.ReturnStatement(" + this.getLocation(returnStatement) + ", enclosingBlockStatement, " + (returnStatement.optionalReturnValue == null ? "null" : "generateAtom" + this.getSuffix(returnStatement.optionalReturnValue) + "(enclosingBlockStatement)") + ");");
        --this.level;
        this.write("}");
        this.write();
        if (returnStatement.optionalReturnValue != null) {
            returnStatement.optionalReturnValue.accept((Visitor.RvalueVisitor)this);
        }
    }

    public void visitRvalueMemberType(Java.RvalueMemberType rvalueMemberType) {
        if (this.instances.contains(rvalueMemberType)) {
            return;
        }
        this.instances.add(rvalueMemberType);
        this.write("private Java.VariableDeclarator generateAtom" + this.getSuffix(rvalueMemberType) + "(Java.Scope scope) throws Exception {");
        ++this.level;
        this.write("return new Java.RvalueMemberType(" + this.getLocation(rvalueMemberType) + ", " + "generateAtom" + this.getSuffix(rvalueMemberType.rvalue) + "(scope), " + "\"" + rvalueMemberType.identifier + "\");");
        --this.level;
        this.write("}");
        this.write();
        rvalueMemberType.rvalue.accept((Visitor.RvalueVisitor)this);
    }

    public void visitSimpleType(Java.SimpleType simpleType) {
        if (this.instances.contains(simpleType)) {
            return;
        }
        this.instances.add(simpleType);
        this.write("private Java.SimpleType generateType" + this.getSuffix(simpleType) + "(Java.Scope scope) throws Exception {");
        ++this.level;
        this.write("return new Java.SimpleType(" + this.getLocation(simpleType) + ", generateIClass" + simpleType.iClass + "(scope));");
        --this.level;
        this.write("}");
        this.write();
        this.generateIClass(simpleType.iClass);
    }

    public void visitSingleTypeImportDeclaration(Java.SingleTypeImportDeclaration singleTypeImportDeclaration) {
        this.write("private Java.SingleTypeImportDeclaration generateImportDeclaration" + this.getSuffix(singleTypeImportDeclaration) + "() throws Exception {");
        ++this.level;
        this.write("return new Java.SingleTypeImportDeclaration(" + this.getLocation(singleTypeImportDeclaration) + ", " + this.arrayToString(singleTypeImportDeclaration.identifiers) + ");");
        --this.level;
        this.write("}");
        this.write();
    }

    public void visitSuperConstructorInvocation(Java.SuperConstructorInvocation superConstructorInvocation) {
        if (this.instances.contains(superConstructorInvocation)) {
            return;
        }
        this.instances.add(superConstructorInvocation);
        this.write("private Java.SuperConstructorInvocation generateConstructorInvocation" + this.getSuffix(superConstructorInvocation) + "(" + "Java.ClassDeclaration declaringClass, Java.ConstructorDeclarator declaringConstructor, Java.BlockStatement enclosingBlockStatement) throws Exception {");
        ++this.level;
        this.write("return new Java.SuperConstructorInvocation(" + this.getLocation(superConstructorInvocation) + ", declaringClass, declaringConstructor, " + (superConstructorInvocation.optionalQualification == null ? "null" : "generateAtom" + this.getSuffix(superConstructorInvocation.optionalQualification) + "(declaringClass)") + ", " + this.getGenerateRvalues(superConstructorInvocation.arguments, "new Java.Block(" + this.getLocation(superConstructorInvocation) + ", declaringConstructor)") + ");");
        --this.level;
        this.write("}");
        this.write();
        if (superConstructorInvocation.optionalQualification != null) {
            superConstructorInvocation.optionalQualification.accept((Visitor.RvalueVisitor)this);
        }
        this.generateRvalues(superConstructorInvocation.arguments);
    }

    public void visitSuperclassMethodInvocation(Java.SuperclassMethodInvocation superclassMethodInvocation) {
        if (this.instances.contains(superclassMethodInvocation)) {
            return;
        }
        this.instances.add(superclassMethodInvocation);
        this.write("private Java.SuperclassMethodInvocation generateAtom" + this.getSuffix(superclassMethodInvocation) + "(Java.BlockStatement enclosingBlockStatement) throws Exception {");
        ++this.level;
        this.write("return new Java.SuperclassMethodInvocation(" + this.getLocation(superclassMethodInvocation) + ", enclosingBlockStatement, \"" + superclassMethodInvocation.methodName + "\", " + this.getGenerateRvalues(superclassMethodInvocation.arguments, "enclosingBlockStatement") + ");");
        --this.level;
        this.write("}");
        this.write();
        this.generateRvalues(superclassMethodInvocation.arguments);
    }

    public void visitSwitchStatement(Java.SwitchStatement switchStatement) {
        Object object;
        this.write("private Java.SwitchStatement generateStatement" + this.getSuffix(switchStatement) + "(Java.Block scope) throws Exception {");
        ++this.level;
        this.write("Java.SwitchStatement statement = new Java.SwitchStatement(" + this.getLocation(switchStatement) + ", scope);");
        this.write("statement.setCondition(generateAtom" + this.getSuffix(switchStatement.condition) + "(scope));");
        Iterator iterator = switchStatement.sbsgs.iterator();
        while (iterator.hasNext()) {
            object = (Java.SwitchBlockStatementGroup)iterator.next();
            this.write("statement.addSwitchBlockStatementGroup(generateSwitchBlockStatementGroup" + this.getSuffix(object) + "(scope));");
        }
        this.write("return statement;");
        --this.level;
        this.write("}");
        this.write();
        switchStatement.condition.accept((Visitor.RvalueVisitor)this);
        object = switchStatement.sbsgs.iterator();
        while (object.hasNext()) {
            this.generateSwitchBlockStatementGroup((Java.SwitchBlockStatementGroup)object.next());
        }
    }

    public void visitSynchronizedStatement(Java.SynchronizedStatement synchronizedStatement) {
        this.write("private Java.SynchronizedStatement generateStatement" + this.getSuffix(synchronizedStatement) + "(Java.BlockStatement enclosingBlockStatement) throws Exception {");
        ++this.level;
        this.write("Java.SynchronizedStatement statement = new Java.SynchronizedStatement(" + this.getLocation(synchronizedStatement) + ", enclosingBlockStatement, " + "generateAtom" + this.getSuffix(synchronizedStatement.expression) + "(enclosingBlockStatement));");
        this.write("statement.setBody(generateStatement" + this.getSuffix(synchronizedStatement.body) + "(statement));");
        this.write("return statement;");
        --this.level;
        this.write("}");
        this.write();
        synchronizedStatement.expression.accept((Visitor.RvalueVisitor)this);
        synchronizedStatement.body.accept(this);
    }

    public void visitThisReference(Java.ThisReference thisReference) {
        if (this.instances.contains(thisReference)) {
            return;
        }
        this.instances.add(thisReference);
        this.write("private Java.ThisReference generateAtom" + this.getSuffix(thisReference) + "(Java.BlockStatement enclosingBlockStatement) throws Exception {");
        ++this.level;
        this.write("return new Java.ThisReference(" + this.getLocation(thisReference) + ", enclosingBlockStatement);");
        --this.level;
        this.write("}");
        this.write();
    }

    public void visitThrowStatement(Java.ThrowStatement throwStatement) {
        this.write("private Java.ThrowStatement generateStatement" + this.getSuffix(throwStatement) + "(Java.BlockStatement enclosingBlockStatement) throws Exception {");
        ++this.level;
        this.write("return new Java.ThrowStatement(" + this.getLocation(throwStatement) + ", enclosingBlockStatement, " + "generateAtom" + this.getSuffix(throwStatement.expression) + "(enclosingBlockStatement));");
        --this.level;
        this.write("}");
        this.write();
        throwStatement.expression.accept((Visitor.RvalueVisitor)this);
    }

    public void visitTryStatement(Java.TryStatement tryStatement) {
        Object object;
        this.write("private Java.TryStatement generateStatement" + this.getSuffix(tryStatement) + "(Java.Scope scope) throws Exception {");
        ++this.level;
        this.write("Java.TryStatement statement = new Java.TryStatement(" + this.getLocation(tryStatement) + ", scope);");
        this.write("statement.setBody(generateStatement" + this.getSuffix(tryStatement.body) + "(statement));");
        Iterator iterator = tryStatement.catchClauses.iterator();
        while (iterator.hasNext()) {
            object = (Java.CatchClause)iterator.next();
            this.write("statement.addCatchClause(new Java.CatchClause(generateFormalParameter" + this.getSuffix(((Java.CatchClause)object).caughtException) + "(statement), " + "generateStatement" + this.getSuffix(((Java.CatchClause)object).body) + "(statement)));");
        }
        if (tryStatement.optionalFinally != null) {
            this.write("statement.setFinally(generateStatement" + this.getSuffix(tryStatement.optionalFinally) + "(statement));");
        }
        this.write("return statement;");
        --this.level;
        this.write("}");
        this.write();
        tryStatement.body.accept(this);
        if (tryStatement.optionalFinally != null) {
            tryStatement.optionalFinally.accept(this);
        }
        object = tryStatement.catchClauses.iterator();
        while (object.hasNext()) {
            Java.CatchClause catchClause = (Java.CatchClause)object.next();
            this.generateFormalParameter(catchClause.caughtException);
            catchClause.body.accept(this);
        }
    }

    public void visitTypeImportOnDemandDeclaration(Java.TypeImportOnDemandDeclaration typeImportOnDemandDeclaration) {
        this.write("private Java.TypeImportOnDemandDeclaration generateImportDeclaration" + this.getSuffix(typeImportOnDemandDeclaration) + "() throws Exception {");
        ++this.level;
        this.write("return new Java.TypeImportOnDemandDeclaration(" + this.getLocation(typeImportOnDemandDeclaration) + ", " + this.arrayToString(typeImportOnDemandDeclaration.identifiers) + ");");
        --this.level;
        this.write("}");
        this.write();
    }

    public void visitUnaryOperation(Java.UnaryOperation unaryOperation) {
        if (this.instances.contains(unaryOperation)) {
            return;
        }
        this.instances.add(unaryOperation);
        this.write("private Java.UnaryOperation generateAtom" + this.getSuffix(unaryOperation) + "(Java.BlockStatement enclosingBlockStatement) throws Exception {");
        ++this.level;
        this.write("return new Java.UnaryOperation(" + this.getLocation(unaryOperation) + ", \"" + unaryOperation.operator + "\", " + "generateAtom" + this.getSuffix(unaryOperation.operand) + "(enclosingBlockStatement));");
        --this.level;
        this.write("}");
        this.write();
        unaryOperation.operand.accept((Visitor.RvalueVisitor)this);
    }

    public void visitWhileStatement(Java.WhileStatement whileStatement) {
        this.write("private Java.WhileStatement generateStatement" + this.getSuffix(whileStatement) + "(Java.Block scope) throws Exception {");
        ++this.level;
        this.write("Java.WhileStatement statement = new Java.WhileStatement(" + this.getLocation(whileStatement) + ", scope, " + "generateAtom" + this.getSuffix(whileStatement.condition) + "(scope));");
        if (whileStatement.body != null) {
            this.write("statement.setBody(generateStatement" + this.getSuffix(whileStatement.body) + "(scope));");
        }
        this.write("return statement;");
        --this.level;
        this.write("}");
        this.write();
        whileStatement.condition.accept((Visitor.RvalueVisitor)this);
        if (whileStatement.body != null) {
            whileStatement.body.accept(this);
        }
    }

    private void write() {
        this.pw.println();
    }

    private void write(String string) {
        int n = this.level * 4;
        while (n >= TAB_FILLER.length()) {
            this.pw.print(TAB_FILLER);
            n -= TAB_FILLER.length();
        }
        if (n > 0) {
            this.pw.print(TAB_FILLER.substring(0, n));
        }
        this.pw.println(string);
    }
}

